(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7586,        248]
NotebookOptionsPosition[      5701,        191]
NotebookOutlinePosition[      6900,        222]
CellTagsIndexPosition[      6857,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ShowGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ShowGraph"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"ShowGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Displaying Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowLabeledGraph", "ObjectName",
 CellID->27277],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowLabeledGraph", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " according to its embedding, with each vertex labeled with its vertex \
number."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowLabeledGraph", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses the ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element of list ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " as the label for vertex ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23509],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ShowGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/ShowGraph"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->3556]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->49001715],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->222566245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->15434748],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->384486943]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowLabeledGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 30.3736130}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ShowLabeledGraph[g] displays graph g according to its embedding, with \
each vertex labeled with its vertex number. ShowLabeledGraph[g, l] uses the i\
\\[Null]^th element of list l as the label for vertex i.", "synonyms" -> {}, 
    "title" -> "ShowLabeledGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ShowLabeledGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1994, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2617, 79, 54, 1, 70, "ObjectName",
 CellID->27277],
Cell[2674, 82, 1155, 36, 70, "Usage",
 CellID->9392]
}, Open  ]],
Cell[CellGroupData[{
Cell[3866, 123, 311, 9, 70, "SeeAlsoSection",
 CellID->23509],
Cell[4180, 134, 211, 6, 70, "SeeAlso",
 CellID->3556]
}, Open  ]],
Cell[CellGroupData[{
Cell[4428, 145, 317, 9, 70, "TutorialsSection",
 CellID->49001715],
Cell[4748, 156, 187, 4, 70, "Tutorials",
 CellID->222566245]
}, Open  ]],
Cell[CellGroupData[{
Cell[4972, 165, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5294, 176, 158, 3, 70, "MoreAbout",
 CellID->15434748],
Cell[5455, 181, 204, 5, 70, "MoreAbout",
 CellID->384486943]
}, Open  ]],
Cell[5674, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

