(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9876,        319]
NotebookOptionsPosition[      7544,        253]
NotebookOutlinePosition[      9058,        288]
CellTagsIndexPosition[      9015,        285]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButterflyGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ButterflyGraph"],
           "DeBruijnGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/DeBruijnGraph"], 
          "Hypercube" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Hypercube"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ButterflyGraph\"\>", 
       2->"\<\"DeBruijnGraph\"\>", 
       3->"\<\"Hypercube\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShuffleExchangeGraph", "ObjectName",
 CellID->26338],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShuffleExchangeGraph", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "-dimensional shuffle-exchange graph whose vertices are length ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " binary strings with an edge from ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], TraditionalForm]], "InlineMath"],
     " if (i) ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], TraditionalForm]], "InlineMath"],
     " differs from ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], TraditionalForm]], "InlineMath"],
     " in its last bit or (ii) ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], TraditionalForm]], "InlineMath"],
     " is obtained from ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " by a cyclic shift left or a cyclic shift right. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12453]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option ",
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 " is provided, with default setting ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", which can be set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", if the user wants to associate the binary strings to the vertices as \
labels."
}], "Notes",
 CellID->16646]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7781],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButterflyGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ButterflyGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeBruijnGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeBruijnGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypercube",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Hypercube"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17026]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->946812357],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->143498019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->52556178]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShuffleExchangeGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 30.5454924}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ShuffleExchangeGraph[n] returns the n-dimensional shuffle-exchange graph \
whose vertices are length n binary strings with an edge from w to \
SuperscriptBox[\"w\", \"\\[Prime]\", MultilineFunction->None] if (i) \
SuperscriptBox[\"w\", \"\\[Prime]\", MultilineFunction->None] differs from \
SuperscriptBox[\"w\", \"\\[Prime]\", MultilineFunction->None] in its last bit \
or (ii) SuperscriptBox[\"w\", \"\\[Prime]\", MultilineFunction->None] is \
obtained from w by a cyclic shift left or a cyclic shift right. ", 
    "synonyms" -> {}, "title" -> "ShuffleExchangeGraph", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/ShuffleExchangeGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2046, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2669, 79, 58, 1, 70, "ObjectName",
 CellID->26338],
Cell[2730, 82, 1515, 44, 70, "Usage",
 CellID->12453]
}, Open  ]],
Cell[CellGroupData[{
Cell[4282, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4760, 148, 573, 19, 70, "Notes",
 CellID->16646]
}, Closed]],
Cell[CellGroupData[{
Cell[5370, 172, 310, 9, 70, "SeeAlsoSection",
 CellID->7781],
Cell[5683, 183, 762, 26, 70, "SeeAlso",
 CellID->17026]
}, Open  ]],
Cell[CellGroupData[{
Cell[6482, 214, 318, 9, 70, "TutorialsSection",
 CellID->946812357],
Cell[6803, 225, 187, 4, 70, "Tutorials",
 CellID->143498019]
}, Open  ]],
Cell[CellGroupData[{
Cell[7027, 234, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7349, 245, 153, 3, 70, "MoreAbout",
 CellID->52556178]
}, Open  ]],
Cell[7517, 251, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

