(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9045,        308]
NotebookOptionsPosition[      6949,        242]
NotebookOutlinePosition[      8119,        273]
CellTagsIndexPosition[      8076,        270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromAdjacencyLists" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromAdjacencyLists"], "ToOrderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToOrderedPairs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromAdjacencyLists\"\>", 
       2->"\<\"ToOrderedPairs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToAdjacencyLists", "ObjectName",
 CellID->710],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToAdjacencyLists", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an adjacency list representation for graph ",
     
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToAdjacencyLists", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        ButtonBox["EdgeWeight",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/EdgeWeight"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns an adjacency list representation along with \
edge weights."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option called ",
 Cell[BoxData["Type"], "InlineFormula"],
 " that takes on values ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " or ",
 Cell[BoxData["Simple"], "InlineFormula"],
 " can be given. "
}], "Notes",
 CellID->31562],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Type", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " is the default setting of the option, and this permits self-loops and \
multiple edges to be reported in the adjacency lists. "
}], "Notes",
 CellID->58094486],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Type", "->", "Simple"}]], "InlineFormula"],
 " deletes self-loops and multiple edges from the constructed adjacency \
lists. "
}], "Notes",
 CellID->81466670]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12690],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromAdjacencyLists",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromAdjacencyLists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToOrderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToOrderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20967]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17674155],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->1638977]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->35969496]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToAdjacencyLists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 54.3742274}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ToAdjacencyLists[g] constructs an adjacency list representation for \
graph g. ToAdjacencyLists[g, EdgeWeight] returns an adjacency list \
representation along with edge weights.", "synonyms" -> {}, "title" -> 
    "ToAdjacencyLists", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ToAdjacencyLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2011, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2634, 79, 52, 1, 70, "ObjectName",
 CellID->710],
Cell[2689, 82, 900, 28, 70, "Usage",
 CellID->3745]
}, Open  ]],
Cell[CellGroupData[{
Cell[3626, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4104, 132, 314, 12, 70, "Notes",
 CellID->31562],
Cell[4421, 146, 317, 9, 70, "Notes",
 CellID->58094486],
Cell[4741, 157, 200, 6, 70, "Notes",
 CellID->81466670]
}, Closed]],
Cell[CellGroupData[{
Cell[4978, 168, 311, 9, 70, "SeeAlsoSection",
 CellID->12690],
Cell[5292, 179, 511, 17, 70, "SeeAlso",
 CellID->20967]
}, Open  ]],
Cell[CellGroupData[{
Cell[5840, 201, 317, 9, 70, "TutorialsSection",
 CellID->17674155],
Cell[6160, 212, 185, 4, 70, "Tutorials",
 CellID->1638977]
}, Open  ]],
Cell[CellGroupData[{
Cell[6382, 221, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6704, 232, 203, 5, 70, "MoreAbout",
 CellID->35969496]
}, Open  ]],
Cell[6922, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

