(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8658,        286]
NotebookOptionsPosition[      6574,        223]
NotebookOutlinePosition[      7840,        255]
CellTagsIndexPosition[      7797,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"KSetPartitions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/KSetPartitions"],
           "SetPartitions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SetPartitions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"KSetPartitions\"\>", 
       2->"\<\"SetPartitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToCanonicalSetPartition", "ObjectName",
 CellID->19227],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToCanonicalSetPartition", "[", 
       RowBox[{
        StyleBox["sp", "TI"], ",", 
        StyleBox["set", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reorders ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " into a canonical order with respect to ",
     Cell[BoxData[
      StyleBox["set", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToCanonicalSetPartition", "[", 
       StyleBox["sp", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]reorders ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " into canonical order, assuming that ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " knows the underlying order on the set for which ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " is a set partition."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30822]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In the canonical order, the elements of each subset of the set partition \
are ordered as they appear in ",
 Cell[BoxData[
  StyleBox["set", "TI"]], "InlineFormula"],
 ", and the subsets themselves are ordered by their first elements. "
}], "Notes",
 CellID->4086]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14703],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["KSetPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/KSetPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SetPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12406]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->255318298],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->373888380]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->153992192]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToCanonicalSetPartition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 54.7179862}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ToCanonicalSetPartition[sp, set] reorders sp into a canonical order with \
respect to set. ToCanonicalSetPartition[sp] reorders sp into canonical order, \
assuming that Mathematica knows the underlying order on the set for which sp \
is a set partition.", "synonyms" -> {}, "title" -> "ToCanonicalSetPartition", 
    "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ToCanonicalSetPartition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1968, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2591, 78, 61, 1, 70, "ObjectName",
 CellID->19227],
Cell[2655, 81, 1143, 35, 70, "Usage",
 CellID->30822]
}, Open  ]],
Cell[CellGroupData[{
Cell[3835, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4313, 138, 282, 7, 70, "Notes",
 CellID->4086]
}, Closed]],
Cell[CellGroupData[{
Cell[4632, 150, 311, 9, 70, "SeeAlsoSection",
 CellID->14703],
Cell[4946, 161, 501, 17, 70, "SeeAlso",
 CellID->12406]
}, Open  ]],
Cell[CellGroupData[{
Cell[5484, 183, 318, 9, 70, "TutorialsSection",
 CellID->255318298],
Cell[5805, 194, 187, 4, 70, "Tutorials",
 CellID->373888380]
}, Open  ]],
Cell[CellGroupData[{
Cell[6029, 203, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6351, 214, 181, 4, 70, "MoreAbout",
 CellID->153992192]
}, Open  ]],
Cell[6547, 221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

