(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7543,        248]
NotebookOptionsPosition[      5803,        193]
NotebookOutlinePosition[      6856,        222]
CellTagsIndexPosition[      6813,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromCycles" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/FromCycles"], 
          "HideCycles" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/HideCycles"], 
          "RevealCycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RevealCycles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromCycles\"\>", 2->"\<\"HideCycles\"\>", 
       3->"\<\"RevealCycles\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsets and Cycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndCycles"], 
          "Subsets and Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndPermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subsets and Cycles\"\>", 
       2->"\<\"Subsets and Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToCycles", "ObjectName",
 CellID->3722],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToCycles", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cycle structure of permutation ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " as a list of cyclic permutations."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26066]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17402],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromCycles",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromCycles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HideCycles",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HideCycles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RevealCycles",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RevealCycles"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12072]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->754424451],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->85008153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "MoreAbout",
 CellID->624360761],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "MoreAbout",
 CellID->28003063]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToCycles - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 54.8898656}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ToCycles[p] gives the cycle structure of permutation p as a list of \
cyclic permutations.", "synonyms" -> {}, "title" -> "ToCycles", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/ToCycles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2236, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2859, 83, 45, 1, 70, "ObjectName",
 CellID->3722],
Cell[2907, 86, 509, 15, 70, "Usage",
 CellID->26066]
}, Open  ]],
Cell[CellGroupData[{
Cell[3453, 106, 311, 9, 70, "SeeAlsoSection",
 CellID->17402],
Cell[3767, 117, 754, 26, 70, "SeeAlso",
 CellID->12072]
}, Open  ]],
Cell[CellGroupData[{
Cell[4558, 148, 318, 9, 70, "TutorialsSection",
 CellID->754424451],
Cell[4879, 159, 186, 4, 70, "Tutorials",
 CellID->85008153]
}, Open  ]],
Cell[CellGroupData[{
Cell[5102, 168, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5424, 179, 160, 3, 70, "MoreAbout",
 CellID->624360761],
Cell[5587, 184, 174, 4, 70, "MoreAbout",
 CellID->28003063]
}, Open  ]],
Cell[5776, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

