(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7384,        243]
NotebookOptionsPosition[      5558,        188]
NotebookOutlinePosition[      6757,        219]
CellTagsIndexPosition[      6714,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalizeVertices" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NormalizeVertices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NormalizeVertices\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TranslateVertices", "ObjectName",
 CellID->14310],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TranslateVertices", "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]adds the vector ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
     " to the vertex embedding location of each vertex in list ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TranslateVertices", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]translates the embedding of the graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " by the vector ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->2216]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13742],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NormalizeVertices",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/NormalizeVertices"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->13787]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->300052782],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->390366377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->338724343]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TranslateVertices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 2.7025656}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "TranslateVertices[v, {x, y}] adds the vector {x, y} to the vertex \
embedding location of each vertex in list v. TranslateVertices[g, {x, y}] \
translates the embedding of the graph g by the vector {x, y}.", 
    "synonyms" -> {}, "title" -> "TranslateVertices", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/TranslateVertices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1803, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2426, 75, 55, 1, 70, "ObjectName",
 CellID->14310],
Cell[2484, 78, 1390, 44, 70, "Usage",
 CellID->2216]
}, Open  ]],
Cell[CellGroupData[{
Cell[3911, 127, 311, 9, 70, "SeeAlsoSection",
 CellID->13742],
Cell[4225, 138, 228, 6, 70, "SeeAlso",
 CellID->13787]
}, Open  ]],
Cell[CellGroupData[{
Cell[4490, 149, 318, 9, 70, "TutorialsSection",
 CellID->300052782],
Cell[4811, 160, 187, 4, 70, "Tutorials",
 CellID->390366377]
}, Open  ]],
Cell[CellGroupData[{
Cell[5035, 169, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5357, 180, 159, 3, 70, "MoreAbout",
 CellID->338724343]
}, Open  ]],
Cell[5531, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

