(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7396,        248]
NotebookOptionsPosition[      5669,        194]
NotebookOutlinePosition[      6768,        224]
CellTagsIndexPosition[      6725,        221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Isomorphism" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Isomorphism"], 
          "TreeToCertificate" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/TreeToCertificate"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Isomorphism\"\>", 
       2->"\<\"TreeToCertificate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TreeIsomorphismQ", "ObjectName",
 CellID->22019],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TreeIsomorphismQ", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the trees ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "1"], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "2"], TraditionalForm]], "InlineMath"],
     " are isomorphic. It yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27459]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27094],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Isomorphism",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Isomorphism"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreeToCertificate",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/TreeToCertificate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11526160],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->438810958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->197690499]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TreeIsomorphismQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 3.4838356}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "TreeIsomorphismQ[t_1, t_2] yields True if the trees t_1 and t_2 are \
isomorphic. It yields False otherwise.", "synonyms" -> {}, "title" -> 
    "TreeIsomorphismQ", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/TreeIsomorphismQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1948, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2571, 78, 54, 1, 70, "ObjectName",
 CellID->22019],
Cell[2628, 81, 1079, 36, 70, "Usage",
 CellID->27459]
}, Open  ]],
Cell[CellGroupData[{
Cell[3744, 122, 311, 9, 70, "SeeAlsoSection",
 CellID->27094],
Cell[4058, 133, 503, 17, 70, "SeeAlso",
 CellID->24845]
}, Open  ]],
Cell[CellGroupData[{
Cell[4598, 155, 317, 9, 70, "TutorialsSection",
 CellID->11526160],
Cell[4918, 166, 187, 4, 70, "Tutorials",
 CellID->438810958]
}, Open  ]],
Cell[CellGroupData[{
Cell[5142, 175, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5464, 186, 163, 3, 70, "MoreAbout",
 CellID->197690499]
}, Open  ]],
Cell[5642, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

