(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9261,        312]
NotebookOptionsPosition[      7283,        249]
NotebookOutlinePosition[      8386,        279]
CellTagsIndexPosition[      8343,        276]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChromaticNumber" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ChromaticNumber"], "ChromaticPolynomial" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ChromaticPolynomial"], "EdgeColoring" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/EdgeColoring"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ChromaticNumber\"\>", 
       2->"\<\"ChromaticPolynomial\"\>", 
       3->"\<\"EdgeColoring\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VertexColoring", "ObjectName",
 CellID->29026],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VertexColoring", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses Brelaz's heuristic to find a good, but not \
necessarily minimal, vertex coloring of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option ",
 Cell[BoxData[
  ButtonBox["Algorithm",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Algorithm"]], "InlineFormula"],
 " that can take on the values ",
 Cell[BoxData[
  ButtonBox["Brelaz",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Brelaz"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Optimum",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Optimum"]], "InlineFormula"],
 " is allowed. "
}], "Notes",
 CellID->10342],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Algorithm",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Algorithm"], "->", 
   ButtonBox["Brelaz",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Brelaz"]}]], "InlineFormula"],
 " is the default, while the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Algorithm",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Algorithm"], "->", 
   ButtonBox["Optimum",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Optimum"]}]], "InlineFormula"],
 " forces the algorithm to do an exhaustive search to find an optimum vertex \
coloring."
}], "Notes",
 CellID->77243643]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1129],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChromaticNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ChromaticNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChromaticPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ChromaticPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeColoring",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/EdgeColoring"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30533]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->62008065],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->320565946]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->139292409]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexColoring - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 27.0000626}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "VertexColoring[g] uses Brelaz's heuristic to find a good, but not \
necessarily minimal, vertex coloring of graph g. ", "synonyms" -> {}, "title" -> 
    "VertexColoring", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/VertexColoring"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2093, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2716, 80, 52, 1, 70, "ObjectName",
 CellID->29026],
Cell[2771, 83, 538, 16, 70, "Usage",
 CellID->25188]
}, Open  ]],
Cell[CellGroupData[{
Cell[3346, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3824, 121, 514, 18, 70, "Notes",
 CellID->10342],
Cell[4341, 141, 708, 22, 70, "Notes",
 CellID->77243643]
}, Closed]],
Cell[CellGroupData[{
Cell[5086, 168, 310, 9, 70, "SeeAlsoSection",
 CellID->1129],
Cell[5399, 179, 782, 26, 70, "SeeAlso",
 CellID->30533]
}, Open  ]],
Cell[CellGroupData[{
Cell[6218, 210, 317, 9, 70, "TutorialsSection",
 CellID->62008065],
Cell[6538, 221, 187, 4, 70, "Tutorials",
 CellID->320565946]
}, Open  ]],
Cell[CellGroupData[{
Cell[6762, 230, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7084, 241, 157, 3, 70, "MoreAbout",
 CellID->139292409]
}, Open  ]],
Cell[7256, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

