(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14143,        527]
NotebookOptionsPosition[     11760,        449]
NotebookOutlinePosition[     12737,        477]
CellTagsIndexPosition[     12694,        474]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Algebra`AlgebraicInequalities`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "New function ",
 Cell[BoxData[
  ButtonBox["SemialgebraicComponentInstances",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SemialgebraicComponentInstances"]], 
  "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "UpgradeSummary",
 CellID->1010000471],

Cell["The output is returned as a list of rules:", "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Algebra`AlgebraicInequalities`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SemialgebraicComponents", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "3"}], ")"}]}], ">", "0"}], "}"}], ",", 
   "x"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "3"}], ")"}]}], ">", "0"}], "}"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->618449480]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SemialgebraicComponentInstances",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SemialgebraicComponentInstances"]], 
  "InlineFormula"],
 " accepts arbitrary Boolean combinations of equations and inequalities:"
}], "UpgradeDetail",
 CellID->1461802342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponents", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", 
         FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
      SuperscriptBox["y", "2"]}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", 
         FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
      SuperscriptBox["y", "2"]}], "==", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "UpgradeDetailLabel", \
"LegacyInputError",
 CellID->541672539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", 
         FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
      SuperscriptBox["y", "2"]}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", 
         FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
      SuperscriptBox["y", "2"]}], "==", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->161317871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["7"], "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       SqrtBox["7"], "4"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->459558880]
}, Open  ]],

Cell[TextData[{
 "Entering the equations as a ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " is equivalent to using the boolean operator ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->117987306],

Cell[BoxData[
 StyleBox[
  RowBox[{"SemialgebraicComponents", "[", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", 
           FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
        SuperscriptBox["y", "2"]}], "<", "1"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", 
           FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
        SuperscriptBox["y", "2"]}], "==", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}],
  FontWeight->"Bold"]], "UpgradeDetail", "LegacyInputError",
 CellID->931446075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
       SuperscriptBox["y", "2"]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", 
          FractionBox["1", "2"]}], ")"}], "2"], "+", " ", 
       SuperscriptBox["y", "2"]}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->783947446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["7"], "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       SqrtBox["7"], "4"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->144577743]
}, Open  ]],

Cell["You may also use other boolean operators:", "UpgradeDetail",
 CellID->670408563],

Cell[BoxData[
 StyleBox[
  RowBox[{"SemialgebraicComponents", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", 
            FractionBox["1", "2"]}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], "<", "1"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", 
            FractionBox["1", "2"]}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]}], ")"}], "||", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", 
            FractionBox["1", "2"]}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", 
            FractionBox["1", "2"]}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], "\[GreaterEqual]", "1"}]}], ")"}]}], ",",
     
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}],
  FontWeight->"Bold"]], "UpgradeDetail", "LegacyInputError",
 CellID->1805879542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", 
           FractionBox["1", "2"]}], ")"}], "2"], "+", 
        SuperscriptBox["y", "2"]}], "<", "1"}], "&&", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", 
           FractionBox["1", "2"]}], ")"}], "2"], "+", 
        SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", 
           FractionBox["1", "2"]}], ")"}], "2"], "+", 
        SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", 
           FractionBox["1", "2"]}], ")"}], "2"], "+", 
        SuperscriptBox["y", "2"]}], "\[GreaterEqual]", "1"}]}], ")"}]}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1424896480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3", "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3", "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["15"], "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3", "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       SqrtBox["15"], "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["7"], "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       SqrtBox["7"], "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["3"], "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       SqrtBox["3"], "2"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->1454901548]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 58.8915040}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/AlgebraicInequalities"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 80, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[892, 35, 342, 12, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1237, 49, 87, 1, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1327, 52, 490, 16, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1842, 72, 408, 14, 70, "Input",
 CellID->1746043248],
Cell[2253, 88, 337, 12, 70, "Output",
 CellID->618449480]
}, Open  ]],
Cell[2605, 103, 299, 8, 70, "UpgradeDetail",
 CellID->1461802342],
Cell[CellGroupData[{
Cell[2929, 115, 628, 21, 70, "UpgradeDetailLabel",
 CellID->541672539],
Cell[CellGroupData[{
Cell[3582, 140, 624, 21, 70, "Input",
 CellID->161317871],
Cell[4209, 163, 717, 27, 70, "Output",
 CellID->459558880]
}, Open  ]],
Cell[4941, 193, 364, 13, 70, "UpgradeDetail",
 CellID->117987306],
Cell[5308, 208, 713, 23, 70, "UpgradeDetail",
 CellID->931446075],
Cell[CellGroupData[{
Cell[6046, 235, 662, 22, 70, "Input",
 CellID->783947446],
Cell[6711, 259, 717, 27, 70, "Output",
 CellID->144577743]
}, Open  ]],
Cell[7443, 289, 86, 1, 70, "UpgradeDetail",
 CellID->670408563],
Cell[7532, 292, 1254, 41, 70, "UpgradeDetail",
 CellID->1805879542],
Cell[CellGroupData[{
Cell[8811, 337, 1185, 40, 70, "Input",
 CellID->1424896480],
Cell[9999, 379, 1695, 63, 70, "Output",
 CellID->1454901548]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[11733, 447, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

