(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11739,        441]
NotebookOptionsPosition[      9223,        359]
NotebookOutlinePosition[     10191,        387]
CellTagsIndexPosition[     10148,        384]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Algebra`RootIsolation`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "New functions ",
 Cell[BoxData[
  ButtonBox["CountRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountRoots"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["IsolatingInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IsolatingInterval"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["RootIntervals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootIntervals"]], "InlineFormula"],
 " have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData[
  ButtonBox["IsolatingInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IsolatingInterval"]], "InlineFormula"],
 " includes the functionality of ",
 Cell[BoxData["ContractInterval"], "InlineFormula"],
 " from Version 5.2.\n",
 Cell[BoxData[
  ButtonBox["RootIntervals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootIntervals"]], "InlineFormula"],
 " incorporates the functionality of ",
 Cell[BoxData["RealRootIntervals"], "InlineFormula"],
 " and ",
 Cell[BoxData["ComplexRootIntervals"], "InlineFormula"],
 " from Version 5.2."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CountRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountRoots"]], "InlineFormula"],
 " now counts roots in closed intervals; in Version 5.2, it used open \
intervals:"
}], "UpgradeDetail",
 CellID->345373338],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Algebra`RootIsolation`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "4"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "4"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1746043248],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[4]=",
 CellID->225016411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2070552641],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootIntervals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootIntervals"]], "InlineFormula"],
 " gives real roots by default:"
}], "UpgradeDetail",
 CellID->1992490216],

Cell[BoxData[
 RowBox[{"RealRootIntervals", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "4"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->827737340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "3"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "4"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15478017],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", 
        FractionBox["3", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->174845797]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1355344251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootIntervals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootIntervals"]], "InlineFormula"],
 " also gives complex roots:"
}], "UpgradeDetail",
 CellID->911782828],

Cell[BoxData[
 RowBox[{"ComplexRootIntervals", "[", 
  RowBox[{"f", "+", "3"}], "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->1953221299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"f", "+", "3"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78379944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "7"}], "-", 
        RowBox[{"7", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"-", 
        FractionBox["7", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["7", "4"]}], "+", 
        RowBox[{"7", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["7", "4"]}], "-", 
        RowBox[{"7", " ", "\[ImaginaryI]"}]}], ",", 
       FractionBox["7", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["7", "4"]}], ",", 
       RowBox[{
        FractionBox["7", "2"], "+", 
        RowBox[{"7", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->490723471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2038168851],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IsolatingInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IsolatingInterval"]], "InlineFormula"],
 " includes the functionality of ",
 Cell[BoxData["ContractInterval"], "InlineFormula"],
 " from Version 5.2:"
}], "UpgradeDetail",
 CellID->992225460],

Cell[BoxData[
 RowBox[{"ContractInterval", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "10"}], "-", "1"}], ",", "5"}], "]"}], ",", "10"}], 
  "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->344037200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "10"}], "-", "1"}], ",", "5"}], "]"}], ",", 
   RowBox[{"10", "^", 
    RowBox[{"-", "10"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298296371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["5", "16"]}], "-", 
    FractionBox[
     RowBox[{"61", " ", "\[ImaginaryI]"}], "64"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["19", "64"]}], "-", 
    FractionBox[
     RowBox[{"15", " ", "\[ImaginaryI]"}], "16"]}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1830672511]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 6.4229468}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/RootIsolation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 72, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[884, 35, 1149, 37, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[2036, 74, 263, 8, 70, "UpgradeDetail",
 CellID->345373338],
Cell[2302, 84, 538, 18, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2865, 106, 457, 16, 70, "Input",
 CellID->1746043248],
Cell[3325, 124, 71, 2, 70, "Output",
 CellID->225016411]
}, Open  ]],
Cell[3411, 129, 126, 3, 70, "ExampleDelimiter",
 CellID->2070552641],
Cell[3540, 134, 219, 7, 70, "UpgradeDetail",
 CellID->1992490216],
Cell[3762, 143, 480, 17, 70, "Input",
 CellID->827737340],
Cell[CellGroupData[{
Cell[4267, 164, 366, 13, 70, "Input",
 CellID->15478017],
Cell[4636, 179, 1012, 36, 70, "Output",
 CellID->174845797]
}, Open  ]],
Cell[5663, 218, 126, 3, 70, "ExampleDelimiter",
 CellID->1355344251],
Cell[5792, 223, 215, 7, 70, "UpgradeDetail",
 CellID->911782828],
Cell[6010, 232, 155, 4, 70, "Input",
 CellID->1953221299],
Cell[CellGroupData[{
Cell[6190, 240, 163, 5, 70, "Input",
 CellID->78379944],
Cell[6356, 247, 1394, 48, 70, "Output",
 CellID->490723471]
}, Open  ]],
Cell[7765, 298, 126, 3, 70, "ExampleDelimiter",
 CellID->2038168851],
Cell[7894, 303, 304, 9, 70, "UpgradeDetail",
 CellID->992225460],
Cell[8201, 314, 265, 9, 70, "Input",
 CellID->344037200],
Cell[CellGroupData[{
Cell[8491, 327, 293, 10, 70, "Input",
 CellID->298296371],
Cell[8787, 339, 382, 14, 70, "Output",
 CellID->1830672511]
}, Open  ]]
}, Open  ]],
Cell[9196, 357, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

