(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5389,        193]
NotebookOptionsPosition[      3733,        141]
NotebookOutlinePosition[      4704,        169]
CellTagsIndexPosition[      4661,        166]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Calculus`FourierTransform`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All of the functionality in ",
 Cell[BoxData["Calculus`FourierTransform`"], "InlineFormula"],
 " is now available through the newly created ",
 ButtonBox["Fourier Series Package",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/guide/FourierSeriesPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Fourier Series Package",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/guide/FourierSeriesPackage"],
 ", load ",
 Cell[BoxData["FourierSeries`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->153674676],

Cell[BoxData[
 RowBox[{"<<", "Calculus`FourierTransform`"}]], "Input", "LegacyInput",
 CellID->1663071679],

Cell[BoxData[
 RowBox[{"<<", "FourierSeries`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1746043248],

Cell[TextData[{
 "This gives a numerical approximation to the Fourier transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", 
    RowBox[{"(", 
     RowBox[{"-", 
      SuperscriptBox[
       StyleBox["t", "TI"], "2"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[LeftBracketingBar]", 
      StyleBox["t", "TI"], "\[RightBracketingBar]"}], ")"}]}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " with respect to ",
 Cell[BoxData[
  FormBox["\[Omega]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ":"
}], "UpgradeDetail",
 CellID->64911255],

Cell[BoxData[
 RowBox[{"NFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"t", "^", "2"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Abs", "[", "t", "]"}]}], ")"}]}], ",", "t", ",", "1"}], 
  "]"}]], "Input", "LegacyInput",
 CellID->70687755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"t", "^", "2"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Abs", "[", "t", "]"}]}], ")"}]}], ",", "t", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->89948489],

Cell[BoxData[
 RowBox[{"0.40402407559580034`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[3]=",
 CellID->208158222]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 6.8917088}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/FourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 76, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[888, 35, 332, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1223, 46, 290, 9, 70, "UpgradeDetail",
 CellID->153674676],
Cell[1516, 57, 106, 2, 70, "Input",
 CellID->1663071679],
Cell[1625, 61, 102, 3, 70, "Input",
 CellID->1746043248],
Cell[1730, 66, 1082, 34, 70, "UpgradeDetail",
 CellID->64911255],
Cell[2815, 102, 329, 11, 70, "Input",
 CellID->70687755],
Cell[CellGroupData[{
Cell[3169, 117, 337, 12, 70, "Input",
 CellID->89948489],
Cell[3509, 131, 170, 4, 70, "Output",
 CellID->208158222]
}, Open  ]]
}, Open  ]],
Cell[3706, 139, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

