(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10715,        401]
NotebookOptionsPosition[      8235,        319]
NotebookOutlinePosition[      9194,        347]
CellTagsIndexPosition[      9151,        344]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Calculus`Pade`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadeApproximant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadeApproximant"]], "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. \n",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EconomizedRationalApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"], 
   "InlineCode"]], "InlineFormula"],
 " is now available in the newly created ",
 ButtonBox["Function Approximations Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["PadeApproximant", "UpgradeDetailLabel",
 CellID->305554978],

Cell[TextData[{
 "Syntax for ",
 Cell[BoxData[
  ButtonBox["PadeApproximant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadeApproximant"]], "InlineFormula"],
 " has changed from the ",
 Cell[BoxData["Pade"], "InlineFormula"],
 " function in",
 Cell[BoxData[
  RowBox[{" ", "Calculus`Pade`"}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[{
 RowBox[{"<<", "Calculus`Pade`"}], "\[IndentingNewLine]", 
 RowBox[{"Pade", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4", ",", "4"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->74822349],

Cell[TextData[{
 "The Pade approximant of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cos"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " about the point ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", "0", " "}]], "InlineFormula"],
 "with numerator of degree 2 and denominator of degree 4:"
}], "UpgradeDetail",
 CellID->543438851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadeApproximant", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->524782711],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"61", " ", 
     SuperscriptBox["x", "2"]}], "150"]}], 
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "2"]}], "75"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "200"]}]]], "Output",
 CellLabel->"Out[12]=",
 CellID->322134067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2070552641],

Cell["\<\
This finds the diagonal Pad\[EAcute] approximant of order 4:\
\>", "UpgradeDetail",
 CellID->1893879272],

Cell[BoxData[
 RowBox[{"Pade", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2", ",", "4"}], "}"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->43335346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadeApproximant", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->425947826],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"115", " ", 
     SuperscriptBox["x", "2"]}], "252"], "+", 
   FractionBox[
    RowBox[{"313", " ", 
     SuperscriptBox["x", "4"]}], "15120"]}], 
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "2"]}], "252"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "4"]}], "15120"]}]]], "Output",
 CellLabel->"Out[2]=",
 CellID->33192322]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EconomizedRationalApproximation", "UpgradeDetailLabel",
 CellID->86537776],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Function Approximations Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"],
 ", load ",
 Cell[BoxData["FunctionApproximations`"], "InlineFormula"],
 ": "
}], "UpgradeDetail",
 CellID->214768297],

Cell[BoxData[
 RowBox[{"<<", "Calculus`Pade`"}]], "Input", "LegacyInput",
 CellID->41422568],

Cell[BoxData[
 RowBox[{"<<", "FunctionApproximations`"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21217621],

Cell[TextData[{
 "Syntax for ",
 StyleBox[ButtonBox["EconomizedRationalApproximation",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"], 
  "InlineCode"],
 " is the same as in ",
 Cell[BoxData["Calculus`Pade`"], "InlineFormula"],
 " in Version 5.2. Here is the economized rational approximation of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "4"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["x", "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " over the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", 
    StyleBox["x", "TI"], "\[LessEqual]", "2"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ":"
}], "UpgradeDetail",
 CellID->181086703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"era", "=", 
  RowBox[{"EconomizedRationalApproximation", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1058768948],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{"679583", " ", "\[ExponentialE]"}], "691200"], "+", 
   FractionBox[
    RowBox[{"4679", " ", "\[ExponentialE]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "14400"], "+", 
   RowBox[{
    FractionBox["23", "720"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}]}], 
  RowBox[{
   FractionBox["679583", "691200"], "-", 
   FractionBox[
    RowBox[{"9479", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "14400"], "+", 
   RowBox[{
    FractionBox["143", "720"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "30"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]}]}]]], "Output",
 CellLabel->"Out[3]=",
 CellID->471110460]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 7.0323374}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Pade"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 64, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[876, 35, 725, 23, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[1626, 62, 65, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[1694, 65, 365, 13, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[2062, 80, 277, 8, 70, "Input",
 CellID->74822349],
Cell[2342, 90, 412, 14, 70, "UpgradeDetail",
 CellID->543438851],
Cell[CellGroupData[{
Cell[2779, 108, 298, 9, 70, "Input",
 CellID->524782711],
Cell[3080, 119, 350, 13, 70, "Output",
 CellID->322134067]
}, Open  ]],
Cell[3445, 135, 126, 3, 70, "ExampleDelimiter",
 CellID->2070552641],
Cell[3574, 140, 114, 3, 70, "UpgradeDetail",
 CellID->1893879272],
Cell[3691, 145, 239, 8, 70, "Input",
 CellID->43335346],
Cell[CellGroupData[{
Cell[3955, 157, 239, 7, 70, "Input",
 CellID->425947826],
Cell[4197, 166, 470, 17, 70, "Output",
 CellID->33192322]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4716, 189, 80, 1, 70, "UpgradeDetailLabel",
 CellID->86537776],
Cell[4799, 192, 331, 10, 70, "UpgradeDetail",
 CellID->214768297],
Cell[5133, 204, 92, 2, 70, "Input",
 CellID->41422568],
Cell[5228, 208, 109, 3, 70, "Input",
 CellID->21217621],
Cell[5340, 213, 1268, 40, 70, "UpgradeDetail",
 CellID->181086703],
Cell[CellGroupData[{
Cell[6633, 257, 339, 11, 70, "Input",
 CellID->1058768948],
Cell[6975, 270, 1194, 42, 70, "Output",
 CellID->471110460]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8208, 317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

