(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11384,        429]
NotebookOptionsPosition[      8044,        317]
NotebookOutlinePosition[      9029,        345]
CellTagsIndexPosition[      8986,        342]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["DiscreteMath`CombinatorialFunctions`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CatalanNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CatalanNumber"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. \n",
 Cell[BoxData[
  ButtonBox["CatalanNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CatalanNumber"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " can now be evaluated numerically for non-integer arguments.\n",
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " now accepts complex arguments."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["CatalanNumber", "UpgradeDetailLabel",
 CellID->1433083933],

Cell[TextData[{
 "Syntax for ",
 Cell[BoxData[
  ButtonBox["CatalanNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CatalanNumber"]], "InlineFormula"],
 " is the same as in ",
 Cell[BoxData["DiscreteMath`CombinatorialFunctions`"], "InlineFormula"],
 " in Version 5.2:"
}], "UpgradeDetail",
 CellID->589507829],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`CombinatorialFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CatalanNumber", "[", "n", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "1", ",", "10"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->277401373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CatalanNumber", "[", "n", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2127015697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "5", ",", "14", ",", "42", ",", "132", ",", "429", ",", 
   "1430", ",", "4862", ",", "16796"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->41977363]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1972195490],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CatalanNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CatalanNumber"]], "InlineFormula"],
 " can now be evaluated numerically for non-integer arguments:"
}], "UpgradeDetail",
 CellID->173231679],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"CatalanNumber", "[", 
   RowBox[{"1", "/", "2"}], "]"}], "]"}]], "Input", "LegacyInputError",
 CellLabel->"In[1]:=",
 CellID->10844172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"CatalanNumber", "[", 
   RowBox[{"1", "/", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->198118193],

Cell[BoxData["0.8488263631567753`"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"Out[2]=",
 CellID->24940867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199600824],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CatalanNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CatalanNumber"]], "InlineFormula"],
 " can now be evaluated for complex arguments: "
}], "UpgradeDetail",
 CellID->201618176],

Cell[BoxData[
 RowBox[{"CatalanNumber", "[", 
  RowBox[{"0.5", " ", "I"}], "]"}]], "Input", "LegacyInputError",
 CellLabel->"In[1]:=",
 CellID->43644304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CatalanNumber", "[", 
  RowBox[{"0.5", " ", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->732894501],

Cell[BoxData[
 RowBox[{"0.6573635312931975`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.18701614008649547`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"Out[2]=",
 CellID->158496935]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Subfactorial", "UpgradeDetailLabel",
 CellID->1812560826],

Cell[TextData[{
 "Syntax for ",
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " is the same as in ",
 Cell[BoxData["DiscreteMath`CombinatorialFunctions`"], "InlineFormula"],
 " in Version 5.2:"
}], "UpgradeDetail",
 CellID->316867029],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`CombinatorialFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Subfactorial", "[", "n", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "10"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->691910562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Subfactorial", "[", "n", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->69358216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "9", ",", "44", ",", "265", ",", "1854", ",", 
   "14833", ",", "133496", ",", "1334961"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->582772962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279508985],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " can now be evaluated numerically for non-integer arguments:"
}], "UpgradeDetail",
 CellID->765796629],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Subfactorial", "[", 
   RowBox[{"1", "/", "2"}], "]"}], "]"}]], "Input", "LegacyInputError",
 CellLabel->"In[1]:=",
 CellID->500801414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Subfactorial", "[", 
   RowBox[{"1", "/", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16423570],

Cell[BoxData[
 RowBox[{"0.3260246660866462`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.4619204930872316`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->135964595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1160774906],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " can now be evaluated for complex arguments: "
}], "UpgradeDetail",
 CellID->118686123],

Cell[BoxData[
 RowBox[{"Subfactorial", "[", 
  RowBox[{"1.5", "+", "I"}], "]"}]], "Input", "LegacyInputError",
 CellLabel->"In[1]:=",
 CellID->251795742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subfactorial", "[", 
  RowBox[{"1.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621012267],

Cell[BoxData[
 RowBox[{"0.2811496622267996`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.2483722972785482`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"Out[2]=",
 CellID->172366987]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 7.5167248}", "context" -> 
    "DiscreteMath`", "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/CombinatorialFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 86, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[898, 35, 922, 30, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[1845, 69, 64, 1, 70, "UpgradeDetailLabel",
 CellID->1433083933],
Cell[1912, 72, 318, 10, 70, "UpgradeDetail",
 CellID->589507829],
Cell[2233, 84, 333, 10, 70, "Input",
 CellID->277401373],
Cell[CellGroupData[{
Cell[2591, 98, 236, 7, 70, "Input",
 CellID->2127015697],
Cell[2830, 107, 218, 6, 70, "Output",
 CellID->41977363]
}, Open  ]],
Cell[3063, 116, 126, 3, 70, "ExampleDelimiter",
 CellID->1972195490],
Cell[3192, 121, 249, 7, 70, "UpgradeDetail",
 CellID->173231679],
Cell[3444, 130, 180, 5, 70, "Input",
 CellID->10844172],
Cell[CellGroupData[{
Cell[3649, 139, 161, 5, 70, "Input",
 CellID->198118193],
Cell[3813, 146, 136, 4, 70, "Output",
 CellID->24940867]
}, Open  ]],
Cell[3964, 153, 125, 3, 70, "ExampleDelimiter",
 CellID->199600824],
Cell[4092, 158, 234, 7, 70, "UpgradeDetail",
 CellID->201618176],
Cell[4329, 167, 153, 4, 70, "Input",
 CellID->43644304],
Cell[CellGroupData[{
Cell[4507, 175, 134, 4, 70, "Input",
 CellID->732894501],
Cell[4644, 181, 234, 6, 70, "Output",
 CellID->158496935]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4927, 193, 63, 1, 70, "UpgradeDetailLabel",
 CellID->1812560826],
Cell[4993, 196, 316, 10, 70, "UpgradeDetail",
 CellID->316867029],
Cell[5312, 208, 320, 9, 70, "Input",
 CellID->691910562],
Cell[CellGroupData[{
Cell[5657, 221, 223, 7, 70, "Input",
 CellID->69358216],
Cell[5883, 230, 224, 6, 70, "Output",
 CellID->582772962]
}, Open  ]],
Cell[6122, 239, 125, 3, 70, "ExampleDelimiter",
 CellID->279508985],
Cell[6250, 244, 247, 7, 70, "UpgradeDetail",
 CellID->765796629],
Cell[6500, 253, 180, 5, 70, "Input",
 CellID->500801414],
Cell[CellGroupData[{
Cell[6705, 262, 159, 5, 70, "Input",
 CellID->16423570],
Cell[6867, 269, 185, 4, 70, "Output",
 CellID->135964595]
}, Open  ]],
Cell[7067, 276, 126, 3, 70, "ExampleDelimiter",
 CellID->1160774906],
Cell[7196, 281, 232, 7, 70, "UpgradeDetail",
 CellID->118686123],
Cell[7431, 290, 153, 4, 70, "Input",
 CellID->251795742],
Cell[CellGroupData[{
Cell[7609, 298, 133, 4, 70, "Input",
 CellID->621012267],
Cell[7745, 304, 233, 6, 70, "Output",
 CellID->172366987]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8017, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

