(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5843,        222]
NotebookOptionsPosition[      4033,        164]
NotebookOutlinePosition[      4995,        192]
CellTagsIndexPosition[      4952,        189]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["DiscreteMath`RSolve`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "The functionality is now available in built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel functions ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ZTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZTransform"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 ".\nBuilt-in kernel function ",
 Cell[BoxData[
  ButtonBox["SeriesCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesCoefficient"]], "InlineFormula"],
 " now contains the functionality for ",
 Cell[BoxData["SeriesTerm"], "InlineFormula"],
 ". "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Compute the generating function of the sequence of squares of integers \
using ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->295704136],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`RSolve`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PowerSum", "[", 
  RowBox[{
   SuperscriptBox["n", "2"], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "n"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["n", "2"], 
    SuperscriptBox["x", "n"]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5263471],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "x"}], "-", 
   SuperscriptBox["x", "2"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]]], "Output",
 CellLabel->"Out[1]=",
 CellID->234345062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->577005136],

Cell[TextData[{
 "Compute the general term in the series expansion of ",
 Cell[BoxData[
  SuperscriptBox["\[ExponentialE]", "x"]]],
 ", using ",
 Cell[BoxData[
  ButtonBox["SeriesCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesCoefficient"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->723029451],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`RSolve`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SeriesTerm", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->229428472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->330141538],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"n", "!"}]]], "Output",
 CellLabel->"Out[2]=",
 CellID->246360743]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 14.9544152}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/RSolve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 70, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[882, 35, 807, 28, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1692, 65, 254, 9, 70, "UpgradeDetail",
 CellID->295704136],
Cell[1949, 76, 289, 8, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2263, 88, 278, 10, 70, "Input",
 CellID->5263471],
Cell[2544, 100, 252, 10, 70, "Output",
 CellID->234345062]
}, Open  ]],
Cell[2811, 113, 125, 3, 70, "ExampleDelimiter",
 CellID->577005136],
Cell[2939, 118, 327, 11, 70, "UpgradeDetail",
 CellID->723029451],
Cell[3269, 131, 334, 10, 70, "Input",
 CellID->229428472],
Cell[CellGroupData[{
Cell[3628, 145, 239, 7, 70, "Input",
 CellID->330141538],
Cell[3870, 154, 109, 4, 70, "Output",
 CellID->246360743]
}, Open  ]]
}, Open  ]],
Cell[4006, 162, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

