(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13334,        476]
NotebookOptionsPosition[     10544,        382]
NotebookOutlinePosition[     11509,        410]
CellTagsIndexPosition[     11466,        407]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Geometry`Rotations`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All of the functionality in ",
 Cell[BoxData["Geometry`Rotations`"], "InlineFormula"],
 " is now available in the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["RotationTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotationTransform"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell["\<\
Here is the matrix for rotation by \[Theta] degrees :\
\>", "UpgradeDetail",
 CellID->178111877],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Geometry`Rotations`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"RotationMatrix2D", "[", "\[Theta]", "]"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->104355620],

Cell[TextData[{
 "In Version 6, we get a ",
 Cell[BoxData[
  ButtonBox["TransformationFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
 " that represents a rotation in 2D by \[Theta] radians about the origin. "
}], "UpgradeDetail",
 CellID->16644231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", " ", 
  RowBox[{"RotationTransform", "[", 
   RowBox[{"-", "\[Theta]"}], "]"}]}]], "Input",
 CellLabel->"In[32]:=",
 CellID->548503351],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      RowBox[{"Cos", "[", "\[Theta]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "0"},
     {
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "0"},
     {"0", "0", "1"}
    },
    ColumnsEqual->False,
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False], ")"}], "]"}]], "Output",
 CellLabel->"Out[32]=",
 CellID->2104083968]
}, Open  ]],

Cell["\<\
The point {0, 0} is rotated about the point {1,1} by 60 degrees: \
\>", "UpgradeDetail",
 CellID->259791230],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Geometry`Rotations`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{"RotationMatrix2D", "[", 
    RowBox[{"N", "[", 
     RowBox[{"Pi", "/", "3"}], "]"}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Rotate2D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.", ",", "0."}], "}"}], ",", " ", 
   RowBox[{"N", "[", 
    RowBox[{"Pi", "/", "3"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1.", ",", " ", "1."}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->74822349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", " ", 
  RowBox[{"RotationTransform", "[", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "3"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[33]:=",
 CellID->524782711],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"0.5000000000000001`", "0.8660254037844386`", 
      RowBox[{"-", "0.3660254037844388`"}]},
     {
      RowBox[{"-", "0.8660254037844386`"}], "0.5000000000000001`", 
      "1.3660254037844384`"},
     {"0.`", "0.`", "1.`"}
    },
    ColumnsEqual->False,
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False], ")"}], "]"}]], "Output",
 CellLabel->"Out[33]=",
 CellID->726035027]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "[", 
  RowBox[{"{", 
   RowBox[{"0.", ",", "0."}], "}"}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->2786254],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3660254037844384`", ",", 
   RowBox[{"-", "0.3660254037844388`"}]}], "}"}]], "Output",
 CellLabel->"Out[53]=",
 CellID->77660872]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RotationMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotationMatrix"]], "InlineFormula"],
 " rotates points in the opposite direction from ",
 Cell[BoxData["RotationMatrix2D"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1374219781],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Geometry`Rotations`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RotationMatrix2D", "[", "phi", "]"}]}], "Input", "LegacyInput",
 CellID->325235782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotationMatrix", "[", 
  RowBox[{"-", "phi"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->891906459],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "phi", "]"}], ",", 
     RowBox[{"Sin", "[", "phi", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
     RowBox[{"Cos", "[", "phi", "]"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->836000353]
}, Open  ]],

Cell[TextData[{
 "Similarly ",
 Cell[BoxData[
  ButtonBox["RotationTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotationTransform"]], "InlineFormula"],
 " rotates points in the opposite direction from ",
 Cell[BoxData["Rotate2D"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1819914197],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Geometry`Rotations`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Rotate2D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "phi", ",", 
   RowBox[{"{", 
    RowBox[{"x0", ",", "y0"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->179801317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationTransform", "[", 
   RowBox[{
    RowBox[{"-", "phi"}], ",", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->411243490],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x0", "+", 
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "phi", "]"}]}], "-", 
    RowBox[{"x0", " ", 
     RowBox[{"Cos", "[", "phi", "]"}]}], "+", 
    RowBox[{"y", " ", 
     RowBox[{"Sin", "[", "phi", "]"}]}], "-", 
    RowBox[{"y0", " ", 
     RowBox[{"Sin", "[", "phi", "]"}]}]}], ",", 
   RowBox[{"y0", "+", 
    RowBox[{"y", " ", 
     RowBox[{"Cos", "[", "phi", "]"}]}], "-", 
    RowBox[{"y0", " ", 
     RowBox[{"Cos", "[", "phi", "]"}]}], "-", 
    RowBox[{"x", " ", 
     RowBox[{"Sin", "[", "phi", "]"}]}], "+", 
    RowBox[{"x0", " ", 
     RowBox[{"Sin", "[", "phi", "]"}]}]}]}], "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->1166960384]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RotationMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotationMatrix"]], "InlineFormula"],
 " uses yaw-pitch-roll angles rather than the Euler angles used by ",
 Cell[BoxData["RotationMatrix3D"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->864983555],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Geometry`Rotations`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RotationMatrix3D", "[", 
  RowBox[{"phi", ",", "theta", ",", "psi"}], "]"}]}], "Input", "LegacyInput",
 CellID->2021125060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix", "[", 
   RowBox[{
    RowBox[{"Pi", "-", "psi"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ".", 
  RowBox[{"RotationMatrix", "[", 
   RowBox[{"theta", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], ".", 
  RowBox[{"RotationMatrix", "[", 
   RowBox[{
    RowBox[{"Pi", "-", "phi"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->152555174],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "phi", "]"}], " ", 
       RowBox[{"Cos", "[", "psi", "]"}]}], "-", 
      RowBox[{
       RowBox[{"Cos", "[", "theta", "]"}], " ", 
       RowBox[{"Sin", "[", "phi", "]"}], " ", 
       RowBox[{"Sin", "[", "psi", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "psi", "]"}], " ", 
       RowBox[{"Sin", "[", "phi", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", "phi", "]"}], " ", 
       RowBox[{"Cos", "[", "theta", "]"}], " ", 
       RowBox[{"Sin", "[", "psi", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "psi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cos", "[", "psi", "]"}]}], " ", 
       RowBox[{"Cos", "[", "theta", "]"}], " ", 
       RowBox[{"Sin", "[", "phi", "]"}]}], "-", 
      RowBox[{
       RowBox[{"Cos", "[", "phi", "]"}], " ", 
       RowBox[{"Sin", "[", "psi", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "phi", "]"}], " ", 
       RowBox[{"Cos", "[", "psi", "]"}], " ", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "-", 
      RowBox[{
       RowBox[{"Sin", "[", "phi", "]"}], " ", 
       RowBox[{"Sin", "[", "psi", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "psi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Cos", "[", "phi", "]"}]}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
     RowBox[{"Cos", "[", "theta", "]"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->2046818547]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 15.1106692}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Rotations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 69, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[881, 35, 399, 13, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1283, 50, 106, 3, 70, "UpgradeDetail",
 CellID->178111877],
Cell[1392, 55, 234, 6, 70, "Input",
 CellID->104355620],
Cell[1629, 63, 306, 8, 70, "UpgradeDetail",
 CellID->16644231],
Cell[CellGroupData[{
Cell[1960, 75, 168, 5, 70, "Input",
 CellID->548503351],
Cell[2131, 82, 626, 18, 70, "Output",
 CellID->2104083968]
}, Open  ]],
Cell[2772, 103, 118, 3, 70, "UpgradeDetail",
 CellID->259791230],
Cell[2893, 108, 570, 17, 70, "Input",
 CellID->74822349],
Cell[CellGroupData[{
Cell[3488, 129, 301, 10, 70, "Input",
 CellID->524782711],
Cell[3792, 141, 603, 16, 70, "Output",
 CellID->726035027]
}, Open  ]],
Cell[CellGroupData[{
Cell[4432, 162, 145, 5, 70, "Input",
 CellID->2786254],
Cell[4580, 169, 171, 5, 70, "Output",
 CellID->77660872]
}, Open  ]],
Cell[4766, 177, 298, 9, 70, "UpgradeDetail",
 CellID->1374219781],
Cell[5067, 188, 190, 4, 70, "Input",
 CellID->325235782],
Cell[CellGroupData[{
Cell[5282, 196, 130, 4, 70, "Input",
 CellID->891906459],
Cell[5415, 202, 376, 13, 70, "Output",
 CellID->836000353]
}, Open  ]],
Cell[5806, 218, 311, 10, 70, "UpgradeDetail",
 CellID->1819914197],
Cell[6120, 230, 315, 9, 70, "Input",
 CellID->179801317],
Cell[CellGroupData[{
Cell[6460, 243, 287, 10, 70, "Input",
 CellID->411243490],
Cell[6750, 255, 711, 22, 70, "Output",
 CellID->1166960384]
}, Open  ]],
Cell[7476, 280, 315, 9, 70, "UpgradeDetail",
 CellID->864983555],
Cell[7794, 291, 230, 5, 70, "Input",
 CellID->2021125060],
Cell[CellGroupData[{
Cell[8049, 300, 541, 17, 70, "Input",
 CellID->152555174],
Cell[8593, 319, 1897, 57, 70, "Output",
 CellID->2046818547]
}, Open  ]]
}, Open  ]],
Cell[10517, 380, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

