(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77068,       1360]
NotebookOptionsPosition[     75235,       1302]
NotebookOutlinePosition[     76201,       1330]
CellTagsIndexPosition[     76158,       1327]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`ComplexMap`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "The new two-parameter form of ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " now provides the functionality of ",
 Cell[BoxData["Graphics`ComplexMap`"], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData["CartesianMap"], "InlineFormula"],
 " functionality is now produced using ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`ComplexMap`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CartesianMap", "[", 
  RowBox[{"Exp", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Through", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}], "[", 
     RowBox[{"Exp", "[", 
      RowBox[{"x", "+", 
       RowBox[{"I", "*", "y"}]}], "]"}], "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[110]:=",
 CellID->1746043248],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1m3dczu8b9pv2iG/Zq8zIClnpvDMKlSR7RlJRlFARympRCIkoDZuKjAbn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   "], {{{}, {}, {}, {}}, {
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{2, 1, 26, 977, 51, 1002, 76, 101, 1027, 126, 1052, 151, 176, 
       1077, 201, 1102, 226, 251, 1127, 276, 1152, 301, 326, 1177, 351, 1202, 
       376, 401, 1227, 426, 451, 476, 1252, 501, 1277, 526, 551, 1302, 576, 
       601, 602, 962, 603, 963, 604, 605, 964, 606, 965, 607, 608, 966, 609, 
       967, 610, 611, 968, 612, 969, 613, 614, 970, 615, 971, 616, 617, 972, 
       618, 619, 620, 973, 621, 974, 622, 623, 975, 624, 625, 600, 1325, 575, 
       550, 1300, 525, 1275, 500, 475, 450, 1250, 425, 400, 1225, 375, 1200, 
       350, 325, 1175, 300, 1150, 275, 250, 1125, 225, 1100, 200, 175, 1075, 
       150, 1050, 125, 100, 1025, 75, 1000, 50, 25, 24, 652, 23, 22, 650, 21, 
       648, 20, 19, 18, 646, 17, 16, 644, 15, 642, 14, 13, 640, 12, 638, 11, 
       10, 636, 9, 634, 8, 7, 632, 6, 630, 5, 4, 628, 3, 626, 2}]}, {}, {}, 
     {GrayLevel[0], Opacity[0.3], 
      LineBox[{626, 627, 1326, 654, 1340, 668, 682, 1354, 696, 1368, 710, 724,
        1382, 738, 1396, 752, 766, 1410, 780, 1424, 794, 808, 1438, 822, 1452,
        836, 850, 1466, 864, 878, 892, 1480, 906, 1494, 920, 934, 1508, 948, 
       962}], LineBox[{628, 629, 1327, 655, 1341, 669, 683, 1355, 697, 1369, 
       711, 725, 1383, 739, 1397, 753, 767, 1411, 781, 1425, 795, 809, 1439, 
       823, 1453, 837, 851, 1467, 865, 879, 893, 1481, 907, 1495, 921, 935, 
       1509, 949, 963}], 
      LineBox[{630, 631, 1328, 656, 1342, 670, 684, 1356, 698, 1370, 712, 726,
        1384, 740, 1398, 754, 768, 1412, 782, 1426, 796, 810, 1440, 824, 1454,
        838, 852, 1468, 866, 880, 894, 1482, 908, 1496, 922, 936, 1510, 950, 
       964}], LineBox[{632, 633, 1329, 657, 1343, 671, 685, 1357, 699, 1371, 
       713, 727, 1385, 741, 1399, 755, 769, 1413, 783, 1427, 797, 811, 1441, 
       825, 1455, 839, 853, 1469, 867, 881, 895, 1483, 909, 1497, 923, 937, 
       1511, 951, 965}], 
      LineBox[{634, 635, 1330, 658, 1344, 672, 686, 1358, 700, 1372, 714, 728,
        1386, 742, 1400, 756, 770, 1414, 784, 1428, 798, 812, 1442, 826, 1456,
        840, 854, 1470, 868, 882, 896, 1484, 910, 1498, 924, 938, 1512, 952, 
       966}], LineBox[{636, 637, 1331, 659, 1345, 673, 687, 1359, 701, 1373, 
       715, 729, 1387, 743, 1401, 757, 771, 1415, 785, 1429, 799, 813, 1443, 
       827, 1457, 841, 855, 1471, 869, 883, 897, 1485, 911, 1499, 925, 939, 
       1513, 953, 967}], 
      LineBox[{638, 639, 1332, 660, 1346, 674, 688, 1360, 702, 1374, 716, 730,
        1388, 744, 1402, 758, 772, 1416, 786, 1430, 800, 814, 1444, 828, 1458,
        842, 856, 1472, 870, 884, 898, 1486, 912, 1500, 926, 940, 1514, 954, 
       968}], LineBox[{640, 641, 1333, 661, 1347, 675, 689, 1361, 703, 1375, 
       717, 731, 1389, 745, 1403, 759, 773, 1417, 787, 1431, 801, 815, 1445, 
       829, 1459, 843, 857, 1473, 871, 885, 899, 1487, 913, 1501, 927, 941, 
       1515, 955, 969}], 
      LineBox[{642, 643, 1334, 662, 1348, 676, 690, 1362, 704, 1376, 718, 732,
        1390, 746, 1404, 760, 774, 1418, 788, 1432, 802, 816, 1446, 830, 1460,
        844, 858, 1474, 872, 886, 900, 1488, 914, 1502, 928, 942, 1516, 956, 
       970}], LineBox[{644, 645, 1335, 663, 1349, 677, 691, 1363, 705, 1377, 
       719, 733, 1391, 747, 1405, 761, 775, 1419, 789, 1433, 803, 817, 1447, 
       831, 1461, 845, 859, 1475, 873, 887, 901, 1489, 915, 1503, 929, 943, 
       1517, 957, 971}], 
      LineBox[{646, 647, 1336, 664, 1350, 678, 692, 1364, 706, 1378, 720, 734,
        1392, 748, 1406, 762, 776, 1420, 790, 1434, 804, 818, 1448, 832, 1462,
        846, 860, 1476, 874, 888, 902, 1490, 916, 1504, 930, 944, 1518, 958, 
       972}], LineBox[{19, 44, 994, 69, 1019, 94, 119, 1044, 144, 1069, 169, 
       194, 1094, 219, 1119, 244, 269, 1144, 294, 1169, 319, 344, 1194, 369, 
       1219, 394, 419, 1244, 444, 469, 494, 1269, 519, 1294, 544, 569, 1319, 
       594, 619}], 
      LineBox[{648, 649, 1337, 665, 1351, 679, 693, 1365, 707, 1379, 721, 735,
        1393, 749, 1407, 763, 777, 1421, 791, 1435, 805, 819, 1449, 833, 1463,
        847, 861, 1477, 875, 889, 903, 1491, 917, 1505, 931, 945, 1519, 959, 
       973}], 
      LineBox[{650, 651, 1338, 666, 1352, 680, 694, 1366, 708, 1380, 722, 736,
        1394, 750, 1408, 764, 778, 1422, 792, 1436, 806, 820, 1450, 834, 1464,
        848, 862, 1478, 876, 890, 904, 1492, 918, 1506, 932, 946, 1520, 960, 
       974}], LineBox[{652, 653, 1339, 667, 1353, 681, 695, 1367, 709, 1381, 
       723, 737, 1395, 751, 1409, 765, 779, 1423, 793, 1437, 807, 821, 1451, 
       835, 1465, 849, 863, 1479, 877, 891, 905, 1493, 919, 1507, 933, 947, 
       1521, 961, 975}]}, 
     {GrayLevel[0], Opacity[0.3], 
      LineBox[{977, 976, 1326, 978, 1327, 979, 980, 1328, 981, 1329, 982, 983,
        1330, 984, 1331, 985, 986, 1332, 987, 1333, 988, 989, 1334, 990, 1335,
        991, 992, 1336, 993, 994, 995, 1337, 996, 1338, 997, 998, 1339, 999, 
       1000}], LineBox[{1002, 1001, 1340, 1003, 1341, 1004, 1005, 1342, 1006, 
       1343, 1007, 1008, 1344, 1009, 1345, 1010, 1011, 1346, 1012, 1347, 1013,
        1014, 1348, 1015, 1349, 1016, 1017, 1350, 1018, 1019, 1020, 1351, 
       1021, 1352, 1022, 1023, 1353, 1024, 1025}], 
      LineBox[{1027, 1026, 1354, 1028, 1355, 1029, 1030, 1356, 1031, 1357, 
       1032, 1033, 1358, 1034, 1359, 1035, 1036, 1360, 1037, 1361, 1038, 1039,
        1362, 1040, 1363, 1041, 1042, 1364, 1043, 1044, 1045, 1365, 1046, 
       1366, 1047, 1048, 1367, 1049, 1050}], 
      LineBox[{1052, 1051, 1368, 1053, 1369, 1054, 1055, 1370, 1056, 1371, 
       1057, 1058, 1372, 1059, 1373, 1060, 1061, 1374, 1062, 1375, 1063, 1064,
        1376, 1065, 1377, 1066, 1067, 1378, 1068, 1069, 1070, 1379, 1071, 
       1380, 1072, 1073, 1381, 1074, 1075}], 
      LineBox[{1077, 1076, 1382, 1078, 1383, 1079, 1080, 1384, 1081, 1385, 
       1082, 1083, 1386, 1084, 1387, 1085, 1086, 1388, 1087, 1389, 1088, 1089,
        1390, 1090, 1391, 1091, 1092, 1392, 1093, 1094, 1095, 1393, 1096, 
       1394, 1097, 1098, 1395, 1099, 1100}], 
      LineBox[{1102, 1101, 1396, 1103, 1397, 1104, 1105, 1398, 1106, 1399, 
       1107, 1108, 1400, 1109, 1401, 1110, 1111, 1402, 1112, 1403, 1113, 1114,
        1404, 1115, 1405, 1116, 1117, 1406, 1118, 1119, 1120, 1407, 1121, 
       1408, 1122, 1123, 1409, 1124, 1125}], 
      LineBox[{1127, 1126, 1410, 1128, 1411, 1129, 1130, 1412, 1131, 1413, 
       1132, 1133, 1414, 1134, 1415, 1135, 1136, 1416, 1137, 1417, 1138, 1139,
        1418, 1140, 1419, 1141, 1142, 1420, 1143, 1144, 1145, 1421, 1146, 
       1422, 1147, 1148, 1423, 1149, 1150}], 
      LineBox[{1152, 1151, 1424, 1153, 1425, 1154, 1155, 1426, 1156, 1427, 
       1157, 1158, 1428, 1159, 1429, 1160, 1161, 1430, 1162, 1431, 1163, 1164,
        1432, 1165, 1433, 1166, 1167, 1434, 1168, 1169, 1170, 1435, 1171, 
       1436, 1172, 1173, 1437, 1174, 1175}], 
      LineBox[{1177, 1176, 1438, 1178, 1439, 1179, 1180, 1440, 1181, 1441, 
       1182, 1183, 1442, 1184, 1443, 1185, 1186, 1444, 1187, 1445, 1188, 1189,
        1446, 1190, 1447, 1191, 1192, 1448, 1193, 1194, 1195, 1449, 1196, 
       1450, 1197, 1198, 1451, 1199, 1200}], 
      LineBox[{1202, 1201, 1452, 1203, 1453, 1204, 1205, 1454, 1206, 1455, 
       1207, 1208, 1456, 1209, 1457, 1210, 1211, 1458, 1212, 1459, 1213, 1214,
        1460, 1215, 1461, 1216, 1217, 1462, 1218, 1219, 1220, 1463, 1221, 
       1464, 1222, 1223, 1465, 1224, 1225}], 
      LineBox[{1227, 1226, 1466, 1228, 1467, 1229, 1230, 1468, 1231, 1469, 
       1232, 1233, 1470, 1234, 1471, 1235, 1236, 1472, 1237, 1473, 1238, 1239,
        1474, 1240, 1475, 1241, 1242, 1476, 1243, 1244, 1245, 1477, 1246, 
       1478, 1247, 1248, 1479, 1249, 1250}], 
      LineBox[{451, 452, 878, 453, 879, 454, 455, 880, 456, 881, 457, 458, 
       882, 459, 883, 460, 461, 884, 462, 885, 463, 464, 886, 465, 887, 466, 
       467, 888, 468, 469, 470, 889, 471, 890, 472, 473, 891, 474, 475}], 
      LineBox[{1252, 1251, 1480, 1253, 1481, 1254, 1255, 1482, 1256, 1483, 
       1257, 1258, 1484, 1259, 1485, 1260, 1261, 1486, 1262, 1487, 1263, 1264,
        1488, 1265, 1489, 1266, 1267, 1490, 1268, 1269, 1270, 1491, 1271, 
       1492, 1272, 1273, 1493, 1274, 1275}], 
      LineBox[{1277, 1276, 1494, 1278, 1495, 1279, 1280, 1496, 1281, 1497, 
       1282, 1283, 1498, 1284, 1499, 1285, 1286, 1500, 1287, 1501, 1288, 1289,
        1502, 1290, 1503, 1291, 1292, 1504, 1293, 1294, 1295, 1505, 1296, 
       1506, 1297, 1298, 1507, 1299, 1300}], 
      LineBox[{1302, 1301, 1508, 1303, 1509, 1304, 1305, 1510, 1306, 1511, 
       1307, 1308, 1512, 1309, 1513, 1310, 1311, 1514, 1312, 1515, 1313, 1314,
        1516, 1315, 1517, 1316, 1317, 1518, 1318, 1319, 1320, 1519, 1321, 
       1520, 1322, 1323, 1521, 1324, 1325}]}}}],
  Axes->True,
  Frame->True,
  Method->{"AxesInFront" -> True},
  PlotRange->{{-1.1312043837568135`, 2.718281828459045}, {-2.7114724960648, 
   2.7114724960648}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[110]=",
 CellID->1776969248]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->621324200],

Cell[TextData[{
 Cell[BoxData["PolarMap"], "InlineFormula"],
 " functionality is also produced using ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->934562795],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`ComplexMap`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PolarMap", "[", 
  RowBox[{"Sqrt", ",", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", " ", "1"}], "}"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->501501407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Through", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}], "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"r", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "t"}], "]"}]}], "]"}], "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2008316621],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzsvWVYVV/0LWx3d3didx0dNnZ3K4rd3YotIYiKAYhIl5TSLFpSOqQ7DmV3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   "], {{{}, {}, {}, {}}, {
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{626, 1, 629, 876, 26, 2636, 51, 76, 101, 2661, 126, 151, 2686, 
       176, 2711, 201, 226, 878, 251, 1076, 2886, 656, 276, 1102, 705, 952, 
       2083}], LineBox[{2252, 2, 1048, 626}], LineBox[{4, 3, 2252}], 
      LineBox[{4, 5, 2254, 6, 7, 2256, 8, 2258, 9, 10, 11, 2260, 12, 13, 14, 
       2262, 15, 16, 2264, 17, 2266, 18, 19, 2268, 20, 2270, 21, 22, 2272, 23,
        2274, 24, 25, 50, 2659, 75, 100, 125, 2684, 150, 175, 2709, 200, 2734,
        225, 250, 275, 948, 2958, 701, 300, 997, 750, 1147, 1793}], 
      LineBox[{2760, 350, 1196, 799, 1046, 2250}], LineBox[{2785, 375, 2760}],
       LineBox[{425, 400, 2785}], 
      LineBox[{425, 2810, 450, 475, 500, 2835, 525, 550, 2860, 575, 2885, 600,
        625, 624, 2503, 623, 2502, 622, 621, 2501, 620, 2500, 619, 618, 2499, 
       617, 2498, 616, 615, 2497, 614, 613, 612, 2496, 611, 610, 609, 2495, 
       608, 2494, 607, 606, 2493, 605, 604, 603, 2492, 602, 1744}]}, {}, {}, 
     {GrayLevel[0], Opacity[0.3], 
      LineBox[{2252, 2253, 3097, 2276, 2288, 2300, 3109, 2312, 2324, 3121, 
       2336, 3133, 2348, 2360, 631, 1206, 3145, 2544, 658, 1279, 2551, 1280, 
       1746}], LineBox[{4, 29, 2638, 54, 79, 104, 2663, 129, 154, 2688, 179, 
       2713, 204, 229, 254, 906, 2937, 659, 279, 955, 708, 1105, 2095}], 
      LineBox[{2254, 2255, 3098, 2277, 2289, 2301, 3110, 2313, 2325, 3122, 
       2337, 3134, 2349, 2361, 634, 1215, 3146, 2545, 664, 1291, 2552, 1292, 
       1749}], LineBox[{2256, 2257, 3099, 2278, 2290, 2302, 3111, 2314, 2326, 
       3123, 2338, 3135, 2350, 2362, 2528, 2565, 3223, 2504, 2532, 2569, 2508,
        2580, 2607}], 
      LineBox[{2258, 2259, 3100, 2279, 2291, 2303, 3112, 2315, 2327, 3124, 
       2339, 3136, 2351, 2363, 637, 1224, 2894, 809, 670, 1303, 833, 1304, 
       1752}], LineBox[{10, 35, 2644, 60, 85, 110, 2669, 135, 160, 2694, 185, 
       2719, 210, 235, 260, 918, 2943, 671, 285, 967, 720, 1117, 2119}], 
      LineBox[{2260, 2261, 3101, 2280, 2292, 2304, 3113, 2316, 2328, 3125, 
       2340, 3137, 2352, 2364, 640, 1233, 3227, 2546, 676, 1315, 2553, 1316, 
       1755}], LineBox[{13, 38, 2647, 63, 88, 113, 2672, 138, 163, 2697, 188, 
       2722, 213, 238, 263, 924, 2946, 677, 288, 973, 726, 1123, 2131}], 
      LineBox[{2262, 2263, 3102, 2281, 2293, 2305, 3114, 2317, 2329, 3126, 
       2341, 3138, 2353, 2365, 643, 1242, 3147, 2547, 682, 1327, 2554, 1328, 
       1758}], LineBox[{2264, 2265, 3103, 2282, 2294, 2306, 3115, 2318, 2330, 
       3127, 2342, 3139, 2354, 2366, 2529, 2566, 3224, 2505, 2533, 2570, 2509,
        2581, 2608}], 
      LineBox[{2266, 2267, 3104, 2283, 2295, 2307, 3116, 2319, 2331, 3128, 
       2343, 3140, 2355, 2367, 2516, 2577, 3148, 2548, 2519, 2582, 2555, 2583,
        2600}], 
      LineBox[{2268, 2269, 3105, 2284, 2296, 2308, 3117, 2320, 2332, 3129, 
       2344, 3141, 2356, 2368, 2530, 2567, 3225, 2506, 2534, 2571, 2510, 2584,
        2609}], 
      LineBox[{2270, 2271, 3106, 2285, 2297, 2309, 3118, 2321, 2333, 3130, 
       2345, 3142, 2357, 2369, 2517, 2578, 3149, 2549, 2520, 2585, 2556, 2586,
        2601}], 
      LineBox[{2272, 2273, 3107, 2286, 2298, 2310, 3119, 2322, 2334, 3131, 
       2346, 3143, 2358, 2370, 2531, 2568, 3226, 2507, 2535, 2572, 2511, 2587,
        2610}], 
      LineBox[{2274, 2275, 3108, 2287, 2299, 2311, 3120, 2323, 2335, 3132, 
       2347, 3144, 2359, 2371, 2518, 2579, 3150, 2550, 2521, 2588, 2557, 2589,
        2602}], 
      LineBox[{2492, 2480, 3211, 2468, 3199, 2456, 2444, 3187, 2432, 2420, 
       2408, 3175, 2396, 2384, 3163, 2372, 3151, 756, 1376, 2558, 1375, 
       1796}], LineBox[{604, 579, 2864, 554, 2839, 529, 504, 2814, 479, 454, 
       429, 2789, 404, 379, 2764, 354, 2739, 329, 1154, 757, 1004, 2187}], 
      LineBox[{2493, 2481, 3212, 2469, 3200, 2457, 2445, 3188, 2433, 2421, 
       2409, 3176, 2397, 2385, 3164, 2373, 3152, 762, 1388, 2559, 1387, 
       1799}], LineBox[{2494, 2482, 3213, 2470, 3201, 2458, 2446, 3189, 2434, 
       2422, 2410, 3177, 2398, 2386, 3165, 2374, 3153, 2540, 2590, 2512, 2573,
        2624}], 
      LineBox[{2495, 2483, 3214, 2471, 3202, 2459, 2447, 3190, 2435, 2423, 
       2411, 3178, 2399, 2387, 3166, 2375, 3154, 768, 1400, 857, 1399, 1802}],
       LineBox[{610, 585, 2870, 560, 2845, 535, 510, 2820, 485, 460, 435, 
       2795, 410, 385, 2770, 360, 2745, 335, 1166, 769, 1016, 2205}], 
      LineBox[{2496, 2484, 3215, 2472, 3203, 2460, 2448, 3191, 2436, 2424, 
       2412, 3179, 2400, 2388, 3167, 2376, 3155, 774, 1412, 2560, 1411, 
       1805}], LineBox[{613, 588, 2873, 563, 2848, 538, 513, 2823, 488, 463, 
       438, 2798, 413, 388, 2773, 363, 2748, 338, 1172, 775, 1022, 2214}], 
      LineBox[{2497, 2485, 3216, 2473, 3204, 2461, 2449, 3192, 2437, 2425, 
       2413, 3180, 2401, 2389, 3168, 2377, 3156, 780, 1424, 2561, 1423, 
       1808}], LineBox[{2498, 2486, 3217, 2474, 3205, 2462, 2450, 3193, 2438, 
       2426, 2414, 3181, 2402, 2390, 3169, 2378, 3157, 2541, 2591, 2513, 2574,
        2625}], 
      LineBox[{2499, 2487, 3218, 2475, 3206, 2463, 2451, 3194, 2439, 2427, 
       2415, 3182, 2403, 2391, 3170, 2379, 3158, 2525, 2593, 2562, 2592, 
       2632}], LineBox[{2500, 2488, 3219, 2476, 3207, 2464, 2452, 3195, 2440, 
       2428, 2416, 3183, 2404, 2392, 3171, 2380, 3159, 2542, 2594, 2514, 2575,
        2626}], 
      LineBox[{2501, 2489, 3220, 2477, 3208, 2465, 2453, 3196, 2441, 2429, 
       2417, 3184, 2405, 2393, 3172, 2381, 3160, 2526, 2596, 2563, 2595, 
       2633}], 
      LineBox[{2502, 2490, 3221, 2478, 3209, 2466, 2454, 3197, 2442, 2430, 
       2418, 3185, 2406, 2394, 3173, 2382, 3161, 2543, 2597, 2515, 2576, 
       2627}], LineBox[{2503, 2491, 3222, 2479, 3210, 2467, 2455, 3198, 2443, 
       2431, 2419, 3186, 2407, 2395, 3174, 2383, 3162, 2527, 2599, 2564, 2598,
        2634}]}, 
     {GrayLevel[0], Opacity[0.3], 
      LineBox[{2636, 2635, 3097, 2637, 2638, 2639, 3098, 2640, 2641, 3099, 
       2642, 3100, 2643, 2644, 2645, 3101, 2646, 2647, 2648, 3102, 2649, 2650,
        3103, 2651, 3104, 2652, 2653, 3105, 2654, 3106, 2655, 2656, 3107, 
       2657, 3108, 2658, 2659}], 
      LineBox[{76, 77, 2288, 78, 79, 80, 2289, 81, 82, 2290, 83, 2291, 84, 85,
        86, 2292, 87, 88, 89, 2293, 90, 91, 2294, 92, 2295, 93, 94, 2296, 95, 
       2297, 96, 97, 2298, 98, 2299, 99, 100}], 
      LineBox[{2661, 2660, 3109, 2662, 2663, 2664, 3110, 2665, 2666, 3111, 
       2667, 3112, 2668, 2669, 2670, 3113, 2671, 2672, 2673, 3114, 2674, 2675,
        3115, 2676, 3116, 2677, 2678, 3117, 2679, 3118, 2680, 2681, 3119, 
       2682, 3120, 2683, 2684}], 
      LineBox[{2686, 2685, 3121, 2687, 2688, 2689, 3122, 2690, 2691, 3123, 
       2692, 3124, 2693, 2694, 2695, 3125, 2696, 2697, 2698, 3126, 2699, 2700,
        3127, 2701, 3128, 2702, 2703, 3129, 2704, 3130, 2705, 2706, 3131, 
       2707, 3132, 2708, 2709}], 
      LineBox[{2711, 2710, 3133, 2712, 2713, 2714, 3134, 2715, 2716, 3135, 
       2717, 3136, 2718, 2719, 2720, 3137, 2721, 2722, 2723, 3138, 2724, 2725,
        3139, 2726, 3140, 2727, 2728, 3141, 2729, 3142, 2730, 2731, 3143, 
       2732, 3144, 2733, 2734}], 
      LineBox[{226, 227, 2360, 228, 229, 230, 2361, 231, 232, 2362, 233, 2363,
        234, 235, 236, 2364, 237, 238, 239, 2365, 240, 241, 2366, 242, 2367, 
       243, 244, 2368, 245, 2369, 246, 247, 2370, 248, 2371, 249, 250}], 
      LineBox[{2760, 2759, 3162, 2758, 3161, 2757, 2756, 3160, 2755, 3159, 
       2754, 2753, 3158, 2752, 3157, 2751, 2750, 3156, 2749, 2748, 2747, 3155,
        2746, 2745, 2744, 3154, 2743, 3153, 2742, 2741, 3152, 2740, 2739, 
       2738, 3151, 2736, 3079}], 
      LineBox[{2785, 2784, 3174, 2783, 3173, 2782, 2781, 3172, 2780, 3171, 
       2779, 2778, 3170, 2777, 3169, 2776, 2775, 3168, 2774, 2773, 2772, 3167,
        2771, 2770, 2769, 3166, 2768, 3165, 2767, 2766, 3164, 2765, 2764, 
       2763, 3163, 2761, 3092}], 
      LineBox[{2810, 2809, 3186, 2808, 3185, 2807, 2806, 3184, 2805, 3183, 
       2804, 2803, 3182, 2802, 3181, 2801, 2800, 3180, 2799, 2798, 2797, 3179,
        2796, 2795, 2794, 3178, 2793, 3177, 2792, 2791, 3176, 2790, 2789, 
       2788, 3175, 2786, 3093}], 
      LineBox[{475, 474, 2431, 473, 2430, 472, 471, 2429, 470, 2428, 469, 468,
        2427, 467, 2426, 466, 465, 2425, 464, 463, 462, 2424, 461, 460, 459, 
       2423, 458, 2422, 457, 456, 2421, 455, 454, 453, 2420, 452, 2048}], 
      LineBox[{2835, 2834, 3198, 2833, 3197, 2832, 2831, 3196, 2830, 3195, 
       2829, 2828, 3194, 2827, 3193, 2826, 2825, 3192, 2824, 2823, 2822, 3191,
        2821, 2820, 2819, 3190, 2818, 3189, 2817, 2816, 3188, 2815, 2814, 
       2813, 3187, 2811, 3094}], 
      LineBox[{2860, 2859, 3210, 2858, 3209, 2857, 2856, 3208, 2855, 3207, 
       2854, 2853, 3206, 2852, 3205, 2851, 2850, 3204, 2849, 2848, 2847, 3203,
        2846, 2845, 2844, 3202, 2843, 3201, 2842, 2841, 3200, 2840, 2839, 
       2838, 3199, 2836, 3095}], 
      LineBox[{2885, 2884, 3222, 2883, 3221, 2882, 2881, 3220, 2880, 3219, 
       2879, 2878, 3218, 2877, 3217, 2876, 2875, 3216, 2874, 2873, 2872, 3215,
        2871, 2870, 2869, 3214, 2868, 3213, 2867, 2866, 3212, 2865, 2864, 
       2863, 3211, 2861, 3096}], 
      LineBox[{2886, 2959, 2887, 2983, 2935, 2960, 2888, 3145, 2984, 2936, 
       2961, 2889, 2985, 2937, 2962, 2890, 2986, 2938, 2963, 2891, 3146, 2987,
        2939, 2964, 2892, 2988, 2940, 3223, 2965, 2893, 2989, 2941, 2966, 
       2894, 2990, 2942, 2967, 2895, 2991, 2943, 2968, 2896, 2992, 2944, 2969,
        3227, 2897, 2993, 2945, 2970, 2898, 2994, 2946, 2971, 2899, 2995, 
       2947, 2972, 2900, 3147, 2996, 2948, 2973, 2901, 2997, 2949, 3224, 2974,
        2902, 2998, 2950, 2975, 2903, 3148, 2999, 2951, 2976, 2904, 3000, 
       2952, 3225, 2977, 2905, 3001, 2953, 2978, 2906, 3149, 3002, 2954, 2979,
        2907, 3003, 2955, 3226, 2980, 2908, 3004, 2956, 2981, 2909, 3150, 
       3005, 2957, 2982, 2910, 3006, 2958}]}, {}}}],
  Axes->True,
  Frame->True,
  Method->{"AxesInFront" -> True},
  PlotRange->{{0., 1.}, {-1., 0.9999951778444004}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->467072307]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 16.1575710}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ComplexMap"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 70, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[882, 35, 326, 10, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1211, 47, 283, 9, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1497, 58, 363, 12, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1885, 74, 585, 18, 70, "Input",
 CellID->1746043248],
Cell[2473, 94, 27417, 438, 70, "Output",
 CellID->1776969248]
}, Open  ]],
Cell[29905, 535, 125, 3, 70, "ExampleDelimiter",
 CellID->621324200],
Cell[30033, 540, 280, 9, 70, "UpgradeDetail",
 CellID->934562795],
Cell[30316, 551, 380, 11, 70, "Input",
 CellID->501501407],
Cell[CellGroupData[{
Cell[30721, 566, 605, 18, 70, "Input",
 CellID->2008316621],
Cell[31329, 586, 43852, 710, 70, "Output",
 CellID->467072307]
}, Open  ]]
}, Open  ]],
Cell[75208, 1300, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

