(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     62267,       1144]
NotebookOptionsPosition[     60436,       1086]
NotebookOutlinePosition[     61402,       1114]
CellTagsIndexPosition[     61359,       1111]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`FilledPlot`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ", and similar functions have new ",
 Cell[BoxData[
  ButtonBox["Filling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Filling"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FillingStyle"]], "InlineFormula"],
 " options."
}], "UpgradeSummary",
 CellID->1010000471],

Cell["Fill from a curve to the axis:", "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`FilledPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FilledPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->1746043248],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJw1mXk8lF/0x61ZEjPPUFSKShuSUlro3MpWJEpaCKFCQpQkqbQhSUglW8pS
KmVPuCGFIqUSSoVkmZnHOmYmy+/+Xr/fd/65r/u688zr3POcz/t8DurO3jsO
iomIiOSKioj87yqOZes7Vp3fwCv7v/XGoH1uXDSGNUoPjVSDMayv2iq7ya8B
LpWUGssaN4BPoOWBXJ9vUHiyUq+kuQmOFh2MFJv/CxZmzflgxm6Dz91bZDKc
O6Gzq3lvlXQHhOvwRAr2doO61CPRrcwuOKZZffNVGhuEfm9XZfG7Qehy5OkP
r354PL27/pZzHziX2lpFHRqEy7swL3gVB1wGPr96FToM7iHuPwXZXIhYXuid
fpkHdjre5hdjaBB7Vah/MZAP1l9uHl8koIG51Lz+520hbI+1nVXwgwaz5E33
+6PH4E2o3PqNm2mYQb83OVs4ARWS7UHzKS7Evy0WFXcXQXaKvzT8nNhgoLpx
Us1VFDVcCd1bt68XNH8xOs8cF0N79Yc6VQv/wpNMyi3fVxzJ8aQ++PzshKC2
/Y2alyXQjx0Hl1zw+g3HDNaYJ8VKoqAG09iVwa0gTDZy7ouaglq6LO5VL/sM
DT7xTidTpdAcuVOLfT+/hbWm8yZ+3JNGH7/KHZoQeQY1xmszUYIMWtvgMCc7
4ilOe35nbXuWLGpgqRmknazGSvO1PBweTkU2i3IWmPxpxJ9EpUNUSuSQRG3y
Q72WVpwv7ZfeUDMNxZ5anl8Z9xtrKTE8nKvkkWbU/T32LzsxHclTXPlVAS2/
xuxYWPMXz79yRcfbg4FkamxDGjf24vZ9rS2b/jKQrvHG2bZb2NjsT6Mg34uJ
OudbPDcS5+IA34Nu0zlMtDPV2TFrIY0tC+5une5PoXWzhq56N9OYO+YRJM6j
UKTY3w2fxmh8r+l8npcfC8XNvK575z6NhW6GTqf+sdCnuvDo3BdcrDp+w+5Y
oCLq/huvssaZg7tMr9ZKSyghe0fOyg9H+nDlwvcw56oSanJ5re4s3oM9pNMl
1GWmI39j2a11jl24MGWBYeWN6UiqVNujRL0D1683qNrBnIEu+xZXVd76ifke
d3c6Rc5AOoU2xW9jvuFqq+Rd06Yro/G2b2/VIhuw81qDjIxYZXTX3z5TNaEc
p3474/lbVQW9d7u0NuGwD9Zd/9D8n7oKGtK59r/6KNvhqdJyOzobVmFh6alr
2ZBzarugtJwLls1NJ/QNeuEp48BkgccAqMTZHK3YywbnppuhmSeHgHFkHade
nAt8hsnt3CsjsDor4ekqXRpMAwp33jw3CnpzxWPPfaFB9oSoeE6YACr2iJU7
jtPwuPPNmu6b/6BIeFCJk0zD8rdSI/pp43A+riPHpoQLC0E9reL1JKQHjDLP
bOHAkcEzItFdIiioSUSkwaMP8iYyj21ni6Ir0Sahi2b0wLbDovtfL2WgzYmu
TR3MHix2TFeyOZOB3A+MNdzY0YeVUnZ7jC1loh3SEeoZqzn4V9Zs3a4nTFSX
rMD+c5+LXWLP7Y3TpRBDDiTVo2mctPdCh1wBhQ6XNnso/6OxmYe/8gs9Fsq+
JO9w/iepjxRH2eOFLKQoLmpmjmgsl/t3/8g6RVT+eJdG1WwuDkmVZxliRdRS
pLTr+Ek2tinUvBRjqoRSGuxG15j04t4wlj13rgqiq9XrXh12wl8coxclRifD
auNpNrtuJEP0p6umOJdw4nCqomhSD9is67KtZfdDjovG1YjfhCdb/T1n04Pw
ak1Q3Y8UDiw7f01rnfQIyIx/VPca5oKHTeHvRPFReLM1unVLEQ2X4+1VZ4kJ
IM1QGPxqkgYHqTBx1xn/gH1M3yunggaDlRoWirPHIStsdNkGCRrmzBgdUdsw
CSPtQ959zzkgtn/2+doMEVT86XL7WHcf8KedWLMmUxSdLjOJTSrpAefdZUNc
WQZSW+q86apPN6aC7Gc+CGOgAMsoE+e6Xhx05k7qXBkmeuQUYy75mo1jzQKU
LCOZ6JO29GPT3VzsJT7kZKtAoQh3C/tOJxrzrijcYsZRiIVZIYhL47u5Plsd
lFhoak7p0skBGvNf+jgeu8lCi62Xubv401g8knLUn6WInmSbXxZ6cXHDdiv9
pgRFdF7C2lBigI0Tz7YuqtdQQtbDXg7l33uxyXOzzr9zVNAFroT3mbtuWPpv
a8b97gF4ZyTvNPsdqW/X/Ad6IsPwq9Jn+WoHLlSkTIhrS/GAy1Y+vvEQDQsS
Cqsixkchb3V1sHofDZHb07vNmELQvuf1R3KQBmG5hJen4hik8CoivU6Q79v1
Jtotm4AjWQfc7xzhwuDBKf3Tqhmo4UPxyU0f+/DTCqUVzRZMpK6WemXWPQ7W
Uii3CK5jIkFuTZVcDxfv0ZDf8XUnhZb5FaCdxTQ20RzVkf5KoZXe25jDkzQe
VgvqYtmw0EwHntn+Kho/uGiZ79/MQl1sR0UnURorfiuxz91HeFStkbmokoMj
ndsah9VUUKJ/5rIpbla4xeRiRVr0dVA9n/J+J1nFJh9ysRYHNvdM36hv0QOL
PmSKfX7SD6stwxd2p/ZB+4VDDl8fDYJ+6o0N6zw5YLb2uf+Z6mH4aTo/ZnEj
F05vKlw8r4oHI+cUjn5Lp8FIO/zR9jI+jGdaL4gh+i9S7u1W/yYEuwM6tNZH
Gjb15J4MaRqDHxef5/5YQMNMcec5DcIJ0NaR4Ct0cMAy+kj5oVARpOSZ8iRK
gw3xSq13tS6Log9FB7/dk+uFlqS1wdI8BbQu2mLilmo3jhcdfCATyEBH+j6W
u4b2Yh3P4g26fAbyKJxi+uQKG3Onp0uFBDPRRJRemO4yLh5a99h19QQTdfiN
eHYZ0Xhe8pd+1mUKaaT5/f7aSWOjb0c7nkmyUODbc8iBT+P3WwQyPhdZaK1D
o9+sSBoH/8tw3DNVEXHOLKs2vcnF/guPbXlwVRH9uFD0JmspB1e4rDzVp6iE
/sxAGus0+vCwkUumK6k/Rr6ztl2+J249nbTzycMBuJ7jm2YRw4b2xLQ47ssh
2JN39bjSCi782DPP0uftCIiGG3bnWtCwOrxQjolH4dUSTzWj3zRYtDeeOFMn
gOOlVONHPg07Gw/uXPrlH7zrl9v/4CoNS5mnamp6xqHgmnGnwk0uBPbdDfQr
YqCwvyz2y+g+7Px8dX3veiaqbNDldHty8OUf3A05pUykyTB3cH/LxW32b3cV
bKLQ/Aj3NfYZNPbdVBom+4ZC4xfK/lyaILw0PnX2kBELFfZoV7o00vgU1eR4
opqFLq9QE6fVaRxlvGP/562KKCPphGJ7Pwcb8Pi3jpH6s964Qvn13T2YVePe
zjMdgQ1RQaerWTTsOVQYr7JpFFz1hyOa3tJQLaUT1WUsAJ7Zqf3ZhF+SvEVz
0m3/gdRAWaBpDg3d79bu91ejEMd8n9b9QBrX+mwxVEinUJLroaasERoPRvo9
n6rBQv4FQY75PTSev6w7zzedhc70WZT52tM4o7vlRY8JD27Pzyn5foYG1tPC
YGkDPjRfS1dWHqKhoSTATnGXEOrNZ/mOddPQyLGx5LlSyF0mokLiHY1nKup+
lewi/Ep89NWZ6HHrWPC2chfCpz/f3njl0/hXfaVCAOm3b1uNRaLcEP6j6MYv
iD4L5x6WB6aSdZ3S2k2ohw2fnPQWPpzXA1Eq4d/2RPbDC3P/9SMhfZCa4rA7
N3SQ8MXJZq41B2yVKmclZw5DZELR+nrSpy+u1bfoTOMBh9WR4pFIw32e2oB7
Ah90uExW2j8aXO/Ft54rEkLOjU8l2U00GBudvrY2fwzmnu+YuVuPBuVTt3IW
NRM+ddQofBdyYFgr5ndegAhaoHpg25rNbDiiElm38IQoavsX3zu4shc6p9+u
Ue1SQFVj179FDv3FDq8NPAx8GehGa5ut5cFeHNpRK1dMM9BMW1/rcjc2njVR
IpLgz0RvfxbUjihzccHX0EPpI0wU3mfqxlhN46JHRapKwRTytXjU7kz66x0P
tk7LOIVEPsVlfBHSuCDK0JE+zUKX2Jfz1e/Q2CBn8KebuCJqDP4iUpzBxbU3
zn+SvaCI5BtZt/NNOPjzrp/qgXJEbzpifuVmffhdpI/sfKI3psOBX1sqvLDR
m7NLVoQPgF+jeGqZPxtSixOvv7szBD12NwpWz+JCr57e0I2MEShquPNmBdCw
4bz+8sbkUXgW6KOU3EpDVpZHya0sAZgL5KOcSH5F7KebhOX/g4pDZ3ymxNGg
7Yl+nns7DjKy87P5mVzY8LQL0p8x0Pfnkoqtvn24ZLFpgt9KJjLoTXkus4OD
c19Lrnmfz0RP/9y82JHPxSn8+7sXrqNQTO5XOalEGktbphRMLaPQqs4wBYVx
Gg81jb67bsBChoMtRdnEn7runZU/jFlo8umUJBdd4k/GEn50blJE8dHL8+Sl
uORkilCH6O36a+vu1Hx7rJZ2+ory4hG4BjO+7CH9/sB+/bLWeaPwKfrw+m2v
aFj0seqryAIBDJ9KLJskessJ/saQ1P8HrcP+Q8XF5P6Hpzt2zaAQxXv+ZqoX
jZ2CtDwYSRR6oLJ9YtUg6U/qg+N6qiz05HRo7AzSv+VPaMkOJrJQQJjb1Bx3
Gue9ZjtMXcQDWnIgYJsvDbPT9FNrZ/MhZ1PE4700DTqXFVKXrRQCrWfWWM2h
IS5M1+qQPYU0n4W9Ga6g8bO5iuJSbURvJf1OfURvyZHjd3rtWGjbdjNhaimN
C5U/HltN9OZSUrzeMsEM+5rrSzp18qDlkmhEXTYNf1yGXFb94sNq/6zkgQka
pkat5VWMCoEb1vZOu5aGiJjBSiqSQi/vXPJ9R3jRb0zHXZlG/EeGKsuT8EQ7
Rr/Hsm0U2GU+yd5dNHCUDXVcaAGctQu9mTtCw6zy3p0m5hTy/pq0R+05jb+v
brGXqaeQ1UTi3yAS75Zc4QpDCxYyr191M/E9jd033N7y/rAA7vvw7D+QePQO
HmLIP6XQbOvLk/dIv0kcG3Zt1yL5FHonfCP9SLZQ387Ejg/1goY8ex4NPkO/
FYX+QhC3OdaU0kHDRWnLhxJcCi2KTzi+j/BZ+lLBkxckH1dXzT983305Fj7T
cW2O9oZjN/OMPpPVNkXE89xbNjw7N021aFoPVJUFbr4b3A8xrjF1jb59IJbd
0njv5CCcmrf8veNmDtiLW3Czbw+Dv37dlqEiLkivGt1vHMcDM7bIpcu3adhh
56l48ioffmQ26QUIaSj+M2jzLFMISTFBpytaaHgz4KCs9ID4I+Plym3rCX/0
coJ2Vk/Ay4wlzlFTuGAqTB9o9RFBhx7F7+2wZoPN3cNd9z1F0T7BJVFv017o
3WHqvbiN8Ife+eRQ21/8SqP9/S4vBlrcduhY4s5evGpuo19wHwNx5BXiZu1l
45xjZuOZvkx05oZap6Y8F99acPKwwwATHWaLvfJeRuMLy5fmKQVSyGCkVe3U
dxq/ztX8yhVQqKmqZFsH8f9aeT9lsk+y0DQw2u6dRPzoNGW1Y5Ms5HlUsqPq
GRcffyszoyxYERX0f6q9YsPBPyxX+W+UVkJjgt+Ru/f14YKVJ9eLEf7oQod2
ebU3PnXEJ/Z44ACYf28xsXRjg1iNilxx6BCEuhayYxS4MDCvtCr11giEiArz
N6+hoSJodKNe1CgUxqiKJX+jYR+j4OeDeAFcN86c6TtGk/fnhYvS/kGd7NqV
MndpeKqywMO+YBxe7764vSiHCykKEan4MQMFxRkEVDr3YTfX7eJrdJjIZHH4
ezcjDt665oZe83MmSj/+JWvoMZlfTKL3tK2i0K7x0+rpt2jc2MjcJldMIcX8
6wXzyfw7R13f98EaFooMGP6aQfLVHFTqmPeSheqaDir1rKHxk90VqpwNiqiO
4hfymVw80SmnqUD44+6yyzi6wgEvipHYt0R5BF4XLWn2HeNC157RDwasUSgT
ccvaV0LD11VM4TSWADYvaqcGCX+kK5eH6y36B/VJMSvelBF95ks4JbEoZPL3
gHz4YRpriiWJMOMJj+oerDTvp7GPh+6DLSosNPojIG8m2V+4XZ/3/A4LOTW0
nJ7tQ+OXOSd0Z88g/bK8YOpuTxpSUkZzNafxYXp/93sLwpu23n1V6+cJ4UDO
aVMB4dHJprnWc/ZQaInksRUFZTQ+nXbpjlQLheoPe+QRPuLaJgM0uZuFbKxU
na6X0zi1tClVieit5Im5lXaBBeaZjE4v/8yDadL7FZ2zaIit3nBl0wc+jL3Q
2mVD9O78+Yb34F8hLIqL7iqpo2G3ius+VjiFnDaNKR/4S/zF9WWGCTIk/nbu
+WEejXMiR4XZ9aOw/GYu1UP0nnAmdIdPmwBQUOR9m1EaxuSbbSZMKLT+9DtP
q8fE35SYD8nUUuhxRMgBJon3+NjaZmszFjonmj6g0EBj5fsdns22AvjJG7Ky
Jvme7G1Kl39E+BXp0L56lMbVxnpTRxezUFJxnKUtiScyZ9Qzw5wPQ+NX79UM
06C2R3uN1CEh6BheDHciPNweiUGyl/ixq4dSuIQ/w0tK226TfBT5sAoPJK7B
wze+1Nk/4UO+7NC0p6R+vdSfhFWJspC6TMC2hwIaj5nMvRNeIoBSV/d5moQf
htXL1KZWUEhc/8fxFtL/AjwDc4f0BJDVNjukh8R7k1fcqJBKoRMei3+JDNP4
9sOTUe5afFjXWTrLbIDw/k6q55R2Ek/x8PRCcv/Vkxlo8QAfnjioih8hzzOf
u72R/kSho75pJ6vJeXGzxUIcIIANoVTIEvJ+3H8On5qWQyFToa82h8R3+eXJ
LX88SL1sH7H6SPL9IuQ7JTFIoWPVv3amk/hm/8oOaiH3fXe/SqP2iBrW6Clb
PyfGEW7lNw3NJmvnwc5zKQVsOOZfNH+VeA84MYcCSvz74eWk3dwXHn2wokCZ
UvEeBF/e/HA/Aw44BUbtLooahrac2S6BeVyoXdHUdSKSBwNbUjVliN94NI1K
Hw/hQ4TEb6vPAhq6pJKZ1SlC6Dvqq4O+03CluuFHyN0xKJp1QiOW+JnbN/CB
HjwBkefNZjjIcaH/17NTtKcIcn6WkLlsLxvM7D/7OruJom8/K7vUrXuB3T+n
QrtFAZkkVxbXNP7Fvl/1gp09GWh1gXj8y629WM5wd4ZTDwMllbZ+MLBm4zOa
kaezfZjItCR26KU0F4eacw+vo5loY83yKdFLaew25DypFEChTXJ3rfgtNN67
x3yJYJRCR5xFEh0IX7qqlv+MPMFCQlRQKH2P+OmXS9GJcRaqfP7oPCL+yKx9
24tbQYqovT5Xx9WOg53NndQ0piihs1sCdWe49GGty8LGAVXCG6tKtwkNH6xY
1l1z03cA0srFaqYeYMOKht1bdc8Nwf7Oppx8GS4M3xHVybo+Aj/f5Ua9In74
YmBTrWvoKGi6rYtjEb+cU2F3TDNaAEmfvDw4pF7PV8wMakj8Bx+Dn4qcJX7b
u/+mTu2TcUDPLvWEF3LB+lXbzvePGEg7TOnPE8L/DSGNq2dqM1Hp4U/yEYYc
rDT4NednNhOteGYS6pPJxb5HZfYWr6RQzy0lle5Y4ofjtt6WK6LQ0MYx+VTS
f3KrbKuermYhTue1o8ptNI6NlF8V+4KFWiw/3UoyoLG95BfDAQNFtPn9nFTn
GaQf6UdVTsxVQT+rmvplahzxUtktlbqMEVCN97Q5zudCpm3TnqNTR0E7bt1U
W+LnlnUXXI2VFcCowUDVD6KHlX++m1jM/Qf+jyjdV8QPnvl+2imQSaGFo9Pz
1rvSmFH11Zx5m+hp/Z2mLTSNpyhYj+6cwUJ7g7ivGQM03vBobviNWyykU7fP
xciPxmVLiuMXKPCg5sTnBVbuhHdJTQb2kny40HxlaB2bzLOJIrsrVISQNerM
lCB6dZuIsxbuolB4BN8orIT4S7eyTqlvFIqqevp7nOjTMcg+RsaWhfJOuC4I
rCT8YtitlyR6U5poaJpdaYmLjJqSB97zYEfboSnqD2lgB3Yq17zhg6V68Fr+
OA3XeIZasr+EwLDdVxfwgQaD7wlprFByH/EG/twuGmevtIxKlyI817DVf0L4
dzyi6cKvN6OQdl7lUHw7DcM6yzp5X8g8esmgcAaZtzmrrHa1GFEoOWRHa8tD
GkecvbhBtppC0WnbUomfwzL39mrZm7BQ9zthVulH0p92hU04Wgoge7n254sk
351PGIPymRSySbi47wTh+/7enQ6ii1joLdc2K6ybxlbPmkaaNvOhf1le1jCZ
RwNkG2uu7ReCmjQ9mvOX+EVrfrhkN4WuWW8s1iL58QhCJ0NJPo4olH9HhQbY
wui0Y8cDPlxeLDptGalfiTfvv3+YJDxbOWK1mcxXNoLXS5l5AtjGC91VS3g7
7+rhI1NfUWhDa/6rAMKzhjlqxoFaArgp56oqIPEGvhiaw0ghvDXx85w7RON9
GbtV4hfwQc3TOsemn4Za+9bCKb8IT0NerftC4ol8vu3T024+TJ7aXr+CPM/z
u8eUaaDQ2mz3p+nknIoYLDT2EcCL27bsc4S3lqnaVdOekX5+4lSsOeGt2Yvd
n5Rc+DB1ZtvHmYS3ScZKDhL9FGJ6fXKWIPmNXrFSqZbcV1H5S2Bo8mIszHwT
0h/DhxvV5mosMp+JOTAs59wXwPwtHz9yyJ7LaBaVK6GQV4HfgUTCm+ALR9yu
zBLAo61vD5L6grh2C0up76T//j4bRu6LDabfGXnZxIfdCZtPZpD4KgRUpsx7
Cu2ot5hvTs5f9Ru27nAk/VP+e6Mied7j3eVhCTZ5//VLwjJJfHskeZ9lX1Mo
48ZfTT2yVyv+rH7UUABjVu/ZDeT7Ik3u6lM6KVTDjh2JIr/XZiGWfU/Ah0ZH
yQ3x5FyLq3Na+jOFZnwz29xOzp0XZcSuOS+A7683zakh9Zx+Tauzl9z/qJhR
8gwfBla8+/GgUF0Gifz/57//h/23/+/v///t/we+H9u/
   "], {{
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 434, 433, 25, 24, 23, 22, 21, 20, 19, 63, 87, 127, 182,
         254, 341, 18, 62, 86, 126, 181, 253, 340, 17, 61, 85, 125, 180, 252, 
        339, 16, 106, 146, 201, 273, 360, 60, 84, 124, 179, 251, 338, 15, 105,
         145, 200, 272, 359, 59, 159, 214, 286, 373, 83, 228, 300, 387, 123, 
        178, 250, 337, 14, 240, 312, 399, 166, 221, 293, 380, 104, 232, 304, 
        391, 144, 317, 404, 199, 418, 271, 358, 58, 431, 325, 412, 236, 424, 
        308, 395, 158, 427, 319, 406, 213, 420, 285, 372, 82, 429, 323, 410, 
        227, 422, 299, 386, 122, 315, 402, 177, 417, 249, 336, 13, 327, 414, 
        239, 311, 398, 165, 321, 408, 220, 292, 379, 103, 231, 303, 390, 143, 
        198, 270, 357, 57, 157, 212, 284, 371, 81, 226, 298, 385, 121, 176, 
        248, 335, 12, 164, 219, 291, 378, 102, 142, 197, 269, 356, 56, 156, 
        211, 283, 370, 80, 120, 175, 247, 334, 11, 101, 141, 196, 268, 355, 
        55, 79, 119, 174, 246, 333, 10, 100, 140, 195, 267, 354, 54, 78, 118, 
        173, 245, 332, 9, 53, 77, 117, 172, 244, 331, 8, 7, 6, 5, 4, 3, 2, 52,
         76, 116, 171, 243, 330}},
        VertexColors->None]]}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{51, 435, 433, 26, 27, 28, 29, 30, 31, 32, 342, 255, 183, 
        128, 88, 64, 33, 343, 256, 184, 129, 89, 65, 361, 274, 202, 147, 107, 
        34, 344, 257, 185, 130, 90, 66, 362, 275, 203, 148, 108, 35, 345, 258,
         186, 131, 91, 67, 363, 276, 204, 149, 109, 36, 346, 259, 187, 132, 
        92, 374, 287, 215, 160, 68, 364, 277, 205, 150, 392, 305, 233, 110, 
        381, 294, 222, 167, 37, 347, 260, 188, 133, 388, 301, 229, 93, 375, 
        288, 216, 407, 320, 161, 396, 309, 237, 413, 326, 69, 365, 278, 419, 
        206, 405, 318, 426, 151, 393, 306, 423, 234, 411, 324, 430, 111, 382, 
        295, 421, 223, 409, 322, 428, 168, 400, 313, 425, 241, 415, 328, 38, 
        348, 261, 189, 403, 316, 134, 389, 302, 230, 94, 376, 289, 217, 162, 
        397, 310, 238, 70, 366, 279, 207, 152, 394, 307, 235, 112, 383, 296, 
        224, 169, 39, 349, 262, 190, 135, 95, 377, 290, 218, 163, 71, 367, 
        280, 208, 153, 113, 40, 350, 263, 191, 136, 96, 72, 368, 281, 209, 
        154, 114, 41, 351, 264, 192, 137, 97, 73, 42, 352, 265, 193, 138, 98, 
        74, 43, 44, 45, 46, 47, 48, 49, 50, 353, 266, 194, 139, 99, 75, 369, 
        282, 210, 155, 115, 384, 297, 225, 170, 401, 314, 242, 416, 329, 
        432}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1HWYFWUcBeCVLumUXEI6JaVD0ly7dbGDVVDKLlBpC0RBCUEa7G6wE+xO
sLvzPc/jH++e8/suM3fmuzMUFpcUjdupoKBgkz/J0f78KNdwFnvSnVKUpgxl
KUd5KjDGMT/JtZzNXvSgYo732c9yHRPZm54UW6/M4/pMjqNSjrX2i1zPJPah
F2OtV+EJfRbHUznns/ar3MBk9mW8tYZs1W+kd85v3pnN+mxOYKq5BW/ry6mS
7zP/JjcyhYvM7fhI348JeiO26Yvok2sxV2WLPodpeme26ydyjt6Sd/QFcjC3
5DpkL77VF8sRucbcg/xdLpGb5FWyL1P1i2V7VvCxeaEcyjqK8pvJxiznVfN1
ciBrWGyeIbtzK19lf+QebGD37IusxlKeNF8j+zNXny67sEM/iXP1Vryrr8i9
6735Tq+a/dL/kLdlD7jE3IFP9P3zrOhNeE2/ib7ZL3N1ntLncTLVKLL2p7w9
38sB9Mt1WK/B09knTqF6zm/tL3kH53Eg/amRY332t7yT8zmIAdTMv/PZP/Iu
LuBgBlKL2tShLvWoT4P/351dZEMa0ZgmNKVZzu/zf+XdXMghDKIw589Lxz15
1jiUwblvazV5Rr+aU2meY/Oecm+eBQ5jSO7bWi2ezW/GabTI+ayV4r7sP4cz
NOezVpvn9Gs5nZY5n7XS3K9fyhFMNDfldf1mhuX85jo8n2eMy/WufK6Py57r
u/KevpJW+W5zGR7QL8v59Y58qh/JJL0Zb+jz5SCW6DNlD77WF8nheWZzzbIu
y3gh9yEHsJr55itkN1byhfkGOYz1lOS3l63zLvK++Xo5hLV5P8xzZR9W8X2e
UTky95V9kWV5ML+P7Me03JfsxGf6UUzWC3lTX8osvSff6MOzV3o9XtQXcKW+
G1/qZ+QZ1Nvwgb6K1tkrczke0qdzNFPMzXlLX8YISsz1eSn3xpm0yXVZK8/D
+d04hpH5PmsNeFlfyHja5vzWKvBI9pRjGUW7HGu9Io/m2ilmNO3pQEc60Zku
dKVbzuGYSjymz2AsY3KNeZd4Jb8XE/LOmNvyob6aefm/ih/yPMpRbMy+mf8D
HrjAIQ==
       "]]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  Method->{"AxesInFront" -> True},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
     0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[35]=",
 CellID->489763601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1752599995],

Cell["Filling between curves:", "UpgradeDetail",
 CellID->152023056],

Cell[BoxData[
 RowBox[{"FilledPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "x"}], "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->1693445909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "x"}], "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", "2", "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", "3", "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1144618872],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxEm3k8lN///u2M3dhJUWmRpbK10DkpSiQkKktSSpJQqSStpE22VMqSEpFk
V5ZjzRISsmbfmZnbvi+/4/t7z3z8M4/7cZt7zjlzznWu1zzPJWd32dSehYmJ
SYmDiWnllRVxV3Wr39szlfv/XwPGrFJCAhHYIfp5v4wXAruLD3HrXKkG3tk5
uty61cDFw+h0iksjyLheqJbd1AAuZdr7sazrABviV/8+SGkDdQP6pBi7HtDT
13SimKsbPFGZYko/MQDkOOOYDwn1AdctpS/zoilg7kqJevzMAJg7c/Frq/MI
+CI2UPXKbhjY5Zgb+58bAz7H0JSXOhWcGa3Ly/OdABfuX2ifTaSBZ1szLn/y
mQKWKpcNHgYRgCUvQ/Ohxwww+fvy6sZZAggpGFS1v54DR4LNpdNbCXAwQufD
SOAC+OnLu3vvPgKIExV6dzKWQAF7l+c6Mg2ElvxgZr3ABC1FOuSv2FKAlsze
ZdmzzLD6ke+JypNDYEuHYM/tqyzwhOZ4j0xGP0iIJTukubFC3inO3y7tPcCz
zbp2iw8bbDW13/zAuRO4au0wCA9mh57VB4JVvVrAXMR+u2F/DtjcZ/i+VLkO
VLuE2l6P4oSreW9ucqsrATsPrF1qfc8F/9Tznlti+gbKdHfGwnckuLPaZnXi
s68oOunNzq54blgtLKsVfb0Uia5TdLT5zAPNNiav1+utRTXMXPcls3khW3nE
Z7XmFpTGdeVTdRkfDL65Na0wpBMpigo62hXzwy3+H45bZfUgwm9KRLVeAG59
LtS9oawfrXv0SOWyoyAklZnfr907hLpOtjTr9AvCbbp7V5nrU9DB3trZNGch
2LPOMGk/Kw3dcLN3EKMKwaNRdqfiNxDIKP3tITF3MtwlPf70chOBaAuOnqxT
ZOjH0r+nZoFA7xvupTpfEYYhUi+2vflAoDkHbdub88KwpvJJYMp3GpJZDLB0
9RCBA/2hkjvsqKjvwNNyLjZRaHWKqvr74jAq3FABVj8VhQ1niuTsWAeRI9cn
NjmSGHTX5T5UeaoPZUSu1y4MEIOcOUqO2XLdqGq3VrGpkDj0cftRXPiqHc04
vj1q6ycOVTLMfpQENaJS44hjfGIScLGtsUTWrxrZ7dSKiQmWgG/drWJl3uWj
qMbbTp0ykrDCwXvnu/MuaNvuzwbzcpJwXOX5yvrINXWSbH4dmAjU0VzOzeeJ
IPnmkdmcfBowamq4pqk1BL4Knl5OdxwFkiFmlwpOUIBdw0vf2OvjQPDiLmoV
Kw3MCOq9Tnk0CTTi331V30aAAzcyjr68Ow3U1rAG3/1LAO5rzKzJj2dBwXGW
/FOLBPjS83PHwMt5kDlnL0qNIMDWEs5JzehFcC+kO9ksmwY2ALnogqJl8OnG
tNBtfSq4OHabKbCPCXo2MDFVOw6D1KVY1yMUZvgoUM93o/ggOHye2bpIQRDu
Czvb0C00iFhct7E3xQrCC6cXqgNMh5FopIXjgoIQNOV6JhejQUUd8au29SUI
wcoIAUrvBxo6E3z3RMg2MhTkBexygQQKP/GgmzedDM/nNDlKzBPooKO7xHc1
YZjozW9zrx3Pj8hT3FczhKEIK/NBA0gg3pR+68ldIjD/yzH54lU0dD+KX1gb
icDmTNFjV69TkFnGFu+gA6IwstpyeofeEBp6LGxFWyMJiVK5yrzztujvqcCN
YYERQEOXz+xYQAQIrHl6AKVgnTgfJcIcPgjMdvWZl1NGQPIZ+afPOrGeHHJ3
WkWMgbwdnpWtkVSgfO+54i6uSUBa/CPnPEEDjmYZnWGs0+DnocAW/UwC+IRa
yUizzIJo7TmvvGUC2HA+Zj0rPg8orprOyQUE0FKVNxRZtQjiH08r72EjwGrx
6UnZPctgsmv88nASFbBYr7pXHsMEf9T4dC0MDIMZvms7dsQyw1u5esHh2YPA
ziJ3nMYtCGUV7HSeugwgsqeV1MfHgvCGkb+eXeUQ8rz9JmoNSQjG2QYZsBdR
UPDBG6JGfkKwRonrywELGnJmHbc1FyDDZxcMrXpsCTT1SOCVUAgZCiPh+5BG
oLcpLodsRIUhT3KOwvIogWayXE65vhSGm0yUL5xxJxCrH/mUprQITEg08Jlz
pqHqI8aaDe9E4D02E222UQoKu9OysUpeFJpMONvk/xtCekkHe/pXS8IHNLbL
t986IK7+lpgPA6Pg135+21W/8Pw+m/ZRjWkCdBS6bNWwoYGCyCVWJc4pQKNI
XN17jgDr32UUP1ucBqkapV5ywwTwO/Jp4KDQHFB679zLPkaAuXw2ZyeRBRA5
VeDnfA3/v+VQmKXyErgYf/rCm4s0MGbPMcJXKgirf/+4rvNnGH0tEN3eZCgE
5WSjHkm/pyJFgXxDr0ohOJtSVsw7SEPH5flN64+SofKVdHj0B4H0tkyrcNWT
oerlw0ITywSakPXsEzYThlI2Uwetiwn08aFRmnuTMOyjnBKxZSaQSGO2VcpJ
rEel8rEbC6nIz66tdkJWEoa5xypzOBijZr2HBdGBL4DMvciKo/iVZfkzDSlS
wb5Bsb2ahoNg4+9YlrqEEaBh9GTDQNQw6HpwzqY+bgxoRgXs2eVEBQd3Jrnf
Lp0A7QfWBW2qpYFbOhmb1hZPgcm7ApcaPxFgv9KTuCO5M2Ax1mR9EF7/mRJD
A3KNc8DytAqh+IcAOoMp1+83LIDWh0kpresJIMVqt7p6bgkoqbDNCHRTgVHg
xfxzvkxQ1CkywV+eAkJFW94q+jDD35n2je95h0Bz+E4vrikBuCvQcOmVzAAK
ZR77SPIQhBeH/+Sf9R1CKk4/9mybEYSOGRwHEh5REE3sE+d9LyG45K/2eJsy
DY3v+nJWY0kIdl+ZdOrbT6C1EX9HhH3IUD76Smd9D4H2N17q/sYuDD1K7kKb
GQJV6M+SXB4Kw502tVek/QjkNR9z6jiPCKTeVi498JKG3De46n98KgJbH2T+
jFegooIzqjeHRURhrziU3yU/jCb2n4k9i+efYJqdkmWaE2q5FX404fMoeJHs
Fm0YRAFdYdEhtKxxcDz16VXR7TTQenytkUvJJGB+oj2QYkgAjScZvEJoGuRt
dpLd30kAw67aa7crZ8HVHHLtnxkCHK21P6rwdx78GuG1/viUAApCN8vKBhdB
+nPdHoGXNOAx/NbjSqYgfNwvTMkKHEZ2SRpVQ7uFYGH1NuqAExX5tNL2JOcI
wS2CBjYXSmiozarkWLoOGa57dmGHVQyB3HRyHnP/JMPFB7m93ktYL3Vv3jm3
XxhmDCoVnqkl0E1yw6lrpcLQZ7ssKyFHIH9dU+u6QyIwJvyaSNcIFWlNzbxy
xfPPZO92iaK3x5Fw2YWuqQOTYI+/561SYQIcP5cRKqkzDc5qTjxrKCFAKaeK
f5/uLJg6eNM6EesX+9TG1Z/M5wHnaK7HgWQCDPzaae0uS4ZUg5OKHzwIVO6i
ry3wiQzDz55riJ8k0JjflSQeeWHonu55Km2QQOuUB1LdPgnD28OGuW5WBIoZ
aP4+qDcFXq9Lzv53mwDCXzO8uLRmQNPzTxIS4wSozr5hKXJsDlQZSLstDBCg
lmpmNHWWDC+QnhWw/SKQlMi2evY+rF9hcfV2eD0eWvA6nH8G61Nv40/nNAJ1
VBUK3MD7bUmLLpO/A0S9Ig4z6YF3wN3P+R5R+HWX6E4dOEgBNbZqGz6vHQT+
kk8aj/uNgO8G7rsn7w+DqEgbixTfMawvtmZrTKjAXLRQOiJ2Avi9y9xdhffp
hzs1DXuipwBVuDvSMYwAH6ZkRy+8mwEqNCHh6HkCnH0f2nI3cw4kB9RkJzYQ
QHf/rec70xbAmnvdUhZqBJC4+Sp5YxPWp+4ygX9zVDChGNSZeoMJrpc5fXjH
Pgq4KOlXueEaM2ybDx0aUx0CPWKvy2T6BGDxwotGv/F+ZFOk5ajlJggDWtrM
jeyHkG93Oe8PQhBKmbuZ5DtQkPRSNtM7dyFY0p5ePilBQ+n1vuc+TQrBJ8MH
HAQ1CJQZlykj6kWGboZxXXZ4f33jSFFpXiRDppqQmL9zBEr31z5F3BKG3hSf
NLk3BNJKHmt3YBWBtV5/mX7E0FB5wL0a7gcikL9W+HWaHhXVHWuX8+DF602F
5Ur+wWH0y8+Fex1eb0I2pzv0C5zR/p93Nm9/Mgqu1LJG5bpTQNSPsBe/3oyD
QcuAdA1pGhhSUxsPiJkEmdVvfm4HBNhzT3NrbcQ0+ObhIhrRQoD4eMfsV/Gz
wGCW398Wjy+TlZje47R5UHDutgtHCAGUnGD73ZJFQOJelzgTSwN7vvaBT98E
4b8kdpEWt2GUvenAuyuqQlBrKDKJZEpFKUXsOyrShODX3pcPu9NoKHLmg8WG
XWQYlFLPyxlGIC6jyHSeXDJU73ksILBIoPGG6V8vtISh9lhzZiL2p2dPSKdN
IGG4/JUj/Mw27E8W3rX26IjA0MCtqfycNHyHY04Fr7cXRSYDUWlWSDb61iOJ
TZPgORD/exzv96etNXNb1k6DmsDzuw/nEWDjn+J6pvWzYOJmWO4yXm/JXo2C
7JrzoGXCffzHD9z/82Kn+sTJkDyV9JPHmUC2noqOguFk+FHyyJL6GN6f5MYW
1WSEYcIt32BxvH/zX1PkHgsThjceO/AkXyBQahHFhmfjFCDYR28cdiPAqmjN
qPJVMyBZ59mXEwQBVHwEopRV5wChdrC2lEqAkMfbjM9ZkeGWb49/ThQQ6Nsa
EVbONrzeskdsh/F6i/BbfDNkKQwPHzk4F5VDoAyJP64aeL2dyf6x2+jdQeRm
oMlu2zMFmr2Zn1UmEqD3zPgZ9Y4ZoOEeHzG6RAAe/51TBdNzgPa47ZdSOQGe
BY0Vkv3IMOuNt9svrBcjukTIIz7sP2JkhJ2wnigFaQ4atU0DSq5LxOU+AlAl
tFXOELPgjqXvy5RJAkjnDx3VMyDDy/Xhx2WTCPRPo9mKVEWGxkth/Z64vfop
c9u1DYWhQZX6y7AKAl3Y81q/4vws+OAyZfUbt0fN/pwg/1cyXGXis/we7zdh
CxNnuxTxeM5dfteI9yPuDE1LPcsZUDVbnWo1RQCX8U6ROfc5wGrm2hDZTYCH
XEaf2WhkuDH03dWTWJ+5vNMTvuPxeKq+7vyHC1vR3DeVs02Bl4Hry9T9dfjV
PJLJ6W4JBXy7yyeTyTcIinM99r31GgFBZ4Mqa92GAUtic+3762Pg5tqtFaf2
UYEVqyEt8fUEcNes1B/PpAEu9Wlr3ZApcJDC5O3zmgCmlk4i15/OgNbYBrUb
cwT40Ttm9i12DoQHed4qaCbAz1EbCdGP2B/pbpVo2431Ry3Z82jpEsiK2Wzn
z0EDB+Y+jba4MMFzcaEnuk0owOzt+b4PTszw5Kw38+UDQ2DI9MDlTW1Yf4ij
Cefa+lGefFfFMWdBuKntnGvY0SGkvqb2itewIKTyC4RIn6CgZNeDi7FuQvB2
gGzPFn4aerX++nmbUSF4nsKSd1mZQA+2KqSKepCh1mSL7M1/BCpK2VJPmyXD
huLsw93Y/yumtpMSrwtDPrD/yOVw7Ef5JGRdl4Wh0yX27uJvNHS1hCSe6yUC
00dqyh+ZUVGrkbr7Xi5RuDDb6Wdxchilq17fzYL1ZxvoVsovvYxuXnQJvuox
Cgz+NesZOVAAS5kk7w/fceB7NoMSJEADo2tziqNeTYL7zHNp+3YQoMBzeq+a
/zTICJJhiWgkwEnB9PaPobPghW6slNsCgb8/Z5QZPQ8quXeqkt4S4Kvkeker
9EVQZPHwSGYyDUQKPItCXwShZ4jWjUK7YeRw9gjrDhUhqLfpSYXDfio6tCNA
rSlJCH66+jd+/AuuX/QCj7epk+GxxVtyn14RqLZW6DDvDzIUSXuRvg7Xv6vl
NN0+7hCGfjcm6mPweDV55pxKzRKGlQ32ooM7CJRgUSBD3SMCK8kzGTNCNLTU
w7tFAOvPhTPHdAMLbNDGILaTmyUmQVHm5ia3BRroOz79W0t4GuQyOcSfzCZA
vbrQHJ/wLNi3sYs8hvWHq3DrE7WN86AqPGj7z1y8PtPYbMOFyVCv/zT/k/ME
2sISziQUivWo8qOqwQiBXBy3fdSXFIbTrTdSpfD1g9dVqUlvhKFtdfOtVS4E
ykq+tm2VON4v89N5LJwIEBk5nbKFbwaIjQxUGGK9aRs6Wbx77Rw4nXzrwCzW
o+sNa0xWHyfDzeyu29NzCXQr2vsNZzMZVp13TMX6iMobtOCyhTA0M5axfZFP
oKichihRvN6yEwyMldIN0ZTetFh+3RTg47IWsYsnQHDpnkc6v2fAwnfFY2Z4
vdvVBVwe658DG0MC+7IrCWAhefak8BMytNVZkDjdj/3FC2XtdyTc/i7avYkp
AiX7Tc8lVk2DrS9TyIN4vb+77Wvq0jYLoKffB7NpAizwN5kt6ZHh7lu/nIy/
YH+TbTBOKifDL8/unxbC7b26sLPJ5KAwvMv8aVSgmkASH7qdmsxnQfvUuLEJ
Hu/loYZP/HFYv/xsujSmCVSqq8YzvUkYhv8IMTLH7fFLnnaKMZgB44tP35dN
EED2uNIOznNzQEX74RNbrIdH/BBgH8J+7Om5SBrWn4nNOW2v8XhkughnnA7b
gSYC/lZaJcyANO5xvq94/jrLJTwuZhaGcqQbhz/PEmhBb82bJ9mzIOfshbVb
sH5olyrL8hSQIatm69VmvP/dcPJIGVebBfFtq+4P4va+nPpRKxBFhtccN3Uw
TRDo9efr/hcUZ8Cunhzpg6NY799EOXF04fb8mBDLwP3XWI6Bm0ZnQIKNDOtF
/H6hJIefXDVkeMkt+nopvv+jyXADujEL9viS72/G38+F9ombfMlkeGDOTYmK
2+eTdV2/1xHPlyOTxn/weH+//4/MNkaGrqUdRz/h9q3qSPRsxv399aFYvvyi
LJIfzN29OugUeJXWML4Kv/bY99yNTKcAV/fMdeqsg8BWaPxGtvsIyFq2XPPd
cRhsT5cgS14eA25T655c0aICWw9/i0z/CdCWvOqMRyoNlG9v6LvmNwVG9aO2
kLDfiOMjf1q8PwOesXUa180SoI8zQqg0cg4MX3JTgf8I8Ki0uvX+2wWQKX1N
Phj7mdcB6PQgWgJ+9w6K2/DSwEjHt5uEExO0+/YuVvkEBRy0qnOzc2CGje2F
fXImQ4AysrpAqVkA6kUU/iir7Udu9Wpedk6CUCOdNTTr0BDi1baIsR0UhOE5
Lb+1TCjo9ha/W4kuQvBAdvB4FhcN+RrQzu8ihODesq0cgQoEchi3Wxa9QYY6
vG+NZ5oJdOK4webZaTK8aMcUZoP1pa94a7vfNWE4B9MzuN5jP52lAK8tCsPC
pLh7EPujg12Hv7/yFIFdVSkqZy2pyM7AVlaeQxTe0ffYJn5mGCn6zNWOymC9
MS50WJJ3QSK5A2Uv3UZBdD5LGc9pCthebXFo291xYN3TkJxGooGJN8wq8S8m
QfuvFP887IcfejSUn/WdBlscdoUIY7+cXGDpuiVwFoTXODtS8Xy9VyDlWR02
D/54fWW6g/325ZGXKuUJiwB+8x58kkEDJnltRyviBKHSY9HeBKz/e+7Xakgp
CcGc8zX8z7SpSHSsPrk9UQhu/6bn6xJLQ26XSCd+qJLh4CtRyYFg7IdDDr3m
zSTD8b0L/FF4/0kpNi/+qiEMqT3PL0m0ESjYj189+LswbDaqeRWuRSAr9r/a
o1oicF/F6ig7cbwfafoXLq2RhO3FDSOkslNIgVu/cJvgJJAJdTK7OkMDseYN
xy/xTAOlkF085tjPKQ+kPw3mngXTWqPFrXg9qPb+0zNcMw/c48jb8rAfvP3v
lq2HEBlumBZL3X2WQILF9QZCr/F62v2mQZ8gEIeAyfRRcWF4wpNWJDhKoD1x
a54EvBKGKpUnz+y/QqDczT9C1wtMgbJrdeuNL2C9C2/QsmKfAQ+aHo3vouB6
NozJokByDsRP2wmx4fXqsBRiMneMDJ88m9n/OBv7S4fcHs5GMvQv/tq5iNfn
KU+rIJK5MEy9dna9RyHWL0HL3ex4vYkuVTesKjRCmfsbIkYrpoBp2zkOuc8E
oHj0SJT9nAFGcl47ZxYJ8HxKW5G7Yw4Imp+svPGbAFr/3kUL++L+sFbPrOkj
UKKqkf8nTqzn8uaaCVj/rj5reNDxcxpE35M8F9pFgAkV5Z6pv7ge9dbKEMf1
NlXd+FjzfjKMuG/a0vyZQM/uPNzDXUqGgdGHo7CfQ6T3JxSt9IThwK+5+Jw/
eH869njplNEsSNyqVPcQj3dPguAYfywZmr17ePIa1nfroaM2zBuFYQnNPP7x
AIGMvzVMNuybASPKqfETuB69wV1b9tx6DshyEdPJ/dgvmsw8YR8gw+cme38o
4vFx9ITXffF4XBTI/wcztJDh/lunuj/OAJ9NzHzKeP6y/az493sZ65nqpPE+
XF+ZzRYpCKXOgsNTvsfKsd6ufXr+Ik8eGe5pScu7gfWserWsrofiLHjJe1Zm
FrfX4/v4asFIrLd6V5zWjBPoZIyFZOj6GSDrZJJsNkKAcquWDI4OrKf383b9
xe3xSzpc83VgBizfPFK1Hb9/6sp7IVI1Ge5MvPD1E75PfjaWoesyC76/Nqfc
xXprFKVUzPcN7+fXbgYbYL09+N2iRvTMDOCRavsjhfU2XFfUhm2EDIWca+zY
8PgGblcVLcf9FZH46+EbsQnNxf68PxI0AwJKDWSFcX3GYiNotPrDLFin/+cP
FV/TBJuYebPJ0Dn9yukwrDdeDy46PJKeBXGHSuzx/AIhXYZGnP/w/tt55zHu
L9ISezOZ1TADLN7tux6D21cwS44lVZChaZXhOgN8P29Eu8X0FN4/+f/ViuD3
O/7ymWCj4O+/avPjWNy+4+xTddxFZBgT0L9FDV/L/qiTu6Q9CxaMKyjV+P+Z
Gi7IcfSQYRkleNIfP6/NkCXx/ewMqD3FvicU31ekqdziqiND8caD+7rwfbuN
McE77s2Cf0U6q8vwfP70XLFnCPf/Esv+CHEXQUTnX+nLK38EoPOvPT4F1J/5
BIN/ybSqXuwYozH4l9SjcIG+JCqDf63u2nPSiI3C4F9d5QLG6t8HGfwrifXQ
C0/Ffgb/splP5ytg6WHwL9XkfWvnnncw+NeVoL6bAuubGfxLY/C+w8n1NQz+
ZTStMSpYWMTgX17Bc/b21I8M/tViqRY6YJ+B6PyL3OX89arJL0TnX4O7IvoS
u/4iOv8qqxqqQ8GtiM6/Tlt0j13Z0IXo/OuG1rNLJM9eROdfdT3Z7mf2DiA6
/xopWV/Q9HcI0fkX62wLLbyXguj8K6RNnFi0piE6/zLNqzAqxf6Szr+03q5j
msP6SOdfdX43As9jfaTzL92tG9GoA8HgXzreW0VWOdIY/EvMyi79xW8Kg3/9
5DHmfZw1xOBf/Ft+n9xrO8DgX2pxN7cKOvQy+NesH5n1waEuBv869tRdv4zS
yuBfrwtCG5BqPYN/xVZ+qMrVr2TwLzibXe//O5PBv8q3J9rz+LwDdP7FL3zs
es6WQkDnXy/2aJwkdf0BdP71NidN3ON4E6Dzr5LlgEdJXh2Azr9ijzj8sZzs
BnT+JfMtqiujow/Q+Zd8ofW5z58GAZ1/sWl9GDSuGwZ0/oXd0MuOp1RA51/+
QbuNlAdpgM6/uOxVzkslE4DOvxZV1isTeD3Q+Rd9fdD5V/qL58QlrF/tzGsz
+i1KwRqZ/iIDXB/UR1SkzbnWActvFO7Hp2kgepIXWFn+AztfRI1NDFBAZHXD
rzqdLmBvnrhxlDoEgvdlhrkssELmNf7Rl0MHkTufgYA9HzvMLTh63pg6jDSc
c+uLyBxQy8PYcsc3KrL3vXw6SZITRhUHkAVnaYjNyiZRYS0XRIYSNMU8At37
qXRUYA0Jnrgc2rqy/2XcGnQRWs8ND+l87iShlf2iyyRSgQf6RAc8TJ3B+z9Z
aiprOy/UXTV1YziBivZ7a4tM6vDBdTqbzi3WDaMRv72+bw7wQ4/3Jp0Qt0/H
eSvz0z9iMLefGCsrHwJnai8+azoiDvnGPKR/51BAh3VYnUaNOPxuaR79xIAG
RIsveZ08JgEPem5znrPC+kpqfby/SQI63TXsOTlMADrfal5z/dc8Hl8633Lm
3bpHGu8/wdoOvm8Ei0Dbl+orfrhe9U3msQ13qwEPIt0mOL/SAHemUjXnuWYw
15vYMmJMBT5FqxOGt3cCxxktDqbbw0DWvZclKIMVes8e/OA9OoBmr5m5lpax
QWOlEIfz9sPI7Ni8f1ItO5TJdfTwMKKirSLNp43+csChzj8yA4k05HhugdOk
ixPOVS5bXnhHoFaO2Fj3Di4oeeEqrQr7rTzbAN7NHSRIiXP1TsX1LbNRru7e
YW54PCdu1Sc1AhVJrdvKR+OBjy6vi7YQpKGnhWsNHi3zQs/kh8zq5hRUY3BS
PI2LH5ppzA7wKQ8hz0cKa2KSxGCgtdjJ+d1D4DVn3aaQreJw9KTbARdDCnA6
uyrY4Js4DGzLbRwkqID2hGMoRV0CFvRN3OveQIDt759JTKVLwM43/3gO1xKA
zq/WF/Q9nsLja12n5j+akAFOVvkOz2G/r/CzpVc9ogL4Wx2w58V+dt3z5zwW
rvXg3Hxuvjsf9rsf9yYwm7DDVOkntc6XKEji0b1VjSYcsLKLvT6Pm4ZCF9hO
i9hwwoENHBTbnQQKN8kzZ7PjguMvRNZw4/GQ90lZjLEmQelrnpXeeP/8GrL3
7+x5bsgV7cPk8ppA3304bZYv8ECPpPGYLdivr+MWyna8zgu/Uu73jutQkXIE
68iqy+LwQVLdcdNNVGBmsVp07YQ49v8AfA6nAa3lOjLzNQmYev9jo/1TAtS4
KM0HzkvA9dX6nNrYn9D51feRurEl3H86v9r7Z+cvDnztbMnjOkbJB8a6/9Iq
EgnQtXuL+ojbH3AtyGKV4x8a0JbMfW19sQmwrNYtP3yfCjz2FMhMx3UAyG+R
9D5/GJwT8FRf/5IVvhxjvnw8dADtUjixdi6GDUJZ1fTA1cOoq1SStjGVHQY2
9P2jSWE/f1Kga1UKB0xQetZH8qWhsIsGamcLOKGVVnVX0CMC8Wy0P6qQzwV3
cPaINGF/t/+ofbNaLgmaTCpeVML+rnY5HgX84obWmrMP848QiBK+sTLtFw9M
72i4a7yHhr7avTxX3coL7zbnyHYEUdD+uL42nUE+uNajt+vVtSEkFbxROe29
GBSs5H4oOzYIUuS4rk/IikOL70UDGkIUkNzfMn4sQhx+m74dOJJLBS3UmogO
eQkYL5RRPs9FgEOXetqroiXgRLpSeUMh9rf/8an0TIM143g89xVHLoVnpQCV
hNruL9hvsvV4VfndKgfmS5u+HzIhgKdYQkes618wNSnP77qDBtRP6NmoqrDD
zat/77BUpqCYuYibRts5YPrl74ln26jors6uzq7dnJAoinhlJkWgP+YCD8R1
uODB8euVEr8JdPSTS6zlHhK8W70pRQPr3fbHoh/Y9bjhS5vlnc1fCPR0x2TD
kUM88PVpaeauBhoy9BM9IXyMFwpcE9lz5yYV+0XNPbdOicMo5vuV1HEKCG1u
varYLQ5/fX6RvcWdBjbZvS9VspeAruL+ZhuuYb3S8i64OCQB7WBm3ij213Q+
RbJxilrxg6uNRtPHE2LA/h5rH23sP3+sKY6Aaj9B32GVUD5vPH5VHzvvTHNA
ocrX2S//0pDm6YQWbRYuOPky2PlAIq4n+oYWC5a5YMPMAGzB/k/LOWePDAs3
5DlHTVysIhDLpl1qj3QlYMLj9ohuHQJI/VUzkSmVgJKfZgVuduB6XUZZ9iLW
037tyUsr/vt6d6nc/sgs8FRxb8LxagI4GboqjN7jgolTf0SY+gk0bT9lOuFJ
glFmxceGcf2i8PESJ+0xNxTInf9YcY9AR95xWdc9lIBr67eHZ0Tg/nz8q/qD
VxLy6O7br4X9LZ1Xnan5lr2yP9J5VWbn4eR8fG05ZNW7uiUP7AgIdyB/x+uR
KWuN5Hg1CCeWO+y6aKBen+M2F60RHOaz+WYaSgVX54XrF851AGuO1WMa3cOA
26qkivKAFYqR5L3FnAeQ5cOWOfIrNtgxynzVbW4IxbF8XnXmIzu8b1KldYeJ
irgWN69li+KAe1SLruhfoSENmlv5pWRO+HdC9aeTJ4HWZhRuepjEBeO8Ob58
wvWIj+GR/F0JJNjWMXWaTCVQdmPUwvcsbnhXabfcKysCMXV+ln7ygwdWzo1s
8DSjIZhsNDFRwQuhTEPEdBIFeTZ9KXjcxAfPqJb/LXw9hBykPqlnvxGDo5VV
qq8rBkGe8trwdZLikEM+a9/s2DA49jlrXUuIOPz91nx7fDQVmK75PjclIwH7
jqZ/MpmlAfOj/vt2h0nA5x4uJJ0sAtB51IEHjzVH8Xim59SnXStIAuqlt/0N
cD085latk3WhDLziHOAUPkWAzS1av/6M1oELP1Xu7jyMn5dSqmG4mh1anFp/
WYSfgpzVVGIfr+WAVhISp3xLqMit10yuXIETZqav15gl4XqwSUNSbjsXDLhx
Rq6rBF9r/L6dpkyCYiqa9xpWfg+8v/yYR50bjhXduLYzHV8LUURu7OKBFzkv
tT0aoCHb6lcx/ft4oZSGj+dsEBWZ/zSxj7MQh3/6DvmINlGA9rucj0nN4lDa
zvvqGuyPwoMerdtvLQFbmL7XH8b1/tTabRsaOyVg7UvLbIIgAJ1HjR8tLFnA
/WcD1vLvsz6AXpU3H4ZmCRDzVUzk0tpiEPB1y94QfwJouyK5830ccF/eLkX2
Quy3u+tcD4xxwjS+9/binwj0012/dtUIF9TRVTQMxPWq1/kY+XWjJNigqlAu
W0+gGydkX4RpS0CjzYqRsuoE2JDVkfoYScBfZjm6is0EuHx+9/3NeH09CUS8
M7g9Qy1LjVIx34Hj3udl/fUEYP/9Om/OlQuGXhENKOokEP+U2SajSyTIdlch
7xqun53CLGjjN7jh1W53G/vnuD2VtIwhTwm4y7fmUcVLAvx8cu/VBjZJ6CT5
QtEH+x86nxq9Huywsr7e73Vkm0l4BTYEvT38G9dzEyEcXtXVXPCB913lAFz/
spy8Na78mwRPH5cvyuwi0J5HOzztvkrAYEDca/lFAJn5Y3qf8Hw6VOXYO4Gf
V13heKA0NQ08O/NsPqCLADvq+il8plzQPCLsb/XflXqWXMtsRIJOH+qvSWM9
ajNvslkek4ApvpNttljf7L8Mq6fg70dT281yZX/dYe19UC8yHjB3D44IT2A9
Mn+26YIACQqVopLPeP7wE77Ub9USMGI+9LBqHwHya2Vzv+DxLCl4lDCH319T
ph/cH8AFj6y+9jJ7mEAdf1/dDn1Ggvuz2F/3TWD/kLu5+rCoJHy711fv1Mrv
/f/xqvTlzcTK+NB5VUbGJaeRleclea9RN80Dh8xda71yCNDTxfJSKaUa6GX7
CyUN0cA6OwXCOrER2Gx5EqLwiQpGmrSSl/d3gJC6aMea8WFgxXJJ2uQWK+yy
CBf9ZTGAnJJWnY/wY4P8V9tXqw8MIb+IkZS779jhYI+wvMw4Bd0z0iy4/oYD
ulpE86U50NCDRJ+XbnGc8FrJ8vY4dwIpL7sJJ33mgpw5EWHtuL7bpF+UmvOR
BNNXH5wwwvXfVt3V0lUp3LDfmb+21o5A3CzDOhNJPNBgciLU+hQNkU5u2f2o
iBeu2+IWWZuH/djoC7WEP3zwgTaniWrcEPK3tv+OXorBYFvLoARcfx9QT9y2
W1QcHsohnUvGerrhSXxWWKA43Bpg9LD+NRXw7VDcxCIlAbv6ZGWOjNKAld65
a6OvJeDZTJprXjrWm/94lJY2j+bKeI58dxXqLP4GjDuLDznRCOCwa9bzT0cp
MJK+bpVvT4C7OQ9hX1IdoFUEnXexoIFzHaQPjaLskOnhIKlgcRiZ/nEHMVIc
sNh+rpKWRUUUDbt87bXYP8Y2WYQw43ol9FCPvAIXXO1bbC5eRCB3Ly+Hrg0k
WHEyeXHl9xWxO1dv+ylyQ8vDbL4pPwg0cPu86rPtPLCFdN4qYQT79dHGKpPd
vHCzl/cT1vdU9K+ibSb/qDgk/Wjlv/uLAvhvJ2hdrReHsSx/xM+Z08DJL3PG
R05IwJcNNZ6qZwiwIMp53K9VApZufvw5g0oAOo8Sj/hzeEV/rmsG/bte8B78
na64R57H+707MHrwpggo1+12Wh+Cx6ugIr+5lQMOLp1W8V053xk9oGU4xAlr
Dj5ebfyeQDW5Mzn6A1xQv4h/CGE/vObsKslPAyRI/fjypWcTgVTdgrJjd0rA
9AwXEyFlAih+Te8DWRIwsLJhogrry0lenRQuvF46/B4dmcbtWd/4Rs0nLhN4
dJ5sYcL6ZOr/5enyBS6YcMdTbbqNQFJ72IRv2ZMgef0y+TmuV/hCKzrdXbjh
vtKQawuBuF7sO907eUMC3jvxNzIW62fFbYuyf8sS8LgRx/wV3D86n+qXHNy2
sr4eba93i84KAlt858M98P7P1J7msFjKBX83GjjtnyHQB/ORvqSfJKhB0eD1
7sX+1YP/q0ScBEzSfDo4XILXa6TVdW88n0JjXnCs6A93GfsH1cxUEDI5Mqnc
S4CHL+czyIe4oM3VvJiHNQQ6aJOfo6xHglmuKnaZWH969BP902gS8AeIScia
JICxydi5QPz9cKesY13Rn/hjWcurYj6D4COj+pn4/sfw3cIhnLg9nodrTPD8
EemyWXO+QgL6lZHvO3QT4MuNjcRTPJ7avWNCK/qz5qn1KcpjLlirm6fhPIj9
tcwBh5KHJDizHAVvYD+emrTMzCYkCb/IXt/UgftP51WpVXLNK+PzaZNVBNPX
R8BxrvLPFXwtdllkj8V3Lpj/8ePmI5MEsqGtCfLVIMGEQX2HENyeERXLCbk+
CSjUoiHFOkaATW+XS41xfw7vMdy54icD9DY6l6dGg47M1I8fZrD/Ug4dIKa5
4O04VhE9PB4sX6O15a6R4J0cUj3A+p/3Kt7ehUsSNvB+Dr2C94eKK+XQArev
jLshZKV9WcZLLw9FvgUoI6+BDd8fMLII+tDIBf/92HcS4f1pa5XdQN0xEhR/
kEo7hffHxjOsSvrTEnCQBZl24s/34Oxlq8Ptu7FgEb8y3s/4W7W1xEnwX8aw
bDfuT+yvo+GvJCVh9fOesO/4Pp1v2dmXza98Pp1vsWlwS6+sp+eioVp5fHng
5K1ZxxhEAMG6T781g6pBllXhmwoaDRxy1orl8m8EL2kXO3m+UIGyvokss1oH
ePbyh5nIwjB4+BftZb3OCsW/eJSHGg6giQPaYfZP2OCwrPJWnvYhxOQcfOfF
a3ZY6z/17DSFgvZMawdue8kBv7z9XGd9hoYU/AXnr37ihLcUPyvkXCGQ2ody
35JoLti3GBM5MoL9QImX8p1IEiyU5yk4ha8d5y0VGhO5YUDZ9qg+ewL5Bz41
/5zAA89lJGvmn6UhWsIbG+M8Xugh//OzeikF9Xneo+ZW8sGE1+nnO5OH0Prl
/bfyg8TghA5MUP42CJ5kXpvXExaHbHUFc2z/hsELjw+cd/zFYXOnaOqpQCpw
LOrN5ZSQgP5JTbd1qDTQDkz8KkIkYBuImnNNxfrwH7+68/tjysrvVbw7AAo5
8A18zJpddsH+aX04X6jVu1Lw7ls8Pw/2V/FfN90aCagDWrfO3L9rRQM0d4Wm
cCF2eEJZfs3zyWFUFCHFky7GAZ+8ltsqnk5Fse0OAdMynPDpY4/3Fos0ZHOr
Tn/TBi5IUh8X3VBAIM+19a0za0lwNnln/grfPreoPH1kEzcc/aKj2J2N/bZa
tE6IMg+M60vNSp2gIeLezS4OTV44eir8560YKpI1ji6oNBGH8v7NrPFFFHD9
UrTvsTpxuGrbk8gFYxrI3JHab2aB96d/mb+kbAlwR2DM5UKLBLSO5Wt9jv0v
nV8V3EjiW5lPSarKO7qLI0HRBf2iUKxfTU1HL/IfKwL5uU0Tra8JcOVibUBw
EwfcMXnPNzuVhoq83aKM+jhh3WX7Lx3heL7bGava9nBB+ZtngAHWZ5eu+sDz
PSQYfG8rSaYFf99Lhke/amL/omK500uBAIkx75elvktAd3uZIPJf7Kdsig1m
sL6931tEXfm9BZqf79qtmAn6OuoK77UQYMZFY5T5HBe88DQ18mErgWS7LH0D
TpNgiO7xfXz482wkHlnucOKGt5unv/x4if2Wm7TnvLsE/IoCJHj8CHDkuk5X
xqIEbFY8Idk6RwA6z0pZ7ST8f/5HgVfBsyAAnFpT+qYI6xPHA7424WIu2Hto
c1Agru8m6uJsrxSQ4Bs1ju+tfQQquTL7czwGj+d7V8e+YgJ4jbULXMPt31I2
F7RSz284UGs8uDMViJBDq1yxX1Nw95YR1eOCb9rHE2uqCWTEIqmqq0OCqw1l
beaxHp3fF/rZnyIBVxEPjFqw//v54dryPawXXXJ/a1f0rMfE3NI3LhZsPFH7
y2uKAHE6Qb5fWEnQRkrYWgrPn1ct+jt0yiXggsUH68lOAqz9FffoFv5+yxSY
81fq2Z8X+4to3lxQyYJ79e4BAo3lh7e23iVBv/M/wtRx/zTjh6Ta+SVhX77Y
70DcfzrfmrzgXrEyPs8kS/m+Zj0AqoN/P4Wv6JOwU8qlNC7Il8WV44X95dnA
61wR20lwONSg9Aduz5XNenyL3RKQS0+AZWmEAOHU+6ch7o9bVzDzSn/KdQrK
1DM/gtnmzVwGuB7Jqxm15pjggskKTqwjWD+5TBeTNV1JMLJ8NKwN6/O+gBAv
Aw5J2Dwr7cmM9Vfn5+EmPdy+ouaCuyvtU9ZXOywX8wb86Ns2fQnfp4195fpR
xwXjBfaJK2J91nD7YT1sQoI9GsHe+fj5ltY03fWTEpDqEfNNHuvzyAmHsELc
Pg0Nt4cr+hyYrJZiKkyCRGzXgXLcny3FezLcxCUhvC3CE7By/z8eNv3LZ2rl
85OmwF+hr9dBmJXSxD987dK8YfyXAgkml7AHUfD7K6TeH1SlcMGyMydpivjz
9R86fWNmkYRCzfJfmHG9onjRjHsDfp5Jl4HRyvNEdkVmVaW+BGm8fc2b8Peh
8+PCQYlDJHhc7xy6tHIeeK477A4PCfK3PIm8h5+/LVNkcJOwJEzbaGS8Hr/f
q2Gn3mf8vEimlN6V5+Vpjmw9GvkUdNyDqnvx9fFDpTJuu0jQumrXaUf8/tQn
Olea5rngVZW228H4+drheYYvuSXh0iNR3394PM3lDsSex89b4vwTt/I8H0fv
UnlpEgxi/Wu6cj5evsbBO1saz7dyylLj8v942fSv0aWV/6fzsqr/y4sFMPJi
kR5W+R3wN4OXaTSlJl280c7gZb0jrqeH5PoYvMznwa3JAfIwg5ftzH2xnRRK
Y/AyDflH39Xx+qDzMqaQdZPrdhMMXmbyt6Pk9TEKg5cFH/l8/fS/fgYv4xqm
7Wyy72Twsk1PJI599axj8LIL52x0hwdSGbxMfeiMQb1hCYOXUR9t0D36rZnB
ywLP3P1G8e9h8DL7bNunxruHGLwsnnvD59u9VAYvG8x5br21kWDwsqNGusnu
HwkGLyuOTg4K0KIyeFn23u2/U2sHGLwsPmheY/3GbgYvU87cZfLrQgODl802
XK+cHEUMXuasNsqb55UL6LxMi/lOgTxbI6DzsowLw4lDA12AzsvMBImvIcKD
gM7LJLV35m44QwV0Xjb2pdm6ENfjdF5muY3ldXoNAei8jHu++ewxNhqg87KX
d2BN0ZUhQOdlJC4J69KaHkDnZU196/f/vf8P0HmZ7s+Mk3FJpYDOy1QGlng0
Hnxh5MU6Wh6usZuoYeTFTgRQexK3dDLyYkXl97nndPsZebFi86irI/spjLyY
Wpxl5ytVgpEXW2334OMMXq90XjZ32m16KZ7GyIsR3X334m4OM/JitRbJFyyT
+hh5scvx0TKF8+2MvJhtQXIMcP3DyIvN9suFBp2/y8iL/fq/vFgAIy9mEK9x
fo0XYvCxa+739oiKdjP42NrNecVdZQMMPrZvjvyaXYIKVHhlvZVt+oC7zkbf
JW+sB0qnDLLuDIGR+QvHNnYRjPyZ8gGWt9I8NEb+rBRl7681GGLkz45szZtz
rO5h5Mf28nhtL5TuRPT8mGRHs/f+0H5Ez4/NCWzckKdHQfT8mPv9d8F75Ank
VCT06c04C9Qf3yNljseTzu9kbReYnmTQGPxOWakmbWj///jdIJvZ6IVNfQx+
91ZLV4O0rp3B495WLecyb2oHdB6ns7pnl8G2PkDncZ2hOZL7bwwDOo+TShtP
TcugAX7TB6j8sABc9cRZowzrLz3fFpbE6bp6MwHo+Tavsr+LYm4UQM+3ufI0
ngtt7Af0fJtqyPH9D750Ano+jewVJ9dl28PIp1llGB+6zjzEyKf9fa15YGGJ
ikLEd0atKReFb7hVrznWY39k1ivrdlgM9hFRTsPvCAYvpEhtCZkwpCI6L9y/
1YE7WXcQ0XnhqFoo7/kH3Yy8m+zQrujc8y6MvJtAriXJ63kig/8ZS/NQLFw7
GfzPbfS9gsK9fgb/U4otUDGXp4D7c2oljra9YIPMpmXDNbi+/KrwKdNpEHCu
8e6KwvsRPT83n66esy2VxsjPSUf/A+PW/8vPNV19IbD2TB8j/7Z4XS/hsncb
ouffjMRePPkr14fo+bd+5g4TBSO8nv7Lv8nZ6pp/CaEhQ1OhYp5UFlgU72vr
g/dzOp+s6Po5JwoJBp/MtB9/9tiYwuCT/e+PF3o+7mfwydi3MtY65zoZvNG0
TeBQxIcWQOeNTno2O6de9wA6b2zsfLLqsdkQoPPGHm5y+ZQ0DYSllAWHkARg
q/NHH0vsT+n5PAn9F9I+zwlAz+dZG5tLrdWnAno+775BQu8htUFAz+f9Pthi
yaPfDej5unB/0unHv7sY+bqWHN/C+aQBRr5uddVJPs3tVKQYwTIaHicK4c2d
lw4HE+j21+JA/S1iUNtEhPtNO8HgoTLtSl1neGiIzkN1Tcuu6zsNIToPrTDn
/bx3Qy8jr5fafmOT+9sbiM4zO6/37v0V3QOgKiXhm3EbSBU3X9s0Nwh+/PMf
yjHtBoaBO716B6ngnwzPvjHLfvDQ4Sw1s5IAN74EjeQEDgOukmxqdyQBamWF
47N/Y18gYxgQBqmAngesCEwW0JEdZOT3/t1RHFDs7EIhKfIKyfJMEORnHXsz
M4DqHrXfOSHPDKXk2YbWrqciF+Jf3LmtLJCqpE8O8ifQMw3yo42qrNB5Ubn4
XQf2j0JPdxjtZYM73YqqXHD/6Tx2WEE3sl1qiMFLFR5vfyf8rR8s6B1vtfPh
gzpq30ce3KYA/ppNs7d9+GHhrNr6SnWsnyNaQ0sBArBFhcmjD/vVHdf3/3xz
SBB2aplRu6L/lze0SH53n+nuMKDnAe0nLp9SaetFapMVtKhOEcjxdveawe3D
iJe41XX8gijs+2q70SqOhpj8Lx+NHBSF3sF2w1+x3/04x5YYelkMfp+cyN2t
gftzTKPbeVQMsk7OrXd2pTD4boGWtOkixwAjb8hJxHxkd7Bl5A23yI1TrQMi
GHzWYL1KROPrDgafFRZWiNCr62Pw2ayDSyVskcMg3hUM+Hb2gLg1Ub3XOmiA
87L/Uc3uAZCv/beUhP0cPb+4YK0cNjtPY+QXv054Dqxv/V9+se2DFeBd18/I
Hxq0ZKYuhP9D9PyhjLYhPGbVi+j5w0Ned+cnS4YQPX9oUmJDs9KhIS3JgLr9
wSyQv7mx6BAV18v/8eNVmRFLte4Egx/Hf0hLDyinMPix9bq9ab7bBhj82PmQ
o+UR/S4GD06V/qnI19AE6Dx4QtevorSwG9B5MLHn55H3GYOAzoOJC9IOGwqp
4GyP0x3Pfn6YNV30UzCHYOQjlWpnIXcqAej5SO8mFw+dOLwf/5ePfHv/Snl0
wyCg5yNLfqV8sRTsAfR8Y9m9A0drlzsZ+UZlthMb3Jb7GfnGsyc4YDCioBm7
86/bQkXhfUe/53nnCXS1Jc1AXUoM/jzO9uPYOMHg1cd/hIa7n6IhOq+2AVsv
bZsaQnRezVJax9FN62XkJTP1yyKOpHkiOm8mHi2/GWrvBm7Bnu4c5q3A+KI/
7wX7QZBgrmZZVt6F68HcjWu8qYDjpehZwdY+IPmFlIsSCDDvNBumRRoGJ5wl
+qR+4vrl8DbTnIMEaG3Ltlr4TAX0POaOK8/2b/w+yMhPmro2mPExd6HgzZa5
JDYmeFb30apfhgNINkc5b5KdGQ4nDjb2ZlIQeVqH35KfBRIj34VPnMJ6txgQ
YivMCveKNPsMjuH6Ok7uYvtqNvjW2ca/256G6Lw8pVU+OTxliMGzzS2E9i6O
9wHZvvKZ+LN88FGElMXPpWFwZ2taHs95fsj8gvjoNUcDenIddT2XBWDWs7bY
Ljz/dYgoocRdgjBT5mvB0eH/5T017hw6fWphGNDzmJp7IlatXduLWn5RmVyq
RaDgP+bDXOFDaGttrar7cVFYLk5O6j1OQ7+O1s21N4nCSSTwZmiYQKEbJ8/7
2IjBQi2l23zOBIo+rTrm2SkG70QOHC7pojD4u7l+2r+DnwcYec/K4jt6BW8d
UNChW1odPzrB1JPioIwoCjj+QOGTYXsvqFwfKnDHnADMtKKZnVODYCeP3nrm
SQKs/XQpMncXDRRuyT3UcYYG0jdWQuUSJmjR+FKvsnIYmXMI/N1XzgwfGuew
m3XRkNXTgLSaWhZ4Q/0xtR3Xf83/jKqZm1nh1iPVXoZMBDpNrTyycRM/7FW/
c+X+JRqov78h7tsWAZh7Y5T17QiuP9tPxTZJCcIOSEpUPYX3i7cP6r9piMLp
ZbmxzHdUdLolTP/UD1GYVHMoTfU7gXzu/W2y1hKD/4K6VUsLCNTuoST4Jl8M
LjM/f9+SSEUldtSbyc3dYODngoqWHg2kfGJaW9fcD5SsPu/u6iXAxLDSPrCK
Anbnf9v03I0AVf3uB9xMWeDwgXtRbZkEenc58DrNlBU+lxU5fvUngQquT7Dn
nGGDkcwdgwaxVBR25d22kWh++P7rl87ACwRIR2+WJVIFcP1daVU/RADl5V6P
hycF4d32nNWtx2lggHt9wG4PUXjjAuvCwXE8/yq4v9jOYqeibSaWisfra6XI
1Ne7YnBntYaEzySNkV9FZgWtLxyMGfnVzQeWmO2xjtP5f4/mNOTa0sHg/8kN
p8aKbvUx+P8VnovZl04OA5hQNCMe1QOo7z6qb8ulgYNH9sW5h+P6eFGKs2Se
YORhBwLevf+wimDkYUOybl3aIUVh5GGdbC79eXa3n5Fn7d5wfi46tgXR86xx
FvE+J6d7ED3PevNykOnl+0OInmf9fuNi0qIIDaUuGFudfsgC9zzlWfe9m0D0
8wmRG+Ojy/wIxvkEkcs7vwezURnnE2xkKLutHwwwziekmWf96snsYpw3uMd5
iNUajwP9vMEBIpbKY9EN6OcNSnYaPb99bhDQzxt8C0gT5gmmglLP3KuX6/lh
VcTuosdxBCNvO9xmPWxZRAB63lYzQHpZuZEK6Hnbpzx3AiI2DAF63vYO+wH3
bW49gJ6XjahK4jEM6WTkZanrx0P9P/Qz8rIBvNz28AEFtRVJOi0FisISg9bR
cCMCEaNKm+KFxKCN50JMOd7/6echrt4tNk3woSH6eQj2d401OTuGEf08xFS8
aEW/cR8jf9vU9C1ud4EXop9nSJz+bit9qxvwFhedTGr8B2ZvPz1zTmIQfBL2
Ef7t0wXWrC0cCD1CBaHVoVcjwvrA4eZVQQ2hBNA6/GXiVtEQmPy+h+nAXwJ4
nMmL1mYnwNH5q/EvW6iAnu8dZlr7RY91iJHHtZZ9cI/0ohNtLBsWvNi3DNzm
KH8sJ/rRTwvzjn1TTPDOotm5r3cpqHtuEhxbZIZ9u9Up5/YRaKLDZPVtVla4
WkaaZxXu/+iUE1ssHxsU9Nf79+cFDdHPY0SZjcapLw4xzkscPlSgfTWoDySr
P/SpPsoHddUfPbyVPQwyT936aGrBD82Otz3gaqaBuO/byhtsBKBErXr0Dazf
B7eYZnzfLgjFetLblHkIRn643k+pU2gHBdDzvUFaCt7yBT1IWXPpcX2JCLR9
ZsqTYjyEdIrv/GMzFoU3j0k1LirS0Lc0n6rlP6Kw8ZL6d7kuAonuubR/4ZgY
PBjxrfatD+5ff9LsgyYxOPwgenWxxP/Od8TU/1mlhf0t/bxG4fZ6tsg0J/SM
s3Ki170TPHzjK89pTwHU3MT0lohecMUXPWvZjfefqutHbiYNgoDkvr2zcwQ4
mb0wvmeaCg6Frm2XeE4DVgUTtp4ZTHCReyf1t98w2shdwLHnOzNc7Wv+JCSH
huqcTbSJQhaYPx31WGUJ1w+bQy+Ul7LCb+pCwSZyeP9ZFazqLMEPwz6eu/VJ
lwZ2Sd+I+CAlAI27/WRk+glgLS1g1EMWhPt6zrCYXyfAk+cqd4CyKLy9QLB5
OVCRnraxzJ1kUWjldnYpLYZALK8Pp9eqikGLflqiaQ2BlJm/iEd+F4PWfxqF
nrdRUd4asD0zpBvoN6Z7yEpivery3n7mbT94KbJxvqSZABoVHW+8GobBjHZc
bssTAkQMb77ptJcFyqX9udQQTSCRo6bL3PtYYf6SV+yDOgLZF4EIb1M2mG8Y
1jPWTEX1UXaimiH8MMlXlPbemABSx4cneD4IwL3vd6beHSeA6u6Xsi9MBWGz
mPcdk7s0MLfwe2e5qyiM2ycm2fubhqSUc+7cHcXfL5ed7+dFAm3ueVaz/oYY
DLPqNF4Q+18eeuS6Xsnhd8eRmMaPhlnZXtAZXrrxLxMBfvq1LkxvHARsnXcL
Vn7/LlL/Y7jpIwt85rwQ3zNBoMKCre8sP7HCSuGFG/93fspQ+snjGX74oum3
iAWupxyCLr2ZZRGEooq73ha8x/Ulc1pRbhT2C1U5yvNeBJop0r6M1orB/Uom
xqFDBHI94X/03qp+wC6d2J6WS4Afz/QOLB4eBob3pNd8xP507/iLf7ZrWGD8
N34h4ZsEYpOq4d+/jhXOae4jcvH79ZiJf0Xu/FDgeOja/1fGlcdD2fVvZpRK
GemZSSVRtiRpVw+dky1rqUh5CpEWpBRKKErRJskSCVGRfSkVcYsWhSwh+25W
5thlf4/f553p93neP89nnHvu+9znfL/XNa7roi1DoMM/oLXfmwI7jnfsEMb8
n94vo1DQToUXiuZ5fcJ4c9Vir7tip2jQOu2zouZBRHza8yIkT4oO7kpxurae
Q6BgkXjs+E42yHVsGM3pwfU2vnJ9dicJLjINcQ7D/fACu/p1njoFxqcfvF89
ioCnO8cVFFJh9mTW9c/FiBBxODbF0KbBWKiTMZ6OCCkHj8U6y5mAXW0pIIwQ
yBTx6Jmx7gGuGVE9Y+YITHYWUS/bkqBl0wfz+G+IkL1XhSptyFDvR2HGuWxE
nNCuNX71RhRWpEV5RXkjcEBBb4H8Zwo8qr5xMbMVARP7w3VQkAZbzYJcf8z8
8XdrPPO2jDsD+f5uOtSlf8J9mqePsdEdJLwYrXx9jIhQ0XnSPjpfH0MpvVbA
3MYBCwyFfayud4F/6PEeR5K54AwRaUbzZAKbAUtlvTHE94uHBO2XXauM+H5x
0Y1Ld67C9YnnFy89u0skJZXB93tvcOsj5Srj/vxfv7fjpFPA/k9dBM/v3VtE
TxW3YhM8v3drRs1DnynMp7mqMec8SVCDLRmxuQURPP2O5Z5jR1jhiK/fecss
VaqW7uXrdwoDAwfeJTH5+p3hIeeCDX0dfD2ObM57a2f3OsDT45w0P31UQboT
8PQ4cT9M5DU1WICnx6l75N9Q6dELxvVOIWaZKFz4u+OkUwzi+9GtDpqrFpfg
/fRfP3pzyyVpD24v4PnR5U5VLjtrzAY8Pzo76bnsC4yDeH7y5JbX66SPt/P9
5G2rhv0mXBh8P7lLd1+i+YkeomJ4wEz0ARWWy7yZNt+NCOWpM7STi2hQ1UHp
jtIk4uuFeomKnqBwLsHTC4keKbA6fYRD8PRCLavblE196Hx/+ooWFe+M4msE
T+/T9sX+6y69TnC4mVk6N6IJfB33OW3azwRrBlJR5YkO4P67RFZ8C+abTs2T
dC86UGhtpr4KxPU3b07Milg2SDDcmyXQhEAo16/cq5MLNlxp1H4y2At4/ncT
P4lwQoHN96tnPE+RCzBrJ+R95zaG1swAccml33y/MggJOfs+e64A/L67ktlr
20OUepYfrhoShP0v1OzCtyAivWqjzd0JElxutE3+8gQiNJ+K7184Rwjm91zp
GIrjEjy9Un9pX76RDIevJ5qU4Rg+sqEDj2brMhvDRXAJS33p0wgOML1kSXPb
Jwr3mCY9XP6NC5puNmjvP0SBv7qlw8/g+mLwbe0CQkUMDk07bj+xHPH99QIH
0g8amPUAnv89jZVmnPywi6hzvPXjdtFfsOG2QMz+tWzCML9GtdSQCucd0P8L
0rhEHN3qHeUHFSrTxOtvNCHigP6rTW/30+DSrxpBIkGIWLHO2cuvBuOvZEoD
bfMf/ZMA5eQ8hVUsvr/e6XvF24BCJ2I+fbiCadoO1GyDXZx0esC7owO71nh3
gxGi727legRsd1WOSzxggeAqCmPpFAJuez6tvFbTCy7eOeTMiuGCtAfznOPS
BCDpoio7w4lDiN17sio3XRCu/anZdDKRSwRab/SZyiXB3MqGBRF4v/0oB9kq
BWRYmfBLcFIVEdu2XHrxUEwU+l0xHJi3kQscGdLLV4pT4IerX3N92xGwfk+P
YYmKQcncXsfk6wgE37r5c64SFcbl1/14YtxL7HBaK/wglQrfu49P74pCBIy7
/TxgAw1+ijzkvKseEWbaDk/i3tCg4cm/JzYP9xIa06dEc106gdjIRPoXQS4Q
9y7OSfRgAP+DlYLXqhEwV9+pI/WGA8IfuecphiLgf5YcxFLD+GLZtzLPJ4io
0N6ktexvMlyrNTK/vAER2fbdHJa+EKxyrN9yabCXuJCj42cRIArf2b1mX9RC
wEg2+NzNCAoMa763cXIE9/96x4vBe8VgVk1yzqFHXEAekQt4eJYKcyLXLbPD
eGaRVeiZwF4qjBB+qsbG+/MkKi5ovUiD484lczrl/+QFmFrahClnHyXafk5a
7RbsBuFeA6YdfVxAn96WEDaHBZ5Lf4kpw/3ZWyEjcFskCWYsGXt7qB/jizO1
TOIpGVat17gyfQYRmyQ+CZH7ROGthyVLPT8jUGNzp25qigL33VCUlEtCYM6m
gNQfUVQokJVYHXERv68K92NXpGiQ/DO+BCJEqI9WNRZP0oFv0CkZ92wEGiaj
ByLXcYDJKpHPCXkIKLmeGW6mkWCQb85WL0dEFIhkHjiwggz3KslvW4Lnd0hU
7WU64fMzz/7Q3AUI/GW23cLhMgVmfgyM0sD3X7d6QqyimQo1desuUPtwPZd8
715ig/FX7mozZI2IgG7Gyjkz3aD16ICihC0CbV4OxhESbBDjcvSrQj8+b+EZ
zp8aSdC6cKpkHPe/59leG7ZvoUCBI07HvIcQcEr8ZLUvnwr1K38r7vyICD23
cE4sxOstQC1YO6svnJcffm+cAcDTTeZZmB//9KgOi97VAz5n5Qjes0Og2+6p
yrAFCZquEGy/g+e3eWVubrPAz1cXEpOej/HP0fdEaYoojLa762zmioDvYJ9v
9AcKTA4RT4zHfF7zycZCkykqfJYZZjSrn+HpySbuD4Qff6pHKLaypmsLmEBk
97Zdmfj8/V7gLHHwHgmeIgV1FDAREZpOHR9uEYWdpIk9VIyHMun9O/qoNBig
Ujpv1j8i2XxAv4nOBhWVuv+MY/ylhpwbnETIUFRbvWo3/vxyr/8+y1MUaDev
xWxWr5Lvm9KFaqgwfbR2RouBiNWWUs/rf7LA5MuqSd3fCEh4OY+1lZAg5dWz
Wt1ZPLGvXFZpDQWmvX8QJIvxkOnCS5vPZVMhJga6mRjffLq3uFhCjQaHXU53
13xHxFVtrcQVuQygmp1R8KgNgewzJtZInwTlO3yKYtMQcfj4hdxJAzI8vfnp
+5wyvP53Na8EJVHgS1i32AXjI8WpzpDzw1RodJvzswfj/RdSvvsPG7DANROF
9bP+13na/fOWJ5NgyMvmoKFRROS8F/QRUqDBfItNx2y68ftVHPi+dR0Z3i/W
LurB4/QP3Scu36bAiItm3mASgcECPY30bipUO33k1Shen+in70YsjrGBwar1
33MwX1DM7mfFc0hQp/xX6xv8/VBKeae2DgXOaF33DcP8xbRM7fbUDiYYPKss
3zyAgPQ/0Q+Syygwq1Y3Oawe97sd17iqc2hQ3kswSGbmT/6DgVzkmu8Oqvz8
h3KD1ZLLHp3j6+G8A97cEkpv5evhjF7PF/NRo/P1cBU3vyj9luUAFK6ocwPz
+JSEOydgHBdcuaS/jm7PBNMha+xm8yd4eRK0ig2Mt5sRP09iukUwnaXbw8+T
WPlbuTj4M4OfB5FYuCE8lNtA8PIgUiIEAhITuwheHoTBzH3tXcZsgpcHcbeo
80Fgfy+xlyFd6HaZBPXu1afvbkQET6/nZKVnqhmN+Hq9JG9pxSKVXr5ez3hR
W3chweTr9RTctja+Funk6+8Yey1cfu2qAzz9XapX1tgjoU7A09+p1yocv6LI
Ajz9nSu94fqdc71gSVpu8otvovBLUlO10hPEz6vw1wqX2VeOAC+vIqPS94bb
WC/g5VUsf1aWE2/NBry8iiEly8aCnC7Ay5soiRbxP6/b/idvYilJ3/8Yg583
AcSja7NMewiDgFYD2n0q/CtFSNxvJyJKSP73tURo8FBuV8UazMd4+sB9c1MU
62K5BE8feCqNcTP0DIfg6QPnXjbxOhFO5+dX6Df+vWFEzpvg6fuEjqgEZ6l0
gqus8ZsZV5pA8Knk6/HNGJcfLzr282AHCLdP3icpj3l23nTBAic66FC+utf2
Lq6HrpmunEA28KsxOS2P+YPsa4eup1VcUPalV8pxphfw8jFGP9etqt3B5udZ
CDdfDMhUaydeti8pUC6bAes/GhX2pzOIQhGXy1fZAtCPK/fqhFkPUaCh3h3Y
JwjdlWqeTSnj+l0i4xs0SoJtTlHdbhgfOJy3u5QvIAQ/3XDcUpnCJXj6RM0x
QabSZg5fPxiuo7hsUp8OrDeW963bswg+953Xfu02B6wmm5T7GYpCy9pLk24F
XDDMUSGJHqDAwJdbgpJw/TR6HJL1UVkMrpooy62QQfz8jXaQoZhv2wN4+Ria
kToG+927iBS/7+dtP/4FT+tO37pIZRMVOQKNafpU6LTdk5m6gEtIXjNKWVpK
hUJ9SqG3MN7o3/v1VfA+GmQQK6/dD0NEaqkJuP2TBg/KXMUo74/ekexS/eDy
JhY/f6PAw2TO3G/nCD2zBYCt1Q7Gj8b/fWFrD3iatIS853w3EBq9+ShKHgGX
Ea8KphcLcNqvNyD8PEKLEjZFf+oFMNbjRVQiFxx2Ex/LThKAAx4MPQ9LDiFk
PC/ZPVkQLq7L4UbEcAmnIzJxQu9I0DY0aTwa44vR2KCmtlwyPE8/vPiJGubP
Bact4xaKQq/quWcD5LnA19j1V/0iCgyf37/jegsCx/0PGPQsFIOjh9xaFP1x
P7iR7sVWoEL/qMG3Y6CXyJxLmwxNpkJTNeFbZphvtSTEr3BcT4Ojwa+6vDBe
ZXYbHHuRRYONEw+qLQS4hOdZT88Ptp1A/deiafpwLxj9wbr6w4EB7hpbha+r
ROD0EH05N44DwighQY/xefVUOS+VsIUERRPPVywLxeursdpOejsZphyqfvq5
GRGtGmrikTpC0PbdY6ubM70E1N0OHe+Iws9pYZFp6gjY3WEqa4ZSYFmTjtcN
3M+2J9RJhhmJwbkBmWNJkVzgP2Ci5upAhbRErff9WVzi1uh1y8ccKrQy3bC4
aRwRc4bp2/OcadD7sa78M5U/eSIebbZDK4osiS+rpWTt+ruAw2CjUS6TC0ay
O71ODTHBUK/DuquzebrSzzI1HpNg98/DXtYY/2ior6VcCCdDU1rlOY/ziDC8
KlFIcEShwcTFS4c/YvwjYLOOPE6BhysOHo1PQ+Dq9ytxtZFUuD2CxflwFhE1
NWHV5pI0qB2Y6noM4zsZ3aHonh46kNfUJClnYr752qjYcTkH5GenKA7h60lt
q/WJFCdB3046a9IOEVFCsS5HlpKhbqWWlCien/68SHjcXhS2Szxz209CYH3u
3aWKLhToRtHcFzvrf89lzKlrpEL2F3SVwkXEhMyvvgRrGtyz+apx4ClEXNwy
v0MRdYPdBt1CjUcR6NsqscZemA187pp0yw/i+w969qjkFwm2ynetmfWn50lW
9QxuoEDhNb+qo3G/ZGpmmJp/oMLBYHcT3TxEMDze2njvokGBs22UuxhP/TBv
PZbOZgCZ3aFuFkzczzb7nD23vge0vPieLeWI8af8gtysQyRYlWT6bnZ+vlus
GeMQGRarbpWLLcTzGYmXW16Jwhsv9c1vnEPg6REdzaPvMN6l5cnsx9f7sFnq
7eEJKvwsJbGZ9f/yUer9fVLhWyNCLSy0+mUaE8SfyVlajvFCLfn4Tgt/EjzQ
rZ1nNJsHQ7N/m9kgCrMeLPE9jt+XSQ8lo2wJDWb6alBO/Mb8O2RGKrmGDSTD
huZn4f1NYx6fdBUmQ1ZxbkY+xisPDzYvXGFLgcdSlV59w+u9fWVE/ehPKny4
VGB/YRfG67QS91eFLBDRFBuUOYbAiOvxFcyvJNgglDzyHeMRmTdrOuhSFLhD
Qm40k4VA2XNbxUuvqVCvK9VDKxkRtkEbwMhWGrSY+nDm5Q88fnTCCSQxQGFF
8828ZgQSlfJ6UnRIUCj0m1B5Isb7FjbN5D1kuKliebtKJSIEB0K374unwDe1
j27dw/j6WUjFncuDVJhdJZw2mx+YXauqoLiDBUQ6Xzm14Punq7crySSQ4Ift
Lcc9MZ46Qqz63S5Lg7QiY18xjF/lZTp61BXI0KuiMNgOj7+t3rl66018Pit1
/Lbi+uZ4ZOumd51U+Lg0/8HZYbw/zexKlYzYQKb4lKExxuNz09pF0hgkeEPL
9dys//eIr/eowG4KPERqUJ39/WmHpIWxjBITrDRI/SSI73fHx0GjM98o0Cne
Z6SyCb+/SodONTINJuao3/Sb+ZMP4zBy56J/tBpxWLjvmu59Juh9578oYtZP
PmoY7U+hQSOP85ULcf2sqt8NfWdIcKhAsPkIrg9Fq275BVtQYMDlfwzIs+fl
lqycfgwLVCjIzZ/NM8g8tdtqhCDBE19WBbrgfr85H2QWR1GgScjDxybDmN9+
eeXij/B6Nr6wrsf9sFb3TtVXGgtor/FXnPUbxqp8dNoQQ4LV5t8vrB/E54/b
EZnqSYF+U+phr6cRsLojKlncSoXOWj8vTOLzXPE5/9L3tWzQHPW2lIzxc2HM
x315rSR4z7yuuw4/712TtReuqFHgEquQJ+qYn5JzImtOL2CCQpJqYw/G899I
OmV6M1ToE5Bng/kBIaGgsVa4ignYVv7u5/H3LWn/WSguQcP9xD50LX4/Vn5b
gp45UCAhu/L//CHiL51/zO9mAbuEZdez8fV3+vr8qi/HfPTD/LVxs/8/PDEa
c3qUCh/cvjZihcfBJ395+P/DAoe5e6ZV8XwlQ0GGeDoJyhX5aRiPISLs0MP4
3PsUWJKmKC83gcAVxaN6CQwq3PncotgGny+DPMHiGESC5Py/i6h4Pyq8++Xp
p0+Bz2PLbxXiv++KCRpTFKbBWAetyEj8OU/fy9n6PmrpeWni+ArS4scf20CD
1dl/tmZzwL/Hlz22WHStHgMCB74UJAwrEv8ek3Z6Car0C0F7w4GBx685/zOG
b3Q4tvXiUEDbjlFkJfY/48TYv+4brmaB7XS37NrHdPDv8YUFh7+es6fA6B3S
V8yD6cS/x/8BRXBYYg==
   "], {{{}, {}, {}, {}, {}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1, 330, 243, 171, 116, 76, 52, 2, 3, 4, 5, 6, 7, 1579, 
         1578, 439, 438, 488, 510, 1570, 548, 602, 674, 764, 437, 487, 509, 
         547, 601, 673, 763, 436, 530, 568, 622, 694, 784, 486, 508, 546, 600,
          672, 762, 435, 529, 567, 621, 693, 783, 485, 583, 637, 709, 799, 
         507, 545, 599, 671, 761, 434, 591, 645, 717, 807, 528, 657, 729, 819,
          566, 620, 692, 782, 484, 662, 734, 824, 582, 747, 837, 636, 708, 
         798, 506, 752, 842, 652, 855, 724, 814, 544, 860, 742, 832, 598, 850,
          670, 760, 433}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt1FlsVAUUBuApKJQ9QRDZhCItRVqgZTEiQWhLaYE2KovKIlASlbWCiSwG
VEB2Qgkga8MWUyGmgj64IPsbi1BAWWRpFUiAiFER5Um/E334+v/ndO6dmTtz
J6Wk9KXptRKJRBKz/cmok0i010fq/8gveZ9X6E8KLyf9d8BX4gNeZQCT7Jpy
XF/LFDrEsXZJfK0vYBQ5TLZ7jBP6OqbyVJzPrhbf6AsZTW6cz64ZJ/X1TKNj
nM+uNvv1RYzhHXM7LujbyYvzm5tzSv+IpXoWt/XpzNPTuKZXkBrPbX6Eb/UP
4/x6Jjf1sczS23NR3yD7s0NfKXvxi14u8xkYr1k+zi6+i/ch+7GHDeZlMpsK
7pi3yDwqKTXPl534mOvmTTKHT/nEXCafZTe/mbfJgnhfcV3koxyIz0f2ZXG8
L9mVW/pr/38PUrik72SV3pt7en5cK70Fp/WNLNd7cFd/i/f0dKr13XSKa2Wu
w0F9CeOYY+7AZX0Xgyg1P8GZeG/MID1el11dDsXnxngK4vnsWlKlb2YmneP8
dskcjmvKBAp5Oo61r8eReO2UMJguZJBJV7rRnSyy4xyOqc9RfQUTGRKv0a4V
Z+Pz4u24Z8ydqdH3sEbvw+/xfZSF7I3rZv5ZTqydSPzlRnxRlsvR8qZ8Xo6Q
4+WvslCukCPlOZkp28n7FOvr5VWe0QfKO+Tp78pjtNUfer5Neg3PmYvlIk6S
Zm4iy7hItrmXnMIXNDL/5PgS+cD8gtwqR8kbsp8cLsfJe7JALpcj5FmZIZ+U
f1Ckr5NX6K3nydvk6nPlUdrof3u+jXo1fcxFciEnSDU3lqu5QJa5p5zM5zQ0
1zh+mL6MKrrYtY3nYQ5HaB3X3+OG6gs4Tke7RrIHk9hHA7tqj2uj5zCbw7SK
62HfMK4Zb7KX+vbX7VvrA5jFIVra/2nfIF4zb/AZ9eyv2d+P75q5O69TSbL/
XbW/wo9x38Q9Gr898TvHD/Gd8/v9vTzPufhOxr0R91P8bvnfvycfsak=
         "],
         VertexColors->None]}]}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV02mQjwUcB/D/7rLI3Z4UJW3H7ooX5FhrqZGKsodS0712u15EWB3knMGM
bFlUI9VUbArdyd2BPXLOFC9S0wzNkFaOQpTj83vx8f3+fs/z/z//5/Fst/Kx
pc8kJxKJJBb7Jzc1kVgr17GeDWxkEzmObZbf8C3f8T1b2Mp5X/Q+D5DDRbs/
2MYF8zIe5Lq4YKTvO+JYx5RE4mvzWPqTRp39Rbmch7ieJP60v9z5a/VxDCCd
+rgB+1r9YW4gmavt6uRUbqfJeWl26/RnKSCDBvsk+w/0R7iRFLrZ1ctp3MFR
56XbrdfHM5De5p9lDZlxbfMuOZviOMd8QC6h0eeTzSv0RxmiH5K59NT3yvkM
10/IZlyjN8hRcrq8TTbFfco745nJ3+T98nU5Up6Sj8m/XC9DbjCXyQnyFnk4
nqsslH3kfnmfXChHyJMyK56DvlvOYZh+VJZQqB+Ub/KDa6SYP4xrkkcv8z5Z
TXO6mxvljLg3jvlMpt1GfSKDyI7nYLdHzqWU7c5rZveRXk4+qRy3z7LfpFdR
RCd22De3X6mPoQctOGGfbb9Zn8RgOrPTPtV+lV7BTbTkpP0uWji22lwZ/z+0
4m/73fTw/uZzlVevK124kivoTCeyySKTDNJJo4jRTGMNF7gn3m05iHuZylec
Z1T8ncjCOI+X+JL/KXOsg3yaGhrpaPckA+OzTOEL/qPUvr18igU00MHuCQr0
d9gX92Suokz/nXx9FpP1zzlHibmdPE4//RVq9V/J0afE79AP00ufw6txH3IR
9fp78Xt4nAHmT+RQltJkXiF7M4+3zStlEa+x17xMdmEipebV8laWcNBcK/OY
yYvmAlnDZ/q78qwslm3lsLgGx/S+sprl+hD5Br/o18YziOelH6KnPjvuXa+j
nV5Jf/0tfor3wjyBEv0AufoMXtA/5V9GmtvE/bCf7vF747no1WyjrbmCfvpS
foz3zTyeYv35eH6c4W671rKS+Wyljd0Y+sb1eI6POc1d9pfJCl5mC63tyrk5
vo9J8Xw5xQj7VrJPfJYqVvEPwx1rKfP8fVwCwRm7RQ==
        "],
        VertexColors->None]]}, {}, {}, {}, {}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1570, 510, 488, 438, 439, 440, 441, 442, 443, 444, 445, 
         1573, 1572, 880, 879, 878, 927, 963, 1027, 1119, 1241, 1394, 877, 
         997, 1061, 1153, 1275, 1428, 926, 962, 1026, 1118, 1240, 1393, 876, 
         996, 1060, 1152, 1274, 1427, 925, 1086, 1178, 1300, 1453, 961, 1025, 
         1117, 1239, 1392, 875, 1226, 1348, 1501, 1100, 1192, 1314, 1467, 995,
          1212, 1334, 1487, 1059, 1359, 1512, 1151, 1273, 1426, 924, 1379, 
         1532, 1220, 1551, 1342, 1495, 1085, 1559, 1363, 1516, 1177, 1543, 
         1299, 1452, 960, 1562, 1373, 1526, 1204, 1547, 1326, 1479, 1024, 
         1556, 1355, 1508, 1116, 1539, 1238, 1391, 874, 1382, 1535, 1225, 
         1554, 1347, 1500, 1099, 1368, 1521, 1191, 1313, 1466, 994, 1211, 
         1333, 1486, 1058, 1150, 1272, 1425, 923, 1219, 1341, 1494, 1084, 
         1176, 1298, 1451, 959, 1203, 1325, 1478, 1023, 1115, 1237, 1390, 873,
          1098, 1190, 1312, 1465, 993, 1057, 1149, 1271, 1424, 922, 1083, 
         1175, 1297, 1450, 958, 1571}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwV1FlQlXUYBvDDdtAxU1YVmylrhqVQ1MkLLAu10sxGoZypaay0HDVNRK2Z
QFnUlBa80ItmckEvNBfUFmdcKqkbFJFFwGbUCxMXFARF66aL6ve/+PG87/P/
DmfO9o1ZWFy0IjYSicRQ4k9mNBLpkUlxkchxB8Xkk0KD/j+5l/lkEUOvPtn1
J8wrmUwqZ8I/1e8zv0s2sTyha5DlzOSu61J0J80lPEcaZ/Ux+u/M75FDHGN0
Z2QFr9LnulTdKfMqnudZ+2W5lfTw3PYWuYm54Rp7l/yWRo+Pte83v89Uc7d8
mjzzRVnDa+YBGc+T5rPyTVkpX5F3w+uUs8J7Jq/Kt+U3co78Wy6Q/Z4vTf5s
f0OultPk7fC+yilykrwi35Lb5Gz5QI4I74O5VW5mhrlPFjLFfF1u55zniLMf
CM/JM4y3/yG3kMBT9kZZFV4b9zwmXfeLeQ0vMDK8D7o2WU0RTa6L1x00LySX
KPf1I/S/mj/hRUZxXp+gP2T+gLEkMqAfqT9t/pQCMmjWR/V15g8ZxyAe6FtI
dHbYvih8Pgzmob6VNi7QTgedXCTH9zqbao/dzA/hcyUt3neOXjYm+H7ovqeT
VN1Ketjg7PPwGTDRvoVBuj0c1XWQoivmDuv1G3VF5iNk239nQDfBXkOifTdH
dC/b9zDafoz28HuyTzQ3kWxewW2q7BucL5YRr6lFN9N8jULzO/IvDpsHO88y
/8Z9j3nMvsD8T+icD7VPNncw3p5uLzT38LU9ao+aa8P/8/jH7YvM/9LgPMle
YL7ES/Z5sj+8LnOG/IkL4V5in2A+R5L5dXmLj83dVJrXu67ZPMP8J3PNdWSa
67nnvN6eH94f8sxfkWDeRZ3z6fZaRtl/pE033L6cW1ToqsJvkHH2L4nX7eRQ
+F0xTLeMm5TrK8NvjLH2L4jT7eBguKfwqO4jbrBOXxF+d+G1MFS3lOusdVau
W8daysI9h/M84nwJXZS5rjTc92hiiG4x1yh19lm415BrryZWt519uiyfx/9E
FLbo
         "],
         VertexColors->None]}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{868, 1386, 1233, 1111, 1019, 955, 919, 869, 870, 1387, 
         1234, 1112, 1020, 956, 920, 1422, 1269, 1147, 1055, 991, 871, 1388, 
         1235, 1113, 1021, 957, 921, 1423, 1270, 1148, 1056, 992, 872, 1389, 
         1236, 1114, 1022, 1571, 1570, 548, 602, 674, 764, 437, 487, 509, 547,
          601, 673, 763, 436, 530, 568, 622, 694, 784, 486, 508, 546, 600, 
         672, 762, 435, 529, 567, 621, 693, 783, 485, 583, 637, 709, 799, 507,
          545, 599, 671, 761, 434, 591, 645, 717, 807, 528, 657, 729, 819, 
         566, 620, 692, 782, 484, 662, 734, 824, 582, 747, 837, 636, 708, 798,
          506, 752, 842, 652, 855, 724, 814, 544, 860, 742, 832, 598, 850, 
         670, 760, 433}},
         VertexColors->None], 
        PolygonBox[{{1572, 881, 882, 1395, 1242, 1120, 1028, 964, 928, 1429, 
         1276, 1154, 1062, 998, 883, 1396, 1243, 1121, 1029, 965, 929, 1430, 
         1277, 1155, 1063, 999, 884, 1397, 1244, 1122, 1030, 966, 1454, 1301, 
         1179, 1087, 930, 1431, 1278, 1156, 1064, 1000, 885, 1398, 1245, 1123,
          1031, 967, 1455, 1302, 1180, 1088, 931, 1432, 1279, 1157, 1065, 
         1488, 1335, 1213, 1001, 1468, 1315, 1193, 1522, 1369, 1101, 1502, 
         1349, 1227, 886, 1399, 1246, 1124, 1509, 1356, 1032, 1480, 1327, 
         1548, 1205, 1527, 1374, 1563, 968, 1456, 1303, 1544, 1181, 1517, 
         1364, 1560, 1089, 1496, 1343, 1552, 1221, 1533, 1380, 1566, 932, 
         1433, 1280, 1541, 1158, 1513, 1360, 1066, 1489, 1336, 1214, 1529, 
         1376, 1002, 1469, 1316, 1194, 1523, 1370, 1102, 1503, 1350, 1228, 
         887, 1400, 1247, 1125, 1033, 1481, 1328, 1206, 969, 1457, 1304, 1182,
          1090, 933, 1434, 1281, 1159, 1067, 1003, 1470, 1317, 1195, 1103, 
         888, 1401, 1248, 1126, 1034, 970, 1575, 1574, 512, 550, 604, 676, 
         766, 453, 489, 511, 549, 603, 675, 765, 452, 451, 450, 449, 448, 447,
          446, 1573}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwV01dsTXEAx/Fjhg4kYlQHEsRM0NpCbBUao60ECanETEjs8WbXas2Q8GJ7
MWp7QRFixNaq1hYxi9Z+8fk/fPv9/X73nHvPPT23ec7s0bOqRlFUBZn+tK4Z
RbnVomgt1mFljSj6VD2K5qAhHtsKsMdeG3m2VFTY1mOV7bM+F41QZDuBvfYY
5NvSUGnbgNW2L/o8NEax7ZQtCXv0wThp26fHYpPeBT9shXobHNXHYKNtjV4u
z0cCbumpOCc/8fppORl79XLOxhC5hPvhmnzKcfvlOGzWP/JodJUfci/UcZ8u
6f/knPCe+k/nXZbbhu+qHwvXKU9Agp6pv5LTUV+/o1fhaXozznN+rvzVXl1f
wO/0DDTQm+i35TScl3/zRJQ47wynYJ/9K4/FUPkp98d1+bTjDsjx2KJ3wyO5
NwrlX16/IrfDcT0L+eFZ0L/JC5EY3tN21tYU+/V0nLEdDPcFW/Xu4fpsm8Jz
ZPuuL0ISSsP5OGSvi222Hvhj2xyeI1uFvhjJKLOdwxZsxbbw7Dim0mtLkIJn
tvM4bK+H7bae+Gu7qrdHgZ6N1/Iw3JWruq/T5ea83bGv/QYm8y8/ilG8m8fz
W+7LWTyJyzk9fDfO5gfcgZtyJTLCdXIZusmD+AMGykv5MpLlPz5vp/wSvfQM
XoFbaKXX5XwUo7PehWfiBOL1V87P4Z/6SN7F4/gN9+FMnshfeGj4X3IW3+f2
nMIVGBHuLZeiqzyQ32OAvIQLkST/9nk75BfoqY/g5biJlnodzkMROulpPAMF
iNNfOn+MnIt7aGdLDp+DxbiExHD/HTdcXoYbaGGL51RMx3HE2l44Lknuj0W4
iCbhftjjwj3DNBxDjP25PVHuh4W4gAT7D3tsuGZMxVHUtj+zVyJG74gpOIJa
Xiuzl+IpSvAExSjCY7TxTP0HrpCybg==
         "],
         VertexColors->None]}]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1HWAVFUcBeCVLunuJSSWlpQOSXPt1sUOVkEpAxNUQMECUVBCkMZOwu4W
7O7uzu/88e05vzvMnffuvKGwpLR4wk4FBQW3+5Mc689Pci1nsgc9KUNZylGe
ClSkSKkkx3nfz3IdZ7EnvaicPbz2i1zPZPaiNyXWq/KIPodjqZL3WvtVbmAK
e9OH8dar8ag+l+Oomv2s/SY3MpV9mGitCa/oN9I3+5t35jH9Co5nurk1b+kr
qJbPM/8uNzGNC8wd+VDfl0l6U17VF9Mv12KuzuP6lczUu/KZfgJn6214W18o
h3JLrkP24Tt9iRyVa8w9yD/kUnmbvEr2Z7p+oSxiJR+ZF8nhrKc435tsxgq2
m6+Tg1nLEvNs2ZNb+TrnI3dnI7vlXGQNlvGE+Ro5kHn6LNmNz/UTOUdvyzv6
yty73pfv9eo5L/3PPF85Ay4yd+Jjfb88K3pzdug30T/nZa7Jk/p8TqIGxdb+
knfkc9mfAbkO67V4KufEydTM/tb+lndyLgcwkFp5r9f+kXdxHgcyiNr5d177
V97NDA5iMHWoSz3q04CGNKIxTWhKM5rTgk5+Hy2zvz3/k/dwPgczhMLsnx8e
9+ZZ4xCG5r6t1eZp/WpOoVXem98q9+VZ4FCG5b6t1eGZfGecSuvsZ60M9+f8
OYzh2c9aXZ7Vr+U02mQ/a2V5QL+Yw5lsbsFr+s2MyP7mejyXZ4xL9e58oU/I
meu78K6+irb5bHM5HtQvyf56Zz7Rj2CK3pLX9QVyCEv1ObIX3+iL5cg8s7lm
WZ/lPJ/7kINYwwLzZbIHq/jSfIMcwQZK893Ldvkt8p75ejmMdfl9mOfJfqzm
hzyjcnTuK+ciy7M5348cwMzcl+zCp/qRTNULeUNfxly9N9/qI3NWegNe0Bdy
ub4rX+mn5xnU2/O+vpp2OStzBbbosziKaeZWvKkvZxSl5oa8mHvjDNrnuqxV
ZGu+N45mdD7PWiNe0hcxkQ7Z31oltuVMOYYxdMx7rVfmoVw7JYylKM8/nelC
V7rRnR7Zw3uq8LA+m/GMyzVaa8zL+b6YlN+MuQMf6GuYn/+r+DHPoxzDppyb
+X+1Nr/T
       "]]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwl03WcFWUYhuHZXVi6u0MWBQFRFBQkDJBQxBVQQCVMUMFOwO4ABQNB7E66
u7u7lQ7pLq/3xx/3uZ/3mW9mzpn5ToUuPTK7pyRJMsbHEJxITZLByExLkrbc
iLfzXVyea/ByvoPf5+Z8gE85t6w8Xe6JxvIeboKr5Y38KbZal9c8XH4EtVHL
vIY/Qn5cbF7Ab+BWDHXOSf4q7osKOK0rZ90MuRduwjZdPt0I+VHUQQEM05/i
r3EnKuKMbjvyWz/S3D2+JwpiuP40f4N2uAhndTswAmfM36I9KsX10pPknH4n
RmIUqupGp1x4rmMxDuMxARmOTeRJmIwpmIppmI6zrvkdOiAD53W7MAPnzN/H
+0BlJGHX2+1YAb9llLkHrkEhzNSf5x9wdzxbpGCPvqD1o+XHUBeFMSs2g/5H
+R5cglSU183k3miKvdYV0o2RH0c9FMFsfYr+J7kjqiAt3pluFr+EZthnXWHd
WPkJXIsrzWv5YxSNe5sX8ptoFWvM//AXmOP8VPPPcidcJ+/gqrhMXsEfoIV8
kLPEe5Jnc2t+OfYm743fyc3jmfGmeOf8Wew9Psqd+T/3K8LjzLfzk3w974zn
yvX5Kl4Xe4z78c18iIvFc5AX8VuxV+V9fBvqy//yQMx1jzTzL3FPXIqa5pX8
IbLGXjTP4Vfit2G/c4rqxstPoQGKx3PQLea3kYl51mXR/Sp3QTWk44C+mH6C
/DQaogTm67Pqf5PvRXVkw0F9cf1E+Rk0Qkks0Kfrf5fvQw1kxyH9QmRz7A/z
/fF+kAOH9YtQ3f5dzEuwFMuwHCtQxbGVvAqrsQZrsQ7rsQHZXftP13sgnhdy
4oh+I3I49pf5QVyOXDiqL6GfJD8bewelsEmfU/+3/BCuQG4c05fUT5afi/eO
0tisz6UfIndFLeRBJd1cfjX2AI5bV0o3RX4eN6BMvF/dEn4n9hS2WJdbN1Tu
Fv+H+M7mVdwHeZFhnsev4RbUNW/mz3HC+aXNU+UX4j7yLr4RteX13D/Okw9z
2dgH8lJuw+9y09jr3JFbx37irdyeB3ErPhZ7KP6L7peHh5kfjv0fz8y8mvsi
Hyqb5/PraIl65i08ACedX8Y8TX4xvqe8mxujjryBP4nz5CNcLvahvIzb8nvc
jPdzJ24T+5e3cQf+Mv5jfDz2cPzP3O9/zIrceA==
       "]]}, 
     {Hue[0.1421359549995791, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nf8jmUcxfHHrlRWmggRlXapNDRV2lSiQbJSSIqmQksDDQpRWalklNUi
M+1NCRkhFVkZCb3PH5/X95xzXdf9u+9r/Z5qLTs16likUCjMLFootCpWKLQv
USh8W7xQaIId/Ad4Ea3RBrdp/07bdfiP/xAvoY/8H9n9OBS/ytridvn3fFPs
5D/CQPSVb5E9gKpYKmuHDvIf+GbYxR9WslCYpr4pL4cX5adjkKwfv5V+ENWw
TPaerCpG8Q1xq6wj/yN9PXbzc/mj8S4/nX+LLo+X+DMwnz4Ts+jB2p+lt9Hd
UR1f8SfjA3q59vfpanid36Beh0voRep5ebZv+DR/m26D9sZ0UufLimm7Qf0t
Y7AfX+A/oY9BaX4iv4W+EQfzHxs/hq6AUvxA7X/RjXEAfya/gD4LZfjZWSv6
Frxs7HPqdtlD+J2+AofRX6t18SG9ImtPV8do/lIsps/HZ/Rt2u+gF9A3oghm
yN7ON2AQfxaGyJ7n/6UfRo18a/YFOst/4m9CUcyUDcUL8h18D9TEyuwL3Cn/
mW+eecMs2StZ38xn3gc1fG/n9EUX/Rfq1wLFMVv2KvrL/+N74nCsSl/cJf+F
vxklMEf2GgbId/K9UAur0xd3yxfxLVESc2VjZRUxmK+PYTk//C76EdTOnGcs
usoX87egVNZcNk62f9aJPxvDc7743fSjOALf8KfgI3pNzmDWD2/wG9WmuIxe
ol6Az+mu+nWjl9CtMqf0pdiDnqcei73N3SR+K30TDuHnGTc++yp9+SHa19JX
40D+HP4nuj7K8nNyzulWqMKPyHmnCyjBP5Z3pq/EkfS36qmYRm9XW+CP3BNq
Dbwp36Q2w+W5V9QG+ILupt899K90a+yJT/njMDla+4S8J4by52KkbBBfBI/z
R+FP2TS+Jt7ir8A9snv5pXQb7IXPZLV8wyh1sLaieEJeJ+cv/XGfbBnfFqXx
uez15Lhf23JZO+yNL2Sjk+MBPIju0fqtyN2FffCl7A08lD7afpO1x765i3I3
4mV5MfSWHZ01kj2c58lW5ryiTM547jsMkRfHk7JjsE7WI39Dtoq/HWWz12Tv
yA7CK/x5GJNzmvXEU/yx+I4+DdPpv7VPpw/HGP5KLKUvxJc5d3k3ejXdIecv
+xXlMsfq8ZiSvaHfu7nz8GreUb0mdxD9s3p2xliPufwuujUO5d/OvUCXDPzT
2v+gr8rZ4o/jv6frYZ/cp/y/9M2oxK83/mO6FvbM87Rvpq/PM+hl6kX4ii5o
b0v3yvypv8s6onzWnj8BUzM/2ifmTOE1/gKMzX3El8Iz/PHYIJvB18ZYvlHu
DVlPfg3dCRXy/rkrcj/lXKKP7IScf9mj6JVzxN+B/fBDzjEewyPa/pR1RkX8
mHOCx/EEavum3uqTeCrP0/8v/e7E/pifPYFhmR/0lZ2Ycyp7On9DtpbvggOw
IOuI4fK90E92UuZU9kz+rmwdfxcOzH0im5S1wDC+ASbKRvCl8Sx/Mv6RzeSP
wDi+MfrkG/i/6btxUM4ZfyLey77RPpmujOHZq+q12Zv0QvUcfEJP0m9k7kQ8
lztCbYS6mUv1dOxrnmbwO+iWeSa/xbhZudvyrfz4vCd9Q84QfzW/nL4YFfiv
+SJqO76q2tf43vR6eXG+q7o6dx8q8gfnPqBPwvv0NrU5Fho3Ra2CEfL1apPs
U/oX9VzMoyfrNyr7Hs/zp2T96TMwk96qfTZ9FCbw16Bf9gK/IXcuDskzZVNz
3jCSvxhTctdlXvACf2reL7+fso9kG3OvohIWZXzuP3kZ9Jedhu35fZJ9JNvE
34vKWJzfdvktkd8H+R+evaPPZm33oQqW5LdY7kp5WQyQ1cvZls3h6+Ad/lqs
oBviG7qoeb2VrqYO0Pd/j+B8MA==
       "]]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  Method->{"AxesInFront" -> True},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.9999998830731719, 0.9999999999999918}}, {{
     0, 6.283185307179586}, {-0.9999998830731719, 0.9999999999999918}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1384847164]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 23.8765186}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/FilledPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 70, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[882, 35, 600, 22, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1485, 59, 75, 1, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1563, 62, 334, 9, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1922, 75, 306, 9, 70, "Input",
 CellID->1746043248],
Cell[2231, 86, 13304, 221, 70, "Output",
 CellID->489763601]
}, Open  ]],
Cell[15550, 310, 126, 3, 70, "ExampleDelimiter",
 CellID->1752599995],
Cell[15679, 315, 68, 1, 70, "UpgradeDetail",
 CellID->152023056],
Cell[15750, 318, 421, 13, 70, "Input",
 CellID->1693445909],
Cell[CellGroupData[{
Cell[16196, 335, 624, 20, 70, "Input",
 CellID->1144618872],
Cell[16823, 357, 43559, 723, 70, "Output",
 CellID->1384847164]
}, Open  ]]
}, Open  ]],
Cell[60409, 1084, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

