(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65496,       1644]
NotebookOptionsPosition[     61853,       1523]
NotebookOutlinePosition[     62819,       1551]
CellTagsIndexPosition[     62776,       1548]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`Graphics3D`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " has been extended to work with irregular data.\n",
 Cell[BoxData[
  ButtonBox["BarChart3D",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart3D"]], "InlineFormula"],
 " is available in the newly created ",
 ButtonBox["Bar Charts Package",
  BaseStyle->"Link",
  ButtonData->"paclet:BarCharts/guide/BarChartsPackage"],
 ".\n",
 Cell[BoxData[
  ButtonBox["Histogram3D",
   BaseStyle->"Link",
   ButtonData->"paclet:Histograms/ref/Histogram3D"]], "InlineFormula"],
 " is available in the newly created ",
 ButtonBox["Histograms Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Histograms/guide/HistogramsPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["New system functions", "UpgradeDetailLabel",
 CellID->305554978],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " has much of the functionality of ",
 Cell[BoxData["ScatterPlot3D"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`Graphics3D`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ScatterPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", " ", 
      RowBox[{"Sin", "[", "t", "]"}], ",", " ", 
      RowBox[{"Sqrt", "[", "t", "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", "0", ",", " ", 
      RowBox[{"4", " ", "Pi"}], ",", " ", "0.2"}], "}"}]}], "]"}], 
  "]"}]}], "Input", "LegacyInput",
 CellID->2087330327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", " ", 
      RowBox[{"Sin", "[", "t", "]"}], ",", " ", 
      RowBox[{"Sqrt", "[", "t", "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", "0", ",", " ", 
      RowBox[{"4", " ", "Pi"}], ",", " ", "0.2"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467948497],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJx913tUVNUewPF9QWEjkBiY5dsEHJ4jUJI8PHtAuggIispDyrwY5nVECCkS
RUeF5LpESlFAQ5GlBiRahHDl4TEMla4kjCHyUFBEYQZmAHllKJe1OHuftfcf
sRZr1vmuw2d+M7M5+8yC8KjACB0AQMX4ry7AP73c3z8CBKgf3CHT8Xm9XHx4
3PGij7Ts36NypfvCschqpkPU2MNXWZxpYdxebiSn+fnanT3s8yH5ZzZdLt0P
mA7R1BXe4abuT4VuQhyzMG83y3+rmA7Qetn5GSnTnjAdIu8YbmBPdafQzYgT
kfH5I7nvM6YDVPOar0wbYDt+Xd1Cf5s4h/WuTJX4PGY6QBojg9S1PSqmi+/H
xONscly70zXt0eIGpgNUtW5mjue9HqZDtCNxJLbv6z6hzyeObrBp+a5fqpgO
kO7j5a01yVqmQxR8qqVph6Zf6O8Sx+mtT6rin2XxdB+fx6Pt1r5RLXM+/rwG
hG5OnPg3LAIGzWp4ugPUO71iX6WVljkfok39AWs/ihsUuiVxJsesCbbMaeLp
DtCHRXWqobd7mPMhqnHdu/l09pDQJcSJLkj2BfVPeLoDBBvyG51au5jzISoo
Sj4cWjYsdGviJNd9U1Sa8ZynO0AZdTcGP83qYM7H63BE6LbiPAOKobNyNU93
gMqSsstG97Qx50O071edscw7fwrdnjh+0cFxly01PN0But7x8cKY6HrmfIhG
CuM5ddVLoS8mjrIj6dqkS1qe7gCF1RdHfmBSyZwPUb5fSGd88V9CdyBO8f+u
PtHvx44DcRztOpc6txcwHf9/jQqOI3F0rm24odOLX5cjcWL9xkyq19cyHSLr
p+98d0HxSnCciBNqqyxaVtjN0x2gvrpeT1lgC9MhOhG5zTQr7LXgvEecztzm
xFMBXTzdAcq+3j0WlNbOdIiWlHd0H108JjjvE+cX82a9C6qnPN0BujS35eFV
506mi9fLiYclxJlz61D39o2tPN0BevBmbWt/u5rpELmetci3jMCOM3HyK8N3
B/9wj6c7QFqJl8PXOzRMh2goaGu1+hZ2PiDOoZRQG/3icp7uAJV2f2y6+o6W
6RDFJ0Tt/kryD+F4KXH2Iv+QdZuLOboDNOZudDKtDTtLiTNxPcSOC3EafeTR
SYuUHN0BcspsG9x3Gb8uF+LkDqSfimvHjitxNFudQ+1GH3J0B6jBvLTQwwuv
K1fiLJwqOSFZpiMcuxHn8I8WUZ8F4H3NjTjRkx3Td5fiz92NOMXHpc7z0rHj
TpzEKQeSo+rwvuZOnKLBEzOCnPC6cifOxHUeO8uIsyjmez27ILyvLSPOb61H
bk0pf8jTHaIka9srbst1hWOOOIPvfmVQclXD0X38+pPz46G+x3U83SGyX2Bg
diQDO4g4v+ftRBfb8b6AiDOn5lpziNcVnu4Q3XxxND1eLTgK0TnrN7fC5rbg
KETH1vp9qc39Cqbj/WuScCwjjvWvMnv/Lfh1yYhz1KBL6tt7j+kQGd6N89iS
IjgK0RluSb48U6nm6A6QwTTVyZQzrUyHqGm12f2DLXgeD+LMmN94enge/tw9
iAOnRFZCvQ6mQ6QaUebttZ4szCM6qmwju6y4do7uAE2tbrcojehiOt6XBQd4
EichWX5XMg3f73kSZ8hq8i7nym6mQ2Rh+EeK1Q08j+go37podc6slqP7+Dwj
JgWOf2qYDpF5iYtXv7GecLycOPHrExMMs3/g6A6QtERhO21Ay3SIrmwIL7we
LDgK0UmTbuKvnank6Q7QrruSbGUuXleiM3G/gefxIk7VXOP04qJ6nu4A2Tt1
DX85E68rL+Icqzm5Pq0TzyM63KU17rqn23i6A5Q5bHe3NQSvK9FpcNszmi/V
F44/JM5f8+/MNP1vB093gOx+Kgq2Vzzn6A6RMsbNRfWF4ChEJ2W6XdDOAWEf
VIjOQ+VvHudKhPtwhehM3Efhef5JHPk7Fy68XNTD0x2gb6VGSyw3NnF0h/Sj
QnTSzpkhtYOwLyhER36qfk7uwTsc3SEq7Ehyf+qJPW/imKY6eu5+hfcXb+I8
kS3PLd2QydF9/DqvV/et0UE8j+j8rLGd9c1+PI/oSEqmw+BVN5mO7w/xPCuI
k6BBq41v4vdnBXF0tv/c9mlsA9MhmturbywzNBDmEZ15cqP/XGxU8XQHKDDg
xeDpLY+ZDtGasCaXED/BAT7EscnSPefZ/IynO0C+m2szP4lgO0Qrx16nVx/G
84hOuclz2fEX+HlF50xKlDYlQcV0fN+L5/Elzvf9tQf+lfeAp/v4vmxhG7jx
YA/TISpaPfrG74ZThHlEJ2/B9i01rbd5ugOUMmvHxj82aZkO0cWbsdKtPoID
/IjTKtXILs2P4egOkPqY/ZfqMbyu/IjzXtSrYzHJeB7ROfbswFKTUeH7tUJ0
9p7/InnbOjyP6Ezcz+N5VhJntk/qqgH7Ro7uAPkEgNyFcvz+rCTOrKM2+g90
DIV5REd3ZW1ZpBT/X4tO8zqnnO/W4s9LdJqtYo+7cYID/ImzqkJ/621jfJ3x
Jw4MrUwMc8Drx584gbqfb5u9C88jOu0R8klNAF/3ROd8RMPwSRu8rkRn4nsK
nieAOE6PhvPWtOHvjwHEiQ9Q73fpuc/THaLY1AJZWB+eR3S2hZZJ2o/gfUF0
zO/X7k90rOLpDlHGS9/U6zZG6P+zYdaU
    "]]},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{All, Automatic},
  PlotRangePadding->Automatic]], "Output",
 CellLabel->"Out[2]=",
 CellID->558987983]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " now works with irregular data:"
}], "UpgradeDetail",
 CellID->1247190321],

Cell[BoxData[
 RowBox[{"ListSurfacePlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], " ", 
       RowBox[{"Cos", "[", "u", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], " ", 
       RowBox[{"Cos", "[", "u", "]"}]}], ",", 
      RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Pi]", ",", 
      FractionBox["\[Pi]", "5"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", 
      FractionBox["\[Pi]", "2"], ",", 
      FractionBox["\[Pi]", "10"]}], "}"}]}], "]"}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[12]:=",
 CellID->1817558303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], " ", 
       RowBox[{"Cos", "[", "u", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], " ", 
       RowBox[{"Cos", "[", "u", "]"}]}], ",", 
      RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Pi]", ",", 
      FractionBox["\[Pi]", "5"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", 
      FractionBox["\[Pi]", "2"], ",", 
      FractionBox["\[Pi]", "10"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2142902541],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJzFWntcVNUWPvh+YmZZalTq1QqNlFTMHvuWoF26miVC+IqLdqHMePhITbuK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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtk1tMj2Ecx5+nNiSTlMKESJLDGGM5nyZNSpRNdUFNbUXJ2NiYQzZy47hl
a045rC4cc2HaXMhYSUKOV1zZlPMFLmw+vz3fi88+3/f5v//38Hu+b3JJ9dqq
COfcZoiEkd65gzgVKskeish/IIIcj5vhErkc/4Vqcj7+BQXkdXg1bIAYOA/b
WS/A0fgklJHP4RjYQu7CibCbHIfvwDbyd8gmr8Ev8XDYRb4G18kVeBh+DDvI
o/ABPMGF6+60d4Io1vdDiT07DLD74YH4EJSSr+KbeCvcIrfYu0EHuRWPg3vk
WB/OmYHP4BUwm9yJp+iat3ECPCAP9eE6V3Ck5nkY94Ni8l7cHzaRT/nwbJZP
aH0juVF7UUhuwP/wevgGWRzn4h9QS87De3CjC//9CblaH4zPam6DcL328QZc
tFnCc3tX1ufi3y5cJxbeQwrri/EbnbMQj7b54zR4BckcL1BPLrjQGdvTbqgh
t2vfK8mvYZWuY10qVU9m4id4st5xnzqQgB/5sK9jcDuepF7ZfiVqr+9qT6fj
h+rzWxjP8SI8DZZZD1zYgywYYp2Eo+qwszn50GPrnPUxCZrgvjp8GVrUq3jc
ph4+0xwy8CeY6sP97Dsq1vcyC/fiTJhD/oJX2j3sHfFEzbZDvaqHOns/+Ggd
57el+BjkK+e4MPtoyGCty+4NPeQR+r7S8HG8HArJX/W/Ih/2y3rVo72e78L3
e9q6A2NZe6r5vdA856kbDdZ9qGKtz4Xvws4/gtOh3IeOWYfLyJ/1DO8gT72q
0Rwytb+dev4PNg+Ol6h7OdpHm1WdevIfOS6AJg==
         "]], Polygon3DBox[CompressedData["
1:eJxFl3mU11MYh+9ts5bKmu2IgxCSYpBsobIPWmjKUgiNFlOaUCpFG6Umo80+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         "]], Polygon3DBox[CompressedData["
1:eJxNlGlMyGEcx5+nQoeVKE1zFJJRttzmihlylXNTNh1bEZUMm6VylGuj3LdS
MTcl5NgM5b7l3HjD5oWbzfGC+fz2/F548dn3+/z+1/N/nu/vCU/NmZTtYYxJ
gCbwFtbCMIi0xrxBj6NH4DD4Qya1/mhvGIX/CP3wPWELPgC2Qwzj+TAPcuA3
tamQpn4KzMCnwg6ZAxoP3/AtIAWfBNPwfyAZ/xR9AAMgnPET9JZx35bv9YUo
xmtgG2yFXtS6ozfgHtyFMGrd0JvQAR+t1+SeGvCllobWodXoSTiLPwPnIYtx
AxoMC/BX0XrYhX8JsTCR8U5di0z8bMiGkYw7og/1X+SfhkA0tXeoP2yGKMY1
UIkPgVNQzfgcnIZaaAW51OeiGZCIt+gcaAoLYQy1OFlr49YnRufwAfrg96En
ZJ+hQt9xUdYDvxhtg15QbYQ8fGfopOvcjlok6gk+xu21J3jAL93nWfi/aLBx
38vQXMg8k4y7X577hE9Ep8NPfKBxmZgA4+GrrCuMk/+COPis+c2z8vM8i4yX
e4x77pmu71h9h+Q1V78v+RzN+BIUQxG0pRaBvocs69Y2V7MumbuvveIHg6EQ
Qql3QeuhAEo1rzMhHUYwfgGPYaCsHbXnus9l//XFJrQSLYO90Fz2lVoE+hp9
BSUwHJpR2wCl8hykSOb1mVD8Ucm/dT0m+xAE5cb1lLc+sxH8rMuX+BJYDwcZ
p2v+faRHJX/W9UAVPl+/5635XK091UNqIGdKoe5NPCzBF0BLuAKXpZckO5Il
63rGF7xgkHHZqbJuLQ7p3KXHgiBMehYWGTfX7+hkWItfB9ehTvrVuPulP0PQ
R9JzmmHJtfSQ9FOOcfOq1TnKXJN1feU/K4zL4g/j1luuLdV783U9UrXvpH/2
wX7N9R3tOemzAdadM0XoMuveIWsr54wXWmzdNTl7WlNbZd1ZKHlfgV9p3Tl8
wLrzJ9C6M3k5fNEeKNR3X9O+lHPvNjQYN69jxp3fe/Dl1tXlupyh7Rl31f1o
1KxKZmONy+Nu6Vd8gGYzQTM8VPtM+vQfcae4aw==
         "]], 
        Polygon3DBox[{{341, 225, 66, 340, 158, 83}, {160, 169, 103, 407, 411, 
         86}, {199, 286, 44, 204, 287, 41}, {291, 210, 58, 290, 215, 63}, {
         464, 275, 112, 120, 280, 463}, {271, 457, 456, 278, 117, 108}, {179, 
         267, 102, 446, 450, 111}, {130, 296, 68, 234, 304, 38}, {330, 213, 
         61, 78, 238, 329}, {205, 312, 311, 231, 67, 46}}]}]}, {}, {}, {}}, {
     Line3DBox[{124, 1, 7, 69, 13, 88, 87, 19, 105, 104, 25, 119, 118, 31, 32,
       33, 34, 35, 36, 123, 122, 30, 115, 114, 24, 101, 100, 18, 82, 12, 6, 
      219, 220, 221, 222, 223, 224, 65, 138, 139, 140, 5, 207, 57, 208, 209, 
      58, 210, 59, 211, 212, 60, 4, 47, 48, 49, 50, 51, 3, 39, 198, 197, 40, 
      199, 41, 201, 200, 42, 136, 2, 193, 192, 191, 37, 129, 128, 127, 126, 
      125, 124}], {
      Line3DBox[{124, 194, 302, 232, 356, 349, 250, 408, 404, 170, 452, 451, 
       276, 183, 458, 187, 281, 468, 465, 180, 447, 443, 165, 395, 392, 156, 
       338, 141, 219}], 
      Line3DBox[{136, 288, 205, 312, 308, 235, 365, 360, 254, 377, 374, 371, 
       260, 389, 386, 240, 332, 330, 213, 289, 207}], 
      Line3DBox[{140, 230, 346, 238, 329, 239, 383, 385, 388, 266, 178, 424, 
       429, 432, 175, 161, 359, 364, 369, 237, 311, 231, 301, 135, 193}], 
      Line3DBox[{191, 133, 299, 147, 355, 249, 367, 259, 421, 417, 173, 430, 
       427, 422, 176, 439, 435, 164, 381, 263, 401, 246, 344, 228, 138}], 
      Line3DBox[{197, 203, 307, 150, 327, 324, 321, 318, 315, 154, 337, 217, 
       211}], Line3DBox[{199, 286, 202, 306, 149, 326, 323, 320, 317, 314, 
       153, 336, 216, 291, 210}], 
      Line3DBox[{200, 206, 313, 309, 236, 366, 361, 255, 378, 375, 372, 261, 
       390, 387, 241, 333, 331, 214, 208}], 
      Line3DBox[{209, 290, 215, 334, 335, 242, 391, 262, 373, 376, 379, 256, 
       362, 152, 305, 310, 204, 287, 201}], 
      Line3DBox[{212, 292, 218, 155, 316, 319, 322, 325, 328, 151, 137, 285, 
       198}], Line3DBox[{224, 295, 227, 343, 245, 400, 403, 264, 163, 434, 
       438, 442, 273, 426, 270, 413, 416, 420, 258, 248, 348, 354, 146, 298, 
       132, 284, 129}], 
      Line3DBox[{125, 195, 303, 233, 357, 350, 251, 409, 405, 171, 453, 277, 
       455, 184, 459, 188, 462, 279, 466, 181, 448, 444, 166, 396, 393, 157, 
       339, 142, 220}], 
      Line3DBox[{126, 196, 304, 234, 358, 351, 252, 410, 406, 172, 454, 278, 
       456, 185, 460, 189, 463, 280, 467, 182, 449, 445, 167, 397, 394, 158, 
       340, 143, 221}], 
      Line3DBox[{127, 282, 130, 296, 144, 352, 253, 411, 407, 268, 414, 271, 
       457, 186, 461, 190, 464, 275, 436, 274, 450, 446, 168, 398, 243, 341, 
       225, 293, 222}], 
      Line3DBox[{128, 283, 131, 297, 145, 353, 347, 160, 169, 419, 415, 412, 
       269, 425, 272, 441, 437, 433, 179, 267, 402, 399, 244, 342, 226, 294, 
       223}], Line3DBox[{139, 229, 345, 247, 162, 380, 382, 384, 265, 440, 
       177, 423, 428, 431, 174, 418, 257, 363, 368, 370, 159, 148, 300, 134, 
       192}]}, {
      Line3DBox[{51, 56, 328, 327, 326, 77, 89, 362, 361, 360, 359, 90, 418, 
       417, 416, 415, 414, 108, 117, 454, 453, 452, 119}], 
      Line3DBox[{60, 292, 64, 337, 336, 335, 81, 387, 386, 385, 384, 98, 435, 
       434, 433, 111, 450, 449, 448, 447, 115}], 
      Line3DBox[{69, 302, 303, 304, 38, 282, 283, 284, 37}], 
      Line3DBox[{82, 338, 339, 340, 66, 293, 294, 295, 65}], 
      Line3DBox[{87, 349, 350, 351, 352, 353, 354, 355, 85, 370, 72, 311, 312,
        313, 45, 287, 41}], 
      Line3DBox[{100, 392, 393, 394, 83, 341, 342, 343, 344, 345, 346, 78, 61,
        289, 57}], 
      Line3DBox[{104, 404, 405, 406, 407, 103, 419, 420, 421, 91, 363, 364, 
       365, 366, 70, 305, 306, 307, 43, 285, 39}], 
      Line3DBox[{114, 443, 444, 445, 446, 102, 402, 403, 97, 381, 382, 383, 
       80, 332, 333, 334, 63, 291, 59}], 
      Line3DBox[{31, 32, 33, 34, 458, 35, 36}], 
      Line3DBox[{118, 451, 116, 455, 456, 457, 107, 412, 413, 106, 430, 431, 
       432, 95, 377, 378, 379, 76, 323, 324, 325, 55, 50}], 
      Line3DBox[{122, 465, 466, 467, 120, 112, 436, 437, 438, 439, 440, 99, 
       388, 389, 390, 391, 92, 73, 314, 315, 316, 52, 47}], 
      Line3DBox[{40, 286, 44, 310, 309, 308, 71, 369, 368, 367, 84, 348, 347, 
       86, 411, 410, 409, 408, 105}], 
      Line3DBox[{42, 288, 46, 67, 301, 300, 299, 298, 297, 296, 68, 358, 357, 
       356, 88}], 
      Line3DBox[{48, 53, 319, 318, 317, 74, 373, 372, 371, 93, 424, 423, 422, 
       109, 442, 441, 113, 464, 463, 462, 121, 468, 123}], 
      Line3DBox[{49, 54, 322, 321, 320, 75, 376, 375, 374, 94, 429, 428, 427, 
       426, 425, 110, 461, 460, 459, 458}], 
      Line3DBox[{58, 290, 62, 331, 330, 329, 79, 380, 96, 401, 400, 399, 398, 
       397, 396, 395, 101}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx1WHs0FP72lZJKRUmhl4oS0YNKKltFUajQA0Uhih4U1Tc9RKI8KvQQ0btQ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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{
   "RotationControl" -> "Globe", "SpherePoints" -> Automatic, 
    "CylinderPoints" -> Automatic},
  PlotRange->{{-1., 1.}, {0., 0.9510565162951535}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVector->Automatic,
  ViewVertical->{0., 0., 1.}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Histograms package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 Cell[BoxData["Histogram"], "InlineFormula"],
 "3D from ",
 Cell[BoxData["Graphics`Graphics3D`"], "InlineFormula"],
 " is now found in the ",
 ButtonBox["Histograms Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Histograms/guide/HistogramsPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[BoxData[
 RowBox[{"Histogram3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input", "LegacyInput",
 CellID->1915518068],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Histograms`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Histogram3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "9"}], "}"}]}], "}"}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1184816699],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[1], Glow[], Specularity[], 
   {EdgeForm[GrayLevel[0]], CuboidBox[{0, 0, 0}, {5, 5, 1}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{0, 5, 0}, {5, 10, 8}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{0, 10, 0}, {5, 15, 1}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{5, 0, 0}, {10, 5, 2}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{5, 5, 0}, {10, 10, 2}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{5, 10, 0}, {10, 15, 0}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{10, 0, 0}, {15, 5, 0}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{10, 5, 0}, {15, 10, 1}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{10, 10, 0}, {15, 15, 0}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesEdge->Automatic,
  AxesLabel->None,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  BoxRatios->{1, 1, 1},
  BoxStyle->{},
  Boxed->True,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  ControllerLinking->Automatic,
  ControllerMethod->Automatic,
  ControllerPath->Automatic,
  DefaultAxesStyle->{},
  DefaultBaseStyle->"Graphics3D",
  DefaultBoxStyle->{},
  DefaultLabelStyle->"Graphics3DLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FaceGrids->None,
  FaceGridsStyle->{},
  FormatType:>TraditionalForm,
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Lighting->Automatic,
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  SphericalRegion->False,
  Ticks->{Automatic, Automatic, Automatic},
  TicksStyle->{},
  ViewAngle->Automatic,
  ViewCenter->NCache[{
     Rational[1, 2], 
     Rational[1, 2], 
     Rational[1, 2]}, {0.5, 0.5, 0.5}],
  ViewMatrix->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewRange->All,
  ViewVector->Automatic,
  ViewVertical->{0, 0, 1}]], "Output",
 CellLabel->"Out[6]=",
 CellID->59611569]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["SolidBarStyle"], "InlineFormula"],
 ", ",
 Cell[BoxData["SolidBarEdges"], "InlineFormula"],
 " and ",
 Cell[BoxData["SolidBarEdgeStyle"], "InlineFormula"],
 " options have been replaced by the ",
 Cell[BoxData[
  ButtonBox["BarStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BarEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarEdges"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BarEdgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"]], "InlineFormula"],
 " options:"
}], "UpgradeDetail",
 CellID->2132010364],

Cell[BoxData[
 RowBox[{"Histogram3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"SolidBarStyle", "\[Rule]", 
    RowBox[{"SurfaceColor", "[", "Red", "]"}]}], ",", " ", 
   RowBox[{"SolidBarEdgeStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "0.02", "]"}]}], ",", " ", 
   RowBox[{"SolidBarEdges", "\[Rule]", "True"}]}], "]"}]], "Input", \
"LegacyInput",
 CellID->872050956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarStyle", "\[Rule]", "Red"}], ",", " ", 
   RowBox[{"BarEdgeStyle", "\[Rule]", "Thick"}], ",", " ", 
   RowBox[{"BarEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1637229832],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0, 0], 
   {EdgeForm[Thickness[Large]], CuboidBox[{0, 0, 0}, {2, 2, 0}]}, 
   {EdgeForm[Thickness[Large]], CuboidBox[{0, 2, 0}, {2, 4, 2}]}, 
   {EdgeForm[Thickness[Large]], CuboidBox[{0, 4, 0}, {2, 6, 3}]}, 
   {EdgeForm[Thickness[Large]], CuboidBox[{2, 0, 0}, {4, 2, 2}]}, 
   {EdgeForm[Thickness[Large]], CuboidBox[{2, 2, 0}, {4, 4, 4}]}, 
   {EdgeForm[Thickness[Large]], CuboidBox[{2, 4, 0}, {4, 6, 2}]}, 
   {EdgeForm[Thickness[Large]], CuboidBox[{4, 0, 0}, {6, 2, 1}]}, 
   {EdgeForm[Thickness[Large]], CuboidBox[{4, 2, 0}, {6, 4, 3}]}, 
   {EdgeForm[Thickness[Large]], CuboidBox[{4, 4, 0}, {6, 6, 3}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesEdge->Automatic,
  AxesLabel->None,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  BoxRatios->{1, 1, 1},
  BoxStyle->{},
  Boxed->True,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  ControllerLinking->Automatic,
  ControllerMethod->Automatic,
  ControllerPath->Automatic,
  DefaultAxesStyle->{},
  DefaultBaseStyle->"Graphics3D",
  DefaultBoxStyle->{},
  DefaultLabelStyle->"Graphics3DLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FaceGrids->None,
  FaceGridsStyle->{},
  FormatType:>TraditionalForm,
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Lighting->Automatic,
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  SphericalRegion->False,
  Ticks->{Automatic, Automatic, Automatic},
  TicksStyle->{},
  ViewAngle->Automatic,
  ViewCenter->NCache[{
     Rational[1, 2], 
     Rational[1, 2], 
     Rational[1, 2]}, {0.5, 0.5, 0.5}],
  ViewMatrix->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewRange->All,
  ViewVector->Automatic,
  ViewVertical->{0, 0, 1}]], "Output",
 CellLabel->"Out[7]=",
 CellID->364241831]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bar charts package", "UpgradePackageSection",
 CellID->1411404028],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["Graphics`Graphics3D`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Bar Charts Package",
  BaseStyle->"Link",
  ButtonData->"paclet:BarCharts/guide/BarChartsPackage"],
 ":"
}], "UpgradeDetail",
 CellID->363133834],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BarChart3D",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart3D"]], "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["GeneralizedBarChart3D",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/GeneralizedBarChart3D"]], 
  "InlineFormula"]
}], "UpgradePackageListing",
 CellID->41823264],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BarChart3D",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart3D"]], "InlineFormula"],
 " is in a new package:"
}], "UpgradeDetail",
 CellID->1909047094],

Cell[BoxData[
 RowBox[{"BarChart3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "6", ",", "7", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "9", ",", "1", ",", "0", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "6", ",", "2", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "0", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "9", ",", "1", ",", "0", ",", "9"}], "}"}]}], "}"}], 
  "]"}]], "Input", "LegacyInput",
 CellID->1653650426],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "BarCharts`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"BarChart3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "6", ",", "7", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "9", ",", "1", ",", "0", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "6", ",", "2", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "0", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "9", ",", "1", ",", "0", ",", "9"}], "}"}]}], "}"}], 
  "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->169350308],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[1, 2], 0}, {0.5, 0.5, 0}], 
     NCache[{Rational[3, 2], Rational[3, 2], 2}, {1.5, 1.5, 2}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[3, 2], 0}, {0.5, 1.5, 0}], 
     NCache[{Rational[3, 2], Rational[5, 2], 1}, {1.5, 2.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[5, 2], 0}, {0.5, 2.5, 0}], 
     NCache[{Rational[3, 2], Rational[7, 2], 6}, {1.5, 3.5, 6}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[7, 2], 0}, {0.5, 3.5, 0}], 
     NCache[{Rational[3, 2], Rational[9, 2], 7}, {1.5, 4.5, 7}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[9, 2], 0}, {0.5, 4.5, 0}], 
     NCache[{Rational[3, 2], Rational[11, 2], 4}, {1.5, 5.5, 4}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[1, 2], 0}, {1.5, 0.5, 0}], 
     NCache[{Rational[5, 2], Rational[3, 2], 7}, {2.5, 1.5, 7}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[3, 2], 0}, {1.5, 1.5, 0}], 
     NCache[{Rational[5, 2], Rational[5, 2], 9}, {2.5, 2.5, 9}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[5, 2], 0}, {1.5, 2.5, 0}], 
     NCache[{Rational[5, 2], Rational[7, 2], 1}, {2.5, 3.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[7, 2], 0}, {1.5, 3.5, 0}], 
     NCache[{Rational[5, 2], Rational[9, 2], 0}, {2.5, 4.5, 0}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[9, 2], 0}, {1.5, 4.5, 0}], 
     NCache[{Rational[5, 2], Rational[11, 2], 4}, {2.5, 5.5, 4}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[1, 2], 0}, {2.5, 0.5, 0}], 
     NCache[{Rational[7, 2], Rational[3, 2], 5}, {3.5, 1.5, 5}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[3, 2], 0}, {2.5, 1.5, 0}], 
     NCache[{Rational[7, 2], Rational[5, 2], 2}, {3.5, 2.5, 2}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[5, 2], 0}, {2.5, 2.5, 0}], 
     NCache[{Rational[7, 2], Rational[7, 2], 6}, {3.5, 3.5, 6}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[7, 2], 0}, {2.5, 3.5, 0}], 
     NCache[{Rational[7, 2], Rational[9, 2], 2}, {3.5, 4.5, 2}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[9, 2], 0}, {2.5, 4.5, 0}], 
     NCache[{Rational[7, 2], Rational[11, 2], 7}, {3.5, 5.5, 7}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[7, 2], Rational[1, 2], 0}, {3.5, 0.5, 0}], 
     NCache[{Rational[9, 2], Rational[3, 2], 4}, {4.5, 1.5, 4}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[7, 2], Rational[3, 2], 0}, {3.5, 1.5, 0}], 
     NCache[{Rational[9, 2], Rational[5, 2], 3}, {4.5, 2.5, 3}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[7, 2], Rational[5, 2], 0}, {3.5, 2.5, 0}], 
     NCache[{Rational[9, 2], Rational[7, 2], 0}, {4.5, 3.5, 0}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[7, 2], Rational[7, 2], 0}, {3.5, 3.5, 0}], 
     NCache[{Rational[9, 2], Rational[9, 2], 0}, {4.5, 4.5, 0}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[7, 2], Rational[9, 2], 0}, {3.5, 4.5, 0}], 
     NCache[{Rational[9, 2], Rational[11, 2], 10}, {4.5, 5.5, 10}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[9, 2], Rational[1, 2], 0}, {4.5, 0.5, 0}], 
     NCache[{Rational[11, 2], Rational[3, 2], 8}, {5.5, 1.5, 8}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[9, 2], Rational[3, 2], 0}, {4.5, 1.5, 0}], 
     NCache[{Rational[11, 2], Rational[5, 2], 9}, {5.5, 2.5, 9}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[9, 2], Rational[5, 2], 0}, {4.5, 2.5, 0}], 
     NCache[{Rational[11, 2], Rational[7, 2], 1}, {5.5, 3.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[9, 2], Rational[7, 2], 0}, {4.5, 3.5, 0}], 
     NCache[{Rational[11, 2], Rational[9, 2], 0}, {5.5, 4.5, 0}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[9, 2], Rational[9, 2], 0}, {4.5, 4.5, 0}], 
     NCache[{Rational[11, 2], Rational[11, 2], 9}, {5.5, 5.5, 9}]]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesEdge->Automatic,
  AxesLabel->None,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  BoxRatios->{1, 1, 1},
  BoxStyle->{},
  Boxed->True,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  ControllerLinking->Automatic,
  ControllerMethod->Automatic,
  ControllerPath->Automatic,
  DefaultAxesStyle->{},
  DefaultBaseStyle->"Graphics3D",
  DefaultBoxStyle->{},
  DefaultLabelStyle->"Graphics3DLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FaceGrids->None,
  FaceGridsStyle->{},
  FormatType:>TraditionalForm,
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Lighting->Automatic,
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  SphericalRegion->False,
  Ticks->Automatic,
  TicksStyle->{},
  ViewAngle->Automatic,
  ViewCenter->NCache[{
     Rational[1, 2], 
     Rational[1, 2], 
     Rational[1, 2]}, {0.5, 0.5, 0.5}],
  ViewMatrix->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewRange->All,
  ViewVector->Automatic,
  ViewVertical->{0, 0, 1}]], "Output",
 CellLabel->"Out[9]=",
 CellID->294301743]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["SolidBarStyle"], "InlineFormula"],
 ", ",
 Cell[BoxData["SolidBarEdges"], "InlineFormula"],
 " and ",
 Cell[BoxData["SolidBarEdgeStyle"], "InlineFormula"],
 " options have been replaced by the ",
 Cell[BoxData[
  ButtonBox["BarStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BarEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarEdges"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BarEdgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"]], "InlineFormula"],
 " options:"
}], "UpgradeDetail",
 CellID->1933537553],

Cell[BoxData[
 RowBox[{"BarChart3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "7", ",", " ", "8"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "6", ",", " ", "2"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"SolidBarStyle", "\[Rule]", 
    RowBox[{"SurfaceColor", "[", "Blue", "]"}]}], ",", 
   RowBox[{"SolidBarEdgeStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "0.02", "]"}]}], ",", " ", 
   RowBox[{"SolidBarEdges", "\[Rule]", "True"}]}], "]"}]], "Input", \
"LegacyInput",
 CellID->1243106867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "7", ",", " ", "8"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "6", ",", " ", "2"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarStyle", "\[Rule]", "Blue"}], ",", " ", 
   RowBox[{"BarEdgeStyle", "\[Rule]", "Thick"}], ",", " ", 
   RowBox[{"BarEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->28712006],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[1, 2], 0}, {0.5, 0.5, 0}], 
     NCache[{Rational[3, 2], Rational[3, 2], 3}, {1.5, 1.5, 3}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[3, 2], 0}, {0.5, 1.5, 0}], 
     NCache[{Rational[3, 2], Rational[5, 2], 1}, {1.5, 2.5, 1}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[5, 2], 0}, {0.5, 2.5, 0}], 
     NCache[{Rational[3, 2], Rational[7, 2], 4}, {1.5, 3.5, 4}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[1, 2], 0}, {1.5, 0.5, 0}], 
     NCache[{Rational[5, 2], Rational[3, 2], 2}, {2.5, 1.5, 2}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[3, 2], 0}, {1.5, 1.5, 0}], 
     NCache[{Rational[5, 2], Rational[5, 2], 7}, {2.5, 2.5, 7}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[5, 2], 0}, {1.5, 2.5, 0}], 
     NCache[{Rational[5, 2], Rational[7, 2], 8}, {2.5, 3.5, 8}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[1, 2], 0}, {2.5, 0.5, 0}], 
     NCache[{Rational[7, 2], Rational[3, 2], 1}, {3.5, 1.5, 1}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[3, 2], 0}, {2.5, 1.5, 0}], 
     NCache[{Rational[7, 2], Rational[5, 2], 6}, {3.5, 2.5, 6}]]}, 
   {RGBColor[0, 0, 1], EdgeForm[Thickness[Large]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[5, 2], 0}, {2.5, 2.5, 0}], 
     NCache[{Rational[7, 2], Rational[7, 2], 2}, {3.5, 3.5, 2}]]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesEdge->Automatic,
  AxesLabel->None,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  BoxRatios->{1, 1, 1},
  BoxStyle->{},
  Boxed->True,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  ControllerLinking->Automatic,
  ControllerMethod->Automatic,
  ControllerPath->Automatic,
  DefaultAxesStyle->{},
  DefaultBaseStyle->"Graphics3D",
  DefaultBoxStyle->{},
  DefaultLabelStyle->"Graphics3DLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FaceGrids->None,
  FaceGridsStyle->{},
  FormatType:>TraditionalForm,
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Lighting->Automatic,
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  SphericalRegion->False,
  Ticks->Automatic,
  TicksStyle->{},
  ViewAngle->Automatic,
  ViewCenter->NCache[{
     Rational[1, 2], 
     Rational[1, 2], 
     Rational[1, 2]}, {0.5, 0.5, 0.5}],
  ViewMatrix->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewRange->All,
  ViewVector->Automatic,
  ViewVertical->{0, 0, 1}]], "Output",
 CellLabel->"Out[10]=",
 CellID->666911732]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["XSpacing"], "InlineFormula"],
 " and ",
 Cell[BoxData["YSpacing"], "InlineFormula"],
 " options have been combined into a",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["BarSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarSpacing"]}]], "InlineFormula"],
 " option:"
}], "UpgradeDetail",
 CellID->1012768853],

Cell[BoxData[
 RowBox[{"BarChart3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "7", ",", " ", "8"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "6", ",", " ", "2"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"XSpacing", "\[Rule]", "0.1"}], ",", " ", 
   RowBox[{"YSpacing", "\[Rule]", "0"}]}], "]"}]], "Input", "LegacyInput",
 CellID->2128829195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "7", ",", " ", "8"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "6", ",", " ", "2"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.1", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->650726249],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{0.55, Rational[1, 2], 0}, {0.55, 0.5, 0}], 
     NCache[{1.45, Rational[3, 2], 3}, {1.45, 1.5, 3}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{0.55, Rational[3, 2], 0}, {0.55, 1.5, 0}], 
     NCache[{1.45, Rational[5, 2], 1}, {1.45, 2.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{0.55, Rational[5, 2], 0}, {0.55, 2.5, 0}], 
     NCache[{1.45, Rational[7, 2], 4}, {1.45, 3.5, 4}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{1.55, Rational[1, 2], 0}, {1.55, 0.5, 0}], 
     NCache[{2.45, Rational[3, 2], 2}, {2.45, 1.5, 2}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{1.55, Rational[3, 2], 0}, {1.55, 1.5, 0}], 
     NCache[{2.45, Rational[5, 2], 7}, {2.45, 2.5, 7}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{1.55, Rational[5, 2], 0}, {1.55, 2.5, 0}], 
     NCache[{2.45, Rational[7, 2], 8}, {2.45, 3.5, 8}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{2.55, Rational[1, 2], 0}, {2.55, 0.5, 0}], 
     NCache[{3.45, Rational[3, 2], 1}, {3.45, 1.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{2.55, Rational[3, 2], 0}, {2.55, 1.5, 0}], 
     NCache[{3.45, Rational[5, 2], 6}, {3.45, 2.5, 6}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{2.55, Rational[5, 2], 0}, {2.55, 2.5, 0}], 
     NCache[{3.45, Rational[7, 2], 2}, {3.45, 3.5, 2}]]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesEdge->Automatic,
  AxesLabel->None,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  BoxRatios->{1, 1, 1},
  BoxStyle->{},
  Boxed->True,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  ControllerLinking->Automatic,
  ControllerMethod->Automatic,
  ControllerPath->Automatic,
  DefaultAxesStyle->{},
  DefaultBaseStyle->"Graphics3D",
  DefaultBoxStyle->{},
  DefaultLabelStyle->"Graphics3DLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FaceGrids->None,
  FaceGridsStyle->{},
  FormatType:>TraditionalForm,
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Lighting->Automatic,
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  SphericalRegion->False,
  Ticks->Automatic,
  TicksStyle->{},
  ViewAngle->Automatic,
  ViewCenter->NCache[{
     Rational[1, 2], 
     Rational[1, 2], 
     Rational[1, 2]}, {0.5, 0.5, 0.5}],
  ViewMatrix->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewRange->All,
  ViewVector->Automatic,
  ViewVertical->{0, 0, 1}]], "Output",
 CellLabel->"Out[11]=",
 CellID->82223370]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 24.5171600}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Graphics3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 70, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[882, 35, 1057, 33, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[1964, 72, 70, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[2037, 75, 284, 9, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[2324, 86, 541, 15, 70, "Input",
 CellID->2087330327],
Cell[CellGroupData[{
Cell[2890, 105, 465, 14, 70, "Input",
 CellID->467948497],
Cell[3358, 121, 2967, 54, 70, "Output",
 CellID->558987983]
}, Open  ]],
Cell[6340, 178, 215, 7, 70, "UpgradeDetail",
 CellID->1247190321],
Cell[6558, 187, 721, 22, 70, "Input",
 CellID->1817558303],
Cell[CellGroupData[{
Cell[7304, 213, 696, 21, 70, "Input",
 CellID->2142902541],
Cell[8003, 236, 25857, 432, 70, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33921, 675, 72, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[33996, 678, 318, 10, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[34317, 690, 1044, 34, 70, "Input",
 CellID->1915518068],
Cell[CellGroupData[{
Cell[35386, 728, 1128, 37, 70, "Input",
 CellID->1184816699],
Cell[36517, 767, 1934, 63, 70, "Output",
 CellID->59611569]
}, Open  ]],
Cell[38466, 833, 702, 24, 70, "UpgradeDetail",
 CellID->2132010364],
Cell[39171, 859, 1665, 51, 70, "Input",
 CellID->872050956],
Cell[CellGroupData[{
Cell[40861, 914, 1579, 49, 70, "Input",
 CellID->1637229832],
Cell[42443, 965, 1935, 63, 70, "Output",
 CellID->364241831]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44427, 1034, 72, 1, 70, "UpgradePackageSection",
 CellID->1411404028],
Cell[44502, 1037, 282, 9, 70, "UpgradeDetail",
 CellID->363133834],
Cell[44787, 1048, 360, 12, 70, "UpgradePackageListing",
 CellID->41823264],
Cell[45150, 1062, 215, 7, 70, "UpgradeDetail",
 CellID->1909047094],
Cell[45368, 1071, 585, 15, 70, "Input",
 CellID->1653650426],
Cell[CellGroupData[{
Cell[45978, 1090, 667, 18, 70, "Input",
 CellID->169350308],
Cell[46648, 1110, 5948, 128, 70, "Output",
 CellID->294301743]
}, Open  ]],
Cell[52611, 1241, 702, 24, 70, "UpgradeDetail",
 CellID->1933537553],
Cell[53316, 1267, 645, 17, 70, "Input",
 CellID->1243106867],
Cell[CellGroupData[{
Cell[53986, 1288, 562, 15, 70, "Input",
 CellID->28712006],
Cell[54551, 1305, 3042, 80, 70, "Output",
 CellID->666911732]
}, Open  ]],
Cell[57608, 1388, 371, 13, 70, "UpgradeDetail",
 CellID->1012768853],
Cell[57982, 1403, 491, 13, 70, "Input",
 CellID->2128829195],
Cell[CellGroupData[{
Cell[58498, 1420, 500, 15, 70, "Input",
 CellID->650726249],
Cell[59001, 1437, 2798, 80, 70, "Output",
 CellID->82223370]
}, Open  ]]
}, Open  ]],
Cell[61826, 1521, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

