(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25386,        600]
NotebookOptionsPosition[     23178,        526]
NotebookOutlinePosition[     24457,        567]
CellTagsIndexPosition[     24387,        562]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`ImplicitPlot`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " in the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel now accepts equations."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " can plot implicit curves:"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`ImplicitPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1746043248],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1mAtsjXcYxo+y2ZK1s02WsExpO0xcNtS6DK+lyRK7aY2NRKYhrqOMoNNa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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1FdUEAQYBWBAlmxENiJDAWXvJQhUlllZtG1YWJqZ0FAb5myn2VAr01Lb
u7RhO9vZsKysTG1PVzu39nF8+O7/fs+5f3ZHV3tnYEBAwEGi+wbRg2BCCCWM
cHoSQSRRRBNDLHHE04sEepNIEsmkkEoa6WTQh0z6kkU2OeTSj/7kkU8BAxhI
IUUUU0IpZZRTQSVVVFNDLXXU00Ajg2iimcG00EpbdxcczCEM4VAOYyiHM4wj
OJKjGM7RHEM7x3Icx3MCJ3ISJzOCUziV0zidkZzBmXQwirM4m9GM4RzGci7j
OI/xdNLF+VzAhVzEBCYyiYu5hEu5jMlczhSmMo3pzGAmV3AlV3E113At13E9
s5jNDczhRm7iZm5hLvOYz63cxu0s4A4Wsog7uYvFLGEpd3MP93If9/MAD/IQ
D/MIj/IYj/MET7KM5TzF0zzDs6zgOZ7nBV7kJV7mFV5lJa/xOm/wJm/xNu/w
Lqt4j/f5gA9ZzUd8zBo+4VM+Yy2f8wVfso6vWM8GNvI13/At3/E9P/AjP/Ez
v/Arv7GJzWxhK9v4nT/4k7/4m3/4l//Yzg52sovd7GEv+9hP9/gDCaIHwYQQ
Shjh9CSCSKKIJoZY4oinFwn0JpEkkkkhlTTSyaAPmfQli2xyyKUf/ckjnwIG
MJBCiiimhFLKKKeCSqqopoZa6qingUYG0UQzg2mhlbbAA7/wf46diqI=
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, 
       "Tooltip"]& ]}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[21]=",
 CellID->2125697993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1974199735],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourStyle"]], "InlineFormula"],
 " is used in place of ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->576789230],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`ImplicitPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], "2"], "\[Equal]", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"]}]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], "2"], "\[Equal]", 
      RowBox[{"2", " ", "x", " ", "y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".03", "}"}], "]"}]}], "}"}]}]}], "]"}]}], "Input", \
"LegacyInput",
 CellTags->"S5.34.1",
 CellLabel->"In[1]:=",
 CellID->651122681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], "2"], "\[Equal]", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"]}]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], "2"], "\[Equal]", 
      RowBox[{"2", " ", "x", " ", "y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ContourStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".03", "}"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"S5.34.1",
 CellLabel->"In[2]:=",
 CellID->355406052],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmglUjesXxo8hM5GQ8XJ1TdcYbtzrb5sukTLPs2SISBEyz7OSDCHR7RpD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   "], {{}, {}, 
    {GrayLevel[0], 
     TagBox[
      TooltipBox[
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
        159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
        173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
        187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 
        201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 
        215, 216, 217, 218, 219, 220}],
       RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}], ")"}], "2"], "\[Equal]", 
         RowBox[{
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]}]],
      Annotation[#, ($CellContext`x^2 + $CellContext`y^2)^2 == \
$CellContext`x^2 - $CellContext`y^2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 
        233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 
        247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 
        261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 
        275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 
        289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 
        303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 
        317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 
        331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 
        345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 
        359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 
        373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 
        387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 
        401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 
        415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 
        429, 430, 431, 432, 433, 434}],
       RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}], ")"}], "2"], "\[Equal]", 
         RowBox[{
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]}]],
      Annotation[#, ($CellContext`x^2 + $CellContext`y^2)^2 == \
$CellContext`x^2 - $CellContext`y^2, "Tooltip"]& ]}, 
    {Dashing[{0.03}], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwV0/WfDwYAxvHv3ek43Xm6Zhhj2gzTMc0wbCaGzeQmNjFMz6bbSnd3N3e6
806cbifffnh//oDn9XrCWnep1zkoEAj0keWsYCWrWM0a1rKO9WxgI5vYzBa2
so3t7GAnu9jNHvayj/0c4CCHOMwRwongKMc4zglOcorTnOEs5zjPBS5yictc
4SrXiCSK69zgJreI5jZ3uMs97vOAhzziMU94yjOe84IYXvKK17zh7fvhggOB
IIIJIRaxiUNc4hGfBCQkEYkJJQlJSUZyUpCSVKQmDWlJR3oykJFMZCYLWQkj
G9nJQU5ykZs85CUf+SnABxTkQwpRmCJ8RFGK8THFKcEnlKQUpSlDWcpRngp8
SkU+oxKVqcLnVKUa1alBTWpRmzrUpR5fUJ8GNKQRjWlCU5rRnC9pQUta8RWt
aUNbvuYb2vEt7elARzrxHZ3pQle+5we68SPd6UFPetGbPvzEz/SlH/0ZwC/8
ykAGMZgh/MZQhjGc3xnBSEYxmjGMZRx/MJ4/+YsJTGQSk5nCVKYxnRnMZBaz
mcNc/uYf/uU//mce81nAQhaxmCUsZRnLWcFKVrGaNaxlHevZwEY2sZktbGUb
29nBTnaxmz3sZR/7OcBBDnGYI4QTwVGOcZwTnOQUpznDWc5xngtc5BKXucJV
rhFJFNe5wU1uEc1t7nCXe9znAQ95xGOe8JRnPOcFMbzkFa95w1sCIf5PMCHE
IjZxiEs84pOAhCQiMaEkISnJSE4KUpKK1KQhLelITwYykonMZCErYWQjOznI
SS5yk4e85CM/BXgH+nvJpg==
        "]],
       RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}], ")"}], "2"], "\[Equal]", 
         RowBox[{"2", " ", "x", " ", "y"}]}]],
      Annotation[#, ($CellContext`x^2 + $CellContext`y^2)^2 == 
       2 $CellContext`x $CellContext`y, "Tooltip"]& ]}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->"S5.34.1",
 CellLabel->"Out[2]=",
 CellID->2089018673]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 28.2672560}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ImplicitPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S5.34.1"->{
  Cell[6881, 194, 1075, 35, 70, "Input",
   CellTags->"S5.34.1",
   CellID->651122681],
  Cell[7981, 233, 1063, 35, 70, "Input",
   CellTags->"S5.34.1",
   CellID->355406052],
  Cell[9047, 270, 14077, 250, 70, "Output",
   CellTags->"S5.34.1",
   CellID->2089018673]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S5.34.1", 24095, 549}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 72, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[884, 35, 288, 10, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1175, 47, 211, 7, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1389, 56, 496, 16, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1910, 76, 415, 14, 70, "Input",
 CellID->1746043248],
Cell[2328, 92, 4071, 80, 70, "Output",
 CellID->2125697993]
}, Open  ]],
Cell[6414, 175, 126, 3, 70, "ExampleDelimiter",
 CellID->1974199735],
Cell[6543, 180, 335, 12, 70, "UpgradeDetail",
 CellID->576789230],
Cell[6881, 194, 1075, 35, 70, "Input",
 CellTags->"S5.34.1",
 CellID->651122681],
Cell[CellGroupData[{
Cell[7981, 233, 1063, 35, 70, "Input",
 CellTags->"S5.34.1",
 CellID->355406052],
Cell[9047, 270, 14077, 250, 70, "Output",
 CellTags->"S5.34.1",
 CellID->2089018673]
}, Open  ]]
}, Open  ]],
Cell[23151, 524, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

