(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    107280,       1967]
NotebookOptionsPosition[    104873,       1891]
NotebookOutlinePosition[    105840,       1919]
CellTagsIndexPosition[    105797,       1916]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`PlotField3D`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["Graphics`PlotField3D`"], "InlineFormula"],
 " is available in the newly created ",
 ButtonBox["Vector Field Plotting Package",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/guide/VectorFieldPlottingPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Load ",
 Cell[BoxData["VectorFieldPlots`"], "InlineFormula"],
 " to use the",
 " ",
 ButtonBox["Vector Field Plotting Package",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/guide/VectorFieldPlottingPackage"],
 "."
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "Graphics`PlotField3D`"}], ";"}]], "Input", "LegacyInput",
 CellID->2075400188],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "VectorFieldPlots`"}], ";"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->1821565142],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1824744232],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VectorFieldPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot3D"]], 
  "InlineFormula"],
 " contains the functionality of ",
 Cell[BoxData["PlotVectorField3D"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->510952580],

Cell[BoxData[
 RowBox[{"PlotVectorField3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->998512136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y", ",", "z"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1725607045],

Cell[BoxData[
 Graphics3DBox[{Line3DBox[{{0., 0., 0.}, {0., 0., 0.}}], 
   Line3DBox[{{0., 0., 0.16666666666666666`}, {0., 0., 
    0.18270417414415627`}}], 
   Line3DBox[{{0., 0., 0.3333333333333333}, {0., 0., 0.36540834828831253`}}], 
   Line3DBox[{{0., 0., 0.5}, {0., 0., 0.5481125224324688}}], 
   Line3DBox[{{0., 0., 0.6666666666666666}, {0., 0., 0.7308166965766251}}], 
   Line3DBox[{{0., 0., 0.8333333333333334}, {0., 0., 0.9135208707207814}}], 
   Line3DBox[{{0., 0., 1.}, {0., 0., 1.0962250448649375`}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.}, {0., 0.18270417414415627`, 
    0.}}], Line3DBox[{{0., 0.16666666666666666`, 0.16666666666666666`}, {0., 
    0.18270417414415627`, 0.18270417414415627`}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.3333333333333333}, {0., 
    0.18270417414415627`, 0.36540834828831253`}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.5}, {0., 0.18270417414415627`, 
    0.5481125224324688}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.6666666666666666}, {0., 
    0.18270417414415627`, 0.7308166965766251}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.8333333333333334}, {0., 
    0.18270417414415627`, 0.9135208707207814}}], 
   Line3DBox[{{0., 0.16666666666666666`, 1.}, {0., 0.18270417414415627`, 
    1.0962250448649375`}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.}, {0., 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.16666666666666666`}, {0., 
    0.36540834828831253`, 0.18270417414415627`}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.3333333333333333}, {0., 
    0.36540834828831253`, 0.36540834828831253`}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.5}, {0., 0.36540834828831253`, 
    0.5481125224324688}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.6666666666666666}, {0., 
    0.36540834828831253`, 0.7308166965766251}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.8333333333333334}, {0., 
    0.36540834828831253`, 0.9135208707207814}}], 
   Line3DBox[{{0., 0.3333333333333333, 1.}, {0., 0.36540834828831253`, 
    1.0962250448649375`}}], 
   Line3DBox[{{0., 0.5, 0.}, {0., 0.5481125224324688, 0.}}], 
   Line3DBox[{{0., 0.5, 0.16666666666666666`}, {0., 0.5481125224324688, 
    0.18270417414415627`}}], 
   Line3DBox[{{0., 0.5, 0.3333333333333333}, {0., 0.5481125224324688, 
    0.36540834828831253`}}], 
   Line3DBox[{{0., 0.5, 0.5}, {0., 0.5481125224324688, 0.5481125224324688}}], 
   Line3DBox[{{0., 0.5, 0.6666666666666666}, {0., 0.5481125224324688, 
    0.7308166965766251}}], 
   Line3DBox[{{0., 0.5, 0.8333333333333334}, {0., 0.5481125224324688, 
    0.9135208707207814}}], 
   Line3DBox[{{0., 0.5, 1.}, {0., 0.5481125224324688, 1.0962250448649375`}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.}, {0., 0.7308166965766251, 0.}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.16666666666666666`}, {0., 
    0.7308166965766251, 0.18270417414415627`}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.3333333333333333}, {0., 
    0.7308166965766251, 0.36540834828831253`}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.5}, {0., 0.7308166965766251, 
    0.5481125224324688}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.6666666666666666}, {0., 
    0.7308166965766251, 0.7308166965766251}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.8333333333333334}, {0., 
    0.7308166965766251, 0.9135208707207814}}], 
   Line3DBox[{{0., 0.6666666666666666, 1.}, {0., 0.7308166965766251, 
    1.0962250448649375`}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.}, {0., 0.9135208707207814, 0.}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.16666666666666666`}, {0., 
    0.9135208707207814, 0.18270417414415627`}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.3333333333333333}, {0., 
    0.9135208707207814, 0.36540834828831253`}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.5}, {0., 0.9135208707207814, 
    0.5481125224324688}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.6666666666666666}, {0., 
    0.9135208707207814, 0.7308166965766251}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.8333333333333334}, {0., 
    0.9135208707207814, 0.9135208707207814}}], 
   Line3DBox[{{0., 0.8333333333333334, 1.}, {0., 0.9135208707207814, 
    1.0962250448649375`}}], 
   Line3DBox[{{0., 1., 0.}, {0., 1.0962250448649375`, 0.}}], 
   Line3DBox[{{0., 1., 0.16666666666666666`}, {0., 1.0962250448649375`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0., 1., 0.3333333333333333}, {0., 1.0962250448649375`, 
    0.36540834828831253`}}], 
   Line3DBox[{{0., 1., 0.5}, {0., 1.0962250448649375`, 0.5481125224324688}}], 
   Line3DBox[{{0., 1., 0.6666666666666666}, {0., 1.0962250448649375`, 
    0.7308166965766251}}], 
   Line3DBox[{{0., 1., 0.8333333333333334}, {0., 1.0962250448649375`, 
    0.9135208707207814}}], 
   Line3DBox[{{0., 1., 1.}, {0., 1.0962250448649375`, 1.0962250448649375`}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.}, {0.18270417414415627`, 0., 
    0.}}], Line3DBox[{{0.16666666666666666`, 0., 0.16666666666666666`}, {
    0.18270417414415627`, 0., 0.18270417414415627`}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.3333333333333333}, {
    0.18270417414415627`, 0., 0.36540834828831253`}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.5}, {0.18270417414415627`, 0., 
    0.5481125224324688}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.6666666666666666}, {
    0.18270417414415627`, 0., 0.7308166965766251}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.8333333333333334}, {
    0.18270417414415627`, 0., 0.9135208707207814}}], 
   Line3DBox[{{0.16666666666666666`, 0., 1.}, {0.18270417414415627`, 0., 
    1.0962250448649375`}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 0.}, {
    0.18270417414415627`, 0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 
    0.16666666666666666`}, {0.18270417414415627`, 0.18270417414415627`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 
    0.3333333333333333}, {0.18270417414415627`, 0.18270417414415627`, 
    0.36540834828831253`}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 0.5}, {
    0.18270417414415627`, 0.18270417414415627`, 0.5481125224324688}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 
    0.6666666666666666}, {0.18270417414415627`, 0.18270417414415627`, 
    0.7308166965766251}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 
    0.8333333333333334}, {0.18270417414415627`, 0.18270417414415627`, 
    0.9135208707207814}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 1.}, {
    0.18270417414415627`, 0.18270417414415627`, 1.0962250448649375`}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 0.}, {
    0.18270417414415627`, 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 
    0.16666666666666666`}, {0.18270417414415627`, 0.36540834828831253`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 
    0.3333333333333333}, {0.18270417414415627`, 0.36540834828831253`, 
    0.36540834828831253`}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 0.5}, {
    0.18270417414415627`, 0.36540834828831253`, 0.5481125224324688}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 
    0.6666666666666666}, {0.18270417414415627`, 0.36540834828831253`, 
    0.7308166965766251}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 
    0.8333333333333334}, {0.18270417414415627`, 0.36540834828831253`, 
    0.9135208707207814}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 1.}, {
    0.18270417414415627`, 0.36540834828831253`, 1.0962250448649375`}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.}, {0.18270417414415627`, 
    0.5481125224324688, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.16666666666666666`}, {
    0.18270417414415627`, 0.5481125224324688, 0.18270417414415627`}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.3333333333333333}, {
    0.18270417414415627`, 0.5481125224324688, 0.36540834828831253`}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.5}, {0.18270417414415627`, 
    0.5481125224324688, 0.5481125224324688}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.6666666666666666}, {
    0.18270417414415627`, 0.5481125224324688, 0.7308166965766251}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.8333333333333334}, {
    0.18270417414415627`, 0.5481125224324688, 0.9135208707207814}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 1.}, {0.18270417414415627`, 
    0.5481125224324688, 1.0962250448649375`}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 0.}, {
    0.18270417414415627`, 0.7308166965766251, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 
    0.16666666666666666`}, {0.18270417414415627`, 0.7308166965766251, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 
    0.3333333333333333}, {0.18270417414415627`, 0.7308166965766251, 
    0.36540834828831253`}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 0.5}, {
    0.18270417414415627`, 0.7308166965766251, 0.5481125224324688}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 
    0.6666666666666666}, {0.18270417414415627`, 0.7308166965766251, 
    0.7308166965766251}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 
    0.8333333333333334}, {0.18270417414415627`, 0.7308166965766251, 
    0.9135208707207814}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 1.}, {
    0.18270417414415627`, 0.7308166965766251, 1.0962250448649375`}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 0.}, {
    0.18270417414415627`, 0.9135208707207814, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 
    0.16666666666666666`}, {0.18270417414415627`, 0.9135208707207814, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 
    0.3333333333333333}, {0.18270417414415627`, 0.9135208707207814, 
    0.36540834828831253`}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 0.5}, {
    0.18270417414415627`, 0.9135208707207814, 0.5481125224324688}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 
    0.6666666666666666}, {0.18270417414415627`, 0.9135208707207814, 
    0.7308166965766251}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 
    0.8333333333333334}, {0.18270417414415627`, 0.9135208707207814, 
    0.9135208707207814}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 1.}, {
    0.18270417414415627`, 0.9135208707207814, 1.0962250448649375`}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.}, {0.18270417414415627`, 
    1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.16666666666666666`}, {
    0.18270417414415627`, 1.0962250448649375`, 0.18270417414415627`}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.3333333333333333}, {
    0.18270417414415627`, 1.0962250448649375`, 0.36540834828831253`}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.5}, {0.18270417414415627`, 
    1.0962250448649375`, 0.5481125224324688}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.6666666666666666}, {
    0.18270417414415627`, 1.0962250448649375`, 0.7308166965766251}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.8333333333333334}, {
    0.18270417414415627`, 1.0962250448649375`, 0.9135208707207814}}], 
   Line3DBox[{{0.16666666666666666`, 1., 1.}, {0.18270417414415627`, 
    1.0962250448649375`, 1.0962250448649375`}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.}, {0.36540834828831253`, 0., 0.}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.16666666666666666`}, {
    0.36540834828831253`, 0., 0.18270417414415627`}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.3333333333333333}, {
    0.36540834828831253`, 0., 0.36540834828831253`}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.5}, {0.36540834828831253`, 0., 
    0.5481125224324688}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.6666666666666666}, {
    0.36540834828831253`, 0., 0.7308166965766251}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.8333333333333334}, {
    0.36540834828831253`, 0., 0.9135208707207814}}], 
   Line3DBox[{{0.3333333333333333, 0., 1.}, {0.36540834828831253`, 0., 
    1.0962250448649375`}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 0.}, {
    0.36540834828831253`, 0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 
    0.16666666666666666`}, {0.36540834828831253`, 0.18270417414415627`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 
    0.3333333333333333}, {0.36540834828831253`, 0.18270417414415627`, 
    0.36540834828831253`}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 0.5}, {
    0.36540834828831253`, 0.18270417414415627`, 0.5481125224324688}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 
    0.6666666666666666}, {0.36540834828831253`, 0.18270417414415627`, 
    0.7308166965766251}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 
    0.8333333333333334}, {0.36540834828831253`, 0.18270417414415627`, 
    0.9135208707207814}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 1.}, {
    0.36540834828831253`, 0.18270417414415627`, 1.0962250448649375`}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.}, {
    0.36540834828831253`, 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 
    0.16666666666666666`}, {0.36540834828831253`, 0.36540834828831253`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.3333333333333333}, {
    0.36540834828831253`, 0.36540834828831253`, 0.36540834828831253`}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.5}, {
    0.36540834828831253`, 0.36540834828831253`, 0.5481125224324688}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.6666666666666666}, {
    0.36540834828831253`, 0.36540834828831253`, 0.7308166965766251}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.8333333333333334}, {
    0.36540834828831253`, 0.36540834828831253`, 0.9135208707207814}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 1.}, {
    0.36540834828831253`, 0.36540834828831253`, 1.0962250448649375`}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.}, {0.36540834828831253`, 
    0.5481125224324688, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.16666666666666666`}, {
    0.36540834828831253`, 0.5481125224324688, 0.18270417414415627`}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.3333333333333333}, {
    0.36540834828831253`, 0.5481125224324688, 0.36540834828831253`}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.5}, {0.36540834828831253`, 
    0.5481125224324688, 0.5481125224324688}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.6666666666666666}, {
    0.36540834828831253`, 0.5481125224324688, 0.7308166965766251}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.8333333333333334}, {
    0.36540834828831253`, 0.5481125224324688, 0.9135208707207814}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 1.}, {0.36540834828831253`, 
    0.5481125224324688, 1.0962250448649375`}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.}, {
    0.36540834828831253`, 0.7308166965766251, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 
    0.16666666666666666`}, {0.36540834828831253`, 0.7308166965766251, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.3333333333333333}, {
    0.36540834828831253`, 0.7308166965766251, 0.36540834828831253`}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.5}, {
    0.36540834828831253`, 0.7308166965766251, 0.5481125224324688}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.6666666666666666}, {
    0.36540834828831253`, 0.7308166965766251, 0.7308166965766251}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.8333333333333334}, {
    0.36540834828831253`, 0.7308166965766251, 0.9135208707207814}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 1.}, {
    0.36540834828831253`, 0.7308166965766251, 1.0962250448649375`}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.}, {
    0.36540834828831253`, 0.9135208707207814, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 
    0.16666666666666666`}, {0.36540834828831253`, 0.9135208707207814, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.3333333333333333}, {
    0.36540834828831253`, 0.9135208707207814, 0.36540834828831253`}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.5}, {
    0.36540834828831253`, 0.9135208707207814, 0.5481125224324688}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.6666666666666666}, {
    0.36540834828831253`, 0.9135208707207814, 0.7308166965766251}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.8333333333333334}, {
    0.36540834828831253`, 0.9135208707207814, 0.9135208707207814}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 1.}, {
    0.36540834828831253`, 0.9135208707207814, 1.0962250448649375`}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.}, {0.36540834828831253`, 
    1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.16666666666666666`}, {
    0.36540834828831253`, 1.0962250448649375`, 0.18270417414415627`}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.3333333333333333}, {
    0.36540834828831253`, 1.0962250448649375`, 0.36540834828831253`}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.5}, {0.36540834828831253`, 
    1.0962250448649375`, 0.5481125224324688}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.6666666666666666}, {
    0.36540834828831253`, 1.0962250448649375`, 0.7308166965766251}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.8333333333333334}, {
    0.36540834828831253`, 1.0962250448649375`, 0.9135208707207814}}], 
   Line3DBox[{{0.3333333333333333, 1., 1.}, {0.36540834828831253`, 
    1.0962250448649375`, 1.0962250448649375`}}], 
   Line3DBox[{{0.5, 0., 0.}, {0.5481125224324688, 0., 0.}}], 
   Line3DBox[{{0.5, 0., 0.16666666666666666`}, {0.5481125224324688, 0., 
    0.18270417414415627`}}], 
   Line3DBox[{{0.5, 0., 0.3333333333333333}, {0.5481125224324688, 0., 
    0.36540834828831253`}}], 
   Line3DBox[{{0.5, 0., 0.5}, {0.5481125224324688, 0., 0.5481125224324688}}], 
   Line3DBox[{{0.5, 0., 0.6666666666666666}, {0.5481125224324688, 0., 
    0.7308166965766251}}], 
   Line3DBox[{{0.5, 0., 0.8333333333333334}, {0.5481125224324688, 0., 
    0.9135208707207814}}], 
   Line3DBox[{{0.5, 0., 1.}, {0.5481125224324688, 0., 1.0962250448649375`}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.}, {0.5481125224324688, 
    0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.16666666666666666`}, {
    0.5481125224324688, 0.18270417414415627`, 0.18270417414415627`}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.3333333333333333}, {
    0.5481125224324688, 0.18270417414415627`, 0.36540834828831253`}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.5}, {0.5481125224324688, 
    0.18270417414415627`, 0.5481125224324688}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.6666666666666666}, {
    0.5481125224324688, 0.18270417414415627`, 0.7308166965766251}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.8333333333333334}, {
    0.5481125224324688, 0.18270417414415627`, 0.9135208707207814}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 1.}, {0.5481125224324688, 
    0.18270417414415627`, 1.0962250448649375`}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.}, {0.5481125224324688, 
    0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.16666666666666666`}, {
    0.5481125224324688, 0.36540834828831253`, 0.18270417414415627`}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.3333333333333333}, {
    0.5481125224324688, 0.36540834828831253`, 0.36540834828831253`}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.5}, {0.5481125224324688, 
    0.36540834828831253`, 0.5481125224324688}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.6666666666666666}, {
    0.5481125224324688, 0.36540834828831253`, 0.7308166965766251}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.8333333333333334}, {
    0.5481125224324688, 0.36540834828831253`, 0.9135208707207814}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 1.}, {0.5481125224324688, 
    0.36540834828831253`, 1.0962250448649375`}}], 
   Line3DBox[{{0.5, 0.5, 0.}, {0.5481125224324688, 0.5481125224324688, 0.}}], 
   Line3DBox[{{0.5, 0.5, 0.16666666666666666`}, {0.5481125224324688, 
    0.5481125224324688, 0.18270417414415627`}}], 
   Line3DBox[{{0.5, 0.5, 0.3333333333333333}, {0.5481125224324688, 
    0.5481125224324688, 0.36540834828831253`}}], 
   Line3DBox[{{0.5, 0.5, 0.5}, {0.5481125224324688, 0.5481125224324688, 
    0.5481125224324688}}], 
   Line3DBox[{{0.5, 0.5, 0.6666666666666666}, {0.5481125224324688, 
    0.5481125224324688, 0.7308166965766251}}], 
   Line3DBox[{{0.5, 0.5, 0.8333333333333334}, {0.5481125224324688, 
    0.5481125224324688, 0.9135208707207814}}], 
   Line3DBox[{{0.5, 0.5, 1.}, {0.5481125224324688, 0.5481125224324688, 
    1.0962250448649375`}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.}, {0.5481125224324688, 
    0.7308166965766251, 0.}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.16666666666666666`}, {
    0.5481125224324688, 0.7308166965766251, 0.18270417414415627`}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.3333333333333333}, {
    0.5481125224324688, 0.7308166965766251, 0.36540834828831253`}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.5}, {0.5481125224324688, 
    0.7308166965766251, 0.5481125224324688}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.6666666666666666}, {
    0.5481125224324688, 0.7308166965766251, 0.7308166965766251}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.8333333333333334}, {
    0.5481125224324688, 0.7308166965766251, 0.9135208707207814}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 1.}, {0.5481125224324688, 
    0.7308166965766251, 1.0962250448649375`}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.}, {0.5481125224324688, 
    0.9135208707207814, 0.}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.16666666666666666`}, {
    0.5481125224324688, 0.9135208707207814, 0.18270417414415627`}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.3333333333333333}, {
    0.5481125224324688, 0.9135208707207814, 0.36540834828831253`}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.5}, {0.5481125224324688, 
    0.9135208707207814, 0.5481125224324688}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.6666666666666666}, {
    0.5481125224324688, 0.9135208707207814, 0.7308166965766251}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.8333333333333334}, {
    0.5481125224324688, 0.9135208707207814, 0.9135208707207814}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 1.}, {0.5481125224324688, 
    0.9135208707207814, 1.0962250448649375`}}], 
   Line3DBox[{{0.5, 1., 0.}, {0.5481125224324688, 1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.5, 1., 0.16666666666666666`}, {0.5481125224324688, 
    1.0962250448649375`, 0.18270417414415627`}}], 
   Line3DBox[{{0.5, 1., 0.3333333333333333}, {0.5481125224324688, 
    1.0962250448649375`, 0.36540834828831253`}}], 
   Line3DBox[{{0.5, 1., 0.5}, {0.5481125224324688, 1.0962250448649375`, 
    0.5481125224324688}}], 
   Line3DBox[{{0.5, 1., 0.6666666666666666}, {0.5481125224324688, 
    1.0962250448649375`, 0.7308166965766251}}], 
   Line3DBox[{{0.5, 1., 0.8333333333333334}, {0.5481125224324688, 
    1.0962250448649375`, 0.9135208707207814}}], 
   Line3DBox[{{0.5, 1., 1.}, {0.5481125224324688, 1.0962250448649375`, 
    1.0962250448649375`}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.}, {0.7308166965766251, 0., 0.}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.16666666666666666`}, {
    0.7308166965766251, 0., 0.18270417414415627`}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.3333333333333333}, {
    0.7308166965766251, 0., 0.36540834828831253`}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.5}, {0.7308166965766251, 0., 
    0.5481125224324688}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.6666666666666666}, {
    0.7308166965766251, 0., 0.7308166965766251}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.8333333333333334}, {
    0.7308166965766251, 0., 0.9135208707207814}}], 
   Line3DBox[{{0.6666666666666666, 0., 1.}, {0.7308166965766251, 0., 
    1.0962250448649375`}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 0.}, {
    0.7308166965766251, 0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 
    0.16666666666666666`}, {0.7308166965766251, 0.18270417414415627`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 
    0.3333333333333333}, {0.7308166965766251, 0.18270417414415627`, 
    0.36540834828831253`}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 0.5}, {
    0.7308166965766251, 0.18270417414415627`, 0.5481125224324688}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 
    0.6666666666666666}, {0.7308166965766251, 0.18270417414415627`, 
    0.7308166965766251}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 
    0.8333333333333334}, {0.7308166965766251, 0.18270417414415627`, 
    0.9135208707207814}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 1.}, {
    0.7308166965766251, 0.18270417414415627`, 1.0962250448649375`}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.}, {
    0.7308166965766251, 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 
    0.16666666666666666`}, {0.7308166965766251, 0.36540834828831253`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.3333333333333333}, {
    0.7308166965766251, 0.36540834828831253`, 0.36540834828831253`}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.5}, {
    0.7308166965766251, 0.36540834828831253`, 0.5481125224324688}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.6666666666666666}, {
    0.7308166965766251, 0.36540834828831253`, 0.7308166965766251}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.8333333333333334}, {
    0.7308166965766251, 0.36540834828831253`, 0.9135208707207814}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 1.}, {
    0.7308166965766251, 0.36540834828831253`, 1.0962250448649375`}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.}, {0.7308166965766251, 
    0.5481125224324688, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.16666666666666666`}, {
    0.7308166965766251, 0.5481125224324688, 0.18270417414415627`}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.3333333333333333}, {
    0.7308166965766251, 0.5481125224324688, 0.36540834828831253`}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.5}, {0.7308166965766251, 
    0.5481125224324688, 0.5481125224324688}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.6666666666666666}, {
    0.7308166965766251, 0.5481125224324688, 0.7308166965766251}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.8333333333333334}, {
    0.7308166965766251, 0.5481125224324688, 0.9135208707207814}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 1.}, {0.7308166965766251, 
    0.5481125224324688, 1.0962250448649375`}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.}, {
    0.7308166965766251, 0.7308166965766251, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 
    0.16666666666666666`}, {0.7308166965766251, 0.7308166965766251, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.3333333333333333}, {
    0.7308166965766251, 0.7308166965766251, 0.36540834828831253`}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.5}, {
    0.7308166965766251, 0.7308166965766251, 0.5481125224324688}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.6666666666666666}, {
    0.7308166965766251, 0.7308166965766251, 0.7308166965766251}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.8333333333333334}, {
    0.7308166965766251, 0.7308166965766251, 0.9135208707207814}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 1.}, {
    0.7308166965766251, 0.7308166965766251, 1.0962250448649375`}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.}, {
    0.7308166965766251, 0.9135208707207814, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 
    0.16666666666666666`}, {0.7308166965766251, 0.9135208707207814, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.3333333333333333}, {
    0.7308166965766251, 0.9135208707207814, 0.36540834828831253`}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.5}, {
    0.7308166965766251, 0.9135208707207814, 0.5481125224324688}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.6666666666666666}, {
    0.7308166965766251, 0.9135208707207814, 0.7308166965766251}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.8333333333333334}, {
    0.7308166965766251, 0.9135208707207814, 0.9135208707207814}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 1.}, {
    0.7308166965766251, 0.9135208707207814, 1.0962250448649375`}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.}, {0.7308166965766251, 
    1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.16666666666666666`}, {
    0.7308166965766251, 1.0962250448649375`, 0.18270417414415627`}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.3333333333333333}, {
    0.7308166965766251, 1.0962250448649375`, 0.36540834828831253`}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.5}, {0.7308166965766251, 
    1.0962250448649375`, 0.5481125224324688}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.6666666666666666}, {
    0.7308166965766251, 1.0962250448649375`, 0.7308166965766251}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.8333333333333334}, {
    0.7308166965766251, 1.0962250448649375`, 0.9135208707207814}}], 
   Line3DBox[{{0.6666666666666666, 1., 1.}, {0.7308166965766251, 
    1.0962250448649375`, 1.0962250448649375`}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.}, {0.9135208707207814, 0., 0.}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.16666666666666666`}, {
    0.9135208707207814, 0., 0.18270417414415627`}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.3333333333333333}, {
    0.9135208707207814, 0., 0.36540834828831253`}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.5}, {0.9135208707207814, 0., 
    0.5481125224324688}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.6666666666666666}, {
    0.9135208707207814, 0., 0.7308166965766251}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.8333333333333334}, {
    0.9135208707207814, 0., 0.9135208707207814}}], 
   Line3DBox[{{0.8333333333333334, 0., 1.}, {0.9135208707207814, 0., 
    1.0962250448649375`}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 0.}, {
    0.9135208707207814, 0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 
    0.16666666666666666`}, {0.9135208707207814, 0.18270417414415627`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 
    0.3333333333333333}, {0.9135208707207814, 0.18270417414415627`, 
    0.36540834828831253`}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 0.5}, {
    0.9135208707207814, 0.18270417414415627`, 0.5481125224324688}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 
    0.6666666666666666}, {0.9135208707207814, 0.18270417414415627`, 
    0.7308166965766251}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 
    0.8333333333333334}, {0.9135208707207814, 0.18270417414415627`, 
    0.9135208707207814}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 1.}, {
    0.9135208707207814, 0.18270417414415627`, 1.0962250448649375`}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.}, {
    0.9135208707207814, 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 
    0.16666666666666666`}, {0.9135208707207814, 0.36540834828831253`, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.3333333333333333}, {
    0.9135208707207814, 0.36540834828831253`, 0.36540834828831253`}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.5}, {
    0.9135208707207814, 0.36540834828831253`, 0.5481125224324688}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.6666666666666666}, {
    0.9135208707207814, 0.36540834828831253`, 0.7308166965766251}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.8333333333333334}, {
    0.9135208707207814, 0.36540834828831253`, 0.9135208707207814}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 1.}, {
    0.9135208707207814, 0.36540834828831253`, 1.0962250448649375`}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.}, {0.9135208707207814, 
    0.5481125224324688, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.16666666666666666`}, {
    0.9135208707207814, 0.5481125224324688, 0.18270417414415627`}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.3333333333333333}, {
    0.9135208707207814, 0.5481125224324688, 0.36540834828831253`}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.5}, {0.9135208707207814, 
    0.5481125224324688, 0.5481125224324688}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.6666666666666666}, {
    0.9135208707207814, 0.5481125224324688, 0.7308166965766251}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.8333333333333334}, {
    0.9135208707207814, 0.5481125224324688, 0.9135208707207814}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 1.}, {0.9135208707207814, 
    0.5481125224324688, 1.0962250448649375`}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.}, {
    0.9135208707207814, 0.7308166965766251, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 
    0.16666666666666666`}, {0.9135208707207814, 0.7308166965766251, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.3333333333333333}, {
    0.9135208707207814, 0.7308166965766251, 0.36540834828831253`}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.5}, {
    0.9135208707207814, 0.7308166965766251, 0.5481125224324688}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.6666666666666666}, {
    0.9135208707207814, 0.7308166965766251, 0.7308166965766251}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.8333333333333334}, {
    0.9135208707207814, 0.7308166965766251, 0.9135208707207814}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 1.}, {
    0.9135208707207814, 0.7308166965766251, 1.0962250448649375`}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.}, {
    0.9135208707207814, 0.9135208707207814, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 
    0.16666666666666666`}, {0.9135208707207814, 0.9135208707207814, 
    0.18270417414415627`}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.3333333333333333}, {
    0.9135208707207814, 0.9135208707207814, 0.36540834828831253`}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.5}, {
    0.9135208707207814, 0.9135208707207814, 0.5481125224324688}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.6666666666666666}, {
    0.9135208707207814, 0.9135208707207814, 0.7308166965766251}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.8333333333333334}, {
    0.9135208707207814, 0.9135208707207814, 0.9135208707207814}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 1.}, {
    0.9135208707207814, 0.9135208707207814, 1.0962250448649375`}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.}, {0.9135208707207814, 
    1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.16666666666666666`}, {
    0.9135208707207814, 1.0962250448649375`, 0.18270417414415627`}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.3333333333333333}, {
    0.9135208707207814, 1.0962250448649375`, 0.36540834828831253`}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.5}, {0.9135208707207814, 
    1.0962250448649375`, 0.5481125224324688}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.6666666666666666}, {
    0.9135208707207814, 1.0962250448649375`, 0.7308166965766251}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.8333333333333334}, {
    0.9135208707207814, 1.0962250448649375`, 0.9135208707207814}}], 
   Line3DBox[{{0.8333333333333334, 1., 1.}, {0.9135208707207814, 
    1.0962250448649375`, 1.0962250448649375`}}], 
   Line3DBox[{{1., 0., 0.}, {1.0962250448649375`, 0., 0.}}], 
   Line3DBox[{{1., 0., 0.16666666666666666`}, {1.0962250448649375`, 0., 
    0.18270417414415627`}}], 
   Line3DBox[{{1., 0., 0.3333333333333333}, {1.0962250448649375`, 0., 
    0.36540834828831253`}}], 
   Line3DBox[{{1., 0., 0.5}, {1.0962250448649375`, 0., 0.5481125224324688}}], 
   Line3DBox[{{1., 0., 0.6666666666666666}, {1.0962250448649375`, 0., 
    0.7308166965766251}}], 
   Line3DBox[{{1., 0., 0.8333333333333334}, {1.0962250448649375`, 0., 
    0.9135208707207814}}], 
   Line3DBox[{{1., 0., 1.}, {1.0962250448649375`, 0., 1.0962250448649375`}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.}, {1.0962250448649375`, 
    0.18270417414415627`, 0.}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.16666666666666666`}, {
    1.0962250448649375`, 0.18270417414415627`, 0.18270417414415627`}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.3333333333333333}, {
    1.0962250448649375`, 0.18270417414415627`, 0.36540834828831253`}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.5}, {1.0962250448649375`, 
    0.18270417414415627`, 0.5481125224324688}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.6666666666666666}, {
    1.0962250448649375`, 0.18270417414415627`, 0.7308166965766251}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.8333333333333334}, {
    1.0962250448649375`, 0.18270417414415627`, 0.9135208707207814}}], 
   Line3DBox[{{1., 0.16666666666666666`, 1.}, {1.0962250448649375`, 
    0.18270417414415627`, 1.0962250448649375`}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.}, {1.0962250448649375`, 
    0.36540834828831253`, 0.}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.16666666666666666`}, {
    1.0962250448649375`, 0.36540834828831253`, 0.18270417414415627`}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.3333333333333333}, {
    1.0962250448649375`, 0.36540834828831253`, 0.36540834828831253`}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.5}, {1.0962250448649375`, 
    0.36540834828831253`, 0.5481125224324688}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.6666666666666666}, {
    1.0962250448649375`, 0.36540834828831253`, 0.7308166965766251}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.8333333333333334}, {
    1.0962250448649375`, 0.36540834828831253`, 0.9135208707207814}}], 
   Line3DBox[{{1., 0.3333333333333333, 1.}, {1.0962250448649375`, 
    0.36540834828831253`, 1.0962250448649375`}}], 
   Line3DBox[{{1., 0.5, 0.}, {1.0962250448649375`, 0.5481125224324688, 0.}}], 
   Line3DBox[{{1., 0.5, 0.16666666666666666`}, {1.0962250448649375`, 
    0.5481125224324688, 0.18270417414415627`}}], 
   Line3DBox[{{1., 0.5, 0.3333333333333333}, {1.0962250448649375`, 
    0.5481125224324688, 0.36540834828831253`}}], 
   Line3DBox[{{1., 0.5, 0.5}, {1.0962250448649375`, 0.5481125224324688, 
    0.5481125224324688}}], 
   Line3DBox[{{1., 0.5, 0.6666666666666666}, {1.0962250448649375`, 
    0.5481125224324688, 0.7308166965766251}}], 
   Line3DBox[{{1., 0.5, 0.8333333333333334}, {1.0962250448649375`, 
    0.5481125224324688, 0.9135208707207814}}], 
   Line3DBox[{{1., 0.5, 1.}, {1.0962250448649375`, 0.5481125224324688, 
    1.0962250448649375`}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.}, {1.0962250448649375`, 
    0.7308166965766251, 0.}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.16666666666666666`}, {
    1.0962250448649375`, 0.7308166965766251, 0.18270417414415627`}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.3333333333333333}, {
    1.0962250448649375`, 0.7308166965766251, 0.36540834828831253`}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.5}, {1.0962250448649375`, 
    0.7308166965766251, 0.5481125224324688}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.6666666666666666}, {
    1.0962250448649375`, 0.7308166965766251, 0.7308166965766251}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.8333333333333334}, {
    1.0962250448649375`, 0.7308166965766251, 0.9135208707207814}}], 
   Line3DBox[{{1., 0.6666666666666666, 1.}, {1.0962250448649375`, 
    0.7308166965766251, 1.0962250448649375`}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.}, {1.0962250448649375`, 
    0.9135208707207814, 0.}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.16666666666666666`}, {
    1.0962250448649375`, 0.9135208707207814, 0.18270417414415627`}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.3333333333333333}, {
    1.0962250448649375`, 0.9135208707207814, 0.36540834828831253`}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.5}, {1.0962250448649375`, 
    0.9135208707207814, 0.5481125224324688}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.6666666666666666}, {
    1.0962250448649375`, 0.9135208707207814, 0.7308166965766251}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.8333333333333334}, {
    1.0962250448649375`, 0.9135208707207814, 0.9135208707207814}}], 
   Line3DBox[{{1., 0.8333333333333334, 1.}, {1.0962250448649375`, 
    0.9135208707207814, 1.0962250448649375`}}], 
   Line3DBox[{{1., 1., 0.}, {1.0962250448649375`, 1.0962250448649375`, 0.}}], 
   Line3DBox[{{1., 1., 0.16666666666666666`}, {1.0962250448649375`, 
    1.0962250448649375`, 0.18270417414415627`}}], 
   Line3DBox[{{1., 1., 0.3333333333333333}, {1.0962250448649375`, 
    1.0962250448649375`, 0.36540834828831253`}}], 
   Line3DBox[{{1., 1., 0.5}, {1.0962250448649375`, 1.0962250448649375`, 
    0.5481125224324688}}], 
   Line3DBox[{{1., 1., 0.6666666666666666}, {1.0962250448649375`, 
    1.0962250448649375`, 0.7308166965766251}}], 
   Line3DBox[{{1., 1., 0.8333333333333334}, {1.0962250448649375`, 
    1.0962250448649375`, 0.9135208707207814}}], 
   Line3DBox[{{1., 1., 1.}, {1.0962250448649375`, 1.0962250448649375`, 
    1.0962250448649375`}}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->2056984575]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->262344417],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListVectorFieldPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/ListVectorFieldPlot3D"]], 
  "InlineFormula"],
 " contains the functionality of ",
 Cell[BoxData["ListPlotVectorField3D"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->518469962],

Cell[BoxData[
 RowBox[{"ListPlotVectorField3D", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", " ", "y", ",", "z"}], "}"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "0", ",", " ", "1", ",", "0.2"}], "}"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"y", ",", " ", "0", ",", " ", "1", ",", "0.2"}], "}"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"z", ",", " ", "0", ",", " ", "1", ",", "0.2"}], "}"}]}], 
     "]"}], ",", "2"}], "]"}], "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->1583495455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListVectorFieldPlot3D", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", " ", "y", ",", "z"}], "}"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "0", ",", " ", "1", ",", "0.2"}], "}"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"y", ",", " ", "0", ",", " ", "1", ",", "0.2"}], "}"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"z", ",", " ", "0", ",", " ", "1", ",", "0.2"}], "}"}]}], 
     "]"}], ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43274914],

Cell[BoxData[
 Graphics3DBox[{Line3DBox[{{0., 0., 0.}, {0., 0., 0.}}], 
   Line3DBox[{{0., 0., 0.2}, {0., 0., 0.4}}], 
   Line3DBox[{{0., 0., 0.4}, {0., 0., 0.8}}], 
   Line3DBox[{{0., 0., 0.6000000000000001}, {0., 0., 1.2000000000000002`}}], 
   Line3DBox[{{0., 0., 0.8}, {0., 0., 1.6}}], 
   Line3DBox[{{0., 0., 1.}, {0., 0., 2.}}], 
   Line3DBox[{{0., 0.2, 0.}, {0., 0.4, 0.}}], 
   Line3DBox[{{0., 0.2, 0.2}, {0., 0.4, 0.4}}], 
   Line3DBox[{{0., 0.2, 0.4}, {0., 0.4, 0.8}}], 
   Line3DBox[{{0., 0.2, 0.6000000000000001}, {0., 0.4, 1.2000000000000002`}}],
    Line3DBox[{{0., 0.2, 0.8}, {0., 0.4, 1.6}}], 
   Line3DBox[{{0., 0.2, 1.}, {0., 0.4, 2.}}], 
   Line3DBox[{{0., 0.4, 0.}, {0., 0.8, 0.}}], 
   Line3DBox[{{0., 0.4, 0.2}, {0., 0.8, 0.4}}], 
   Line3DBox[{{0., 0.4, 0.4}, {0., 0.8, 0.8}}], 
   Line3DBox[{{0., 0.4, 0.6000000000000001}, {0., 0.8, 1.2000000000000002`}}],
    Line3DBox[{{0., 0.4, 0.8}, {0., 0.8, 1.6}}], 
   Line3DBox[{{0., 0.4, 1.}, {0., 0.8, 2.}}], 
   Line3DBox[{{0., 0.6000000000000001, 0.}, {0., 1.2000000000000002`, 0.}}], 
   Line3DBox[{{0., 0.6000000000000001, 0.2}, {0., 1.2000000000000002`, 0.4}}],
    Line3DBox[{{0., 0.6000000000000001, 0.4}, {0., 1.2000000000000002`, 
    0.8}}], Line3DBox[{{0., 0.6000000000000001, 0.6000000000000001}, {0., 
    1.2000000000000002`, 1.2000000000000002`}}], 
   Line3DBox[{{0., 0.6000000000000001, 0.8}, {0., 1.2000000000000002`, 1.6}}],
    Line3DBox[{{0., 0.6000000000000001, 1.}, {0., 1.2000000000000002`, 2.}}], 
   Line3DBox[{{0., 0.8, 0.}, {0., 1.6, 0.}}], 
   Line3DBox[{{0., 0.8, 0.2}, {0., 1.6, 0.4}}], 
   Line3DBox[{{0., 0.8, 0.4}, {0., 1.6, 0.8}}], 
   Line3DBox[{{0., 0.8, 0.6000000000000001}, {0., 1.6, 1.2000000000000002`}}],
    Line3DBox[{{0., 0.8, 0.8}, {0., 1.6, 1.6}}], 
   Line3DBox[{{0., 0.8, 1.}, {0., 1.6, 2.}}], 
   Line3DBox[{{0., 1., 0.}, {0., 2., 0.}}], 
   Line3DBox[{{0., 1., 0.2}, {0., 2., 0.4}}], 
   Line3DBox[{{0., 1., 0.4}, {0., 2., 0.8}}], 
   Line3DBox[{{0., 1., 0.6000000000000001}, {0., 2., 1.2000000000000002`}}], 
   Line3DBox[{{0., 1., 0.8}, {0., 2., 1.6}}], 
   Line3DBox[{{0., 1., 1.}, {0., 2., 2.}}], 
   Line3DBox[{{0.2, 0., 0.}, {0.4, 0., 0.}}], 
   Line3DBox[{{0.2, 0., 0.2}, {0.4, 0., 0.4}}], 
   Line3DBox[{{0.2, 0., 0.4}, {0.4, 0., 0.8}}], 
   Line3DBox[{{0.2, 0., 0.6000000000000001}, {0.4, 0., 1.2000000000000002`}}],
    Line3DBox[{{0.2, 0., 0.8}, {0.4, 0., 1.6}}], 
   Line3DBox[{{0.2, 0., 1.}, {0.4, 0., 2.}}], 
   Line3DBox[{{0.2, 0.2, 0.}, {0.4, 0.4, 0.}}], 
   Line3DBox[{{0.2, 0.2, 0.2}, {0.4, 0.4, 0.4}}], 
   Line3DBox[{{0.2, 0.2, 0.4}, {0.4, 0.4, 0.8}}], 
   Line3DBox[{{0.2, 0.2, 0.6000000000000001}, {0.4, 0.4, 
    1.2000000000000002`}}], Line3DBox[{{0.2, 0.2, 0.8}, {0.4, 0.4, 1.6}}], 
   Line3DBox[{{0.2, 0.2, 1.}, {0.4, 0.4, 2.}}], 
   Line3DBox[{{0.2, 0.4, 0.}, {0.4, 0.8, 0.}}], 
   Line3DBox[{{0.2, 0.4, 0.2}, {0.4, 0.8, 0.4}}], 
   Line3DBox[{{0.2, 0.4, 0.4}, {0.4, 0.8, 0.8}}], 
   Line3DBox[{{0.2, 0.4, 0.6000000000000001}, {0.4, 0.8, 
    1.2000000000000002`}}], Line3DBox[{{0.2, 0.4, 0.8}, {0.4, 0.8, 1.6}}], 
   Line3DBox[{{0.2, 0.4, 1.}, {0.4, 0.8, 2.}}], 
   Line3DBox[{{0.2, 0.6000000000000001, 0.}, {0.4, 1.2000000000000002`, 0.}}],
    Line3DBox[{{0.2, 0.6000000000000001, 0.2}, {0.4, 1.2000000000000002`, 
    0.4}}], Line3DBox[{{0.2, 0.6000000000000001, 0.4}, {0.4, 
    1.2000000000000002`, 0.8}}], 
   Line3DBox[{{0.2, 0.6000000000000001, 0.6000000000000001}, {0.4, 
    1.2000000000000002`, 1.2000000000000002`}}], 
   Line3DBox[{{0.2, 0.6000000000000001, 0.8}, {0.4, 1.2000000000000002`, 
    1.6}}], Line3DBox[{{0.2, 0.6000000000000001, 1.}, {0.4, 
    1.2000000000000002`, 2.}}], Line3DBox[{{0.2, 0.8, 0.}, {0.4, 1.6, 0.}}], 
   Line3DBox[{{0.2, 0.8, 0.2}, {0.4, 1.6, 0.4}}], 
   Line3DBox[{{0.2, 0.8, 0.4}, {0.4, 1.6, 0.8}}], 
   Line3DBox[{{0.2, 0.8, 0.6000000000000001}, {0.4, 1.6, 
    1.2000000000000002`}}], Line3DBox[{{0.2, 0.8, 0.8}, {0.4, 1.6, 1.6}}], 
   Line3DBox[{{0.2, 0.8, 1.}, {0.4, 1.6, 2.}}], 
   Line3DBox[{{0.2, 1., 0.}, {0.4, 2., 0.}}], 
   Line3DBox[{{0.2, 1., 0.2}, {0.4, 2., 0.4}}], 
   Line3DBox[{{0.2, 1., 0.4}, {0.4, 2., 0.8}}], 
   Line3DBox[{{0.2, 1., 0.6000000000000001}, {0.4, 2., 1.2000000000000002`}}],
    Line3DBox[{{0.2, 1., 0.8}, {0.4, 2., 1.6}}], 
   Line3DBox[{{0.2, 1., 1.}, {0.4, 2., 2.}}], 
   Line3DBox[{{0.4, 0., 0.}, {0.8, 0., 0.}}], 
   Line3DBox[{{0.4, 0., 0.2}, {0.8, 0., 0.4}}], 
   Line3DBox[{{0.4, 0., 0.4}, {0.8, 0., 0.8}}], 
   Line3DBox[{{0.4, 0., 0.6000000000000001}, {0.8, 0., 1.2000000000000002`}}],
    Line3DBox[{{0.4, 0., 0.8}, {0.8, 0., 1.6}}], 
   Line3DBox[{{0.4, 0., 1.}, {0.8, 0., 2.}}], 
   Line3DBox[{{0.4, 0.2, 0.}, {0.8, 0.4, 0.}}], 
   Line3DBox[{{0.4, 0.2, 0.2}, {0.8, 0.4, 0.4}}], 
   Line3DBox[{{0.4, 0.2, 0.4}, {0.8, 0.4, 0.8}}], 
   Line3DBox[{{0.4, 0.2, 0.6000000000000001}, {0.8, 0.4, 
    1.2000000000000002`}}], Line3DBox[{{0.4, 0.2, 0.8}, {0.8, 0.4, 1.6}}], 
   Line3DBox[{{0.4, 0.2, 1.}, {0.8, 0.4, 2.}}], 
   Line3DBox[{{0.4, 0.4, 0.}, {0.8, 0.8, 0.}}], 
   Line3DBox[{{0.4, 0.4, 0.2}, {0.8, 0.8, 0.4}}], 
   Line3DBox[{{0.4, 0.4, 0.4}, {0.8, 0.8, 0.8}}], 
   Line3DBox[{{0.4, 0.4, 0.6000000000000001}, {0.8, 0.8, 
    1.2000000000000002`}}], Line3DBox[{{0.4, 0.4, 0.8}, {0.8, 0.8, 1.6}}], 
   Line3DBox[{{0.4, 0.4, 1.}, {0.8, 0.8, 2.}}], 
   Line3DBox[{{0.4, 0.6000000000000001, 0.}, {0.8, 1.2000000000000002`, 0.}}],
    Line3DBox[{{0.4, 0.6000000000000001, 0.2}, {0.8, 1.2000000000000002`, 
    0.4}}], Line3DBox[{{0.4, 0.6000000000000001, 0.4}, {0.8, 
    1.2000000000000002`, 0.8}}], 
   Line3DBox[{{0.4, 0.6000000000000001, 0.6000000000000001}, {0.8, 
    1.2000000000000002`, 1.2000000000000002`}}], 
   Line3DBox[{{0.4, 0.6000000000000001, 0.8}, {0.8, 1.2000000000000002`, 
    1.6}}], Line3DBox[{{0.4, 0.6000000000000001, 1.}, {0.8, 
    1.2000000000000002`, 2.}}], Line3DBox[{{0.4, 0.8, 0.}, {0.8, 1.6, 0.}}], 
   Line3DBox[{{0.4, 0.8, 0.2}, {0.8, 1.6, 0.4}}], 
   Line3DBox[{{0.4, 0.8, 0.4}, {0.8, 1.6, 0.8}}], 
   Line3DBox[{{0.4, 0.8, 0.6000000000000001}, {0.8, 1.6, 
    1.2000000000000002`}}], Line3DBox[{{0.4, 0.8, 0.8}, {0.8, 1.6, 1.6}}], 
   Line3DBox[{{0.4, 0.8, 1.}, {0.8, 1.6, 2.}}], 
   Line3DBox[{{0.4, 1., 0.}, {0.8, 2., 0.}}], 
   Line3DBox[{{0.4, 1., 0.2}, {0.8, 2., 0.4}}], 
   Line3DBox[{{0.4, 1., 0.4}, {0.8, 2., 0.8}}], 
   Line3DBox[{{0.4, 1., 0.6000000000000001}, {0.8, 2., 1.2000000000000002`}}],
    Line3DBox[{{0.4, 1., 0.8}, {0.8, 2., 1.6}}], 
   Line3DBox[{{0.4, 1., 1.}, {0.8, 2., 2.}}], 
   Line3DBox[{{0.6000000000000001, 0., 0.}, {1.2000000000000002`, 0., 0.}}], 
   Line3DBox[{{0.6000000000000001, 0., 0.2}, {1.2000000000000002`, 0., 0.4}}],
    Line3DBox[{{0.6000000000000001, 0., 0.4}, {1.2000000000000002`, 0., 
    0.8}}], Line3DBox[{{0.6000000000000001, 0., 0.6000000000000001}, {
    1.2000000000000002`, 0., 1.2000000000000002`}}], 
   Line3DBox[{{0.6000000000000001, 0., 0.8}, {1.2000000000000002`, 0., 1.6}}],
    Line3DBox[{{0.6000000000000001, 0., 1.}, {1.2000000000000002`, 0., 2.}}], 
   Line3DBox[{{0.6000000000000001, 0.2, 0.}, {1.2000000000000002`, 0.4, 0.}}],
    Line3DBox[{{0.6000000000000001, 0.2, 0.2}, {1.2000000000000002`, 0.4, 
    0.4}}], Line3DBox[{{0.6000000000000001, 0.2, 0.4}, {1.2000000000000002`, 
    0.4, 0.8}}], 
   Line3DBox[{{0.6000000000000001, 0.2, 0.6000000000000001}, {
    1.2000000000000002`, 0.4, 1.2000000000000002`}}], 
   Line3DBox[{{0.6000000000000001, 0.2, 0.8}, {1.2000000000000002`, 0.4, 
    1.6}}], Line3DBox[{{0.6000000000000001, 0.2, 1.}, {1.2000000000000002`, 
    0.4, 2.}}], 
   Line3DBox[{{0.6000000000000001, 0.4, 0.}, {1.2000000000000002`, 0.8, 0.}}],
    Line3DBox[{{0.6000000000000001, 0.4, 0.2}, {1.2000000000000002`, 0.8, 
    0.4}}], Line3DBox[{{0.6000000000000001, 0.4, 0.4}, {1.2000000000000002`, 
    0.8, 0.8}}], 
   Line3DBox[{{0.6000000000000001, 0.4, 0.6000000000000001}, {
    1.2000000000000002`, 0.8, 1.2000000000000002`}}], 
   Line3DBox[{{0.6000000000000001, 0.4, 0.8}, {1.2000000000000002`, 0.8, 
    1.6}}], Line3DBox[{{0.6000000000000001, 0.4, 1.}, {1.2000000000000002`, 
    0.8, 2.}}], 
   Line3DBox[{{0.6000000000000001, 0.6000000000000001, 0.}, {
    1.2000000000000002`, 1.2000000000000002`, 0.}}], 
   Line3DBox[{{0.6000000000000001, 0.6000000000000001, 0.2}, {
    1.2000000000000002`, 1.2000000000000002`, 0.4}}], 
   Line3DBox[{{0.6000000000000001, 0.6000000000000001, 0.4}, {
    1.2000000000000002`, 1.2000000000000002`, 0.8}}], 
   Line3DBox[{{0.6000000000000001, 0.6000000000000001, 0.6000000000000001}, {
    1.2000000000000002`, 1.2000000000000002`, 1.2000000000000002`}}], 
   Line3DBox[{{0.6000000000000001, 0.6000000000000001, 0.8}, {
    1.2000000000000002`, 1.2000000000000002`, 1.6}}], 
   Line3DBox[{{0.6000000000000001, 0.6000000000000001, 1.}, {
    1.2000000000000002`, 1.2000000000000002`, 2.}}], 
   Line3DBox[{{0.6000000000000001, 0.8, 0.}, {1.2000000000000002`, 1.6, 0.}}],
    Line3DBox[{{0.6000000000000001, 0.8, 0.2}, {1.2000000000000002`, 1.6, 
    0.4}}], Line3DBox[{{0.6000000000000001, 0.8, 0.4}, {1.2000000000000002`, 
    1.6, 0.8}}], 
   Line3DBox[{{0.6000000000000001, 0.8, 0.6000000000000001}, {
    1.2000000000000002`, 1.6, 1.2000000000000002`}}], 
   Line3DBox[{{0.6000000000000001, 0.8, 0.8}, {1.2000000000000002`, 1.6, 
    1.6}}], Line3DBox[{{0.6000000000000001, 0.8, 1.}, {1.2000000000000002`, 
    1.6, 2.}}], 
   Line3DBox[{{0.6000000000000001, 1., 0.}, {1.2000000000000002`, 2., 0.}}], 
   Line3DBox[{{0.6000000000000001, 1., 0.2}, {1.2000000000000002`, 2., 0.4}}],
    Line3DBox[{{0.6000000000000001, 1., 0.4}, {1.2000000000000002`, 2., 
    0.8}}], Line3DBox[{{0.6000000000000001, 1., 0.6000000000000001}, {
    1.2000000000000002`, 2., 1.2000000000000002`}}], 
   Line3DBox[{{0.6000000000000001, 1., 0.8}, {1.2000000000000002`, 2., 1.6}}],
    Line3DBox[{{0.6000000000000001, 1., 1.}, {1.2000000000000002`, 2., 2.}}], 
   Line3DBox[{{0.8, 0., 0.}, {1.6, 0., 0.}}], 
   Line3DBox[{{0.8, 0., 0.2}, {1.6, 0., 0.4}}], 
   Line3DBox[{{0.8, 0., 0.4}, {1.6, 0., 0.8}}], 
   Line3DBox[{{0.8, 0., 0.6000000000000001}, {1.6, 0., 1.2000000000000002`}}],
    Line3DBox[{{0.8, 0., 0.8}, {1.6, 0., 1.6}}], 
   Line3DBox[{{0.8, 0., 1.}, {1.6, 0., 2.}}], 
   Line3DBox[{{0.8, 0.2, 0.}, {1.6, 0.4, 0.}}], 
   Line3DBox[{{0.8, 0.2, 0.2}, {1.6, 0.4, 0.4}}], 
   Line3DBox[{{0.8, 0.2, 0.4}, {1.6, 0.4, 0.8}}], 
   Line3DBox[{{0.8, 0.2, 0.6000000000000001}, {1.6, 0.4, 
    1.2000000000000002`}}], Line3DBox[{{0.8, 0.2, 0.8}, {1.6, 0.4, 1.6}}], 
   Line3DBox[{{0.8, 0.2, 1.}, {1.6, 0.4, 2.}}], 
   Line3DBox[{{0.8, 0.4, 0.}, {1.6, 0.8, 0.}}], 
   Line3DBox[{{0.8, 0.4, 0.2}, {1.6, 0.8, 0.4}}], 
   Line3DBox[{{0.8, 0.4, 0.4}, {1.6, 0.8, 0.8}}], 
   Line3DBox[{{0.8, 0.4, 0.6000000000000001}, {1.6, 0.8, 
    1.2000000000000002`}}], Line3DBox[{{0.8, 0.4, 0.8}, {1.6, 0.8, 1.6}}], 
   Line3DBox[{{0.8, 0.4, 1.}, {1.6, 0.8, 2.}}], 
   Line3DBox[{{0.8, 0.6000000000000001, 0.}, {1.6, 1.2000000000000002`, 0.}}],
    Line3DBox[{{0.8, 0.6000000000000001, 0.2}, {1.6, 1.2000000000000002`, 
    0.4}}], Line3DBox[{{0.8, 0.6000000000000001, 0.4}, {1.6, 
    1.2000000000000002`, 0.8}}], 
   Line3DBox[{{0.8, 0.6000000000000001, 0.6000000000000001}, {1.6, 
    1.2000000000000002`, 1.2000000000000002`}}], 
   Line3DBox[{{0.8, 0.6000000000000001, 0.8}, {1.6, 1.2000000000000002`, 
    1.6}}], Line3DBox[{{0.8, 0.6000000000000001, 1.}, {1.6, 
    1.2000000000000002`, 2.}}], Line3DBox[{{0.8, 0.8, 0.}, {1.6, 1.6, 0.}}], 
   Line3DBox[{{0.8, 0.8, 0.2}, {1.6, 1.6, 0.4}}], 
   Line3DBox[{{0.8, 0.8, 0.4}, {1.6, 1.6, 0.8}}], 
   Line3DBox[{{0.8, 0.8, 0.6000000000000001}, {1.6, 1.6, 
    1.2000000000000002`}}], Line3DBox[{{0.8, 0.8, 0.8}, {1.6, 1.6, 1.6}}], 
   Line3DBox[{{0.8, 0.8, 1.}, {1.6, 1.6, 2.}}], 
   Line3DBox[{{0.8, 1., 0.}, {1.6, 2., 0.}}], 
   Line3DBox[{{0.8, 1., 0.2}, {1.6, 2., 0.4}}], 
   Line3DBox[{{0.8, 1., 0.4}, {1.6, 2., 0.8}}], 
   Line3DBox[{{0.8, 1., 0.6000000000000001}, {1.6, 2., 1.2000000000000002`}}],
    Line3DBox[{{0.8, 1., 0.8}, {1.6, 2., 1.6}}], 
   Line3DBox[{{0.8, 1., 1.}, {1.6, 2., 2.}}], 
   Line3DBox[{{1., 0., 0.}, {2., 0., 0.}}], 
   Line3DBox[{{1., 0., 0.2}, {2., 0., 0.4}}], 
   Line3DBox[{{1., 0., 0.4}, {2., 0., 0.8}}], 
   Line3DBox[{{1., 0., 0.6000000000000001}, {2., 0., 1.2000000000000002`}}], 
   Line3DBox[{{1., 0., 0.8}, {2., 0., 1.6}}], 
   Line3DBox[{{1., 0., 1.}, {2., 0., 2.}}], 
   Line3DBox[{{1., 0.2, 0.}, {2., 0.4, 0.}}], 
   Line3DBox[{{1., 0.2, 0.2}, {2., 0.4, 0.4}}], 
   Line3DBox[{{1., 0.2, 0.4}, {2., 0.4, 0.8}}], 
   Line3DBox[{{1., 0.2, 0.6000000000000001}, {2., 0.4, 1.2000000000000002`}}],
    Line3DBox[{{1., 0.2, 0.8}, {2., 0.4, 1.6}}], 
   Line3DBox[{{1., 0.2, 1.}, {2., 0.4, 2.}}], 
   Line3DBox[{{1., 0.4, 0.}, {2., 0.8, 0.}}], 
   Line3DBox[{{1., 0.4, 0.2}, {2., 0.8, 0.4}}], 
   Line3DBox[{{1., 0.4, 0.4}, {2., 0.8, 0.8}}], 
   Line3DBox[{{1., 0.4, 0.6000000000000001}, {2., 0.8, 1.2000000000000002`}}],
    Line3DBox[{{1., 0.4, 0.8}, {2., 0.8, 1.6}}], 
   Line3DBox[{{1., 0.4, 1.}, {2., 0.8, 2.}}], 
   Line3DBox[{{1., 0.6000000000000001, 0.}, {2., 1.2000000000000002`, 0.}}], 
   Line3DBox[{{1., 0.6000000000000001, 0.2}, {2., 1.2000000000000002`, 0.4}}],
    Line3DBox[{{1., 0.6000000000000001, 0.4}, {2., 1.2000000000000002`, 
    0.8}}], Line3DBox[{{1., 0.6000000000000001, 0.6000000000000001}, {2., 
    1.2000000000000002`, 1.2000000000000002`}}], 
   Line3DBox[{{1., 0.6000000000000001, 0.8}, {2., 1.2000000000000002`, 1.6}}],
    Line3DBox[{{1., 0.6000000000000001, 1.}, {2., 1.2000000000000002`, 2.}}], 
   Line3DBox[{{1., 0.8, 0.}, {2., 1.6, 0.}}], 
   Line3DBox[{{1., 0.8, 0.2}, {2., 1.6, 0.4}}], 
   Line3DBox[{{1., 0.8, 0.4}, {2., 1.6, 0.8}}], 
   Line3DBox[{{1., 0.8, 0.6000000000000001}, {2., 1.6, 1.2000000000000002`}}],
    Line3DBox[{{1., 0.8, 0.8}, {2., 1.6, 1.6}}], 
   Line3DBox[{{1., 0.8, 1.}, {2., 1.6, 2.}}], 
   Line3DBox[{{1., 1., 0.}, {2., 2., 0.}}], 
   Line3DBox[{{1., 1., 0.2}, {2., 2., 0.4}}], 
   Line3DBox[{{1., 1., 0.4}, {2., 2., 0.8}}], 
   Line3DBox[{{1., 1., 0.6000000000000001}, {2., 2., 1.2000000000000002`}}], 
   Line3DBox[{{1., 1., 0.8}, {2., 2., 1.6}}], 
   Line3DBox[{{1., 1., 1.}, {2., 2., 2.}}]},
  Method->{
   "CylinderPoints" -> {40, 3}, "SpherePoints" -> {40, 30}, "RotationControl" -> 
    "ArcBall"},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVector->Automatic,
  ViewVertical->{0., 0., 1.}]], "Output",
 CellLabel->"Out[2]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->438689228],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GradientFieldPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/GradientFieldPlot3D"]], 
  "InlineFormula"],
 " contains the functionality of ",
 Cell[BoxData["PlotGradientField3D"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1008556544],

Cell[BoxData[
 RowBox[{"PlotVectorField", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->721409237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GradientFieldPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "-", 
    RowBox[{"z", "^", "2"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32375297],

Cell[BoxData[
 Graphics3DBox[{Line3DBox[{{0., 0., 0.}, {0., 0., 0.}}], 
   Line3DBox[{{0., 0., 0.16666666666666666`}, {0., 0., 
    0.15062915918917705`}}], 
   Line3DBox[{{0., 0., 0.3333333333333333}, {0., 0., 0.3012583183783541}}], 
   Line3DBox[{{0., 0., 0.5}, {0., 0., 0.45188747756753117`}}], 
   Line3DBox[{{0., 0., 0.6666666666666666}, {0., 0., 0.6025166367567082}}], 
   Line3DBox[{{0., 0., 0.8333333333333334}, {0., 0., 0.7531457959458854}}], 
   Line3DBox[{{0., 0., 1.}, {0., 0., 0.9037749551350623}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.}, {0., 0.18270417414415627`, 
    0.}}], Line3DBox[{{0., 0.16666666666666666`, 0.16666666666666666`}, {0., 
    0.18270417414415627`, 0.15062915918917705`}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.3333333333333333}, {0., 
    0.18270417414415627`, 0.3012583183783541}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.5}, {0., 0.18270417414415627`, 
    0.45188747756753117`}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.6666666666666666}, {0., 
    0.18270417414415627`, 0.6025166367567082}}], 
   Line3DBox[{{0., 0.16666666666666666`, 0.8333333333333334}, {0., 
    0.18270417414415627`, 0.7531457959458854}}], 
   Line3DBox[{{0., 0.16666666666666666`, 1.}, {0., 0.18270417414415627`, 
    0.9037749551350623}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.}, {0., 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.16666666666666666`}, {0., 
    0.36540834828831253`, 0.15062915918917705`}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.3333333333333333}, {0., 
    0.36540834828831253`, 0.3012583183783541}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.5}, {0., 0.36540834828831253`, 
    0.45188747756753117`}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.6666666666666666}, {0., 
    0.36540834828831253`, 0.6025166367567082}}], 
   Line3DBox[{{0., 0.3333333333333333, 0.8333333333333334}, {0., 
    0.36540834828831253`, 0.7531457959458854}}], 
   Line3DBox[{{0., 0.3333333333333333, 1.}, {0., 0.36540834828831253`, 
    0.9037749551350623}}], 
   Line3DBox[{{0., 0.5, 0.}, {0., 0.5481125224324688, 0.}}], 
   Line3DBox[{{0., 0.5, 0.16666666666666666`}, {0., 0.5481125224324688, 
    0.15062915918917705`}}], 
   Line3DBox[{{0., 0.5, 0.3333333333333333}, {0., 0.5481125224324688, 
    0.3012583183783541}}], 
   Line3DBox[{{0., 0.5, 0.5}, {0., 0.5481125224324688, 
    0.45188747756753117`}}], 
   Line3DBox[{{0., 0.5, 0.6666666666666666}, {0., 0.5481125224324688, 
    0.6025166367567082}}], 
   Line3DBox[{{0., 0.5, 0.8333333333333334}, {0., 0.5481125224324688, 
    0.7531457959458854}}], 
   Line3DBox[{{0., 0.5, 1.}, {0., 0.5481125224324688, 0.9037749551350623}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.}, {0., 0.7308166965766251, 0.}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.16666666666666666`}, {0., 
    0.7308166965766251, 0.15062915918917705`}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.3333333333333333}, {0., 
    0.7308166965766251, 0.3012583183783541}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.5}, {0., 0.7308166965766251, 
    0.45188747756753117`}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.6666666666666666}, {0., 
    0.7308166965766251, 0.6025166367567082}}], 
   Line3DBox[{{0., 0.6666666666666666, 0.8333333333333334}, {0., 
    0.7308166965766251, 0.7531457959458854}}], 
   Line3DBox[{{0., 0.6666666666666666, 1.}, {0., 0.7308166965766251, 
    0.9037749551350623}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.}, {0., 0.9135208707207814, 0.}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.16666666666666666`}, {0., 
    0.9135208707207814, 0.15062915918917705`}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.3333333333333333}, {0., 
    0.9135208707207814, 0.3012583183783541}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.5}, {0., 0.9135208707207814, 
    0.45188747756753117`}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.6666666666666666}, {0., 
    0.9135208707207814, 0.6025166367567082}}], 
   Line3DBox[{{0., 0.8333333333333334, 0.8333333333333334}, {0., 
    0.9135208707207814, 0.7531457959458854}}], 
   Line3DBox[{{0., 0.8333333333333334, 1.}, {0., 0.9135208707207814, 
    0.9037749551350623}}], 
   Line3DBox[{{0., 1., 0.}, {0., 1.0962250448649375`, 0.}}], 
   Line3DBox[{{0., 1., 0.16666666666666666`}, {0., 1.0962250448649375`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0., 1., 0.3333333333333333}, {0., 1.0962250448649375`, 
    0.3012583183783541}}], 
   Line3DBox[{{0., 1., 0.5}, {0., 1.0962250448649375`, 
    0.45188747756753117`}}], 
   Line3DBox[{{0., 1., 0.6666666666666666}, {0., 1.0962250448649375`, 
    0.6025166367567082}}], 
   Line3DBox[{{0., 1., 0.8333333333333334}, {0., 1.0962250448649375`, 
    0.7531457959458854}}], 
   Line3DBox[{{0., 1., 1.}, {0., 1.0962250448649375`, 0.9037749551350623}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.}, {0.18270417414415627`, 0., 
    0.}}], Line3DBox[{{0.16666666666666666`, 0., 0.16666666666666666`}, {
    0.18270417414415627`, 0., 0.15062915918917705`}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.3333333333333333}, {
    0.18270417414415627`, 0., 0.3012583183783541}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.5}, {0.18270417414415627`, 0., 
    0.45188747756753117`}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.6666666666666666}, {
    0.18270417414415627`, 0., 0.6025166367567082}}], 
   Line3DBox[{{0.16666666666666666`, 0., 0.8333333333333334}, {
    0.18270417414415627`, 0., 0.7531457959458854}}], 
   Line3DBox[{{0.16666666666666666`, 0., 1.}, {0.18270417414415627`, 0., 
    0.9037749551350623}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 0.}, {
    0.18270417414415627`, 0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 
    0.16666666666666666`}, {0.18270417414415627`, 0.18270417414415627`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 
    0.3333333333333333}, {0.18270417414415627`, 0.18270417414415627`, 
    0.3012583183783541}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 0.5}, {
    0.18270417414415627`, 0.18270417414415627`, 0.45188747756753117`}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 
    0.6666666666666666}, {0.18270417414415627`, 0.18270417414415627`, 
    0.6025166367567082}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 
    0.8333333333333334}, {0.18270417414415627`, 0.18270417414415627`, 
    0.7531457959458854}}], 
   Line3DBox[{{0.16666666666666666`, 0.16666666666666666`, 1.}, {
    0.18270417414415627`, 0.18270417414415627`, 0.9037749551350623}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 0.}, {
    0.18270417414415627`, 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 
    0.16666666666666666`}, {0.18270417414415627`, 0.36540834828831253`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 
    0.3333333333333333}, {0.18270417414415627`, 0.36540834828831253`, 
    0.3012583183783541}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 0.5}, {
    0.18270417414415627`, 0.36540834828831253`, 0.45188747756753117`}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 
    0.6666666666666666}, {0.18270417414415627`, 0.36540834828831253`, 
    0.6025166367567082}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 
    0.8333333333333334}, {0.18270417414415627`, 0.36540834828831253`, 
    0.7531457959458854}}], 
   Line3DBox[{{0.16666666666666666`, 0.3333333333333333, 1.}, {
    0.18270417414415627`, 0.36540834828831253`, 0.9037749551350623}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.}, {0.18270417414415627`, 
    0.5481125224324688, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.16666666666666666`}, {
    0.18270417414415627`, 0.5481125224324688, 0.15062915918917705`}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.3333333333333333}, {
    0.18270417414415627`, 0.5481125224324688, 0.3012583183783541}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.5}, {0.18270417414415627`, 
    0.5481125224324688, 0.45188747756753117`}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.6666666666666666}, {
    0.18270417414415627`, 0.5481125224324688, 0.6025166367567082}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 0.8333333333333334}, {
    0.18270417414415627`, 0.5481125224324688, 0.7531457959458854}}], 
   Line3DBox[{{0.16666666666666666`, 0.5, 1.}, {0.18270417414415627`, 
    0.5481125224324688, 0.9037749551350623}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 0.}, {
    0.18270417414415627`, 0.7308166965766251, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 
    0.16666666666666666`}, {0.18270417414415627`, 0.7308166965766251, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 
    0.3333333333333333}, {0.18270417414415627`, 0.7308166965766251, 
    0.3012583183783541}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 0.5}, {
    0.18270417414415627`, 0.7308166965766251, 0.45188747756753117`}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 
    0.6666666666666666}, {0.18270417414415627`, 0.7308166965766251, 
    0.6025166367567082}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 
    0.8333333333333334}, {0.18270417414415627`, 0.7308166965766251, 
    0.7531457959458854}}], 
   Line3DBox[{{0.16666666666666666`, 0.6666666666666666, 1.}, {
    0.18270417414415627`, 0.7308166965766251, 0.9037749551350623}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 0.}, {
    0.18270417414415627`, 0.9135208707207814, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 
    0.16666666666666666`}, {0.18270417414415627`, 0.9135208707207814, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 
    0.3333333333333333}, {0.18270417414415627`, 0.9135208707207814, 
    0.3012583183783541}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 0.5}, {
    0.18270417414415627`, 0.9135208707207814, 0.45188747756753117`}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 
    0.6666666666666666}, {0.18270417414415627`, 0.9135208707207814, 
    0.6025166367567082}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 
    0.8333333333333334}, {0.18270417414415627`, 0.9135208707207814, 
    0.7531457959458854}}], 
   Line3DBox[{{0.16666666666666666`, 0.8333333333333334, 1.}, {
    0.18270417414415627`, 0.9135208707207814, 0.9037749551350623}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.}, {0.18270417414415627`, 
    1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.16666666666666666`}, {
    0.18270417414415627`, 1.0962250448649375`, 0.15062915918917705`}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.3333333333333333}, {
    0.18270417414415627`, 1.0962250448649375`, 0.3012583183783541}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.5}, {0.18270417414415627`, 
    1.0962250448649375`, 0.45188747756753117`}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.6666666666666666}, {
    0.18270417414415627`, 1.0962250448649375`, 0.6025166367567082}}], 
   Line3DBox[{{0.16666666666666666`, 1., 0.8333333333333334}, {
    0.18270417414415627`, 1.0962250448649375`, 0.7531457959458854}}], 
   Line3DBox[{{0.16666666666666666`, 1., 1.}, {0.18270417414415627`, 
    1.0962250448649375`, 0.9037749551350623}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.}, {0.36540834828831253`, 0., 0.}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.16666666666666666`}, {
    0.36540834828831253`, 0., 0.15062915918917705`}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.3333333333333333}, {
    0.36540834828831253`, 0., 0.3012583183783541}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.5}, {0.36540834828831253`, 0., 
    0.45188747756753117`}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.6666666666666666}, {
    0.36540834828831253`, 0., 0.6025166367567082}}], 
   Line3DBox[{{0.3333333333333333, 0., 0.8333333333333334}, {
    0.36540834828831253`, 0., 0.7531457959458854}}], 
   Line3DBox[{{0.3333333333333333, 0., 1.}, {0.36540834828831253`, 0., 
    0.9037749551350623}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 0.}, {
    0.36540834828831253`, 0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 
    0.16666666666666666`}, {0.36540834828831253`, 0.18270417414415627`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 
    0.3333333333333333}, {0.36540834828831253`, 0.18270417414415627`, 
    0.3012583183783541}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 0.5}, {
    0.36540834828831253`, 0.18270417414415627`, 0.45188747756753117`}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 
    0.6666666666666666}, {0.36540834828831253`, 0.18270417414415627`, 
    0.6025166367567082}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 
    0.8333333333333334}, {0.36540834828831253`, 0.18270417414415627`, 
    0.7531457959458854}}], 
   Line3DBox[{{0.3333333333333333, 0.16666666666666666`, 1.}, {
    0.36540834828831253`, 0.18270417414415627`, 0.9037749551350623}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.}, {
    0.36540834828831253`, 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 
    0.16666666666666666`}, {0.36540834828831253`, 0.36540834828831253`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.3333333333333333}, {
    0.36540834828831253`, 0.36540834828831253`, 0.3012583183783541}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.5}, {
    0.36540834828831253`, 0.36540834828831253`, 0.45188747756753117`}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.6666666666666666}, {
    0.36540834828831253`, 0.36540834828831253`, 0.6025166367567082}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 0.8333333333333334}, {
    0.36540834828831253`, 0.36540834828831253`, 0.7531457959458854}}], 
   Line3DBox[{{0.3333333333333333, 0.3333333333333333, 1.}, {
    0.36540834828831253`, 0.36540834828831253`, 0.9037749551350623}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.}, {0.36540834828831253`, 
    0.5481125224324688, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.16666666666666666`}, {
    0.36540834828831253`, 0.5481125224324688, 0.15062915918917705`}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.3333333333333333}, {
    0.36540834828831253`, 0.5481125224324688, 0.3012583183783541}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.5}, {0.36540834828831253`, 
    0.5481125224324688, 0.45188747756753117`}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.6666666666666666}, {
    0.36540834828831253`, 0.5481125224324688, 0.6025166367567082}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 0.8333333333333334}, {
    0.36540834828831253`, 0.5481125224324688, 0.7531457959458854}}], 
   Line3DBox[{{0.3333333333333333, 0.5, 1.}, {0.36540834828831253`, 
    0.5481125224324688, 0.9037749551350623}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.}, {
    0.36540834828831253`, 0.7308166965766251, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 
    0.16666666666666666`}, {0.36540834828831253`, 0.7308166965766251, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.3333333333333333}, {
    0.36540834828831253`, 0.7308166965766251, 0.3012583183783541}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.5}, {
    0.36540834828831253`, 0.7308166965766251, 0.45188747756753117`}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.6666666666666666}, {
    0.36540834828831253`, 0.7308166965766251, 0.6025166367567082}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 0.8333333333333334}, {
    0.36540834828831253`, 0.7308166965766251, 0.7531457959458854}}], 
   Line3DBox[{{0.3333333333333333, 0.6666666666666666, 1.}, {
    0.36540834828831253`, 0.7308166965766251, 0.9037749551350623}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.}, {
    0.36540834828831253`, 0.9135208707207814, 0.}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 
    0.16666666666666666`}, {0.36540834828831253`, 0.9135208707207814, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.3333333333333333}, {
    0.36540834828831253`, 0.9135208707207814, 0.3012583183783541}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.5}, {
    0.36540834828831253`, 0.9135208707207814, 0.45188747756753117`}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.6666666666666666}, {
    0.36540834828831253`, 0.9135208707207814, 0.6025166367567082}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 0.8333333333333334}, {
    0.36540834828831253`, 0.9135208707207814, 0.7531457959458854}}], 
   Line3DBox[{{0.3333333333333333, 0.8333333333333334, 1.}, {
    0.36540834828831253`, 0.9135208707207814, 0.9037749551350623}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.}, {0.36540834828831253`, 
    1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.16666666666666666`}, {
    0.36540834828831253`, 1.0962250448649375`, 0.15062915918917705`}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.3333333333333333}, {
    0.36540834828831253`, 1.0962250448649375`, 0.3012583183783541}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.5}, {0.36540834828831253`, 
    1.0962250448649375`, 0.45188747756753117`}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.6666666666666666}, {
    0.36540834828831253`, 1.0962250448649375`, 0.6025166367567082}}], 
   Line3DBox[{{0.3333333333333333, 1., 0.8333333333333334}, {
    0.36540834828831253`, 1.0962250448649375`, 0.7531457959458854}}], 
   Line3DBox[{{0.3333333333333333, 1., 1.}, {0.36540834828831253`, 
    1.0962250448649375`, 0.9037749551350623}}], 
   Line3DBox[{{0.5, 0., 0.}, {0.5481125224324688, 0., 0.}}], 
   Line3DBox[{{0.5, 0., 0.16666666666666666`}, {0.5481125224324688, 0., 
    0.15062915918917705`}}], 
   Line3DBox[{{0.5, 0., 0.3333333333333333}, {0.5481125224324688, 0., 
    0.3012583183783541}}], 
   Line3DBox[{{0.5, 0., 0.5}, {0.5481125224324688, 0., 
    0.45188747756753117`}}], 
   Line3DBox[{{0.5, 0., 0.6666666666666666}, {0.5481125224324688, 0., 
    0.6025166367567082}}], 
   Line3DBox[{{0.5, 0., 0.8333333333333334}, {0.5481125224324688, 0., 
    0.7531457959458854}}], 
   Line3DBox[{{0.5, 0., 1.}, {0.5481125224324688, 0., 0.9037749551350623}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.}, {0.5481125224324688, 
    0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.16666666666666666`}, {
    0.5481125224324688, 0.18270417414415627`, 0.15062915918917705`}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.3333333333333333}, {
    0.5481125224324688, 0.18270417414415627`, 0.3012583183783541}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.5}, {0.5481125224324688, 
    0.18270417414415627`, 0.45188747756753117`}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.6666666666666666}, {
    0.5481125224324688, 0.18270417414415627`, 0.6025166367567082}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 0.8333333333333334}, {
    0.5481125224324688, 0.18270417414415627`, 0.7531457959458854}}], 
   Line3DBox[{{0.5, 0.16666666666666666`, 1.}, {0.5481125224324688, 
    0.18270417414415627`, 0.9037749551350623}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.}, {0.5481125224324688, 
    0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.16666666666666666`}, {
    0.5481125224324688, 0.36540834828831253`, 0.15062915918917705`}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.3333333333333333}, {
    0.5481125224324688, 0.36540834828831253`, 0.3012583183783541}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.5}, {0.5481125224324688, 
    0.36540834828831253`, 0.45188747756753117`}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.6666666666666666}, {
    0.5481125224324688, 0.36540834828831253`, 0.6025166367567082}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 0.8333333333333334}, {
    0.5481125224324688, 0.36540834828831253`, 0.7531457959458854}}], 
   Line3DBox[{{0.5, 0.3333333333333333, 1.}, {0.5481125224324688, 
    0.36540834828831253`, 0.9037749551350623}}], 
   Line3DBox[{{0.5, 0.5, 0.}, {0.5481125224324688, 0.5481125224324688, 0.}}], 
   Line3DBox[{{0.5, 0.5, 0.16666666666666666`}, {0.5481125224324688, 
    0.5481125224324688, 0.15062915918917705`}}], 
   Line3DBox[{{0.5, 0.5, 0.3333333333333333}, {0.5481125224324688, 
    0.5481125224324688, 0.3012583183783541}}], 
   Line3DBox[{{0.5, 0.5, 0.5}, {0.5481125224324688, 0.5481125224324688, 
    0.45188747756753117`}}], 
   Line3DBox[{{0.5, 0.5, 0.6666666666666666}, {0.5481125224324688, 
    0.5481125224324688, 0.6025166367567082}}], 
   Line3DBox[{{0.5, 0.5, 0.8333333333333334}, {0.5481125224324688, 
    0.5481125224324688, 0.7531457959458854}}], 
   Line3DBox[{{0.5, 0.5, 1.}, {0.5481125224324688, 0.5481125224324688, 
    0.9037749551350623}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.}, {0.5481125224324688, 
    0.7308166965766251, 0.}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.16666666666666666`}, {
    0.5481125224324688, 0.7308166965766251, 0.15062915918917705`}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.3333333333333333}, {
    0.5481125224324688, 0.7308166965766251, 0.3012583183783541}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.5}, {0.5481125224324688, 
    0.7308166965766251, 0.45188747756753117`}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.6666666666666666}, {
    0.5481125224324688, 0.7308166965766251, 0.6025166367567082}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 0.8333333333333334}, {
    0.5481125224324688, 0.7308166965766251, 0.7531457959458854}}], 
   Line3DBox[{{0.5, 0.6666666666666666, 1.}, {0.5481125224324688, 
    0.7308166965766251, 0.9037749551350623}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.}, {0.5481125224324688, 
    0.9135208707207814, 0.}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.16666666666666666`}, {
    0.5481125224324688, 0.9135208707207814, 0.15062915918917705`}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.3333333333333333}, {
    0.5481125224324688, 0.9135208707207814, 0.3012583183783541}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.5}, {0.5481125224324688, 
    0.9135208707207814, 0.45188747756753117`}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.6666666666666666}, {
    0.5481125224324688, 0.9135208707207814, 0.6025166367567082}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 0.8333333333333334}, {
    0.5481125224324688, 0.9135208707207814, 0.7531457959458854}}], 
   Line3DBox[{{0.5, 0.8333333333333334, 1.}, {0.5481125224324688, 
    0.9135208707207814, 0.9037749551350623}}], 
   Line3DBox[{{0.5, 1., 0.}, {0.5481125224324688, 1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.5, 1., 0.16666666666666666`}, {0.5481125224324688, 
    1.0962250448649375`, 0.15062915918917705`}}], 
   Line3DBox[{{0.5, 1., 0.3333333333333333}, {0.5481125224324688, 
    1.0962250448649375`, 0.3012583183783541}}], 
   Line3DBox[{{0.5, 1., 0.5}, {0.5481125224324688, 1.0962250448649375`, 
    0.45188747756753117`}}], 
   Line3DBox[{{0.5, 1., 0.6666666666666666}, {0.5481125224324688, 
    1.0962250448649375`, 0.6025166367567082}}], 
   Line3DBox[{{0.5, 1., 0.8333333333333334}, {0.5481125224324688, 
    1.0962250448649375`, 0.7531457959458854}}], 
   Line3DBox[{{0.5, 1., 1.}, {0.5481125224324688, 1.0962250448649375`, 
    0.9037749551350623}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.}, {0.7308166965766251, 0., 0.}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.16666666666666666`}, {
    0.7308166965766251, 0., 0.15062915918917705`}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.3333333333333333}, {
    0.7308166965766251, 0., 0.3012583183783541}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.5}, {0.7308166965766251, 0., 
    0.45188747756753117`}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.6666666666666666}, {
    0.7308166965766251, 0., 0.6025166367567082}}], 
   Line3DBox[{{0.6666666666666666, 0., 0.8333333333333334}, {
    0.7308166965766251, 0., 0.7531457959458854}}], 
   Line3DBox[{{0.6666666666666666, 0., 1.}, {0.7308166965766251, 0., 
    0.9037749551350623}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 0.}, {
    0.7308166965766251, 0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 
    0.16666666666666666`}, {0.7308166965766251, 0.18270417414415627`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 
    0.3333333333333333}, {0.7308166965766251, 0.18270417414415627`, 
    0.3012583183783541}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 0.5}, {
    0.7308166965766251, 0.18270417414415627`, 0.45188747756753117`}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 
    0.6666666666666666}, {0.7308166965766251, 0.18270417414415627`, 
    0.6025166367567082}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 
    0.8333333333333334}, {0.7308166965766251, 0.18270417414415627`, 
    0.7531457959458854}}], 
   Line3DBox[{{0.6666666666666666, 0.16666666666666666`, 1.}, {
    0.7308166965766251, 0.18270417414415627`, 0.9037749551350623}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.}, {
    0.7308166965766251, 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 
    0.16666666666666666`}, {0.7308166965766251, 0.36540834828831253`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.3333333333333333}, {
    0.7308166965766251, 0.36540834828831253`, 0.3012583183783541}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.5}, {
    0.7308166965766251, 0.36540834828831253`, 0.45188747756753117`}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.6666666666666666}, {
    0.7308166965766251, 0.36540834828831253`, 0.6025166367567082}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 0.8333333333333334}, {
    0.7308166965766251, 0.36540834828831253`, 0.7531457959458854}}], 
   Line3DBox[{{0.6666666666666666, 0.3333333333333333, 1.}, {
    0.7308166965766251, 0.36540834828831253`, 0.9037749551350623}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.}, {0.7308166965766251, 
    0.5481125224324688, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.16666666666666666`}, {
    0.7308166965766251, 0.5481125224324688, 0.15062915918917705`}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.3333333333333333}, {
    0.7308166965766251, 0.5481125224324688, 0.3012583183783541}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.5}, {0.7308166965766251, 
    0.5481125224324688, 0.45188747756753117`}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.6666666666666666}, {
    0.7308166965766251, 0.5481125224324688, 0.6025166367567082}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 0.8333333333333334}, {
    0.7308166965766251, 0.5481125224324688, 0.7531457959458854}}], 
   Line3DBox[{{0.6666666666666666, 0.5, 1.}, {0.7308166965766251, 
    0.5481125224324688, 0.9037749551350623}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.}, {
    0.7308166965766251, 0.7308166965766251, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 
    0.16666666666666666`}, {0.7308166965766251, 0.7308166965766251, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.3333333333333333}, {
    0.7308166965766251, 0.7308166965766251, 0.3012583183783541}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.5}, {
    0.7308166965766251, 0.7308166965766251, 0.45188747756753117`}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.6666666666666666}, {
    0.7308166965766251, 0.7308166965766251, 0.6025166367567082}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 0.8333333333333334}, {
    0.7308166965766251, 0.7308166965766251, 0.7531457959458854}}], 
   Line3DBox[{{0.6666666666666666, 0.6666666666666666, 1.}, {
    0.7308166965766251, 0.7308166965766251, 0.9037749551350623}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.}, {
    0.7308166965766251, 0.9135208707207814, 0.}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 
    0.16666666666666666`}, {0.7308166965766251, 0.9135208707207814, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.3333333333333333}, {
    0.7308166965766251, 0.9135208707207814, 0.3012583183783541}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.5}, {
    0.7308166965766251, 0.9135208707207814, 0.45188747756753117`}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.6666666666666666}, {
    0.7308166965766251, 0.9135208707207814, 0.6025166367567082}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 0.8333333333333334}, {
    0.7308166965766251, 0.9135208707207814, 0.7531457959458854}}], 
   Line3DBox[{{0.6666666666666666, 0.8333333333333334, 1.}, {
    0.7308166965766251, 0.9135208707207814, 0.9037749551350623}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.}, {0.7308166965766251, 
    1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.16666666666666666`}, {
    0.7308166965766251, 1.0962250448649375`, 0.15062915918917705`}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.3333333333333333}, {
    0.7308166965766251, 1.0962250448649375`, 0.3012583183783541}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.5}, {0.7308166965766251, 
    1.0962250448649375`, 0.45188747756753117`}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.6666666666666666}, {
    0.7308166965766251, 1.0962250448649375`, 0.6025166367567082}}], 
   Line3DBox[{{0.6666666666666666, 1., 0.8333333333333334}, {
    0.7308166965766251, 1.0962250448649375`, 0.7531457959458854}}], 
   Line3DBox[{{0.6666666666666666, 1., 1.}, {0.7308166965766251, 
    1.0962250448649375`, 0.9037749551350623}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.}, {0.9135208707207814, 0., 0.}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.16666666666666666`}, {
    0.9135208707207814, 0., 0.15062915918917705`}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.3333333333333333}, {
    0.9135208707207814, 0., 0.3012583183783541}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.5}, {0.9135208707207814, 0., 
    0.45188747756753117`}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.6666666666666666}, {
    0.9135208707207814, 0., 0.6025166367567082}}], 
   Line3DBox[{{0.8333333333333334, 0., 0.8333333333333334}, {
    0.9135208707207814, 0., 0.7531457959458854}}], 
   Line3DBox[{{0.8333333333333334, 0., 1.}, {0.9135208707207814, 0., 
    0.9037749551350623}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 0.}, {
    0.9135208707207814, 0.18270417414415627`, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 
    0.16666666666666666`}, {0.9135208707207814, 0.18270417414415627`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 
    0.3333333333333333}, {0.9135208707207814, 0.18270417414415627`, 
    0.3012583183783541}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 0.5}, {
    0.9135208707207814, 0.18270417414415627`, 0.45188747756753117`}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 
    0.6666666666666666}, {0.9135208707207814, 0.18270417414415627`, 
    0.6025166367567082}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 
    0.8333333333333334}, {0.9135208707207814, 0.18270417414415627`, 
    0.7531457959458854}}], 
   Line3DBox[{{0.8333333333333334, 0.16666666666666666`, 1.}, {
    0.9135208707207814, 0.18270417414415627`, 0.9037749551350623}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.}, {
    0.9135208707207814, 0.36540834828831253`, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 
    0.16666666666666666`}, {0.9135208707207814, 0.36540834828831253`, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.3333333333333333}, {
    0.9135208707207814, 0.36540834828831253`, 0.3012583183783541}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.5}, {
    0.9135208707207814, 0.36540834828831253`, 0.45188747756753117`}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.6666666666666666}, {
    0.9135208707207814, 0.36540834828831253`, 0.6025166367567082}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 0.8333333333333334}, {
    0.9135208707207814, 0.36540834828831253`, 0.7531457959458854}}], 
   Line3DBox[{{0.8333333333333334, 0.3333333333333333, 1.}, {
    0.9135208707207814, 0.36540834828831253`, 0.9037749551350623}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.}, {0.9135208707207814, 
    0.5481125224324688, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.16666666666666666`}, {
    0.9135208707207814, 0.5481125224324688, 0.15062915918917705`}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.3333333333333333}, {
    0.9135208707207814, 0.5481125224324688, 0.3012583183783541}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.5}, {0.9135208707207814, 
    0.5481125224324688, 0.45188747756753117`}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.6666666666666666}, {
    0.9135208707207814, 0.5481125224324688, 0.6025166367567082}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 0.8333333333333334}, {
    0.9135208707207814, 0.5481125224324688, 0.7531457959458854}}], 
   Line3DBox[{{0.8333333333333334, 0.5, 1.}, {0.9135208707207814, 
    0.5481125224324688, 0.9037749551350623}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.}, {
    0.9135208707207814, 0.7308166965766251, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 
    0.16666666666666666`}, {0.9135208707207814, 0.7308166965766251, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.3333333333333333}, {
    0.9135208707207814, 0.7308166965766251, 0.3012583183783541}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.5}, {
    0.9135208707207814, 0.7308166965766251, 0.45188747756753117`}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.6666666666666666}, {
    0.9135208707207814, 0.7308166965766251, 0.6025166367567082}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 0.8333333333333334}, {
    0.9135208707207814, 0.7308166965766251, 0.7531457959458854}}], 
   Line3DBox[{{0.8333333333333334, 0.6666666666666666, 1.}, {
    0.9135208707207814, 0.7308166965766251, 0.9037749551350623}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.}, {
    0.9135208707207814, 0.9135208707207814, 0.}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 
    0.16666666666666666`}, {0.9135208707207814, 0.9135208707207814, 
    0.15062915918917705`}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.3333333333333333}, {
    0.9135208707207814, 0.9135208707207814, 0.3012583183783541}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.5}, {
    0.9135208707207814, 0.9135208707207814, 0.45188747756753117`}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.6666666666666666}, {
    0.9135208707207814, 0.9135208707207814, 0.6025166367567082}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 0.8333333333333334}, {
    0.9135208707207814, 0.9135208707207814, 0.7531457959458854}}], 
   Line3DBox[{{0.8333333333333334, 0.8333333333333334, 1.}, {
    0.9135208707207814, 0.9135208707207814, 0.9037749551350623}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.}, {0.9135208707207814, 
    1.0962250448649375`, 0.}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.16666666666666666`}, {
    0.9135208707207814, 1.0962250448649375`, 0.15062915918917705`}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.3333333333333333}, {
    0.9135208707207814, 1.0962250448649375`, 0.3012583183783541}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.5}, {0.9135208707207814, 
    1.0962250448649375`, 0.45188747756753117`}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.6666666666666666}, {
    0.9135208707207814, 1.0962250448649375`, 0.6025166367567082}}], 
   Line3DBox[{{0.8333333333333334, 1., 0.8333333333333334}, {
    0.9135208707207814, 1.0962250448649375`, 0.7531457959458854}}], 
   Line3DBox[{{0.8333333333333334, 1., 1.}, {0.9135208707207814, 
    1.0962250448649375`, 0.9037749551350623}}], 
   Line3DBox[{{1., 0., 0.}, {1.0962250448649375`, 0., 0.}}], 
   Line3DBox[{{1., 0., 0.16666666666666666`}, {1.0962250448649375`, 0., 
    0.15062915918917705`}}], 
   Line3DBox[{{1., 0., 0.3333333333333333}, {1.0962250448649375`, 0., 
    0.3012583183783541}}], 
   Line3DBox[{{1., 0., 0.5}, {1.0962250448649375`, 0., 
    0.45188747756753117`}}], 
   Line3DBox[{{1., 0., 0.6666666666666666}, {1.0962250448649375`, 0., 
    0.6025166367567082}}], 
   Line3DBox[{{1., 0., 0.8333333333333334}, {1.0962250448649375`, 0., 
    0.7531457959458854}}], 
   Line3DBox[{{1., 0., 1.}, {1.0962250448649375`, 0., 0.9037749551350623}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.}, {1.0962250448649375`, 
    0.18270417414415627`, 0.}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.16666666666666666`}, {
    1.0962250448649375`, 0.18270417414415627`, 0.15062915918917705`}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.3333333333333333}, {
    1.0962250448649375`, 0.18270417414415627`, 0.3012583183783541}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.5}, {1.0962250448649375`, 
    0.18270417414415627`, 0.45188747756753117`}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.6666666666666666}, {
    1.0962250448649375`, 0.18270417414415627`, 0.6025166367567082}}], 
   Line3DBox[{{1., 0.16666666666666666`, 0.8333333333333334}, {
    1.0962250448649375`, 0.18270417414415627`, 0.7531457959458854}}], 
   Line3DBox[{{1., 0.16666666666666666`, 1.}, {1.0962250448649375`, 
    0.18270417414415627`, 0.9037749551350623}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.}, {1.0962250448649375`, 
    0.36540834828831253`, 0.}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.16666666666666666`}, {
    1.0962250448649375`, 0.36540834828831253`, 0.15062915918917705`}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.3333333333333333}, {
    1.0962250448649375`, 0.36540834828831253`, 0.3012583183783541}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.5}, {1.0962250448649375`, 
    0.36540834828831253`, 0.45188747756753117`}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.6666666666666666}, {
    1.0962250448649375`, 0.36540834828831253`, 0.6025166367567082}}], 
   Line3DBox[{{1., 0.3333333333333333, 0.8333333333333334}, {
    1.0962250448649375`, 0.36540834828831253`, 0.7531457959458854}}], 
   Line3DBox[{{1., 0.3333333333333333, 1.}, {1.0962250448649375`, 
    0.36540834828831253`, 0.9037749551350623}}], 
   Line3DBox[{{1., 0.5, 0.}, {1.0962250448649375`, 0.5481125224324688, 0.}}], 
   Line3DBox[{{1., 0.5, 0.16666666666666666`}, {1.0962250448649375`, 
    0.5481125224324688, 0.15062915918917705`}}], 
   Line3DBox[{{1., 0.5, 0.3333333333333333}, {1.0962250448649375`, 
    0.5481125224324688, 0.3012583183783541}}], 
   Line3DBox[{{1., 0.5, 0.5}, {1.0962250448649375`, 0.5481125224324688, 
    0.45188747756753117`}}], 
   Line3DBox[{{1., 0.5, 0.6666666666666666}, {1.0962250448649375`, 
    0.5481125224324688, 0.6025166367567082}}], 
   Line3DBox[{{1., 0.5, 0.8333333333333334}, {1.0962250448649375`, 
    0.5481125224324688, 0.7531457959458854}}], 
   Line3DBox[{{1., 0.5, 1.}, {1.0962250448649375`, 0.5481125224324688, 
    0.9037749551350623}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.}, {1.0962250448649375`, 
    0.7308166965766251, 0.}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.16666666666666666`}, {
    1.0962250448649375`, 0.7308166965766251, 0.15062915918917705`}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.3333333333333333}, {
    1.0962250448649375`, 0.7308166965766251, 0.3012583183783541}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.5}, {1.0962250448649375`, 
    0.7308166965766251, 0.45188747756753117`}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.6666666666666666}, {
    1.0962250448649375`, 0.7308166965766251, 0.6025166367567082}}], 
   Line3DBox[{{1., 0.6666666666666666, 0.8333333333333334}, {
    1.0962250448649375`, 0.7308166965766251, 0.7531457959458854}}], 
   Line3DBox[{{1., 0.6666666666666666, 1.}, {1.0962250448649375`, 
    0.7308166965766251, 0.9037749551350623}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.}, {1.0962250448649375`, 
    0.9135208707207814, 0.}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.16666666666666666`}, {
    1.0962250448649375`, 0.9135208707207814, 0.15062915918917705`}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.3333333333333333}, {
    1.0962250448649375`, 0.9135208707207814, 0.3012583183783541}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.5}, {1.0962250448649375`, 
    0.9135208707207814, 0.45188747756753117`}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.6666666666666666}, {
    1.0962250448649375`, 0.9135208707207814, 0.6025166367567082}}], 
   Line3DBox[{{1., 0.8333333333333334, 0.8333333333333334}, {
    1.0962250448649375`, 0.9135208707207814, 0.7531457959458854}}], 
   Line3DBox[{{1., 0.8333333333333334, 1.}, {1.0962250448649375`, 
    0.9135208707207814, 0.9037749551350623}}], 
   Line3DBox[{{1., 1., 0.}, {1.0962250448649375`, 1.0962250448649375`, 0.}}], 
   Line3DBox[{{1., 1., 0.16666666666666666`}, {1.0962250448649375`, 
    1.0962250448649375`, 0.15062915918917705`}}], 
   Line3DBox[{{1., 1., 0.3333333333333333}, {1.0962250448649375`, 
    1.0962250448649375`, 0.3012583183783541}}], 
   Line3DBox[{{1., 1., 0.5}, {1.0962250448649375`, 1.0962250448649375`, 
    0.45188747756753117`}}], 
   Line3DBox[{{1., 1., 0.6666666666666666}, {1.0962250448649375`, 
    1.0962250448649375`, 0.6025166367567082}}], 
   Line3DBox[{{1., 1., 0.8333333333333334}, {1.0962250448649375`, 
    1.0962250448649375`, 0.7531457959458854}}], 
   Line3DBox[{{1., 1., 1.}, {1.0962250448649375`, 1.0962250448649375`, 
    0.9037749551350623}}]},
  Method->{
   "CylinderPoints" -> {40, 3}, "SpherePoints" -> {40, 30}, "RotationControl" -> 
    "ArcBall"},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVector->Automatic,
  ViewVertical->{0., 0., 1.}]], "Output",
 CellLabel->"Out[2]="]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 31.5329646}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/PlotField3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 71, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[883, 35, 331, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1217, 46, 287, 10, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1507, 58, 119, 3, 70, "Input",
 CellID->2075400188],
Cell[1629, 63, 124, 4, 70, "Input",
 CellID->1821565142],
Cell[1756, 69, 126, 3, 70, "ExampleDelimiter",
 CellID->1824744232],
Cell[1885, 74, 308, 10, 70, "UpgradeDetail",
 CellID->510952580],
Cell[2196, 86, 424, 13, 70, "Input",
 CellID->998512136],
Cell[CellGroupData[{
Cell[2645, 103, 443, 12, 70, "Input",
 CellID->1725607045],
Cell[3091, 117, 41965, 695, 70, "Output",
 CellID->2056984575]
}, Open  ]],
Cell[45071, 815, 125, 3, 70, "ExampleDelimiter",
 CellID->262344417],
Cell[45199, 820, 320, 10, 70, "UpgradeDetail",
 CellID->518469962],
Cell[45522, 832, 765, 22, 70, "Input",
 CellID->1583495455],
Cell[CellGroupData[{
Cell[46312, 858, 748, 22, 70, "Input",
 CellID->43274914],
Cell[47063, 882, 14341, 248, 70, "Output"]
}, Open  ]],
Cell[61419, 1133, 125, 3, 70, "ExampleDelimiter",
 CellID->438689228],
Cell[61547, 1138, 315, 10, 70, "UpgradeDetail",
 CellID->1008556544],
Cell[61865, 1150, 328, 11, 70, "Input",
 CellID->721409237],
Cell[CellGroupData[{
Cell[62218, 1165, 488, 14, 70, "Input",
 CellID->32375297],
Cell[62709, 1181, 42110, 704, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[104846, 1889, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

