(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6236,        224]
NotebookOptionsPosition[      4484,        168]
NotebookOutlinePosition[      5451,        196]
CellTagsIndexPosition[      5408,        193]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["LinearAlgebra`FourierTrig`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "New function",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["FourierDCT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDCT"], " "}]], "InlineFormula"],
 "has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\nNew function ",
 Cell[BoxData[
  ButtonBox["FourierDST",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierDST"]], "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Evaluate the discrete Fourier Cosine transform of ",
 Cell[BoxData[
  RowBox[{"Type", " ", "I", " "}]], "InlineFormula"],
 "using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierDCT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDCT"], "[", 
   RowBox[{
    StyleBox["data",
     FontSlant->"Italic"], ",", "1"}], "]"}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "LinearAlgebra`FourierTrig`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"x", "-", ".5"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", ".1", ",", ".9", ",", ".1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FourierCos", "[", "data", "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"x", "-", ".5"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", ".1", ",", ".9", ",", ".1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FourierDCT", "[", 
  RowBox[{"data", ",", "1"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[34]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.4`", ",", "1.2979023938288658`*^-16", ",", 
   RowBox[{"-", "0.682842712474619`"}], ",", 
   RowBox[{"-", "5.726142504647343`*^-17"}], ",", "0.`", ",", 
   RowBox[{"-", "9.974782082190409`*^-17"}], ",", 
   RowBox[{"-", "0.11715728752538096`"}], ",", "2.7219006485490938`*^-17", 
   ",", "0.`"}], "}"}]], "Output",
 CellLabel->"Out[35]=",
 CellID->1550809238]
}, Open  ]],

Cell[TextData[{
 "Evaluate the discrete Fourier Sine transform of ",
 Cell[BoxData[
  RowBox[{"Type", " ", "I"}]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierDST",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDST"], "[", 
   RowBox[{
    StyleBox["data",
     FontSlant->"Italic"], ",", "1"}], "]"}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->2104093346],

Cell[BoxData[
 RowBox[{"FourierSin", "[", "data", "]"}]], "Input", "LegacyInput",
 CellID->888977530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourierDST", "[", 
   RowBox[{"data", ",", "1"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->1001614531],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.8274694061292347`", ",", "1.05588484211067`*^-16", ",", 
   RowBox[{"-", "0.21698088095444057`"}], ",", "0.`", ",", 
   "0.08944271909999162`", ",", 
   RowBox[{"-", "6.525727206302103`*^-17"}], ",", 
   RowBox[{"-", "0.05633174824545861`"}], ",", "0.`", ",", 
   "0.04584322307066402`"}], "}"}]], "Output",
 CellLabel->"Out[36]=",
 CellID->441839427]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 32.9861268}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/FourierTrig"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 76, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[888, 35, 558, 20, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1449, 57, 418, 15, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1870, 74, 522, 16, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2417, 94, 485, 15, 70, "Input",
 CellID->1746043248],
Cell[2905, 111, 401, 9, 70, "Output",
 CellID->1550809238]
}, Open  ]],
Cell[3321, 123, 413, 15, 70, "UpgradeDetail",
 CellID->2104093346],
Cell[3737, 140, 101, 2, 70, "Input",
 CellID->888977530],
Cell[CellGroupData[{
Cell[3863, 146, 171, 5, 70, "Input",
 CellID->1001614531],
Cell[4037, 153, 393, 9, 70, "Output",
 CellID->441839427]
}, Open  ]]
}, Open  ]],
Cell[4457, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

