(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    127213,       2216]
NotebookOptionsPosition[    125563,       2164]
NotebookOutlinePosition[    126524,       2192]
CellTagsIndexPosition[    126481,       2189]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Miscellaneous`Audio`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "The functionality in ",
 Cell[BoxData["Miscellaneous`Audio`"], "InlineFormula"],
 " is now available through the newly created ",
 ButtonBox["Audio Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/guide/AudioPackage"],
 ":"
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Audio Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/guide/AudioPackage"],
 ", load ",
 Cell[BoxData["Audio`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[
 RowBox[{"<<", "Miscellaneous`Audio`"}]], "Input", "LegacyInput",
 CellID->1663071679],

Cell[BoxData[
 RowBox[{"<<", "Audio`"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->1746043248],

Cell[TextData[{
 "Here ",
 StyleBox[ButtonBox["Waveform",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/Waveform"], "InlineCode"],
 " returns a ",
 Cell[BoxData["sound"], "InlineFormula"],
 " object corresponding to a triangle wave having a fundamental of 440 hertz \
and lasting 0.2 seconds:"
}], "UpgradeDetail",
 CellID->723029451],

Cell[BoxData[
 RowBox[{
  RowBox[{"Waveform", "[", 
   RowBox[{"Triangle", ",", "440", ",", "0.2"}], "]"}], "//", 
  "Show"}]], "Input", "LegacyInput",
 CellID->146173710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Waveform", "[", 
  RowBox[{"Triangle", ",", "440", ",", "0.2"}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->380652551],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJzstnk8ldH3921MZSiSSmYp0YDIUFnmsUhRKiSpRKMiiQiZGkklCiFKKPN4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          "],
          ColorFunction->(Blend[{
             RGBColor[1, 1, 1], 
             RGBColor[0, 0, 1]}, #]& )],
         AspectRatio->Full,
         ImageSize->NCache[{
            Rational[819, 4096]}, {0.199951171875}],
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[819, 4096], 1}, {0.199951171875, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[819, 4096]}, {0, 1}}, {{0, 0.199951171875}, {0, 1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -35}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[
         {RGBColor[0.325101, 0.364492, 0.820256], LineBox[CompressedData["
1:eJxVnHd0VFXXxkcURUQNiAVRjB17VCxg2YNiR40iICoyNgQUCYoKijgqAiol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           "]]},
         AspectRatio->Full,
         PlotRange->{Automatic, {0, 1}},
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[819, 4096], 1}, {0.199951171875, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[819, 4096]}, {0, 1}}, {{0, 0.199951171875}, {0, 1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       RowBox[{
        InterpretationBox[
         RowBox[{"\<\"0.2\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
         Row[{"0.2", " s"}]], 
        StyleBox["\<\" | \"\>",
         StripOnInput->False,
         FontSize->14,
         FontColor->GrayLevel[0.75]], 
        InterpretationBox[
         RowBox[{"8192", "\[InvisibleSpace]", "\<\" Hz\"\>"}],
         Row[{8192, " Hz"}]]}],
       Row[{
         Row[{"0.2", " s"}], 
         Row[{8192, " Hz"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[None =!= None, 
            Sound`EmitMIDI[None]]; Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[CompressedData["
1:eJztmUmOVTcUhp0Msg5nJfEasoKrSMk0LMFDhhkwYMDAQgghhBA9hCZlCKHv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             "], 8192], "Preemptive"]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[
   SampledSoundFunction[
    CompiledFunction[{
      Blank[Integer]}, {{2, 0, 0}, {3, 0, 2}}, {0, 4, 4, 0, 
     0}, {{1, 5}, {8, 0., 0}, {8, 0.0001220703125, 1}, {15, 1, 0, 2}, {21, 1, 
      2, 1}, {18, 0, 1, 0}, {7, 440, 1}, {15, 1, 1, 1}, {21, 1, 0, 1}, {7, 2, 
      1}, {8, -0.5, 2}, {28, 1, 2}, {23, 2, 3}, {15, 0, 3, 3}, {18, 2, 1, 3, 
      2}, {93, 36, 3, 0, 2, 3, 0, 3}, {15, 1, 1, 2}, {21, 2, 3, 2}, {
      8, -0.5, 3}, {18, 2, 3, 2}, {8, 2., 3}, {21, 2, 3, 2}, {2}}, 
     Function[{Play`Time3}, 
      Block[{Internal`$$3356}, 
       Block[{Audio`Private`t$3342 = 0. + 0.0001220703125 Play`Time3}, 
        Internal`$$3356 = 
         440 Audio`Private`t$3342; (
          2 Abs[Rational[-1, 2] + Internal`$$3356 - Floor[Internal`$$3356]] - 
          0.5) 2.]]], Evaluate], 1638, 8192]]]], "Output",
 CellLabel->"Out[37]=",
 CellID->27315169]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 33.5486412}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Audio"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 70, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[882, 35, 294, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1179, 46, 257, 9, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1439, 57, 100, 2, 70, "Input",
 CellID->1663071679],
Cell[1542, 61, 95, 3, 70, "Input",
 CellID->1746043248],
Cell[1640, 66, 341, 10, 70, "UpgradeDetail",
 CellID->723029451],
Cell[1984, 78, 171, 5, 70, "Input",
 CellID->146173710],
Cell[CellGroupData[{
Cell[2180, 87, 149, 4, 70, "Input",
 CellID->380652551],
Cell[2332, 93, 123177, 2065, 70, "Output",
 CellID->27315169]
}, Open  ]]
}, Open  ]],
Cell[125536, 2162, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

