(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31150,        643]
NotebookOptionsPosition[     29489,        591]
NotebookOutlinePosition[     30463,        619]
CellTagsIndexPosition[     30420,        616]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Miscellaneous`BlackBodyRadiation`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All of the functionality in ",
 Cell[BoxData["Miscellaneous`BlackBodyRadiation`"], "InlineFormula"],
 " is now available through the newly created ",
 ButtonBox["Black Body Radiation Package",
  BaseStyle->"Link",
  ButtonData->"paclet:BlackBodyRadiation/guide/BlackBodyRadiationPackage"],
 ". "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Black Body Radiation Package",
  BaseStyle->"Link",
  ButtonData->"paclet:BlackBodyRadiation/guide/BlackBodyRadiationPackage"],
 ", load ",
 Cell[BoxData["BlackBodyRadiation`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->172004744],

Cell[BoxData[
 RowBox[{"<<", "Miscellaneous`BlackBodyRadiation`"}]], "Input", "LegacyInput",
 CellID->1663071679],

Cell[BoxData[
 RowBox[{"<<", "BlackBodyRadiation`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1746043248],

Cell["\<\
This gives the spectral distribution of radiation from a black body for three \
different temperatures:\
\>", "UpgradeDetail",
 CellID->723029451],

Cell[BoxData[
 RowBox[{"BlackBodyProfile", "[", 
  RowBox[{
   RowBox[{"4000", " ", "Kelvin"}], ",", 
   RowBox[{"5000", " ", "Kelvin"}], ",", 
   RowBox[{"6000", " ", "Kelvin"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", " ", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"-", "6"}], ")"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"1.1", " ", 
         RowBox[{"10", "^", "14"}]}]}], "}"}]}], "}"}]}]}], "]"}]], "Input", \
"LegacyInput",
 CellID->30545565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlackBodyProfile", "[", 
  RowBox[{
   RowBox[{"4000", " ", "Kelvin"}], ",", 
   RowBox[{"5000", " ", "Kelvin"}], ",", 
   RowBox[{"6000", " ", "Kelvin"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", " ", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"-", "6"}], ")"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"1.1", " ", 
         RowBox[{"10", "^", "14"}]}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->110025637],

Cell[BoxData[
 GraphicsBox[{
   {Dashing[{0.01, 0.01}], 
    LineBox[{{7.249999999999999*^-7, 0}, {7.249999999999999*^-7, 
      1.317580232468474*^13}}], InsetBox[
     RowBox[{
     "4000.`", " ", 
      "K"}], {7.249999999999999*^-7, 1.317580232468474*^13}, {0, -1}]}, {{}, \
{}, 
    {Hue[0.65, 1, 0.55], LineBox[CompressedData["
1:eJw91nk0F1/8P3BaRGVfklLIWkIosry85yJriSgVZZeEQrLv+75lTdb3e952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      "]]}}, 
   {Dashing[{0.01, 0.01}], 
    LineBox[{{5.8*^-7, 0}, {5.8*^-7, 4.020935768031232*^13}}], InsetBox[
     RowBox[{
     "5000.`", " ", 
      "K"}], {5.8*^-7, 4.020935768031232*^13}, {0, -1}]}, {{}, {}, 
    {Hue[0.4, 1, 0.55], LineBox[CompressedData["
1:eJw91Xc41W/4OHCUvUciSlYoSZkZt3MeipYy0jAyM0L23jt7ZWWeY1MiZWSd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      "]]}}, 
   {Dashing[{0.01, 0.01}], 
    LineBox[{{4.833333333333333*^-7, 0}, {4.833333333333333*^-7, 
      1.0005374890307472`*^14}}], InsetBox[
     RowBox[{
     "6000.`", " ", 
      "K"}], {4.833333333333333*^-7, 1.0005374890307472`*^14}, {0, -1}]}, \
{{}, {}, 
    {Hue[0.15000000000000002`, 1, 0.55], LineBox[CompressedData["
1:eJw91Xc8lW/8P3BRIrtCRYX6pETJnu/jXElJ2WQk2XsfK3uTmZXtHFtmtpC9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      "]]}}},
  AlignmentPoint->ImageScaled[{0.5, 0.5}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Wavelength, m\"", TraditionalForm], 
    FormBox["\"Intensity, W/m^3\"", TraditionalForm]},
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->Automatic,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType->TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->NCache[{{0, 
      Rational[1, 500000]}, {0, 1.1000000000000002`*^14}}, {{0, 2.*^-6}, {
     0, 1.1000000000000002`*^14}}],
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellLabel->"Out[3]=",
 CellID->67503164]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 38.7206486}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/BlackBodyRadiation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 83, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[895, 35, 356, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1254, 46, 311, 9, 70, "UpgradeDetail",
 CellID->172004744],
Cell[1568, 57, 113, 2, 70, "Input",
 CellID->1663071679],
Cell[1684, 61, 107, 3, 70, "Input",
 CellID->1746043248],
Cell[1794, 66, 156, 4, 70, "UpgradeDetail",
 CellID->723029451],
Cell[1953, 72, 624, 20, 70, "Input",
 CellID->30545565],
Cell[CellGroupData[{
Cell[2602, 96, 631, 20, 70, "Input",
 CellID->110025637],
Cell[3236, 118, 26199, 467, 70, "Output",
 CellID->67503164]
}, Open  ]]
}, Open  ]],
Cell[29462, 589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

