(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5024,        183]
NotebookOptionsPosition[      3379,        131]
NotebookOutlinePosition[      4342,        159]
CellTagsIndexPosition[      4299,        156]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Miscellaneous`Geodesy`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All of the functionality in ",
 Cell[BoxData["Miscellaneous`Geodesy`"], "InlineFormula"],
 " is now available through the newly created ",
 ButtonBox["Geodesy Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/guide/GeodesyPackage"],
 ". "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Geodesy Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/guide/GeodesyPackage"],
 ", load ",
 Cell[BoxData["Geodesy`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->172004744],

Cell[BoxData[
 RowBox[{"<<", "Miscellaneous`Geodesy`"}]], "Input", "LegacyInput",
 CellID->1663071679],

Cell[BoxData[
 RowBox[{"<<", "Geodesy`"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1746043248],

Cell[TextData[{
 "This gives the distance between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " lat., ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " long., and ",
 Cell[BoxData[
  FormBox["45", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " N. lat., ",
 Cell[BoxData[
  FormBox["45", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " E. long., using a spherical model:"
}], "UpgradeDetail",
 CellID->723029451],

Cell[BoxData[
 RowBox[{
  RowBox[{"SphericalDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"45", ",", "45"}], "}"}]}], "]"}], "//", "N"}]], "Input", \
"LegacyInput",
 CellID->30545565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SphericalDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"45", ",", "45"}], "}"}]}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->110025637],

Cell[BoxData["6671.702929056382`"], "Output",
 CellLabel->"Out[8]=",
 CellID->188396677]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 39.6737980}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Geodesy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 72, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[884, 35, 310, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1197, 46, 265, 9, 70, "UpgradeDetail",
 CellID->172004744],
Cell[1465, 57, 102, 2, 70, "Input",
 CellID->1663071679],
Cell[1570, 61, 96, 3, 70, "Input",
 CellID->1746043248],
Cell[1669, 66, 1014, 31, 70, "UpgradeDetail",
 CellID->723029451],
Cell[2686, 99, 258, 9, 70, "Input",
 CellID->30545565],
Cell[CellGroupData[{
Cell[2969, 112, 265, 9, 70, "Input",
 CellID->110025637],
Cell[3237, 123, 88, 2, 70, "Output",
 CellID->188396677]
}, Open  ]]
}, Open  ]],
Cell[3352, 129, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

