(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8701,        266]
NotebookOptionsPosition[      6963,        212]
NotebookOutlinePosition[      7943,        240]
CellTagsIndexPosition[      7900,        237]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Miscellaneous`ResonanceAbsorptionLines`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["Miscellaneous`ResonanceAbsorptionLines`"], "InlineFormula"],
 "is now available in the newly created ",
 ButtonBox["Resonance Absorption Lines Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/guide/ResonanceAbsorptionLinesPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new",
 " ",
 ButtonBox["Resonance Absorption Lines Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/guide/ResonanceAbsorptionLinesPackage"],
 " load ",
 Cell[BoxData["ResonanceAbsorptionLines`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Miscellaneous`ResonanceAbsorptionLines`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindIons", "[", 
  RowBox[{
   RowBox[{"1215", " ", "Angstrom"}], ",", 
   RowBox[{"1220", " ", "Angstrom"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "ResonanceAbsorptionLines`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindIons", "[", 
  RowBox[{
   RowBox[{"1215", " ", "Angstrom"}], ",", 
   RowBox[{"1220", " ", "Angstrom"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6701`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6737`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6683`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Deuterium\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.3394`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Deuterium\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.343`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Deuterium\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.3376`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Oxygen\"\>", ",", "\<\"Vanadium\"\>", ",", 
     RowBox[{"1218.344`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Phosphorus\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.385`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Phosphorus\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1217.843`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sulfur\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.5953`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sulfur\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.57`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sulfur\"\>", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.5133`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Manganese\"\>", ",", "\<\"II\"\>", ",", 
     RowBox[{"1219.604`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Manganese\"\>", ",", "\<\"II\"\>", ",", 
     RowBox[{"1218.745`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Manganese\"\>", ",", "\<\"II\"\>", ",", 
     RowBox[{"1218.704`", " ", "Angstrom"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1073233357]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Resonance Absorption Lines package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["Miscellaneous`ResonanceAbsorptionLines`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Resonance Absorption Lines Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/guide/ResonanceAbsorptionLinesPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[Cell[BoxData[{
 ButtonBox["AirWavelength",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/AirWavelength"], "\n", 
 ButtonBox["AtomicData",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/AtomicData"], "\n", 
 ButtonBox["DampingConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/DampingConstant"], "\n", 
 ButtonBox["Deuterium",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/Deuterium"], "\n", 
 ButtonBox["ElementAbsorptionMap",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/ref/ElementAbsorptionMap"], "\n", 
 ButtonBox["FindIons",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/FindIons"], "\n", 
 ButtonBox["IonStage",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/IonStage"], "\n", 
 ButtonBox["LowerStatisticalWeight",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"], "\n", 
 ButtonBox["LowerTermFineStructureEnergy",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"], "\n", 

 ButtonBox["OscillatorStrength",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"], "\n",
 
 ButtonBox["RelativeStrength",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/RelativeStrength"], "\n", 
 ButtonBox["TransitionProbability",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/ref/TransitionProbability"], "\n", 
 ButtonBox["UpperStatisticalWeight",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"], "\n", 
 ButtonBox["VacuumWavelength",
  BaseStyle->"Link",
  ButtonData->"paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"], "\n", 
 ButtonBox["WavelengthAbsorptionMap",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ResonanceAbsorptionLines/ref/WavelengthAbsorptionMap"]}], \
"InlineFormula"]], "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 40.4863188}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ResonanceAbsorptionLines"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 89, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[901, 35, 374, 10, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1278, 47, 343, 11, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1624, 60, 295, 8, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1944, 72, 286, 8, 70, "Input",
 CellID->1746043248],
Cell[2233, 82, 2110, 49, 70, "Output",
 CellID->1073233357]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4392, 137, 88, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[4483, 140, 352, 10, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[4838, 152, 2083, 55, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[6936, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

