(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7763,        291]
NotebookOptionsPosition[      5470,        215]
NotebookOutlinePosition[      6435,        243]
CellTagsIndexPosition[      6392,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumberTheory`Frobenius`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData["FrobeniusInstance"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FrobeniusSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFormula"],
 " are now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["FrobeniusSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["FrobeniusF"], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["FrobeniusNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrobeniusNumber"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["FrobeniusSolve", "UpgradeDetailLabel",
 CellID->2082128514],

Cell[TextData[{
 "All solutions of the Frobenius equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"12", "x"}], "+", 
     RowBox[{"16", "y"}], "+", 
     RowBox[{"20", "z"}], "+", 
     RowBox[{"27", "t"}]}], "=", "123"}], TraditionalForm]], "InlineMath"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`Frobenius`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "123"}], 
  "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "123"}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->446202874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749800371],

Cell[TextData[{
 "Find one solution of the Frobenius equation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"12", " ", 
     StyleBox["x", "TI"]}], "+", 
    RowBox[{"16", " ", 
     StyleBox["y", "TI"]}], "+", 
    RowBox[{"20", " ", 
     StyleBox["z", "TI"]}], "+", 
    RowBox[{"27", " ", 
     StyleBox["t", "TI"]}]}], "=", "123"}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->676964633],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`Frobenius`"}], ";"}], "\n", 
 RowBox[{"FrobeniusInstance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "123"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->376225025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "123", ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1022138407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"8", ",", "0", ",", "0", ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->500276568]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FrobeniusNumber", "UpgradeDetailLabel",
 CellID->693025918],

Cell["The Frobenius number of 12, 16, 20, 27:", "UpgradeDetail",
 CellID->547750810],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`Frobenius`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FrobeniusF", "[", 
  RowBox[{"{", 
   RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->116052816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusNumber", "[", 
  RowBox[{"{", 
   RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->96157164],

Cell[BoxData["89"], "Output",
 CellLabel->"Out[12]=",
 CellID->304705994]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 47.1896154}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Frobenius"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 73, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[885, 35, 822, 27, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[1732, 66, 65, 1, 70, "UpgradeDetailLabel",
 CellID->2082128514],
Cell[1800, 69, 329, 12, 70, "UpgradeDetail",
 CellID->556646693],
Cell[2132, 83, 292, 8, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2449, 95, 212, 7, 70, "Input",
 CellID->1746043248],
Cell[2664, 104, 728, 20, 70, "Output",
 CellID->446202874]
}, Open  ]],
Cell[3407, 127, 125, 3, 70, "ExampleDelimiter",
 CellID->749800371],
Cell[3535, 132, 409, 15, 70, "UpgradeDetail",
 CellID->676964633],
Cell[3947, 149, 300, 9, 70, "Input",
 CellID->376225025],
Cell[CellGroupData[{
Cell[4272, 162, 223, 7, 70, "Input",
 CellID->1022138407],
Cell[4498, 171, 160, 5, 70, "Output",
 CellID->500276568]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4707, 182, 65, 1, 70, "UpgradeDetailLabel",
 CellID->693025918],
Cell[4775, 185, 84, 1, 70, "UpgradeDetail",
 CellID->547750810],
Cell[4862, 188, 259, 7, 70, "Input",
 CellID->116052816],
Cell[CellGroupData[{
Cell[5146, 199, 182, 5, 70, "Input",
 CellID->96157164],
Cell[5331, 206, 73, 2, 70, "Output",
 CellID->304705994]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5443, 213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

