(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6854,        231]
NotebookOptionsPosition[      5129,        177]
NotebookOutlinePosition[      6099,        205]
CellTagsIndexPosition[      6056,        202]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`Approximations`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["NumericalMath`Approximations`"], "InlineFormula"],
 " is now available in the newly created ",
 ButtonBox["Function Approximations Package.",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Function Approximations Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"],
 ", load \n",
 Cell[BoxData["FunctionApproximations`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`Approximations`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RationalInterpolation", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"2", "/", "3"}], ",", "1", ",", 
     RowBox[{"4", "/", "3"}], ",", 
     RowBox[{"5", "/", "3"}], ",", "2"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "FunctionApproximations`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RationalInterpolation", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"2", "/", "3"}], ",", "1", ",", 
     RowBox[{"4", "/", "3"}], ",", 
     RowBox[{"5", "/", "3"}], ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[31]:=",
 CellID->1746043248],

Cell[BoxData[
 FractionBox[
  RowBox[{"1.`", "\[InvisibleSpace]", "+", 
   RowBox[{"0.37996150599712336`", " ", "x"}], "+", 
   RowBox[{"0.04695275726449144`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.6200285166916588`", " ", "x"}], "+", 
   RowBox[{"0.16691391444380876`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.023405766183248237`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0014527901993413583`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[32]=",
 CellID->2374261]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function Approximations Package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["NumericalMath`Approximations`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Function Approximation Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Bias",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Bias"]], "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["Brake",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Brake"]], "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["Derivatives",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Derivatives"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[{
  ButtonBox["GeneralMiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"], "\n", 
  ButtonBox["GeneralRationalInterpolation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"], "\n", 
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/MiniMaxApproximation"], "\n", 
  ButtonBox["PlotFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PlotFlag"], "\n", 
  ButtonBox["PrintFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PrintFlag"], "\n", 
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]}], 
  "InlineFormula"]
}], "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 55.0179408}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Approximations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 79, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[891, 35, 353, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1247, 46, 332, 10, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1582, 58, 535, 16, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2142, 78, 533, 15, 70, "Input",
 CellID->1746043248],
Cell[2678, 95, 563, 15, 70, "Output",
 CellID->2374261]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3290, 116, 85, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[3378, 119, 334, 10, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[3715, 131, 1372, 41, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[5102, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

