(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9049,        303]
NotebookOptionsPosition[      7329,        249]
NotebookOutlinePosition[      8292,        277]
CellTagsIndexPosition[      8249,        274]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`Butcher`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of",
 Cell[BoxData[
  RowBox[{" ", "NumericalMath`Butcher`"}]], "InlineFormula"],
 "is now available in the newly created ",
 ButtonBox["Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 ", load \n",
 Cell[BoxData["NumericalDifferentialEquationAnalysis`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`Butcher`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ButcherPrincipalError", "[", "3", "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalDifferentialEquationAnalysis`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ButcherPrincipalError", "[", "3", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "24"]}], "+", 
    RowBox[{"b", ".", "a", ".", "a", ".", "c"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "12"]}], "+", 
      RowBox[{"b", ".", "a", ".", 
       SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "8"]}], "+", 
    RowBox[{"b", ".", 
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"a", ".", "c"}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], "+", 
      RowBox[{"b", ".", 
       SuperscriptBox["c", "3"]}]}], ")"}]}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->116884026]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Differential Equation Analysis", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["NumericalMath`Butcher`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[Cell[BoxData[{
 ButtonBox["ButcherAlpha",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherAlpha"], "\n", 
 ButtonBox["ButcherBeta",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBeta"], "\n", 
 ButtonBox["ButcherBetaBar",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBetaBar"], "\n", 
 ButtonBox["ButcherColumnConditions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherColumnConditions"]\
, "\n", 
 ButtonBox["ButcherGamma",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherGamma"], "\n", 
 ButtonBox["ButcherHeight",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherHeight"], "\n", 
 ButtonBox["ButcherOrder",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"], "\n", 
 ButtonBox["ButcherPhi",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPhi"], "\n", 
 ButtonBox["ButcherPlot",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlot"], "\n", 
 ButtonBox["ButcherPlotColumns",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotColumns"], "\n\
", 
 ButtonBox["ButcherPlotLabel",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotLabel"], "\n",
 
 ButtonBox["ButcherPlotNodeSize",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotNodeSize"], "\
\n", 
 ButtonBox["ButcherPlotRootSize",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotRootSize"], "\
\n", 
 ButtonBox["ButcherPrincipalError",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPrincipalError"], \
"\n", 
 ButtonBox["ButcherQuadratureConditions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherQuadratureConditions"], "\n", 
 ButtonBox["ButcherRowConditions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowConditions"], \
"\n", 
 ButtonBox["ButcherRowSum",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowSum"], "\n", 
 ButtonBox["ButcherSigma",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSigma"], "\n", 
 ButtonBox["ButcherSimplify",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSimplify"], "\n", 

 ButtonBox["ButcherTreeCount",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeCount"], "\n",
 
 ButtonBox["ButcherTreeQ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeQ"], "\n", 
 ButtonBox["ButcherTrees",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTrees"], "\n", 
 ButtonBox["ButcherTreeSimplify",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeSimplify"], "\
\n", 
 ButtonBox["ButcherWidth",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherWidth"], "\n", 
 ButtonBox["RungeKuttaOrderConditions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]}], "InlineFormula"]], "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 55.2991980}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Butcher"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 72, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[884, 35, 416, 12, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1303, 49, 396, 11, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1702, 62, 197, 4, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1924, 70, 224, 6, 70, "Input",
 CellID->1746043248],
Cell[2151, 78, 839, 31, 70, "Output",
 CellID->116884026]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3039, 115, 94, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[3136, 118, 377, 11, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[3516, 131, 3771, 113, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[7302, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

