(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4458,        162]
NotebookOptionsPosition[      2976,        116]
NotebookOutlinePosition[      3952,        144]
CellTagsIndexPosition[      3909,        141]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`CauchyPrincipalValue`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "New method option",
 Cell[BoxData[
  RowBox[{" ", "\"\<PrincipalValue\>\""}]], "InlineFormula"],
 " has been added to the ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " function of the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To evaluate the Cauchy Principal Value of ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", "1"}], "2"], 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]]],
 " use the ",
 Cell[BoxData["\"\<PrincipalValue\>\""], "InlineFormula"],
 " Method option for ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`CauchyPrincipalValue`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CauchyPrincipalValue", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", "-", 
     SuperscriptBox["x", "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"{", "0", "}"}], ",", "2"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", "-", 
     SuperscriptBox["x", "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<PrincipalValue\>\"", ",", 
      RowBox[{"\"\<SingularPointIntegrationRadius\>\"", "\[Rule]", 
       RowBox[{"1", "/", "4"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1746043248],

Cell[BoxData["1.3862943611192309`"], "Output",
 CellLabel->"Out[6]=",
 CellID->801492227]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 55.4242012}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/CauchyPrincipalValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 85, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[897, 35, 400, 14, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1300, 51, 561, 20, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1864, 73, 427, 14, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2316, 91, 514, 15, 70, "Input",
 CellID->1746043248],
Cell[2833, 108, 89, 2, 70, "Output",
 CellID->801492227]
}, Open  ]]
}, Open  ]],
Cell[2949, 114, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

