(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5772,        196]
NotebookOptionsPosition[      4047,        142]
NotebookOutlinePosition[      5021,        170]
CellTagsIndexPosition[      4978,        167]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`ComputerArithmetic`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["NumericalMath`ComputerArithmetic`"], "InlineFormula"],
 " is now available in the newly created ",
 ButtonBox["Computer Arithmetic Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Computer Arithmetic Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"],
 ", load",
 Cell[BoxData[
  RowBox[{" ", "ComputerArithmetic`"}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`ComputerArithmetic`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ComputerNumber", "[", "4", "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "ComputerArithmetic`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ComputerNumber", "[", "4", "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1746043248],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"4.000000000000000000\"\>",
   4.`18.954589770191003,
   AutoDelete->True],
  BaseForm[#, 10]& ]], "Output",
 CellLabel->"Out[8]=",
 CellID->696064087]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computer Arithmetic package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["NumericalMath`ComputerArithmetic`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Computer Arithmetic Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[Cell[BoxData[{
 ButtonBox["Arithmetic",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/Arithmetic"], "\n", 
 ButtonBox["ComputerNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/ComputerNumber"], "\n", 
 ButtonBox["ExponentRange",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/ExponentRange"], "\n", 
 ButtonBox["IdealDivide",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/IdealDivide"], "\n", 
 ButtonBox["MixedMode",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/MixedMode"], "\n", 
 ButtonBox["NaN",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/NaN"], "\n", 
 ButtonBox["RoundingRule",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"], "\n", 
 ButtonBox["RoundToEven",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/RoundToEven"], "\n", 
 ButtonBox["RoundToInfinity",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/RoundToInfinity"], "\n", 
 ButtonBox["SetArithmetic",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"], "\n", 
 ButtonBox["Truncation",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ComputerArithmetic/ref/Truncation"]}], "InlineFormula"]], \
"UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 55.5648298}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ComputerArithmetic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 83, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[895, 35, 346, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1244, 46, 327, 10, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1574, 58, 204, 5, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1803, 67, 195, 5, 70, "Input",
 CellID->1746043248],
Cell[2001, 74, 198, 7, 70, "Output",
 CellID->696064087]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2248, 87, 81, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[2332, 90, 323, 9, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[2658, 101, 1347, 36, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[4020, 140, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

