(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6931,        225]
NotebookOptionsPosition[      5205,        171]
NotebookOutlinePosition[      6175,        199]
CellTagsIndexPosition[      6132,        196]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`EquationTrekker`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["NumericalMath`EquationTrekker`"], "InlineFormula"],
 " is now available in the newly created ",
 ButtonBox["Equation Trekker Package",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/guide/EquationTrekkerPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Equation Trekker Package",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/guide/EquationTrekkerPackage"],
 ", load ",
 Cell[BoxData["EquationTrekker`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`EquationTrekker`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"y", "[", "x", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", "y", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     FractionBox["\[Pi]", "8"], ",", " ", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "EquationTrekker`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"y", "[", "x", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", "y", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     FractionBox["\[Pi]", "8"], ",", " ", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"EquationTrekkerState", "[", 
     RowBox[{"\<\"\\\"\\!\\({y[x] + \\*\\nSuperscriptBox[\\\"y\\\", \\\"\
\[Prime]\[Prime]\\\",\\nMultilineFunction->None][x] \[Equal] 0, y, {x, \
\\n\\*FractionBox[\\(\[Pi]\\), \\(8\\)], 2\\\\ \[Pi]}}\\)\\\"\"\>", 
      ",", "\<\"\\\"\\!\\({}\\)\\\"\"\>", ",", 
      TagBox[
       RowBox[{"{", "}"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], ",", "\<\" <>\"\>"}], "]"}],
    EquationTrekker`EquationTrekkerState[{$CellContext`y[$CellContext`x] + 
       Derivative[2][$CellContext`y][$CellContext`x] == 
      0, $CellContext`y, {$CellContext`x, Rational[1, 8] Pi, 2 Pi}}, {}, {}, {
     EquationTrekker`TrekParameters -> {}, 
      PlotRange -> {{-1., 1.}, {-1.02, 1.}}, "CanvasSize" -> {400, 404}}]], 
   ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->1710112301]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equation Trekker Package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["NumericalMath`EquationTrekker`"], "InlineFormula"],
 " are now found in the",
 ButtonBox[" Equation Trekker Package",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/guide/EquationTrekkerPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[Cell[BoxData[{
 ButtonBox["DifferentialEquationTrek",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"], "\n", 
 ButtonBox["EquationTrekker",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"], "\n", 
 ButtonBox["EquationTrekkerNonModal",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerNonModal"], "\n", 
 ButtonBox["EquationTrekkerState",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"], "\n", 
 ButtonBox["InitializeGenerator",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"], "\n", 
 ButtonBox["PoincareSection",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/ref/PoincareSection"], "\n", 
 ButtonBox["TrekData",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/ref/TrekData"], "\n", 
 ButtonBox["TrekGenerator",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"], "\n", 
 ButtonBox["TrekParameters",
  BaseStyle->"Link",
  ButtonData->
   "paclet:EquationTrekker/ref/TrekParameters"]}], "InlineFormula"]], \
"UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 2.3931296}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/EquationTrekker"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 80, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[892, 35, 334, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1229, 46, 298, 9, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1530, 57, 522, 16, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2077, 77, 513, 16, 70, "Input",
 CellID->1746043248],
Cell[2593, 95, 930, 21, 70, "Output",
 CellID->1710112301]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3572, 122, 78, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[3653, 125, 311, 9, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[3967, 136, 1196, 30, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[5178, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

