(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5641,        195]
NotebookOptionsPosition[      3912,        141]
NotebookOutlinePosition[      4885,        169]
CellTagsIndexPosition[      4842,        166]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`GaussianQuadrature`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of",
 Cell[BoxData[
  RowBox[{" ", "NumericalMath`GaussianQuadrature`"}]], "InlineFormula"],
 "is now available in the newly created ",
 ButtonBox["Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 ", load \n",
 Cell[BoxData["NumericalDifferentialEquationAnalysis`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`GaussianQuadrature`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GaussianQuadratureWeights", "[", 
  RowBox[{"5", ",", 
   RowBox[{"-", "3"}], ",", "7"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalDifferentialEquationAnalysis`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GaussianQuadratureWeights", "[", 
  RowBox[{"5", ",", 
   RowBox[{"-", "3"}], ",", "7"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.5308992296933193`"}], ",", "1.1846344252809495`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.692346550528415`"}], ",", "2.3931433524968293`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "2.8444444444444406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.6923465505284145`", ",", "2.3931433524968293`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.530899229693318`", ",", "1.1846344252809495`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->196449272]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Differential Equation Analysis Package", \
"UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["NumericalMath`GaussianQuadrature`"], "InlineFormula"],
 " are now found in the",
 ButtonBox[" Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[Cell[BoxData[{
 ButtonBox["GaussianQuadratureError",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/GaussianQuadratureError"]\
, "\n", 
 ButtonBox["GaussianQuadratureWeights",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"]}], "InlineFormula"]], "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 2.5337582}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/GaussianQuadrature"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 83, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[895, 35, 427, 12, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1325, 49, 396, 11, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1724, 62, 267, 7, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2016, 73, 280, 8, 70, "Input",
 CellID->1746043248],
Cell[2299, 83, 607, 19, 70, "Output",
 CellID->196449272]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2955, 108, 104, 2, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[3062, 112, 388, 11, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[3453, 125, 417, 11, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[3885, 139, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

