(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4270,        156]
NotebookOptionsPosition[      2796,        110]
NotebookOutlinePosition[      3764,        138]
CellTagsIndexPosition[      3721,        135]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`ListIntegrate`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "The functionality of ",
 Cell[BoxData["NumericalMath`ListIntegrate`"], "InlineFormula"],
 " is now accessible by using the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel functions ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->831593344],

Cell["\<\
This gives an approximation to the integral of the function that produced the \
list of data:\
\>", "UpgradeDetail",
 CellID->1349403780],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`ListIntegrate`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "7"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListIntegrate", "[", 
  RowBox[{"data", ",", "1"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"n", "^", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "7"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"data", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}], "[", "x", 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1746043248],

Cell[BoxData[
 FractionBox["343", "3"]], "Output",
 CellLabel->"Out[5]=",
 CellID->2002018140]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 2.7837646}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ListIntegrate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 78, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[890, 35, 531, 18, 70, "UpgradeSummary",
 CellID->831593344],
Cell[1424, 55, 147, 4, 70, "UpgradeDetail",
 CellID->1349403780],
Cell[1574, 61, 445, 14, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2044, 79, 601, 20, 70, "Input",
 CellID->1746043248],
Cell[2648, 101, 94, 3, 70, "Output",
 CellID->2002018140]
}, Open  ]]
}, Open  ]],
Cell[2769, 108, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

