(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4980,        179]
NotebookOptionsPosition[      3269,        125]
NotebookOutlinePosition[      4230,        153]
CellTagsIndexPosition[      4187,        150]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`NLimit`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["NumericalMath`NLimit`"], "InlineFormula"],
 " is now available in the newly created ",
 ButtonBox["Numerical Calculus Package",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/guide/NumericalCalculusPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Numerical Calculus Package",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/guide/NumericalCalculusPackage"],
 ", load ",
 Cell[BoxData["NumericalCalculus`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`NLimit`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Zeta", "[", "s", "]"}], "-", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}]}]}], ",", 
   RowBox[{"s", "\[Rule]", "1"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalCalculus`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Zeta", "[", "s", "]"}], "-", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}]}]}], ",", 
   RowBox[{"s", "\[Rule]", "1"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1746043248],

Cell[BoxData["0.5772156597127777`"], "Output",
 CellLabel->"Out[3]=",
 CellID->962246956]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Calculus Package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["NumericalMath`NLimit`"], "InlineFormula"],
 " are now found in the",
 ButtonBox[" Numerical Calculus Package",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/guide/NumericalCalculusPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[Cell[BoxData[{
 ButtonBox["NLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/NLimit"], "\n", 
 ButtonBox["EulerSum",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/EulerSum"], "\n", 
 ButtonBox["ND",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalCalculus/ref/ND"]}], "InlineFormula"]], \
"UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 3.3306536}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/NLimit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 71, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[883, 35, 331, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1217, 46, 306, 9, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1526, 57, 369, 11, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1920, 72, 374, 12, 70, "Input",
 CellID->1746043248],
Cell[2297, 86, 89, 2, 70, "Output",
 CellID->962246956]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2435, 94, 80, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[2518, 97, 308, 9, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[2829, 108, 398, 12, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[3242, 123, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

