(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6115,        202]
NotebookOptionsPosition[      4647,        156]
NotebookOutlinePosition[      5608,        184]
CellTagsIndexPosition[      5565,        181]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`ANOVA`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All functionality is available in the newly created ",
 ButtonBox["Analysis of Variance Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/guide/AnalysisOfVariancePackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Load ",
 Cell[BoxData["ANOVA`"], "InlineFormula"],
 " to use the ",
 ButtonBox["Analysis of Variance Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/guide/AnalysisOfVariancePackage"],
 " functionality:"
}], "UpgradeDetail",
 CellID->1521184287],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`ANOVA`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ANOVA", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "8"}], "}"}]}], "}"}], "]"}]}], "Input", "LegacyInput",
 
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "ANOVA`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ANOVA", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "8"}], "}"}]}], "}"}], "]"}]}], "Input",
 CellLabel->"In[23]:=",
 CellID->2088293695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "2.666666666666657`", "2.666666666666657`", 
        "0.39999999999999847`", "0.5614380442505265`"},
       {"\<\"Error\"\>", "4", "26.66666666666667`", 
        "6.666666666666668`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "5", 
        "29.33333333333333`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 2.66666666666666, 2.66666666666666, 0.399999999999998, 
        0.561438044250526}, {4, 26.6666666666667, 6.66666666666667}, {
       5, 29.3333333333333}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "4.333333333333333`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], "3.6666666666666665`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], "5.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], "}"}]], "Output",
 CellLabel->"Out[24]=",
 CellID->871815122]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 12.7840206}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ANOVA"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 67, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[879, 35, 247, 7, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1129, 44, 273, 9, 70, "UpgradeDetail",
 CellID->1521184287],
Cell[1405, 55, 571, 19, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2001, 78, 567, 19, 70, "Input",
 CellID->2088293695],
Cell[2571, 99, 2022, 51, 70, "Output",
 CellID->871815122]
}, Open  ]]
}, Open  ]],
Cell[4620, 154, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

