(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10346,        382]
NotebookOptionsPosition[      7998,        306]
NotebookOutlinePosition[      8969,        334]
CellTagsIndexPosition[      8926,        331]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`ClusterAnalysis`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " and the distance and dissimilarity functions have been added to the \
built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData["SupDistance"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["ChebyshevDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevDistance"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["CorrelationDissimilarity"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["CorrelationDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CorrelationDistance"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["CosineAngleDissimilarity"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["CosineDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosineDistance"]], "InlineFormula"],
 ".\nA new ",
 ButtonBox["Hierarchical Clustering Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:HierarchicalClustering/guide/HierarchicalClusteringPackage"],
 " has been created."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Syntax for ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " is the same as in ",
 Cell[BoxData["Statistics`ClusterAnalysis`"], "InlineFormula"],
 " in Version 5.2:"
}], "UpgradeDetail",
 CellID->1402395794],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`ClusterAnalysis`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "10"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->277401373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "10"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->2127015697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"20", ",", "10"}], "}"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[51]=",
 CellID->81951985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4294142],

Cell[TextData[{
 "Syntax for distance and dissimilarity functions is also the same as in ",
 Cell[BoxData["Statistics`ClusterAnalysis`"], "InlineFormula"],
 " in Version 5.2:"
}], "UpgradeDetail",
 CellID->171064451],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`ClusterAnalysis`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ManhattanDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "10", ",", "4", ",", "15"}], "}"}]}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->178515524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ManhattanDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "10", ",", "4", ",", "15"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->164196875],

Cell[BoxData["15"], "Output",
 CellLabel->"Out[2]=",
 CellID->898576044]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["HierarchicalClustering package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["Statistics`ClusterAnalysis`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Hierarchical Clustering Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:HierarchicalClustering/guide/HierarchicalClusteringPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Agglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["ClusterFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/ClusterFlatten"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["ClusterSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/ClusterSplit"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["DirectAgglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DirectAgglomerate"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["DistanceMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DistanceMatrix"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["DendrogramPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["DirectAgglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DirectAgglomerate"]], 
  "InlineFormula"]
}], "UpgradePackageListing",
 CellID->701993520],

Cell[TextData[{
 "Syntax for these functions is the same as in ",
 Cell[BoxData["Statistics`ClusterAnalysis`"], "InlineFormula"],
 " in Version 5.2:"
}], "UpgradeDetail",
 CellID->112609602],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`ClusterAnalysis`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Agglomerate", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "10"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->100830205],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "HierarchicalClustering`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Agglomerate", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "10"}], "}"}]}], "}"}], "]"}]}], "Input",
 CellLabel->"In[53]:=",
 CellID->63209799],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", "8", ",", "1", ",", "1"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "10"}], "}"}], ",", "325", ",", "2", ",", "1"}], 
  "]"}]], "Output",
 CellLabel->"Out[54]=",
 CellID->503725213]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 12.9402746}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ClusterAnalysis"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 77, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[889, 35, 1183, 37, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[2075, 74, 308, 10, 70, "UpgradeDetail",
 CellID->1402395794],
Cell[2386, 86, 409, 14, 70, "Input",
 CellID->277401373],
Cell[CellGroupData[{
Cell[2820, 104, 322, 11, 70, "Input",
 CellID->2127015697],
Cell[3145, 117, 348, 13, 70, "Output",
 CellID->81951985]
}, Open  ]],
Cell[3508, 133, 123, 3, 70, "ExampleDelimiter",
 CellID->4294142],
Cell[3634, 138, 216, 5, 70, "UpgradeDetail",
 CellID->171064451],
Cell[3853, 145, 410, 12, 70, "Input",
 CellID->178515524],
Cell[CellGroupData[{
Cell[4288, 161, 300, 9, 70, "Input",
 CellID->164196875],
Cell[4591, 172, 72, 2, 70, "Output",
 CellID->898576044]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4712, 180, 84, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[4799, 183, 333, 10, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[5135, 195, 1356, 49, 70, "UpgradePackageListing",
 CellID->701993520],
Cell[6494, 246, 190, 5, 70, "UpgradeDetail",
 CellID->112609602],
Cell[6687, 253, 408, 14, 70, "Input",
 CellID->100830205],
Cell[CellGroupData[{
Cell[7120, 271, 407, 13, 70, "Input",
 CellID->63209799],
Cell[7530, 286, 414, 14, 70, "Output",
 CellID->503725213]
}, Open  ]]
}, Open  ]],
Cell[7971, 304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

