(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31187,       1182]
NotebookOptionsPosition[     25321,        980]
NotebookOutlinePosition[     26293,       1008]
CellTagsIndexPosition[     26250,       1005]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`DataManipulation`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "Functionality in this package has been added to the built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData["CumulativeSums"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["Accumulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accumulate"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["Frequencies"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["Tally",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tally"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinLists"]], "InlineFormula"],
 " incorporate the functionality of ",
 Cell[BoxData["RangeCounts"], "InlineFormula"],
 " and ",
 Cell[BoxData["RangeLists"], "InlineFormula"],
 " from Version 5.2."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LengthWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LengthWhile"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TakeWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TakeWhile"]], "InlineFormula"],
 " are now part of the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->356205909],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], ",", 
   "EvenQ"}], "]"}]}], "Input", "LegacyInput",
 CellID->689022859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], ",", 
   "EvenQ"}], "]"}]], "Input",
 CellLabel->"In[86]:=",
 CellID->57037058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "50", ",", "10"}], "}"}]], "Output",
 CellLabel->"Out[86]=",
 CellID->372671941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56503734],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinLists"]], "InlineFormula"],
 " are now part of the built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->245467195],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "15", ",", "95"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "100", ",", "10"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->212315539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "15", ",", "95"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "100", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166843422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->136345936]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->501957219],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinLists"]], "InlineFormula"],
 " incorporate the functionality of ",
 Cell[BoxData["RangeCounts"], "InlineFormula"],
 " and ",
 Cell[BoxData["RangeLists"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->237538494],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RangeLists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "15", ",", "95"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5", ",", "10", ",", "50", ",", "100"}], "}"}]}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->182823683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "15", ",", "95"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "Infinity"}], ",", "0", ",", "5", ",", "10", ",", "50", 
      ",", "100", ",", "Infinity"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98346600],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "15", "}"}], ",", 
   RowBox[{"{", "95", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->905122176]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->334470168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Accumulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accumulate"]], "InlineFormula"],
 " replaces ",
 Cell[BoxData["CumulativeSums"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->183743354],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CumulativeSums", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "15", ",", "95"}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->139116896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "15", ",", "95"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8895719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "6", ",", "21", ",", "116"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->716243989]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->582431533],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tally",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tally"]], "InlineFormula"],
 " replaces ",
 Cell[BoxData["Frequencies"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->27807651],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Frequencies", "[", 
  RowBox[{"{", 
   RowBox[{
   "c", ",", "a", ",", "b", ",", "c", ",", "a", ",", "b", ",", "b", ",", "b", 
    ",", "a"}], "}"}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->185160750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reverse", "[", 
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"Tally", "[", 
     RowBox[{"{", 
      RowBox[{
      "c", ",", "a", ",", "b", ",", "c", ",", "a", ",", "b", ",", "b", ",", 
       "b", ",", "a"}], "}"}], "]"}], "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137487424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "c"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->166833989]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->918070713],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ", ",
 Cell[BoxData["ColumnDrop"], "InlineFormula"],
 ", ",
 Cell[BoxData["ColumnJoin"], "InlineFormula"],
 ", ",
 Cell[BoxData["ColumnTake"], "InlineFormula"],
 " and ",
 Cell[BoxData["RowJoin"], "InlineFormula"],
 " can be accomplished with built\[Hyphen]in extraction functions:"
}], "UpgradeDetail",
 CellID->178212970],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->41412830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112286589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "b", ",", "a", ",", "b"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->4366703]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ColumnDrop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[3]:=",
 CellID->140308208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", "None", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->915370885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->7568410]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ColumnJoin", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[5]:=",
 CellID->431796558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->323253246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->278625902]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ColumnTake", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[7]:=",
 CellID->142635747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", "All", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->303850343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", "b", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->80595914]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RowJoin", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[9]:=",
 CellID->65702270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->65494775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "a", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "b", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "a", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->214953918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->467333874],

Cell[TextData[{
 Cell[BoxData["DropNonNumeric"], "InlineFormula"],
 " and ",
 Cell[BoxData["DropNonNumericColumn"], "InlineFormula"],
 " can be accomplished using ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->41344728],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DropNonNumeric", "[", 
  RowBox[{"{", 
   RowBox[{"c", ",", "a", ",", "2", ",", "3", ",", "a", ",", "1", ",", "b"}], 
   "}"}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->705258421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "2", ",", "3", ",", "a", ",", "1", ",", "b"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"NumberQ", "[", 
     RowBox[{"N", "[", "#", "]"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388350156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->303702274]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DropNonNumeric", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", "a", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[3]:=",
 CellID->718707067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"VectorQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{
       RowBox[{"NumberQ", "[", 
        RowBox[{"N", "[", "#", "]"}], "]"}], "&"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->380639581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->164218716]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DropNonNumericColumn", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", "a", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[5]:=",
 CellID->206199529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", "a", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{
     RowBox[{"VectorQ", "[", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"NumberQ", "[", 
         RowBox[{"N", "[", "#", "]"}], "]"}], "&"}]}], "]"}], "&"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->575460256],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->490729517]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197229868],

Cell[TextData[{
 Cell[BoxData["CategoryCounts"], "InlineFormula"],
 " can be replaced with ",
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->58820522],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CategoryCounts", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "1", ",", "2", ",", "d", ",", "3"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"_", "?", "NumberQ"}], ",", 
     RowBox[{"_", "?", "EvenQ"}]}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->212626156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Count", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "1", ",", "2", ",", "d", ",", "3"}], 
       "}"}], ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"_", "?", "NumberQ"}], ",", 
     RowBox[{"_", "?", "EvenQ"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->643331815],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"Out[2]=",
 CellID->481434967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172972292],

Cell[TextData[{
 Cell[BoxData["CategoryLists"], "InlineFormula"],
 " can be replaced with ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->988882],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DataManipulation`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CategoryLists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "1", ",", "2", ",", "d", ",", "3"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"_", "?", "NumberQ"}], ",", 
     RowBox[{"_", "?", "EvenQ"}]}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->188112904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "1", ",", "2", ",", "d", ",", "3"}], 
       "}"}], ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"_", "?", "NumberQ"}], ",", 
     RowBox[{"_", "?", "EvenQ"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106845436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"Out[2]=",
 CellID->160331972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556742619],

Cell[TextData[{
 Cell[BoxData["QuantileForm"], "InlineFormula"],
 " can be replaced with the following simple function:"
}], "UpgradeDetail",
 CellID->323872173],

Cell[BoxData[
 RowBox[{
  RowBox[{"qForm", "[", "data_", "]"}], ":=", 
  RowBox[{"Sort", "[", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"Length", "[", "data", "]"}], "]"}], "/", 
       RowBox[{"Length", "[", "data", "]"}]}], ",", 
      RowBox[{"Sort", "[", "data", "]"}]}], "}"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42362416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"qForm", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->219517848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "5"], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "5"], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "5"], ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "5"], ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "50"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->45117806]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 13.6277922}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/DataManipulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 78, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[890, 35, 1005, 34, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1898, 71, 408, 15, 70, "UpgradeDetail",
 CellID->356205909],
Cell[2309, 88, 308, 9, 70, "Input",
 CellID->689022859],
Cell[CellGroupData[{
Cell[2642, 101, 220, 7, 70, "Input",
 CellID->57037058],
Cell[2865, 110, 130, 4, 70, "Output",
 CellID->372671941]
}, Open  ]],
Cell[3010, 117, 124, 3, 70, "ExampleDelimiter",
 CellID->56503734],
Cell[3137, 122, 410, 15, 70, "UpgradeDetail",
 CellID->245467195],
Cell[3550, 139, 374, 12, 70, "Input",
 CellID->212315539],
Cell[CellGroupData[{
Cell[3949, 155, 261, 8, 70, "Input",
 CellID->166843422],
Cell[4213, 165, 203, 6, 70, "Output",
 CellID->136345936]
}, Open  ]],
Cell[4431, 174, 125, 3, 70, "ExampleDelimiter",
 CellID->501957219],
Cell[4559, 179, 455, 16, 70, "UpgradeDetail",
 CellID->237538494],
Cell[5017, 197, 397, 12, 70, "Input",
 CellID->182823683],
Cell[CellGroupData[{
Cell[5439, 213, 369, 11, 70, "Input",
 CellID->98346600],
Cell[5811, 226, 312, 11, 70, "Output",
 CellID->905122176]
}, Open  ]],
Cell[6138, 240, 125, 3, 70, "ExampleDelimiter",
 CellID->334470168],
Cell[6266, 245, 250, 9, 70, "UpgradeDetail",
 CellID->183743354],
Cell[6519, 256, 292, 9, 70, "Input",
 CellID->139116896],
Cell[CellGroupData[{
Cell[6836, 269, 173, 5, 70, "Input",
 CellID->8895719],
Cell[7012, 276, 139, 4, 70, "Output",
 CellID->716243989]
}, Open  ]],
Cell[7166, 283, 125, 3, 70, "ExampleDelimiter",
 CellID->582431533],
Cell[7294, 288, 236, 9, 70, "UpgradeDetail",
 CellID->27807651],
Cell[7533, 299, 344, 10, 70, "Input",
 CellID->185160750],
Cell[CellGroupData[{
Cell[7902, 313, 330, 10, 70, "Input",
 CellID->137487424],
Cell[8235, 325, 273, 10, 70, "Output",
 CellID->166833989]
}, Open  ]],
Cell[8523, 338, 125, 3, 70, "ExampleDelimiter",
 CellID->918070713],
Cell[8651, 343, 455, 15, 70, "UpgradeDetail",
 CellID->178212970],
Cell[9109, 360, 559, 18, 70, "Input",
 CellID->41412830],
Cell[CellGroupData[{
Cell[9693, 382, 457, 15, 70, "Input",
 CellID->112286589],
Cell[10153, 399, 134, 4, 70, "Output",
 CellID->4366703]
}, Open  ]],
Cell[10302, 406, 585, 18, 70, "Input",
 CellID->140308208],
Cell[CellGroupData[{
Cell[10912, 428, 481, 15, 70, "Input",
 CellID->915370885],
Cell[11396, 445, 330, 12, 70, "Output",
 CellID->7568410]
}, Open  ]],
Cell[11741, 460, 648, 21, 70, "Input",
 CellID->431796558],
Cell[CellGroupData[{
Cell[12414, 485, 529, 17, 70, "Input",
 CellID->323253246],
Cell[12946, 504, 441, 14, 70, "Output",
 CellID->278625902]
}, Open  ]],
Cell[13402, 521, 585, 18, 70, "Input",
 CellID->142635747],
Cell[CellGroupData[{
Cell[14012, 543, 480, 15, 70, "Input",
 CellID->303850343],
Cell[14495, 560, 231, 8, 70, "Output",
 CellID->80595914]
}, Open  ]],
Cell[14741, 571, 730, 23, 70, "Input",
 CellID->65702270],
Cell[CellGroupData[{
Cell[15496, 598, 627, 20, 70, "Input",
 CellID->65494775],
Cell[16126, 620, 413, 12, 70, "Output",
 CellID->214953918]
}, Open  ]],
Cell[16554, 635, 125, 3, 70, "ExampleDelimiter",
 CellID->467333874],
Cell[16682, 640, 325, 11, 70, "UpgradeDetail",
 CellID->41344728],
Cell[17010, 653, 322, 9, 70, "Input",
 CellID->705258421],
Cell[CellGroupData[{
Cell[17357, 666, 315, 10, 70, "Input",
 CellID->388350156],
Cell[17675, 678, 126, 4, 70, "Output",
 CellID->303702274]
}, Open  ]],
Cell[17816, 685, 534, 17, 70, "Input",
 CellID->718707067],
Cell[CellGroupData[{
Cell[18375, 706, 625, 21, 70, "Input",
 CellID->380639581],
Cell[19003, 729, 234, 8, 70, "Output",
 CellID->164218716]
}, Open  ]],
Cell[19252, 740, 540, 17, 70, "Input",
 CellID->206199529],
Cell[CellGroupData[{
Cell[19817, 761, 726, 23, 70, "Input",
 CellID->575460256],
Cell[20546, 786, 232, 8, 70, "Output",
 CellID->490729517]
}, Open  ]],
Cell[20793, 797, 125, 3, 70, "ExampleDelimiter",
 CellID->197229868],
Cell[20921, 802, 251, 9, 70, "UpgradeDetail",
 CellID->58820522],
Cell[21175, 813, 459, 14, 70, "Input",
 CellID->212626156],
Cell[CellGroupData[{
Cell[21659, 831, 433, 15, 70, "Input",
 CellID->643331815],
Cell[22095, 848, 166, 6, 70, "Output",
 CellID->481434967]
}, Open  ]],
Cell[22276, 857, 125, 3, 70, "ExampleDelimiter",
 CellID->172972292],
Cell[22404, 862, 248, 9, 70, "UpgradeDetail",
 CellID->988882],
Cell[22655, 873, 458, 14, 70, "Input",
 CellID->188112904],
Cell[CellGroupData[{
Cell[23138, 891, 433, 15, 70, "Input",
 CellID->106845436],
Cell[23574, 908, 249, 9, 70, "Output",
 CellID->160331972]
}, Open  ]],
Cell[23838, 920, 125, 3, 70, "ExampleDelimiter",
 CellID->556742619],
Cell[23966, 925, 161, 4, 70, "UpgradeDetail",
 CellID->323872173],
Cell[24130, 931, 432, 13, 70, "Input",
 CellID->42362416],
Cell[CellGroupData[{
Cell[24587, 948, 186, 6, 70, "Input",
 CellID->219517848],
Cell[24776, 956, 491, 18, 70, "Output",
 CellID->45117806]
}, Open  ]]
}, Open  ]],
Cell[25294, 978, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

