(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7154,        224]
NotebookOptionsPosition[      5676,        178]
NotebookOutlinePosition[      6648,        206]
CellTagsIndexPosition[      6605,        203]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`LinearRegression`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All functionality is available in the newly created ",
 ButtonBox["Linear Regression Package",
  BaseStyle->"Link",
  ButtonData->"paclet:LinearRegression/guide/LinearRegressionPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Load ",
 Cell[BoxData["LinearRegression`"], "InlineFormula"],
 " to use the ",
 ButtonBox["Linear Regression Package",
  BaseStyle->"Link",
  ButtonData->"paclet:LinearRegression/guide/LinearRegressionPackage"],
 " functionality:"
}], "UpgradeDetail",
 CellID->746756666],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`LinearRegression`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "LinearRegression`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Regress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], 
         RowBox[{"-", "0.5714285714285725`"}], "1.8210783977117084`", 
         RowBox[{"-", "0.31378581622109514`"}], "0.8064320282966713`"},
        {
         TagBox["x",
          HoldForm], "2.2142857142857144`", "0.6185895741317418`", 
         "3.5795716689756807`", "0.17342665114532352`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{1, $CellContext`x}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.9276061776061775`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.855212355212355`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "1.7857142857142874`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "22.88095238095238`", "22.88095238095238`", 
        "12.813333333333322`", "0.17342665114532363`"},
       {"\<\"Error\"\>", "1", "1.7857142857142874`", 
        "1.7857142857142874`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "2", 
        "24.666666666666668`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[2.0999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 22.88095238095238, 22.88095238095238, 12.813333333333322`, 
        0.17342665114532363`}, {
       1, 1.7857142857142874`, 1.7857142857142874`}, {
       2, 24.666666666666668`}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->449942335]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 19.0498060}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/LinearRegression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 78, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[890, 35, 253, 7, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1146, 44, 289, 9, 70, "UpgradeDetail",
 CellID->746756666],
Cell[1438, 55, 491, 16, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1954, 75, 485, 16, 70, "Input",
 CellID->1746043248],
Cell[2442, 93, 3180, 79, 70, "Output",
 CellID->449942335]
}, Open  ]]
}, Open  ]],
Cell[5649, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

