(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23689,        893]
NotebookOptionsPosition[     19553,        755]
NotebookOutlinePosition[     20535,        783]
CellTagsIndexPosition[     20492,        780]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`MultiDescriptiveStatistics`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "Univariate descriptive statistics have been added to the built\[Hyphen]in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\nMultivariate functionality from this package is included in the \
newly created ",
 ButtonBox["MultivariateStatistics Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"],
 ".\n",
 Cell[BoxData["MultivariateMode"], "InlineFormula"],
 " is replaced by the system function ",
 Cell[BoxData[
  ButtonBox["Commonest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Commonest"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["CovarianceMatrix"], "InlineFormula"],
 " and ",
 Cell[BoxData["CorrelationMatrix"], "InlineFormula"],
 " are replaced by the built\[Hyphen]in functions ",
 Cell[BoxData[
  ButtonBox["Covariance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Covariance"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Correlation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Correlation"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["RegionProbability"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["EllipsoidProbability",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"]], 
  "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["ConvexHullMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ConvexHullArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullArea"]], 
  "InlineFormula"],
 " are included in the newly created ",
 ButtonBox["ComputationalGeometry Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ComputationalGeometry/guide/ComputationalGeometryPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HarmonicMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicMean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InterquartileRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterquartileRange"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Kurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Kurtosis"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["QuartileDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuartileDeviation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Quartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartiles"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["QuartileSkewness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuartileSkewness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Skewness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skewness"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TrimmedMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrimmedMean"]], "InlineFormula"],
 " are now part of the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GeometricMean", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"10", " ", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]]}], ",", 
   RowBox[{"5", " ", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    SqrtBox["15"]}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1028087505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56503734],

Cell[TextData[{
 "MultivariateMode is replaced by ",
 Cell[BoxData[
  ButtonBox["Commonest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Commonest"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->245467195],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Mode", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->212315539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Commonest", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166843422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "15"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->350495468]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->782357569],

Cell[TextData[{
 Cell[BoxData["SampleRange"], "InlineFormula"],
 " can be computed using ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->48587845],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SampleRange", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->23348653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Min", "[", "#", "]"}], ",", 
      RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], ",", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "50"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "25"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359718975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "50"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->41517415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216775021],

Cell[TextData[{
 Cell[BoxData["ZeroMean"], "InlineFormula"],
 " can be computed by subtracting the mean from the data:"
}], "UpgradeDetail",
 CellID->784821678],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ZeroMean", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->153396708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", "#", "]"}], "-", 
     RowBox[{"Mean", "[", "#", "]"}]}], "]"}], "&"}], "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52286549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", 
     FractionBox["95", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["45", "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["15", "2"], ",", 
     RowBox[{"-", 
      FractionBox["5", "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["45", "4"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->373824726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14318716],

Cell[TextData[{
 "Other univariate measures can be computed as shown in the ",
 Cell[BoxData["Statistics`DescriptiveStatistics`"], "InlineFormula"],
 " compatibility pages:"
}], "UpgradeDetail",
 CellID->40519099],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"KurtosisExcess", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->81254237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Kurtosis", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}], "-", "3"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->354492564],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["2", "3"]}], ",", 
   RowBox[{"-", 
    FractionBox["15622", "17161"]}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->174272091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->822481974],

Cell["Covariance matrix for data:", "UpgradeDetail",
 CellID->415013396],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CovarianceMatrix", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->218463083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Covariance", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->484810466],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"25", ",", 
     RowBox[{"-", 
      FractionBox["25", "6"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["25", "6"]}], ",", 
     FractionBox["3275", "12"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->16308326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97417886],

Cell[TextData[{
 Cell[BoxData["MultivariateKurtosisExcess"], "InlineFormula"],
 " can be computed from ",
 Cell[BoxData[
  ButtonBox["MultivariateKurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/MultivariateKurtosis"]], 
  "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->653832257],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MultivariateKurtosisExcess", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->433896785],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "15"}], "}"}]}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MultivariateKurtosis", "[", "data", "]"}], "-", 
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"data", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"data", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", "2"}], ")"}]}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->507891895],

Cell[BoxData[
 RowBox[{"-", "3"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->41997405]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221477223],

Cell[TextData[{
 "Alternate covariances can be computed from ",
 Cell[BoxData[
  ButtonBox["Covariance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Covariance"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->166469807],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CovarianceMLE", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "35", ",", "5", ",", "25", ",", "40"}], "}"}]}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->269574689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", "=", 
     RowBox[{"{", 
      RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Covariance", "[", 
     RowBox[{"data1", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "35", ",", "5", ",", "25", ",", "40"}], "}"}]}], 
     "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Length", "[", "data1", "]"}], "-", "1"}], ")"}], "/", 
     RowBox[{"Length", "[", "data1", "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50412256],

Cell[BoxData["110"], "Output",
 CellLabel->"Out[2]=",
 CellID->290379840]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CovarianceMatrixMLE", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[3]:=",
 CellID->234772430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "15"}], "}"}]}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Covariance", "[", "data", "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}], "/", 
     RowBox[{"Length", "[", "data", "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->469082269],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["75", "4"], ",", 
     RowBox[{"-", 
      FractionBox["25", "8"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["25", "8"]}], ",", 
     FractionBox["3275", "16"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->323340293]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 19.2216854}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/MultiDescriptiveStatistics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 88, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[900, 35, 1878, 59, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[2781, 96, 1912, 70, 70, "UpgradeDetail",
 CellID->556646693],
Cell[4696, 168, 489, 16, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[5210, 188, 389, 13, 70, "Input",
 CellID->1746043248],
Cell[5602, 203, 295, 11, 70, "Output",
 CellID->1028087505]
}, Open  ]],
Cell[5912, 217, 124, 3, 70, "ExampleDelimiter",
 CellID->56503734],
Cell[6039, 222, 219, 8, 70, "UpgradeDetail",
 CellID->245467195],
Cell[6261, 232, 502, 17, 70, "Input",
 CellID->212315539],
Cell[CellGroupData[{
Cell[6788, 253, 445, 15, 70, "Input",
 CellID->166843422],
Cell[7236, 270, 118, 4, 70, "Output",
 CellID->350495468]
}, Open  ]],
Cell[7369, 277, 125, 3, 70, "ExampleDelimiter",
 CellID->782357569],
Cell[7497, 282, 364, 14, 70, "UpgradeDetail",
 CellID->48587845],
Cell[7864, 298, 508, 17, 70, "Input",
 CellID->23348653],
Cell[CellGroupData[{
Cell[8397, 319, 596, 20, 70, "Input",
 CellID->359718975],
Cell[8996, 341, 217, 8, 70, "Output",
 CellID->41517415]
}, Open  ]],
Cell[9228, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->216775021],
Cell[9356, 357, 160, 4, 70, "UpgradeDetail",
 CellID->784821678],
Cell[9519, 363, 506, 17, 70, "Input",
 CellID->153396708],
Cell[CellGroupData[{
Cell[10050, 384, 528, 18, 70, "Input",
 CellID->52286549],
Cell[10581, 404, 660, 26, 70, "Output",
 CellID->373824726]
}, Open  ]],
Cell[11256, 433, 124, 3, 70, "ExampleDelimiter",
 CellID->14318716],
Cell[11383, 438, 213, 5, 70, "UpgradeDetail",
 CellID->40519099],
Cell[11599, 445, 511, 17, 70, "Input",
 CellID->81254237],
Cell[CellGroupData[{
Cell[12135, 466, 416, 14, 70, "Input",
 CellID->354492564],
Cell[12554, 482, 208, 8, 70, "Output",
 CellID->174272091]
}, Open  ]],
Cell[12777, 493, 125, 3, 70, "ExampleDelimiter",
 CellID->822481974],
Cell[12905, 498, 72, 1, 70, "UpgradeDetail",
 CellID->415013396],
Cell[12980, 501, 514, 17, 70, "Input",
 CellID->218463083],
Cell[CellGroupData[{
Cell[13519, 522, 385, 13, 70, "Input",
 CellID->484810466],
Cell[13907, 537, 336, 13, 70, "Output",
 CellID->16308326]
}, Open  ]],
Cell[14258, 553, 124, 3, 70, "ExampleDelimiter",
 CellID->97417886],
Cell[14385, 558, 320, 10, 70, "UpgradeDetail",
 CellID->653832257],
Cell[14708, 570, 524, 17, 70, "Input",
 CellID->433896785],
Cell[CellGroupData[{
Cell[15257, 591, 955, 31, 70, "Input",
 CellID->507891895],
Cell[16215, 624, 87, 3, 70, "Output",
 CellID->41997405]
}, Open  ]],
Cell[16317, 630, 125, 3, 70, "ExampleDelimiter",
 CellID->221477223],
Cell[16445, 635, 232, 8, 70, "UpgradeDetail",
 CellID->166469807],
Cell[16680, 645, 423, 12, 70, "Input",
 CellID->269574689],
Cell[CellGroupData[{
Cell[17128, 661, 639, 20, 70, "Input",
 CellID->50412256],
Cell[17770, 683, 73, 2, 70, "Output",
 CellID->290379840]
}, Open  ]],
Cell[17858, 688, 517, 17, 70, "Input",
 CellID->234772430],
Cell[CellGroupData[{
Cell[18400, 709, 735, 24, 70, "Input",
 CellID->469082269],
Cell[19138, 735, 361, 14, 70, "Output",
 CellID->323340293]
}, Open  ]]
}, Open  ]],
Cell[19526, 753, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

