(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12949,        467]
NotebookOptionsPosition[     10558,        389]
NotebookOutlinePosition[     11537,        417]
CellTagsIndexPosition[     11494,        414]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`MultinormalDistribution`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "Distributions defined in this package are included in the newly created ",
 ButtonBox["Multivariate Statistics Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"],
 ".\n",
 Cell[BoxData[
  ButtonBox["Random",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Random"]], "InlineFormula"],
 " and ",
 Cell[BoxData["RandomArray"], "InlineFormula"],
 " are replaced by ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["CovarianceMatrix"], "InlineFormula"],
 " and ",
 Cell[BoxData["CorrelationMatrix"], "InlineFormula"],
 " are replaced by ",
 Cell[BoxData[
  ButtonBox["Covariance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Covariance"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Correlation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Correlation"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["RegionProbability"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["EllipsoidProbability",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"]], 
  "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Load ",
 Cell[BoxData["MultivariateStatistics`"], "InlineFormula"],
 " to use ",
 ButtonBox["Multivariate Statistics Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"],
 " functionality:"
}], "UpgradeDetail",
 CellID->746756666],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultinormalDistribution`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Mu]", "1"], ",", 
       SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "\[Rho]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Mu]", "1"], ",", 
       SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "\[Rho]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[115]:=",
 CellID->2088293695],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"x", "-", 
          SubscriptBox["\[Mu]", "1"]}], ")"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"x", "-", 
           SubscriptBox["\[Mu]", "1"]}], 
          RowBox[{"1", "-", 
           SuperscriptBox["\[Rho]", "2"]}]], "-", 
         FractionBox[
          RowBox[{"\[Rho]", " ", 
           RowBox[{"(", 
            RowBox[{"y", "-", 
             SubscriptBox["\[Mu]", "2"]}], ")"}]}], 
          RowBox[{"1", "-", 
           SuperscriptBox["\[Rho]", "2"]}]]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[Rho]", " ", 
            RowBox[{"(", 
             RowBox[{"x", "-", 
              SubscriptBox["\[Mu]", "1"]}], ")"}]}], 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Rho]", "2"]}]]}], "+", 
         FractionBox[
          RowBox[{"y", "-", 
           SubscriptBox["\[Mu]", "2"]}], 
          RowBox[{"1", "-", 
           SuperscriptBox["\[Rho]", "2"]}]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"y", "-", 
         SubscriptBox["\[Mu]", "2"]}], ")"}]}]}], ")"}]}]], 
  RowBox[{"2", " ", "\[Pi]", " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["\[Rho]", "2"]}]]}]]], "Output",
 CellLabel->"Out[116]=",
 CellID->11415534]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260366343],

Cell[TextData[{
 "Random elements for multivariate continuous distributions are generated via \
",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->148245370],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultinormalDistribution`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Random", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->873779382],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomReal", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->75025638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.8544114276709116`", ",", "1.563043676147815`"}], "}"}]], "Output",\

 CellLabel->"Out[2]=",
 CellID->416474422]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultinormalDistribution`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomArray", "[", 
  RowBox[{
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
   "5"}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[3]:=",
 CellID->156217555],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
   "5"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->438868097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.23400431152021328`"}], ",", "0.08826910830765455`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7737929828952872`", ",", "2.0516998024112594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6054927509416768`", ",", "1.2228559109819006`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4882304640965534`", ",", "1.0245193713020835`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1299187014417904`", ",", "0.6851350142225223`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->203140002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->822481974],

Cell["Covariance matrix for a multivariate distribution:", "UpgradeDetail",
 CellID->415013396],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultinormalDistribution`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CovarianceMatrix", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->218463083],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Covariance", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->484810466],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->425001386]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 19.5810696}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/MultinormalDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 85, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[897, 35, 1278, 42, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[2178, 79, 313, 10, 70, "UpgradeDetail",
 CellID->746756666],
Cell[2494, 91, 635, 20, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[3154, 115, 630, 20, 70, "Input",
 CellID->2088293695],
Cell[3787, 137, 1537, 50, 70, "Output",
 CellID->11415534]
}, Open  ]],
Cell[5339, 190, 125, 3, 70, "ExampleDelimiter",
 CellID->260366343],
Cell[5467, 195, 267, 9, 70, "UpgradeDetail",
 CellID->148245370],
Cell[5737, 206, 567, 19, 70, "Input",
 CellID->873779382],
Cell[CellGroupData[{
Cell[6329, 229, 540, 18, 70, "Input",
 CellID->75025638],
Cell[6872, 249, 153, 5, 70, "Output",
 CellID->416474422]
}, Open  ]],
Cell[7040, 257, 608, 20, 70, "Input",
 CellID->156217555],
Cell[CellGroupData[{
Cell[7673, 281, 577, 19, 70, "Input",
 CellID->438868097],
Cell[8253, 302, 602, 17, 70, "Output",
 CellID->203140002]
}, Open  ]],
Cell[8870, 322, 125, 3, 70, "ExampleDelimiter",
 CellID->822481974],
Cell[8998, 327, 95, 1, 70, "UpgradeDetail",
 CellID->415013396],
Cell[9096, 330, 577, 19, 70, "Input",
 CellID->218463083],
Cell[CellGroupData[{
Cell[9698, 353, 541, 18, 70, "Input",
 CellID->484810466],
Cell[10242, 373, 262, 10, 70, "Output",
 CellID->425001386]
}, Open  ]]
}, Open  ]],
Cell[10531, 387, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

