(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12562,        400]
NotebookOptionsPosition[     10672,        340]
NotebookOutlinePosition[     11640,        368]
CellTagsIndexPosition[     11597,        365]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`NonlinearFit`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData["NonlinearFit"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 ".\nA new ",
 ButtonBox["Nonlinear Regression Package",
  BaseStyle->"Link",
  ButtonData->"paclet:NonlinearRegression/guide/NonlinearRegressionPackage"],
 " has been created."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData["NonlinearFit"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`NonlinearFit`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NonlinearFit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"a", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", "*", "x"}], "]"}]}], ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "*", 
   RowBox[{"Sin", "[", 
    RowBox[{"b", "*", "x"}], "]"}]}], "/.", 
  RowBox[{"FindFit", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"a", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"b", "*", "x"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", "x", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"6.47756139391417`", " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"0.7862248547484633`", " ", "x"}], "]"}]}]], "Output",
 CellLabel->"Out[4]=",
 CellID->219635456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31526440],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " function from ",
 Cell[BoxData["Statistics`NonlinearFit`"], "InlineFormula"],
 " is now found in the ",
 StyleBox["NonlinearRegression",
  FontWeight->"Bold"],
 " package:"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`NonlinearFit`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"a", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", "*", "x"}], "]"}]}], ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->403553132],

Cell[TextData[{
 "The arguments are consistent with those of",
 " ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->601192615],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NonlinearRegression`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"a", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", "*", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->254997184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFitParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "6.47756139391417`"}], ",", 
      RowBox[{"b", "\[Rule]", "0.7862248547484633`"}]}], "}"}]}], ",", 
   RowBox[{"ParameterCITable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"Asymptotic SE\"\>",
          HoldForm], 
         TagBox["\<\"CI\"\>",
          HoldForm]},
        {
         TagBox["a",
          HoldForm], "6.47756139391417`", "1.148786811931746`", 
         RowBox[{"{", 
          RowBox[{"1.5347306816558604`", ",", "11.42039210617248`"}], "}"}]},
        {
         TagBox["b",
          HoldForm], "0.7862248547484633`", "0.05468070581881483`", 
         RowBox[{"{", 
          RowBox[{"0.5509527665925122`", ",", "1.0214969429044143`"}], "}"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{$CellContext`a, $CellContext`b}, {
         "Estimate", "Asymptotic SE", "CI"}}]]]}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "2.575713109248597`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>"},
       {"\<\"Model\"\>", "2", "83.84857378150281`", "41.924286890751404`"},
       {"\<\"Error\"\>", "2", "5.151426218497194`", "2.575713109248597`"},
       {"\<\"Uncorrected Total\"\>", "4", "89.`", "\<\"\"\>"},
       {"\<\"Corrected Total\"\>", "3", "32.75`", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[2.0999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{2, 83.84857378150281, 41.924286890751404`}, {
       2, 5.151426218497194, 2.575713109248597}, {4, 89.}, {3, 32.75}}, 
      TableHeadings -> {{
        "Model", "Error", "Uncorrected Total", "Corrected Total"}, {
        "DF", "SumOfSq", "MeanSq"}}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1.0000000000000002`", "0.1527552015159662`"},
        {"0.1527552015159662`", "1.0000000000000002`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Curvature\"\>",
          HoldForm]},
        {
         TagBox["\<\"Max Intrinsic\"\>",
          HoldForm], "0.06168276137569487`"},
        {
         TagBox["\<\"Max Parameter-Effects\"\>",
          HoldForm], "0.32750897775995474`"},
        {
         TagBox["\<\"95. % Confidence Region\"\>",
          HoldForm], "0.22941573387056188`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 CellLabel->"Out[2]=",
 CellID->352979893]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 19.7373236}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/NonlinearFit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 74, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[886, 35, 423, 13, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1312, 50, 248, 9, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1563, 61, 669, 21, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2257, 86, 703, 24, 70, "Input",
 CellID->1746043248],
Cell[2963, 112, 181, 5, 70, "Output",
 CellID->219635456]
}, Open  ]],
Cell[3159, 120, 124, 3, 70, "ExampleDelimiter",
 CellID->31526440],
Cell[3286, 125, 400, 14, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[3689, 141, 695, 22, 70, "Input",
 CellID->403553132],
Cell[4387, 165, 231, 9, 70, "UpgradeDetail",
 CellID->601192615],
Cell[CellGroupData[{
Cell[4643, 178, 676, 22, 70, "Input",
 CellID->254997184],
Cell[5322, 202, 5296, 132, 70, "Output",
 CellID->352979893]
}, Open  ]]
}, Open  ]],
Cell[10645, 338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

