(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13393,        464]
NotebookOptionsPosition[     11227,        394]
NotebookOutlinePosition[     12198,        422]
CellTagsIndexPosition[     12155,        419]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`StatisticsPlots`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All functionality is available in the newly created ",
 ButtonBox["Statistical Plots Package",
  BaseStyle->"Link",
  ButtonData->"paclet:StatisticalPlots/guide/StatisticalPlotsPackage"],
 ".\n",
 Cell[BoxData["SymbolShape"], "InlineFormula"],
 " and ",
 Cell[BoxData["SymbolStyle"], "InlineFormula"],
 " options are replaced by ",
 Cell[BoxData[
  ButtonBox["PlotMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotMarkers"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["PlotJoined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotJoined"]], "InlineFormula"],
 " option is replaced by ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["BoxOutlierShapes"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["BoxOutlierMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutlierMarkers"]], 
  "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Load ",
 Cell[BoxData["StatisticalPlots`"], "InlineFormula"],
 " to use the ",
 ButtonBox["Statistical Plots Package",
  BaseStyle->"Link",
  ButtonData->"paclet:StatisticalPlots/guide/StatisticalPlotsPackage"],
 " functionality:"
}], "UpgradeDetail",
 CellID->1365381745],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`StatisticsPlots`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "5", ",", "2", ",", "10", ",", "3", ",", "2", ",", "5", ",", 
    "4"}], "}"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "StatisticalPlots`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "5", ",", "2", ",", "10", ",", "3", ",", "2", ",", "5", ",", 
    "4"}], "}"}], "]"}]}], "Input",
 CellLabel->"In[19]:=",
 CellID->1746043248],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.4, 0.8], 
    PolygonBox[{{0.75, 2}, {1.25, 2}, {1.25, 5}, {0.75, 5}, {0.75, 2}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.75, 2}, {1.25, 2}, {1.25, 5}, {0.75, 5}, {0.75, 2}}], 
    LineBox[{{0.88, 1}, {1.12, 1}}], LineBox[{{1, 1}, {1, 2}}], 
    LineBox[{{1, 5}, {1, 10}}], LineBox[{{0.88, 10}, {1.12, 10}}], 
    LineBox[NCache[{{0.75, Rational[7, 2]}, {1.25, Rational[7, 2]}}, {{0.75, 
      3.5}, {1.25, 3.5}}]]}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->True,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{None, Automatic, None, None},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.5, 1.5}, All},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellLabel->"Out[20]=",
 CellID->39993310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->985997995],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " replaces ",
 Cell[BoxData[
  ButtonBox["PlotJoined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotJoined"]], "InlineFormula"],
 " option:"
}], "UpgradeDetail",
 CellID->9145629],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`StatisticsPlots`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ParetoPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "a", ",", "a", ",", "c", ",", "b", ",", "c", ",", 
     "a"}], "}"}], ",", 
   RowBox[{"PlotJoined", "\[Rule]", "True"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->301401026],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "StatisticalPlots`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ParetoPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "a", ",", "a", ",", "c", ",", "b", ",", "c", ",", 
     "a"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->5170467],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{0.615, 0}, 
      NCache[{1.385, Rational[1, 2]}, {1.385, 0.5}]]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{1.615, 0}, 
      NCache[{2.385, Rational[1, 4]}, {2.385, 0.25}]]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{2.615, 0}, 
      NCache[{3.385, Rational[1, 4]}, {3.385, 0.25}]]}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{{1., 0.5}, {2., 0.75}, {3., 1.}}]}}, {
     {Hue[0.67, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], {1., 0.5}], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], {2., 0.75}], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], {3., 1.}]}, {}}}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0.4, 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{{{1, 
      FormBox["a", TraditionalForm], 0}, {2, 
      FormBox["c", TraditionalForm], 0}, {3, 
      FormBox["b", TraditionalForm], 0}}, Automatic},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.4, 3.6}, All},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{1, 
      FormBox["a", TraditionalForm], 0}, {2, 
      FormBox["c", TraditionalForm], 0}, {3, 
      FormBox["b", TraditionalForm], 0}}, Automatic},
  TicksStyle->{}]], "Output",
 CellLabel->"Out[2]=",
 CellID->95345561]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14898632],

Cell["\<\
Use non\[Hyphen]default outlier markers:\
\>", "UpgradeDetail",
 CellID->31178525],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`StatisticsPlots`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "5", ",", "2", ",", "10", ",", "3", ",", "2", ",", "5", ",", 
     "4"}], "}"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"BoxOutlierShapes", "\[Rule]", 
    RowBox[{"PlotSymbol", "[", "Triangle", "]"}]}]}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->374697140],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "StatisticalPlots`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "5", ",", "2", ",", "10", ",", "3", ",", "2", ",", "5", ",", 
     "4"}], "}"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"BoxOutlierMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[RectangleBox[{0., 0.}],
       ImageSize->{11., Automatic}], ",", 
      GraphicsBox[
       PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772,
         0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
       ImageSize->{19., 16.},
       PlotRange->{{0, 1}, {0, 0.61803}},
       PlotRegion->{{0., 1.57342657342657}, {0., 1.}}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->711049014],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.4, 0.8], 
    PolygonBox[{{0.75, 2}, {1.25, 2}, {1.25, 5}, {0.75, 5}, {0.75, 2}}]}, {
    {GrayLevel[0], 
     LineBox[{{0.75, 2}, {1.25, 2}, {1.25, 5}, {0.75, 5}, {0.75, 2}}], 
     LineBox[{{0.88, 1}, {1.12, 1}}], LineBox[{{1, 1}, {1, 2}}], 
     LineBox[{{1, 5}, {1, 5}}], LineBox[{{0.88, 5}, {1.12, 5}}]}, 
    {Hue[0.67, 0.6, 0.6], InsetBox[
      GraphicsBox[RectangleBox[{0., 0.}],
       ImageSize->{11., Automatic}], {1., 10.}], InsetBox[
      GraphicsBox[RectangleBox[{0., 0.}],
       ImageSize->{11., Automatic}], {1., 10.}], 
     LineBox[NCache[{{0.75, Rational[7, 2]}, {1.25, Rational[7, 2]}}, {{0.75, 
       3.5}, {1.25, 3.5}}]]}}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->True,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{None, Automatic, None, None},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.5, 1.5}, All},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellLabel->"Out[2]=",
 CellID->432117139]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 26.5499980}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/StatisticsPlots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 77, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[889, 35, 1035, 34, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1927, 71, 290, 9, 70, "UpgradeDetail",
 CellID->1365381745],
Cell[2220, 82, 315, 9, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2560, 95, 311, 9, 70, "Input",
 CellID->1746043248],
Cell[2874, 106, 1461, 50, 70, "Output",
 CellID->39993310]
}, Open  ]],
Cell[4350, 159, 125, 3, 70, "ExampleDelimiter",
 CellID->985997995],
Cell[4478, 164, 319, 12, 70, "UpgradeDetail",
 CellID->9145629],
Cell[4800, 178, 403, 13, 70, "Input",
 CellID->301401026],
Cell[CellGroupData[{
Cell[5228, 195, 367, 11, 70, "Input",
 CellID->5170467],
Cell[5598, 208, 2235, 68, 70, "Output",
 CellID->95345561]
}, Open  ]],
Cell[7848, 279, 124, 3, 70, "ExampleDelimiter",
 CellID->14898632],
Cell[7975, 284, 92, 3, 70, "UpgradeDetail",
 CellID->31178525],
Cell[8070, 289, 515, 15, 70, "Input",
 CellID->374697140],
Cell[CellGroupData[{
Cell[8610, 308, 864, 23, 70, "Input",
 CellID->711049014],
Cell[9477, 333, 1696, 55, 70, "Output",
 CellID->432117139]
}, Open  ]]
}, Open  ]],
Cell[11200, 392, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

