(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8455,        285]
NotebookOptionsPosition[      5299,        199]
NotebookOutlinePosition[      6983,        236]
CellTagsIndexPosition[      6940,        233]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Computational Geometry Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConvexHull",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/ConvexHull"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " planar convex hull of a list of points"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["DelaunayTriangulation",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " planar Delaunay triangulation of a list of points"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["VoronoiDiagram",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " planar Voronoi diagram of a list of points"
}], "GuideText",
 CellID->320907706],

Cell["\t", "GuideDelimiter",
 CellID->78587309],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlanarGraphPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/PlanarGraphPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot the Delaunay triangulation of specified points"
}], "GuideText",
 CellID->733602381],

Cell[TextData[{
 Cell[TextData[ButtonBox["DiagramPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot the Voronoi diagram of specified points"
}], "GuideText",
 CellID->570026476],

Cell[TextData[{
 Cell[TextData[ButtonBox["TriangularSurfacePlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/TriangularSurfacePlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot a surface according to a Delaunay triangulation"
}], "GuideText",
 CellID->538902354],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["DelaunayTriangulationQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulationQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether a vertex adjacency list is a Delaunay triangulation"
}], "GuideText",
 CellID->104592913],

Cell["\t", "GuideDelimiter",
 CellID->369159721],

Cell[TextData[{
 Cell[TextData[ButtonBox["BoundedDiagram",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/BoundedDiagram"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " bounded Voronoi diagram of a list of points"
}], "GuideText",
 CellID->303242830],

Cell["\t", "GuideDelimiter",
 CellID->3779888],

Cell[TextData[{
 Cell[TextData[ButtonBox["TileAreas",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/TileAreas"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find areas of tiles established by a vertex adjacency list"
}], "GuideText",
 CellID->355173453],

Cell["\t", "GuideDelimiter",
 CellID->90082264],

Cell[TextData[{
 Cell[TextData[ButtonBox["Ray",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/Ray"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ConvexHullMedian",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ConvexHullArea",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullArea"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->94037791]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS:", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], \
"GuideTutorial",
 CellID->260608343]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Computational Geometry Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 27.1281378}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Guide", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "ConvexHull -- planar convex hull of a list of points, \
DelaunayTriangulation -- planar Delaunay triangulation of a list of points, \
VoronoiDiagram -- planar Voronoi diagram of a list of points, PlanarGraphPlot \
-- plot the Delaunay triangulation of specified points, DiagramPlot -- plot \
the Voronoi diagram of specified points, TriangularSurfacePlot -- plot a \
surface according to a Delaunay triangulation, DelaunayTriangulationQ -- \
whether a vertex adjacency list is a Delaunay triangulation, BoundedDiagram \
-- bounded Voronoi diagram of a list of points, TileAreas -- find areas of \
tiles established by a vertex adjacency list", "synonyms" -> {}, "title" -> 
    "Computational Geometry Package", "type" -> "Guide", "uri" -> 
    "ComputationalGeometry/guide/ComputationalGeometryPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 72, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[694, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[753, 31, 291, 9, 70, "GuideText",
 CellID->203374175],
Cell[1047, 42, 325, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1375, 53, 303, 9, 70, "GuideText",
 CellID->320907706],
Cell[1681, 64, 47, 1, 70, "GuideDelimiter",
 CellID->78587309],
Cell[1731, 67, 314, 9, 70, "GuideText",
 CellID->733602381],
Cell[2048, 78, 299, 9, 70, "GuideText",
 CellID->570026476],
Cell[2350, 89, 327, 9, 70, "GuideText",
 CellID->538902354],
Cell[2680, 100, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2731, 103, 336, 9, 70, "GuideText",
 CellID->104592913],
Cell[3070, 114, 48, 1, 70, "GuideDelimiter",
 CellID->369159721],
Cell[3121, 117, 304, 9, 70, "GuideText",
 CellID->303242830],
Cell[3428, 128, 46, 1, 70, "GuideDelimiter",
 CellID->3779888],
Cell[3477, 131, 309, 9, 70, "GuideText",
 CellID->355173453],
Cell[3789, 142, 47, 1, 70, "GuideDelimiter",
 CellID->90082264],
Cell[3839, 145, 696, 20, 70, "InlineGuideFunctionListing",
 CellID->94037791]
}, Open  ]],
Cell[CellGroupData[{
Cell[4572, 170, 63, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4638, 173, 197, 5, 70, "GuideTutorial",
 CellID->260608343]
}, Open  ]],
Cell[CellGroupData[{
Cell[4872, 183, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4937, 186, 161, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[5101, 191, 156, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[5272, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

