(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12648,        421]
NotebookOptionsPosition[     10313,        354]
NotebookOutlinePosition[     11781,        388]
CellTagsIndexPosition[     11738,        385]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VoronoiDiagram" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/VoronoiDiagram"], 
          "DelaunayTriangulation" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/DelaunayTriangulation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"VoronoiDiagram\"\>", 
       2->"\<\"DelaunayTriangulation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoundedDiagram", "ObjectName",
 CellID->12386],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BoundedDiagram", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields the bounded Voronoi diagram of the points ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], 
        StyleBox["\[Ellipsis]", "TR"]}]}]], "InlineFormula"],
     ", where the bound is the convex polygon formed from the points ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BoundedDiagram", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]takes ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " to be the Delaunay triangulation vertex adjacency list."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BoundedDiagram", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["val", "TI"], 
        StyleBox[",", "TI"], 
        StyleBox["hull", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]takes ",
     Cell[BoxData[
      StyleBox["hull", "TI"]], "InlineFormula"],
     " to be the convex hull index list."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->11103]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The bounded Voronoi diagram is represented by two lists, a vertex coordinate \
list and a vertex adjacency list.\
\>", "Notes",
 CellID->21129],

Cell[TextData[{
 "An element ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 " of the vertex adjacency list corresponds to the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 ", and the indices ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["1", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " identify the vertices in the vertex coordinate list which form its \
bounding polygon."
}], "Notes",
 CellID->4634],

Cell[TextData[{
 Cell[BoxData["BoundedDiagram"], "InlineFormula"],
 " begins by finding the unbounded Voronoi diagram, and then incorporating \
the bounding polygon vertices into the diagram."
}], "Notes",
 CellID->31724],

Cell[TextData[{
 "The bounding polygon should be large enough to contain all the points ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11733],

Cell[TextData[{
 "The optional arguments ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["hull", "TI"]], "InlineFormula"],
 " may be used to speed up the initial Voronoi diagram computation if the \
Delaunay triangulation and convex hull are available."
}], "Notes",
 CellID->20269]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24322],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VoronoiDiagram",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DelaunayTriangulation",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27738]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30305],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->3520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoundedDiagram - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 27.4406458}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "BoundedDiagram[{{a_1, b_1}, ...}, {{x_1, y_1}, ...}] yields the bounded \
Voronoi diagram of the points {x_1, y_1}, {x_2, y_2} ..., where the bound is \
the convex polygon formed from the points {{a_1, b_1}, ...}. \
BoundedDiagram[{{a_1, b_1}, ...}, {{x_1, y_1}, ...}, val] takes val to be the \
Delaunay triangulation vertex adjacency list. BoundedDiagram[{{a_1, b_1}, \
...}, {{x_1, y_1}, ...}, val, hull] takes hull to be the convex hull index \
list.", "synonyms" -> {}, "title" -> "BoundedDiagram", "type" -> "Symbol", 
    "uri" -> "ComputationalGeometry/ref/BoundedDiagram"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1466, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2089, 64, 52, 1, 70, "ObjectName",
 CellID->12386],
Cell[2144, 67, 4249, 134, 70, "Usage",
 CellID->11103]
}, Open  ]],
Cell[CellGroupData[{
Cell[6430, 206, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6908, 223, 153, 4, 70, "Notes",
 CellID->21129],
Cell[7064, 229, 874, 32, 70, "Notes",
 CellID->4634],
Cell[7941, 263, 221, 5, 70, "Notes",
 CellID->31724],
Cell[8165, 270, 345, 13, 70, "Notes",
 CellID->11733],
Cell[8513, 285, 332, 10, 70, "Notes",
 CellID->20269]
}, Closed]],
Cell[CellGroupData[{
Cell[8882, 300, 311, 9, 70, "SeeAlsoSection",
 CellID->24322],
Cell[9196, 311, 533, 17, 70, "SeeAlso",
 CellID->27738]
}, Open  ]],
Cell[CellGroupData[{
Cell[9766, 333, 314, 9, 70, "TutorialsSection",
 CellID->30305],
Cell[10083, 344, 188, 5, 70, "Tutorials",
 CellID->3520]
}, Open  ]],
Cell[10286, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

