(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8166,        273]
NotebookOptionsPosition[      6349,        218]
NotebookOutlinePosition[      7517,        248]
CellTagsIndexPosition[      7474,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConvexHull" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/ConvexHull"], "VoronoiDiagram" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/VoronoiDiagram"], 
          "DelaunayTriangulationQ" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/DelaunayTriangulationQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ConvexHull\"\>", 
       2->"\<\"VoronoiDiagram\"\>", 
       3->"\<\"DelaunayTriangulationQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DelaunayTriangulation", "ObjectName",
 CellID->7955],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DelaunayTriangulation", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields the planar Delaunay triangulation of the points \
",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Delaunay triangulation is represented by a vertex adjacency list, one \
entry for each unique point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 " indicating the adjacent vertices in counterclockwise order."
}], "Notes",
 CellID->26748]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16208],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConvexHull",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHull"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VoronoiDiagram",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DelaunayTriangulationQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulationQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->784136009]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25798],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->2071]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DelaunayTriangulation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 34.6908314}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "DelaunayTriangulation[{{x_1, y_1}, {x_2, y_2}, ...}] yields the planar \
Delaunay triangulation of the points {{x_1, y_1}, ...}.", "synonyms" -> {}, 
    "title" -> "DelaunayTriangulation", "type" -> "Symbol", "uri" -> 
    "ComputationalGeometry/ref/DelaunayTriangulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1614, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2237, 67, 58, 1, 70, "ObjectName",
 CellID->7955],
Cell[2298, 70, 1353, 44, 70, "Usage",
 CellID->1955]
}, Open  ]],
Cell[CellGroupData[{
Cell[3688, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4166, 136, 438, 14, 70, "Notes",
 CellID->26748]
}, Closed]],
Cell[CellGroupData[{
Cell[4641, 155, 311, 9, 70, "SeeAlsoSection",
 CellID->16208],
Cell[4955, 166, 810, 26, 70, "SeeAlso",
 CellID->784136009]
}, Open  ]],
Cell[CellGroupData[{
Cell[5802, 197, 314, 9, 70, "TutorialsSection",
 CellID->25798],
Cell[6119, 208, 188, 5, 70, "Tutorials",
 CellID->2071]
}, Open  ]],
Cell[6322, 216, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

