(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7170,        246]
NotebookOptionsPosition[      5316,        189]
NotebookOutlinePosition[      6474,        219]
CellTagsIndexPosition[      6431,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DiagramPlot" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/DiagramPlot"], "PlanarGraphPlot" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/PlanarGraphPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DiagramPlot\"\>", 
       2->"\<\"PlanarGraphPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LabelPoints", "ObjectName",
 CellID->1390],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LabelPoints"], "InlineFormula"],
     " \[LineSeparator]is an option to the ",
     Cell[BoxData[
      ButtonBox["DiagramPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"]], 
      "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["PlanarGraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputationalGeometry/ref/PlanarGraphPlot"]], 
      "InlineFormula"],
     " that specifies whether to label points according to their position in \
the input list."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11807]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9614],

Cell["\<\
Repeated instances of a point are plotted once and labeled according to the \
position of the first instance in the list.\
\>", "Notes",
 CellID->9322]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24083],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiagramPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlanarGraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/PlanarGraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14417]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2895],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->13159]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LabelPoints - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 35.3470982}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "LabelPoints is an option to the DiagramPlot and PlanarGraphPlot that \
specifies whether to label points according to their position in the input \
list.", "synonyms" -> {}, "title" -> "LabelPoints", "type" -> "Symbol", "uri" -> 
    "ComputationalGeometry/ref/LabelPoints"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1427, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2050, 63, 48, 1, 70, "ObjectName",
 CellID->1390],
Cell[2101, 66, 780, 23, 70, "Usage",
 CellID->11807]
}, Open  ]],
Cell[CellGroupData[{
Cell[2918, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3396, 111, 306, 13, 70, "Notes",
 CellID->9614],
Cell[3705, 126, 161, 4, 70, "Notes",
 CellID->9322]
}, Closed]],
Cell[CellGroupData[{
Cell[3903, 135, 311, 9, 70, "SeeAlsoSection",
 CellID->24083],
Cell[4217, 146, 515, 17, 70, "SeeAlso",
 CellID->14417]
}, Open  ]],
Cell[CellGroupData[{
Cell[4769, 168, 313, 9, 70, "TutorialsSection",
 CellID->2895],
Cell[5085, 179, 189, 5, 70, "Tutorials",
 CellID->13159]
}, Open  ]],
Cell[5289, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

