(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8756,        300]
NotebookOptionsPosition[      6917,        244]
NotebookOutlinePosition[      8111,        275]
CellTagsIndexPosition[      8068,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConvexHull" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/ConvexHull"], 
          "DelaunayTriangulation" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/DelaunayTriangulation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ConvexHull\"\>", 
       2->"\<\"DelaunayTriangulation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TileAreas", "ObjectName",
 CellID->4819],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TileAreas", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["q", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["q", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the areas of the tiles centered on ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
     " and having vertices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["q", "TI"], 
       StyleBox["j", "TI"]]], "InlineFormula"],
     " as stipulated by the vertex adjacency list ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4536]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The polygon described by the vertices ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["1", "TR"]], ",", 
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["2", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " in an element ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 " of the vertex adjacency list must contain the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31270]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21999],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConvexHull",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHull"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DelaunayTriangulation",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23039]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16442],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->9176]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TileAreas - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 42.5347822}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "TileAreas[{{x_1, y_1}, {x_2, y_2}, ...}, {q_1, q_2, ...}, val] finds the \
areas of the tiles centered on {x_i, y_i} and having vertices q_j as \
stipulated by the vertex adjacency list val.", "synonyms" -> {}, "title" -> 
    "TileAreas", "type" -> "Symbol", "uri" -> 
    "ComputationalGeometry/ref/TileAreas"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1454, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2077, 64, 46, 1, 70, "ObjectName",
 CellID->4819],
Cell[2126, 67, 1846, 59, 70, "Usage",
 CellID->4536]
}, Open  ]],
Cell[CellGroupData[{
Cell[4009, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4487, 148, 970, 37, 70, "Notes",
 CellID->31270]
}, Closed]],
Cell[CellGroupData[{
Cell[5494, 190, 311, 9, 70, "SeeAlsoSection",
 CellID->21999],
Cell[5808, 201, 525, 17, 70, "SeeAlso",
 CellID->23039]
}, Open  ]],
Cell[CellGroupData[{
Cell[6370, 223, 314, 9, 70, "TutorialsSection",
 CellID->16442],
Cell[6687, 234, 188, 5, 70, "Tutorials",
 CellID->9176]
}, Open  ]],
Cell[6890, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

