(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11262,        378]
NotebookOptionsPosition[      9138,        316]
NotebookOutlinePosition[     10505,        349]
CellTagsIndexPosition[     10462,        346]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DelaunayTriangulation" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/DelaunayTriangulation"], 
          "ConvexHull" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/ConvexHull"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DelaunayTriangulation\"\>", 
       2->"\<\"ConvexHull\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VoronoiDiagram", "ObjectName",
 CellID->27978],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VoronoiDiagram", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields the planar Voronoi diagram of the points ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VoronoiDiagram", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]takes ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " to be the Delaunay triangulation vertex adjacency list."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VoronoiDiagram", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["val", "TI"], ",", 
        StyleBox["hull", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]takes ",
     Cell[BoxData[
      StyleBox["hull", "TI"]], "InlineFormula"],
     " to be the convex hull index list."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->31959]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The Voronoi diagram is represented by two lists, a vertex coordinate list and \
a vertex adjacency list.\
\>", "Notes",
 CellID->25465],

Cell[TextData[{
 "An element ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 " of the vertex adjacency list corresponds to the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 ", and the indices ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["1", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " identify the vertices or rays in the vertex coordinate list which form the \
polygon associated with the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30120],

Cell[TextData[{
 "The optional arguments ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["hull", "TI"]], "InlineFormula"],
 " may be used to speed up the Voronoi diagram computation if the Delaunay \
triangulation and convex hull are available."
}], "Notes",
 CellID->6920]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21776],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DelaunayTriangulation",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConvexHull",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHull"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19597],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->29379]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VoronoiDiagram - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 43.0660458}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "VoronoiDiagram[{{x_1, y_1}, {x_2, y_2}, ...}] yields the planar Voronoi \
diagram of the points {x_1, y_1}, {x_2, y_2}, ... VoronoiDiagram[{{x_1, y_1}, \
{x_2, y_2}, ...}, val] takes val to be the Delaunay triangulation vertex \
adjacency list. VoronoiDiagram[{{x_1, y_1}, {x_2, y_2}, ...}, val, hull] \
takes hull to be the convex hull index list.", "synonyms" -> {}, "title" -> 
    "VoronoiDiagram", "type" -> "Symbol", "uri" -> 
    "ComputationalGeometry/ref/VoronoiDiagram"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1453, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2076, 64, 52, 1, 70, "ObjectName",
 CellID->27978],
Cell[2131, 67, 3431, 108, 70, "Usage",
 CellID->31959]
}, Open  ]],
Cell[CellGroupData[{
Cell[5599, 180, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6077, 197, 145, 4, 70, "Notes",
 CellID->25465],
Cell[6225, 203, 1127, 42, 70, "Notes",
 CellID->30120],
Cell[7355, 247, 323, 10, 70, "Notes",
 CellID->6920]
}, Closed]],
Cell[CellGroupData[{
Cell[7715, 262, 311, 9, 70, "SeeAlsoSection",
 CellID->21776],
Cell[8029, 273, 524, 17, 70, "SeeAlso",
 CellID->3691]
}, Open  ]],
Cell[CellGroupData[{
Cell[8590, 295, 314, 9, 70, "TutorialsSection",
 CellID->19597],
Cell[8907, 306, 189, 5, 70, "Tutorials",
 CellID->29379]
}, Open  ]],
Cell[9111, 314, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

