(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    238106,       5206]
NotebookOptionsPosition[    226916,       4833]
NotebookOutlinePosition[    229320,       4884]
CellTagsIndexPosition[    229277,       4881]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AllPoints" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/AllPoints"], "BoundedDiagram" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/BoundedDiagram"], "ConvexHull" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/ConvexHull"], 
         "DelaunayTriangulation" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/DelaunayTriangulation"], 
         "DelaunayTriangulationQ" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/DelaunayTriangulationQ"], 
         "DiagramPlot" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/DiagramPlot"], "False" :> 
         Documentation`HelpLookup["paclet:ref/False"], "Hull" :> 
         Documentation`HelpLookup["paclet:ComputationalGeometry/ref/Hull"], 
         "LabelPoints" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/LabelPoints"], "PlanarGraphPlot" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/PlanarGraphPlot"], "TileAreas" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/TileAreas"], 
         "TriangularSurfacePlot" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/TriangularSurfacePlot"], 
         "TrimPoints" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/TrimPoints"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"], "VoronoiDiagram" :> 
         Documentation`HelpLookup[
          "paclet:ComputationalGeometry/ref/VoronoiDiagram"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"AllPoints\"\>", 
      2->"\<\"BoundedDiagram\"\>", 3->"\<\"ConvexHull\"\>", 
      4->"\<\"DelaunayTriangulation\"\>", 5->"\<\"DelaunayTriangulationQ\"\>",
       6->"\<\"DiagramPlot\"\>", 7->"\<\"False\"\>", 8->"\<\"Hull\"\>", 
      9->"\<\"LabelPoints\"\>", 10->"\<\"PlanarGraphPlot\"\>", 
      11->"\<\"TileAreas\"\>", 12->"\<\"TriangularSurfacePlot\"\>", 
      13->"\<\"TrimPoints\"\>", 14->"\<\"True\"\>", 
      15->"\<\"VoronoiDiagram\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Computational Geometry Package", "Title",
 CellID->17318],

Cell["\<\
Computational geometry is the study of efficient algorithms for solving \
geometric problems. The nearest neighbor problem involves identifying one \
point, out of a set of points, that is nearest to the query point according \
to some measure of distance. The nearest neighborhood problem involves \
identifying the locus of points lying nearer to the query point than to any \
other point in the set. This package provides functions for solving these and \
related problems in the case of planar points and the Euclidean distance \
metric. \
\>", "Text",
 CellID->6043],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ConvexHull",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/ConvexHull"], "[", "{", 
     "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "compute the convex hull of a set of points in the plane", "TableText"]},
   {
    RowBox[{
     ButtonBox["DelaunayTriangulation",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"], 
     "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell["\<\
compute the Delaunay triangulation of a set of points in the plane\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["VoronoiDiagram",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "compute the Voronoi diagram of a set of points in the plane", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->15937],

Cell["Computational geometry functions. ", "Caption",
 CellID->22060],

Cell[TextData[{
 "The convex hull of a set ",
 Cell[BoxData[
  FormBox[
   StyleBox["S", "TI"], TraditionalForm]], "InlineFormula"],
 " is the boundary of the smallest set containing ",
 Cell[BoxData[
  FormBox[
   StyleBox["S", "TI"], TraditionalForm]], "InlineFormula"],
 ". The Voronoi diagram of ",
 Cell[BoxData[
  FormBox[
   StyleBox["S", "TI"], TraditionalForm]], "InlineFormula"],
 " is the collection of nearest neighborhoods for each of the points in ",
 Cell[BoxData[
  FormBox[
   StyleBox["S", "TI"], TraditionalForm]], "InlineFormula"],
 ". For points in the plane, these neighborhoods are polygons. The Delaunay \
triangulation of ",
 Cell[BoxData[
  FormBox[
   StyleBox["S", "TI"], TraditionalForm]], "InlineFormula"],
 " is a triangulation of the points in ",
 Cell[BoxData[
  FormBox[
   StyleBox["S", "TI"], TraditionalForm]], "InlineFormula"],
 " such that no triangle contains a point of ",
 Cell[BoxData[
  FormBox[
   StyleBox["S", "TI"], TraditionalForm]], "InlineFormula"],
 " in its circumcircle. This is equivalent to connecting the points in ",
 Cell[BoxData[
  FormBox[
   StyleBox["S", "TI"], TraditionalForm]], "InlineFormula"],
 " according to whether their neighborhood polygons share a common side. "
}], "Text",
 CellID->20610],

Cell["This loads the package. ", "MathCaption",
 CellID->10797],

Cell[BoxData[
 RowBox[{"<<", "ComputationalGeometry`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22106],

Cell["Here is a list of points in the plane. ", "MathCaption",
 CellID->11447],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2D", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.4", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.7", ",", "15.25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.9", ",", "12.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.1", ",", "11.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9.5", ",", "14.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13.2", ",", "11.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10.3", ",", "12.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.8", ",", "9.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", "7.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6", ",", "5.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.3", ",", "2.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8.45", ",", "4.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11.5", ",", "9.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13.8", ",", "7.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12.9", ",", "3.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "1.1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17829],

Cell["\<\
This gives the indices of the points lying on the convex hull in \
counterclockwise order. \
\>", "MathCaption",
 CellID->24763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"convexhull", "=", 
  RowBox[{"ConvexHull", "[", "data2D", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "14", ",", "6", ",", "5", ",", "2", ",", "1", ",", "4", ",", "10", ",", 
   "11", ",", "16", ",", "15"}], "}"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->912]
}, Open  ]],

Cell["Duplicate points are ignored. ", "MathCaption",
 CellID->26899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvexHull", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14985],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConvexHull", "::", "\<\"duplicated\"\>"}], ":", 
  " ", "\<\"\\!\\(1\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" duplicated point(s) \
ignored.\\\\\\\"\\\", \\\"MSG\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->10808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1832]
}, Open  ]],

Cell[TextData[{
 "This gives the counterclockwise vertex adjacency list for each point in the \
Delaunay triangulation. For example, the entry ",
 StyleBox["{1,", "MR"],
 " ",
 StyleBox["{4,", "MR"],
 " ",
 StyleBox["3,", "MR"],
 " ",
 StyleBox["2}}", "MR"],
 " indicates that the first point in ",
 StyleBox["data2D", "MR"],
 " is connected in counterclockwise order to the fourth, third, and second \
points. "
}], "MathCaption",
 CellID->5206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Shallow", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}]}], "]"}], "&"}], ")"}], "[", 
  RowBox[{"delval", "=", 
   RowBox[{"DelaunayTriangulation", "[", "data2D", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->25927],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "4", ",", "8", ",", "7", ",", "5"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "9", ",", "8", ",", "3", ",", "1"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "7", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "7", ",", "13", ",", "14"}], "}"}]}], "}"}], ",", 
   RowBox[{"\[LeftSkeleton]", "10", "\[RightSkeleton]"}]}], "}"}]], "Output",
 ImageSize->{456, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//Shallow=",
 CellID->20945]
}, Open  ]],

Cell[TextData[{
 "While ",
 Cell[BoxData[
  ButtonBox["DelaunayTriangulation",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"]], 
  "InlineFormula"],
 " need only specify the connections between points, ",
 Cell[BoxData[
  ButtonBox["VoronoiDiagram",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"]], 
  "InlineFormula"],
 " must specify both a set of diagram vertices and the connections between \
those vertices. Another difference between the two functions is that while a \
triangulation consists of segments, a diagram consists of both segments and \
rays. For example, in the case of a Voronoi diagram, points in the interior \
of the convex hull will have nearest neighborhoods that are closed polygons, \
but the nearest neighborhoods of points on the convex hull will be open \
polygons. "
}], "Text",
 CellID->24458],

Cell[TextData[{
 "These considerations make the output of ",
 Cell[BoxData[
  ButtonBox["VoronoiDiagram",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"]], 
  "InlineFormula"],
 " more complex than that of ",
 Cell[BoxData[
  ButtonBox["DelaunayTriangulation",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"]], 
  "InlineFormula"],
 ". The diagram is given as a list of diagram vertices followed by a diagram \
vertex adjacency list. The finite vertices of the diagram are listed first in \
the vertex list. The vertices lying at infinity have head ",
 Cell[BoxData[
  ButtonBox["Ray",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/Ray"]], "InlineFormula"],
 " and are listed last. "
}], "Text",
 CellID->627],

Cell[TextData[{
 "This assigns the list of Voronoi diagram vertices to ",
 StyleBox["vorvert", "MR"],
 " and the Voronoi diagram vertex adjacency list to ",
 StyleBox["vorval", "MR"],
 ". "
}], "MathCaption",
 CellID->9017],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vorvert", ",", "vorval"}], "}"}], "=", 
   RowBox[{"VoronoiDiagram", "[", "data2D", "]"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->21394],

Cell[TextData[{
 "The first vertex in ",
 StyleBox["vorvert", "MR"],
 " is a finite diagram vertex having coordinates ",
 StyleBox["{-0.0158537,", "MR"],
 " ",
 StyleBox["8.44146}", "MR"],
 ". The last vertex in ",
 StyleBox["vorvert", "MR"],
 " is a point at infinity. This point is represented by a ",
 Cell[BoxData[
  ButtonBox["Ray",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/Ray"]], "InlineFormula"],
 " object having origin ",
 StyleBox["{10.5172,", "MR"],
 " ",
 StyleBox["3.46115}", "MR"],
 " and containing ",
 StyleBox["{13.95,", "MR"],
 " ",
 StyleBox["0.2}", "MR"],
 ". "
}], "MathCaption",
 CellID->15609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"First", "[", "vorvert", "]"}], ",", 
   RowBox[{"Last", "[", "vorvert", "]"}]}], "}"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->14878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.01585365853658583`"}], ",", "8.441463414634146`"}], 
    "}"}], ",", 
   RowBox[{"Ray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10.51721105527638`", ",", "3.4611494974874377`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"13.949999999999996`", ",", "0.20000000000000306`"}], "}"}]}], 
    "]"}]}], "}"}]], "Output",
 ImageSize->{425, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->27756]
}, Open  ]],

Cell[TextData[{
 "Each entry in ",
 StyleBox["vorval", "MR"],
 " gives the index of a point in ",
 StyleBox["data2D", "MR"],
 " followed by a counterclockwise list of the Voronoi diagram vertices that \
comprise the point\[CloseCurlyQuote]s nearest neighborhood polygon. "
}], "MathCaption",
 CellID->5549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vorval", " ", "//", " ", "Short"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->32345],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "21", ",", "22"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "9", ",", "23", ",", "21"}], "}"}]}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "13", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"16", ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "10", ",", "28", ",", "30"}], "}"}]}], "}"}]}], 
   "}"}],
  Short]], "Output",
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//Short=",
 CellID->28321]
}, Open  ]],

Cell[TextData[{
 "Here is the Voronoi polygon vertex adjacency list for the first point in ",
 StyleBox["data2D", "MR"],
 ". "
}], "MathCaption",
 CellID->24621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vorval", "\[LeftDoubleBracket]", 
  RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->13555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "7", ",", "21", ",", "22"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->19558]
}, Open  ]],

Cell[TextData[{
 "This selects the coordinates of the polygon vertices from ",
 StyleBox["vorvert", "MR"],
 ". The first two vertices have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ", while the last two have head ",
 Cell[BoxData[
  ButtonBox["Ray",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/Ray"]], "InlineFormula"],
 ". Thus, the Voronoi polygon associated with the first point in ",
 StyleBox["data2D", "MR"],
 " is open and is defined by a segment and two rays. "
}], "MathCaption",
 CellID->15939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vorvert", "\[LeftDoubleBracket]", "%", 
  "\[RightDoubleBracket]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->5965],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.692757242757243`", ",", "11.405744255744255`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.915335598980459`", ",", "13.952782497875955`"}], "}"}], ",", 
   RowBox[{"Ray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.915335598980459`", ",", "13.952782497875955`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"4.3000000000000025`", ",", "16.924999999999997`"}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"Ray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.692757242757243`", ",", "11.405744255744255`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"0.34999999999999964`", ",", "14.850000000000001`"}], "}"}]}], 
    "]"}]}], "}"}]], "Output",
 ImageSize->{545, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->23646]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VoronoiDiagram",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["delval", "TI"], "]"}], Cell[TextData[{
     "compute the Voronoi diagram using the Delaunay triangulation vertex \
adjacency list ",
     StyleBox["delval", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["VoronoiDiagram",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["delval", "TI"], ",", 
     StyleBox["convexhull", "TI"], "]"}], Cell[TextData[{
     "compute the Voronoi diagram using the Delaunay triangulation vertex \
adjacency list ",
     Cell[BoxData[
      StyleBox["delval", "TI"]], "InlineFormula"],
     " and the convex hull index list ",
     StyleBox["convexhull", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->4399],

Cell["\<\
Computing the Voronoi diagram using the Delaunay triangulation and the convex \
hull. \
\>", "Caption",
 CellID->10719],

Cell[TextData[{
 "This computes the Voronoi diagram of ",
 StyleBox["data2D", "MR"],
 " more efficiently by making use of the Delaunay triangulation vertex \
adjacency list. "
}], "MathCaption",
 CellID->12519],

Cell[BoxData[
 RowBox[{
  RowBox[{"VoronoiDiagram", "[", 
   RowBox[{"data2D", ",", "delval"}], "]"}], ";"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->29621],

Cell["\<\
Here the Voronoi diagram is computed using both the Delaunay triangulation \
and the convex hull. \
\>", "MathCaption",
 CellID->524],

Cell[BoxData[
 RowBox[{
  RowBox[{"VoronoiDiagram", "[", 
   RowBox[{"data2D", ",", "delval", ",", "convexhull"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->30578],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PlanarGraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/PlanarGraphPlot"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "plot the Delaunay triangulation of the points", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlanarGraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/PlanarGraphPlot"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["indexlist", "TI"], "]"}], Cell[TextData[{
     "plot the graph depicted by the counterclockwise list of indices in ",
     StyleBox["indexlist", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PlanarGraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/PlanarGraphPlot"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["val", "TI"], "]"}], Cell[TextData[{
     "plot the graph depicted by the vertex adjacency list ",
     StyleBox["val", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DiagramPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"], "[", "{", 
     "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "plot the Voronoi diagram of the points", "TableText"]},
   {
    RowBox[{
     ButtonBox["DiagramPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"], "[", "{", 
     "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["diagvert", "TI"], ",", 
     StyleBox["diagval", "TI"], "]"}], Cell[TextData[{
     "plot the diagram depicted by the vertex list ",
     Cell[BoxData[
      StyleBox["diagvert", "TI"]], "InlineFormula"],
     " and the vertex adjacency list ",
     StyleBox["diagval", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TriangularSurfacePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/TriangularSurfacePlot"], 
     "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "plot the surface according to the Delaunay triangulation established by \
projecting the points onto the ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "\[Hyphen]",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " plane"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TriangularSurfacePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/TriangularSurfacePlot"], 
     "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["trival", "TI"], "]"}], Cell[TextData[{
     "plot the surface according to the triangulation depicted by the vertex \
adjacency list ",
     StyleBox["trival", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->2029],

Cell["Computational geometry plotting functions. ", "Caption",
 CellID->20133],

Cell[TextData[{
 "The default of ",
 Cell[BoxData[
  ButtonBox["PlanarGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/PlanarGraphPlot"]], 
  "InlineFormula"],
 " is a plot of the Delaunay triangulation of the points. "
}], "MathCaption",
 CellID->29554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlanarGraphPlot", "[", "data2D", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->13793],

Cell[BoxData[
 GraphicsBox[{{InsetBox["10", {0.6, 5.1}], InsetBox["4", {2.1, 11.1}], 
    InsetBox["9", {3.3, 7.7}], InsetBox["1", {4.4, 14}], 
    InsetBox["11", {5.3, 2.4}], InsetBox["2", {6.7, 15.25}], 
    InsetBox["8", {6.8, 9.5}], InsetBox["3", {6.9, 12.8}], 
    InsetBox["12", {8.45, 4.7}], InsetBox["5", {9.5, 14.9}], 
    InsetBox["7", {10.3, 12.3}], InsetBox["16", {11, 1.1}], 
    InsetBox["13", {11.5, 9.6}], InsetBox["15", {12.9, 3.1}], 
    InsetBox["6", {13.2, 11.9}], InsetBox["14", {13.8, 7.3}]}, 
   {Thickness[0.003], LineBox[{{4.4, 14}, {6.7, 15.25}}], 
    LineBox[{{4.4, 14}, {6.9, 12.8}}], LineBox[{{4.4, 14}, {2.1, 11.1}}], 
    LineBox[{{6.7, 15.25}, {6.9, 12.8}}], 
    LineBox[{{6.7, 15.25}, {9.5, 14.9}}], LineBox[{{6.9, 12.8}, {2.1, 11.1}}],
     LineBox[{{6.9, 12.8}, {9.5, 14.9}}], 
    LineBox[{{6.9, 12.8}, {10.3, 12.3}}], LineBox[{{6.9, 12.8}, {6.8, 9.5}}], 
    LineBox[{{2.1, 11.1}, {6.8, 9.5}}], LineBox[{{2.1, 11.1}, {3.3, 7.7}}], 
    LineBox[{{2.1, 11.1}, {0.6, 5.1}}], LineBox[{{9.5, 14.9}, {13.2, 11.9}}], 
    LineBox[{{9.5, 14.9}, {10.3, 12.3}}], 
    LineBox[{{13.2, 11.9}, {10.3, 12.3}}], 
    LineBox[{{13.2, 11.9}, {11.5, 9.6}}], 
    LineBox[{{13.2, 11.9}, {13.8, 7.3}}], LineBox[{{10.3, 12.3}, {6.8, 9.5}}],
     LineBox[{{10.3, 12.3}, {11.5, 9.6}}], LineBox[{{6.8, 9.5}, {3.3, 7.7}}], 
    LineBox[{{6.8, 9.5}, {8.45, 4.7}}], LineBox[{{6.8, 9.5}, {11.5, 9.6}}], 
    LineBox[{{3.3, 7.7}, {0.6, 5.1}}], LineBox[{{3.3, 7.7}, {5.3, 2.4}}], 
    LineBox[{{3.3, 7.7}, {8.45, 4.7}}], LineBox[{{0.6, 5.1}, {5.3, 2.4}}], 
    LineBox[{{5.3, 2.4}, {8.45, 4.7}}], LineBox[{{5.3, 2.4}, {11, 1.1}}], 
    LineBox[{{8.45, 4.7}, {11.5, 9.6}}], LineBox[{{8.45, 4.7}, {13.8, 7.3}}], 
    LineBox[{{8.45, 4.7}, {12.9, 3.1}}], LineBox[{{8.45, 4.7}, {11, 1.1}}], 
    LineBox[{{11.5, 9.6}, {13.8, 7.3}}], LineBox[{{13.8, 7.3}, {12.9, 3.1}}], 
    LineBox[{{12.9, 3.1}, {11, 1.1}}]}},
  AspectRatio->1,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{-0.247368421052632, 14.6473684210526}, {0.727631578947369, 
   15.6223684210526}}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->27982]
}, Open  ]],

Cell["This plots the convex hull of the points. ", "MathCaption",
 CellID->32395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlanarGraphPlot", "[", 
  RowBox[{"data2D", ",", "convexhull"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->28218],

Cell[BoxData[
 GraphicsBox[{{InsetBox["10", {0.6, 5.1}], InsetBox["4", {2.1, 11.1}], 
    InsetBox["9", {3.3, 7.7}], InsetBox["1", {4.4, 14}], 
    InsetBox["11", {5.3, 2.4}], InsetBox["2", {6.7, 15.25}], 
    InsetBox["8", {6.8, 9.5}], InsetBox["3", {6.9, 12.8}], 
    InsetBox["12", {8.45, 4.7}], InsetBox["5", {9.5, 14.9}], 
    InsetBox["7", {10.3, 12.3}], InsetBox["16", {11, 1.1}], 
    InsetBox["13", {11.5, 9.6}], InsetBox["15", {12.9, 3.1}], 
    InsetBox["6", {13.2, 11.9}], InsetBox["14", {13.8, 7.3}]}, 
   {Thickness[0.003], 
    LineBox[{{13.8, 7.3}, {13.2, 11.9}, {9.5, 14.9}, {6.7, 15.25}, {
      4.4, 14}, {2.1, 11.1}, {0.6, 5.1}, {5.3, 2.4}, {11, 1.1}, {12.9, 3.1}, {
      13.8, 7.3}}]}},
  AspectRatio->1,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{-0.247368421052632, 14.6473684210526}, {0.727631578947369, 
   15.6223684210526}}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->481]
}, Open  ]],

Cell["Here is an alternative triangulation. ", "MathCaption",
 CellID->28028],

Cell[BoxData[
 RowBox[{
  RowBox[{"trival", "=", 
   RowBox[{"Insert", "[", 
    RowBox[{
     RowBox[{"Insert", "[", 
      RowBox[{
       RowBox[{"Delete", "[", 
        RowBox[{"delval", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"12", ",", "2", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"16", ",", "2", ",", "2"}], "}"}]}], "}"}]}], "]"}], ",", 
       "15", ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "2", ",", "2"}], "}"}]}], "]"}], ",", "11", ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "2", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->930],

Cell[TextData[{
 "This plots the triangulation of ",
 StyleBox["data2D", "MR"],
 " given by ",
 StyleBox["trival", "MR"],
 ". "
}], "MathCaption",
 CellID->20640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlanarGraphPlot", "[", 
  RowBox[{"data2D", ",", "trival"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->8839],

Cell[BoxData[
 GraphicsBox[{{InsetBox["10", {0.6, 5.1}], InsetBox["4", {2.1, 11.1}], 
    InsetBox["9", {3.3, 7.7}], InsetBox["1", {4.4, 14}], 
    InsetBox["11", {5.3, 2.4}], InsetBox["2", {6.7, 15.25}], 
    InsetBox["8", {6.8, 9.5}], InsetBox["3", {6.9, 12.8}], 
    InsetBox["12", {8.45, 4.7}], InsetBox["5", {9.5, 14.9}], 
    InsetBox["7", {10.3, 12.3}], InsetBox["16", {11, 1.1}], 
    InsetBox["13", {11.5, 9.6}], InsetBox["15", {12.9, 3.1}], 
    InsetBox["6", {13.2, 11.9}], InsetBox["14", {13.8, 7.3}]}, 
   {Thickness[0.003], LineBox[{{4.4, 14}, {6.7, 15.25}}], 
    LineBox[{{4.4, 14}, {6.9, 12.8}}], LineBox[{{4.4, 14}, {2.1, 11.1}}], 
    LineBox[{{6.7, 15.25}, {6.9, 12.8}}], 
    LineBox[{{6.7, 15.25}, {9.5, 14.9}}], LineBox[{{6.9, 12.8}, {2.1, 11.1}}],
     LineBox[{{6.9, 12.8}, {9.5, 14.9}}], 
    LineBox[{{6.9, 12.8}, {10.3, 12.3}}], LineBox[{{6.9, 12.8}, {6.8, 9.5}}], 
    LineBox[{{2.1, 11.1}, {6.8, 9.5}}], LineBox[{{2.1, 11.1}, {3.3, 7.7}}], 
    LineBox[{{2.1, 11.1}, {0.6, 5.1}}], LineBox[{{9.5, 14.9}, {13.2, 11.9}}], 
    LineBox[{{9.5, 14.9}, {10.3, 12.3}}], 
    LineBox[{{13.2, 11.9}, {10.3, 12.3}}], 
    LineBox[{{13.2, 11.9}, {11.5, 9.6}}], 
    LineBox[{{13.2, 11.9}, {13.8, 7.3}}], LineBox[{{10.3, 12.3}, {6.8, 9.5}}],
     LineBox[{{10.3, 12.3}, {11.5, 9.6}}], LineBox[{{6.8, 9.5}, {3.3, 7.7}}], 
    LineBox[{{6.8, 9.5}, {8.45, 4.7}}], LineBox[{{6.8, 9.5}, {11.5, 9.6}}], 
    LineBox[{{3.3, 7.7}, {0.6, 5.1}}], LineBox[{{3.3, 7.7}, {5.3, 2.4}}], 
    LineBox[{{3.3, 7.7}, {8.45, 4.7}}], LineBox[{{0.6, 5.1}, {5.3, 2.4}}], 
    LineBox[{{5.3, 2.4}, {8.45, 4.7}}], LineBox[{{5.3, 2.4}, {12.9, 3.1}}], 
    LineBox[{{5.3, 2.4}, {11, 1.1}}], LineBox[{{8.45, 4.7}, {11.5, 9.6}}], 
    LineBox[{{8.45, 4.7}, {13.8, 7.3}}], LineBox[{{8.45, 4.7}, {12.9, 3.1}}], 
    LineBox[{{11.5, 9.6}, {13.8, 7.3}}], LineBox[{{13.8, 7.3}, {12.9, 3.1}}], 
    LineBox[{{12.9, 3.1}, {11, 1.1}}]}},
  AspectRatio->1,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{-0.247368421052632, 14.6473684210526}, {0.727631578947369, 
   15.6223684210526}}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->4144]
}, Open  ]],

Cell[TextData[{
 "The default of ",
 Cell[BoxData[
  ButtonBox["DiagramPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"]], 
  "InlineFormula"],
 " is a plot of the Voronoi diagram of the points. "
}], "MathCaption",
 CellID->24829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagramPlot", "[", "data2D", "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->17479],

Cell[BoxData[
 GraphicsBox[{{InsetBox["1", {4.4, 14}], InsetBox["2", {6.7, 15.25}], 
    InsetBox["3", {6.9, 12.8}], InsetBox["4", {2.1, 11.1}], 
    InsetBox["5", {9.5, 14.9}], InsetBox["6", {13.2, 11.9}], 
    InsetBox["7", {10.3, 12.3}], InsetBox["8", {6.8, 9.5}], 
    InsetBox["9", {3.3, 7.7}], InsetBox["10", {0.6, 5.1}], 
    InsetBox["11", {5.3, 2.4}], InsetBox["12", {8.45, 4.7}], 
    InsetBox["13", {11.5, 9.6}], InsetBox["14", {13.8, 7.3}], 
    InsetBox["15", {12.9, 3.1}], InsetBox["16", {11, 1.1}]}, 
   {PointSize[0.012], PointBox[{-0.0158536585365858, 8.44146341463415}], 
    PointBox[{3.52985648385443, 4.75937980522809}], 
    PointBox[{4.34075391180654, 9.97908961593172}], 
    PointBox[{4.69275724275724, 11.4057442557443}], 
    PointBox[{4.76091257179324, 11.2133056796426}], 
    PointBox[{5.46011387649683, 5.48777882131956}], 
    PointBox[{5.91533559898046, 13.952782497876}], 
    PointBox[{6.09237481031867, 6.57316009104704}], 
    PointBox[{7.98079896907217, 14.1213917525773}], 
    PointBox[{8.15935047951177, 1.79099825632084}], 
    PointBox[{8.38726708074534, 11.1034161490683}], 
    PointBox[{8.70011848341232, 13.2308056872038}], 
    PointBox[{9.13688524590164, 10.166393442623}], 
    PointBox[{9.19067656765677, 7.63820132013201}], 
    PointBox[{10.5172110552764, 3.46114949748744}], 
    PointBox[{10.8224842767296, 6.62248427672956}], 
    PointBox[{11.3003353204173, 5.63921385991058}], 
    PointBox[{11.6365306122449, 11.2773469387755}], 
    PointBox[{12.0480609418283, 14.2609418282548}], 
    PointBox[{13.845, 9.645}]}, 
   {Thickness[0.003], 
    LineBox[{{5.91533559898046, 13.952782497876}, {4.3, 16.925}}], 
    LineBox[{{4.69275724275724, 11.4057442557443}, {0.35, 14.85}}], 
    LineBox[{{7.98079896907217, 14.1213917525773}, {8.44999999999999, 
     17.8749999999999}}], 
    LineBox[{{-0.0158536585365858, 8.44146341463415}, {-6.01585365853659, 
     9.94146341463415}}], 
    LineBox[{{12.0480609418283, 14.2609418282548}, {15.0480609418283, 
     17.9609418282548}}], LineBox[{{13.845, 9.645}, {18.445, 10.245}}], 
    LineBox[{{3.52985648385443, 4.75937980522809}, {0.25, -0.95}}], 
    LineBox[{{8.15935047951177, 1.79099825632084}, {
     6.85000000000001, -3.94999999999997}}], 
    LineBox[{{11.3003353204173, 5.63921385991058}, {17.55, 4.3}}], 
    LineBox[{{10.5172110552764, 3.46114949748744}, {13.95, 
     0.200000000000003}}], 
    LineBox[{{4.69275724275724, 11.4057442557443}, {5.91533559898046, 
     13.952782497876}}], 
    LineBox[{{5.91533559898046, 13.952782497876}, {7.98079896907217, 
     14.1213917525773}}], 
    LineBox[{{5.91533559898046, 13.952782497876}, {4.69275724275724, 
     11.4057442557443}, {4.76091257179324, 11.2133056796426}, {
     8.38726708074534, 11.1034161490683}, {8.70011848341232, 
     13.2308056872038}, {7.98079896907217, 14.1213917525773}, {
     5.91533559898046, 13.952782497876}}], 
    LineBox[{{-0.0158536585365858, 8.44146341463415}, {4.34075391180654, 
     9.97908961593172}, {4.76091257179324, 11.2133056796426}, {
     4.69275724275724, 11.4057442557443}}], 
    LineBox[{{7.98079896907217, 14.1213917525773}, {8.70011848341232, 
     13.2308056872038}, {12.0480609418283, 14.2609418282548}}], 
    LineBox[{{12.0480609418283, 14.2609418282548}, {11.6365306122449, 
     11.2773469387755}, {13.845, 9.645}}], 
    LineBox[{{8.70011848341232, 13.2308056872038}, {8.38726708074534, 
     11.1034161490683}, {9.13688524590164, 10.166393442623}, {
     11.6365306122449, 11.2773469387755}, {12.0480609418283, 
     14.2609418282548}, {8.70011848341232, 13.2308056872038}}], 
    LineBox[{{4.76091257179324, 11.2133056796426}, {4.34075391180654, 
     9.97908961593172}, {6.09237481031867, 6.57316009104704}, {
     9.19067656765677, 7.63820132013201}, {9.13688524590164, 
     10.166393442623}, {8.38726708074534, 11.1034161490683}, {
     4.76091257179324, 11.2133056796426}}], 
    LineBox[{{-0.0158536585365858, 8.44146341463415}, {3.52985648385443, 
     4.75937980522809}, {5.46011387649683, 5.48777882131956}, {
     6.09237481031867, 6.57316009104704}, {4.34075391180654, 
     9.97908961593172}, {-0.0158536585365858, 8.44146341463415}}], 
    LineBox[{{3.52985648385443, 4.75937980522809}, {-0.0158536585365858, 
     8.44146341463415}}], 
    LineBox[{{8.15935047951177, 1.79099825632084}, {5.46011387649683, 
     5.48777882131956}, {3.52985648385443, 4.75937980522809}}], 
    LineBox[{{6.09237481031867, 6.57316009104704}, {5.46011387649683, 
     5.48777882131956}, {8.15935047951177, 1.79099825632084}, {
     10.5172110552764, 3.46114949748744}, {11.3003353204173, 
     5.63921385991058}, {10.8224842767296, 6.62248427672956}, {
     9.19067656765677, 7.63820132013201}, {6.09237481031867, 
     6.57316009104704}}], 
    LineBox[{{9.13688524590164, 10.166393442623}, {9.19067656765677, 
     7.63820132013201}, {10.8224842767296, 6.62248427672956}, {13.845, 
     9.645}, {11.6365306122449, 11.2773469387755}, {9.13688524590164, 
     10.166393442623}}], 
    LineBox[{{13.845, 9.645}, {10.8224842767296, 6.62248427672956}, {
     11.3003353204173, 5.63921385991058}}], 
    LineBox[{{11.3003353204173, 5.63921385991058}, {10.5172110552764, 
     3.46114949748744}}], 
    LineBox[{{10.5172110552764, 3.46114949748744}, {8.15935047951177, 
     1.79099825632084}}]}},
  AspectRatio->1,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{-6.65956033376123, 19.0887066752246}, {-5.8686625903655, 
   19.8796044186204}}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->23196]
}, Open  ]],

Cell["Here is an alternative set of diagram vertices. ", "MathCaption",
 CellID->13577],

Cell[BoxData[
 RowBox[{
  RowBox[{"diagvert", "=", 
   RowBox[{"ReplacePart", "[", 
    RowBox[{"vorvert", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6."}], ",", "0."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"27", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->19288],

Cell["Here is an alternative diagram vertex adjacency list. ", "MathCaption",
 CellID->10377],

Cell[BoxData[
 RowBox[{
  RowBox[{"diagval", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"vorval", ",", 
       RowBox[{"-", "8"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "6", ",", "8", ",", "3"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "6", ",", "1", ",", "24", ",", "27"}], "}"}]}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"Drop", "[", 
      RowBox[{"vorval", ",", "10"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->28488],

Cell[TextData[{
 "This plots the diagram of ",
 StyleBox["data2D", "MR"],
 " given by ",
 StyleBox["diagvert", "MR"],
 " and ",
 StyleBox["diagval", "MR"],
 ". "
}], "MathCaption",
 CellID->1035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagramPlot", "[", 
  RowBox[{"data2D", ",", "diagvert", ",", "diagval"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->16116],

Cell[BoxData[
 GraphicsBox[{{InsetBox["1", {4.4, 14}], InsetBox["2", {6.7, 15.25}], 
    InsetBox["3", {6.9, 12.8}], InsetBox["4", {2.1, 11.1}], 
    InsetBox["5", {9.5, 14.9}], InsetBox["6", {13.2, 11.9}], 
    InsetBox["7", {10.3, 12.3}], InsetBox["8", {6.8, 9.5}], 
    InsetBox["9", {3.3, 7.7}], InsetBox["10", {0.6, 5.1}], 
    InsetBox["11", {5.3, 2.4}], InsetBox["12", {8.45, 4.7}], 
    InsetBox["13", {11.5, 9.6}], InsetBox["14", {13.8, 7.3}], 
    InsetBox["15", {12.9, 3.1}], InsetBox["16", {11, 1.1}]}, 
   {PointSize[0.012], PointBox[{-0.0158536585365858, 8.44146341463415}], 
    PointBox[{3.52985648385443, 4.75937980522809}], 
    PointBox[{4.34075391180654, 9.97908961593172}], 
    PointBox[{4.69275724275724, 11.4057442557443}], 
    PointBox[{4.76091257179324, 11.2133056796426}], 
    PointBox[{5.46011387649683, 5.48777882131956}], 
    PointBox[{5.91533559898046, 13.952782497876}], 
    PointBox[{6.09237481031867, 6.57316009104704}], 
    PointBox[{7.98079896907217, 14.1213917525773}], 
    PointBox[{8.15935047951177, 1.79099825632084}], 
    PointBox[{8.38726708074534, 11.1034161490683}], 
    PointBox[{8.70011848341232, 13.2308056872038}], 
    PointBox[{9.13688524590164, 10.166393442623}], 
    PointBox[{9.19067656765677, 7.63820132013201}], 
    PointBox[{10.5172110552764, 3.46114949748744}], 
    PointBox[{10.8224842767296, 6.62248427672956}], 
    PointBox[{11.3003353204173, 5.63921385991058}], 
    PointBox[{11.6365306122449, 11.2773469387755}], 
    PointBox[{12.0480609418283, 14.2609418282548}], 
    PointBox[{13.845, 9.645}]}, 
   {Thickness[0.003], 
    LineBox[{{5.91533559898046, 13.952782497876}, {4.3, 16.925}}], 
    LineBox[{{4.69275724275724, 11.4057442557443}, {0.35, 14.85}}], 
    LineBox[{{7.98079896907217, 14.1213917525773}, {8.44999999999999, 
     17.8749999999999}}], 
    LineBox[{{-0.0158536585365858, 8.44146341463415}, {-6.01585365853659, 
     9.94146341463415}}], 
    LineBox[{{12.0480609418283, 14.2609418282548}, {15.0480609418283, 
     17.9609418282548}}], LineBox[{{13.845, 9.645}, {18.445, 10.245}}], 
    LineBox[{{3.52985648385443, 4.75937980522809}, {-6., 0.}}], 
    LineBox[{{8.15935047951177, 1.79099825632084}, {
     6.85000000000001, -3.94999999999997}}], 
    LineBox[{{11.3003353204173, 5.63921385991058}, {17.55, 4.3}}], 
    LineBox[{{10.5172110552764, 3.46114949748744}, {13.95, 
     0.200000000000003}}], 
    LineBox[{{4.69275724275724, 11.4057442557443}, {5.91533559898046, 
     13.952782497876}}], 
    LineBox[{{5.91533559898046, 13.952782497876}, {7.98079896907217, 
     14.1213917525773}}], 
    LineBox[{{5.91533559898046, 13.952782497876}, {4.69275724275724, 
     11.4057442557443}, {4.76091257179324, 11.2133056796426}, {
     8.38726708074534, 11.1034161490683}, {8.70011848341232, 
     13.2308056872038}, {7.98079896907217, 14.1213917525773}, {
     5.91533559898046, 13.952782497876}}], 
    LineBox[{{-0.0158536585365858, 8.44146341463415}, {4.34075391180654, 
     9.97908961593172}, {4.76091257179324, 11.2133056796426}, {
     4.69275724275724, 11.4057442557443}}], 
    LineBox[{{7.98079896907217, 14.1213917525773}, {8.70011848341232, 
     13.2308056872038}, {12.0480609418283, 14.2609418282548}}], 
    LineBox[{{12.0480609418283, 14.2609418282548}, {11.6365306122449, 
     11.2773469387755}, {13.845, 9.645}}], 
    LineBox[{{8.70011848341232, 13.2308056872038}, {8.38726708074534, 
     11.1034161490683}, {9.13688524590164, 10.166393442623}, {
     11.6365306122449, 11.2773469387755}, {12.0480609418283, 
     14.2609418282548}, {8.70011848341232, 13.2308056872038}}], 
    LineBox[{{4.76091257179324, 11.2133056796426}, {4.34075391180654, 
     9.97908961593172}, {6.09237481031867, 6.57316009104704}, {
     9.19067656765677, 7.63820132013201}, {9.13688524590164, 
     10.166393442623}, {8.38726708074534, 11.1034161490683}, {
     4.76091257179324, 11.2133056796426}}], 
    LineBox[{{-0.0158536585365858, 8.44146341463415}, {5.46011387649683, 
     5.48777882131956}, {6.09237481031867, 6.57316009104704}, {
     4.34075391180654, 9.97908961593172}, {-0.0158536585365858, 
     8.44146341463415}}], 
    LineBox[{{3.52985648385443, 4.75937980522809}, {5.46011387649683, 
     5.48777882131956}, {-0.0158536585365858, 8.44146341463415}}], 
    LineBox[{{8.15935047951177, 1.79099825632084}, {5.46011387649683, 
     5.48777882131956}, {3.52985648385443, 4.75937980522809}}], 
    LineBox[{{6.09237481031867, 6.57316009104704}, {5.46011387649683, 
     5.48777882131956}, {8.15935047951177, 1.79099825632084}, {
     10.5172110552764, 3.46114949748744}, {11.3003353204173, 
     5.63921385991058}, {10.8224842767296, 6.62248427672956}, {
     9.19067656765677, 7.63820132013201}, {6.09237481031867, 
     6.57316009104704}}], 
    LineBox[{{9.13688524590164, 10.166393442623}, {9.19067656765677, 
     7.63820132013201}, {10.8224842767296, 6.62248427672956}, {13.845, 
     9.645}, {11.6365306122449, 11.2773469387755}, {9.13688524590164, 
     10.166393442623}}], 
    LineBox[{{13.845, 9.645}, {10.8224842767296, 6.62248427672956}, {
     11.3003353204173, 5.63921385991058}}], 
    LineBox[{{11.3003353204173, 5.63921385991058}, {10.5172110552764, 
     3.46114949748744}}], 
    LineBox[{{10.5172110552764, 3.46114949748744}, {8.15935047951177, 
     1.79099825632084}}]}},
  AspectRatio->1,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{-6.65956033376123, 19.0887066752246}, {-5.8686625903655, 
   19.8796044186204}}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->20222]
}, Open  ]],

Cell[TextData[{
 "Here is a set of three\[Hyphen]dimensional points having the same ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], TraditionalForm]], "InlineFormula"],
 " coordinates as ",
 StyleBox["data2D", "MR"],
 ". "
}], "MathCaption",
 CellID->18700],

Cell[BoxData[
 RowBox[{
  RowBox[{"data3D", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Append", "[", 
       RowBox[{"#", ",", 
        SqrtBox[
         RowBox[{"64", "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-",
              "8"}], ")"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "-",
              "8"}], ")"}], "2"]}]]}], "]"}], "&"}], ")"}], "/@", 
    "data2D"}]}], ";"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->28685],

Cell[TextData[{
 "The default of ",
 Cell[BoxData[
  ButtonBox["TriangularSurfacePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/TriangularSurfacePlot"]], 
  "InlineFormula"],
 " is a plot of the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " coordinates according to the connectivity established by the Delaunay \
triangulation of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], TraditionalForm]], "InlineFormula"],
 " coordinates. "
}], "MathCaption",
 CellID->172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TriangularSurfacePlot", "[", "data3D", "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->23200],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[{{4.4, 14, 3.87814388593306}, {6.7, 15.25, 
     3.12209865314983}, {6.9, 12.8, 6.30476010645924}}], 
   Polygon3DBox[{{4.4, 14, 3.87814388593306}, {6.9, 12.8, 6.30476010645924}, {
     2.1, 11.1, 4.42492937796752}}], 
   Polygon3DBox[{{6.7, 15.25, 3.12209865314983}, {6.9, 12.8, 
    6.30476010645924}, {9.5, 14.9, 3.76031913539263}}], 
   Polygon3DBox[{{6.9, 12.8, 6.30476010645924}, {2.1, 11.1, 
    4.42492937796752}, {6.8, 9.5, 7.76595132614157}}], 
   Polygon3DBox[{{6.9, 12.8, 6.30476010645924}, {9.5, 14.9, 
    3.76031913539263}, {10.3, 12.3, 6.34192399828317}}], 
   Polygon3DBox[{{6.9, 12.8, 6.30476010645924}, {10.3, 12.3, 
    6.34192399828317}, {6.8, 9.5, 7.76595132614157}}], 
   Polygon3DBox[{{2.1, 11.1, 4.42492937796752}, {6.8, 9.5, 
    7.76595132614157}, {3.3, 7.7, 6.4668384856899}}], 
   Polygon3DBox[{{2.1, 11.1, 4.42492937796752}, {3.3, 7.7, 6.4668384856899}, {
    0.6, 5.1, 0.911043357914425}}], 
   Polygon3DBox[{{9.5, 14.9, 3.76031913539263}, {13.2, 11.9, 
    4.66368952654441}, {10.3, 12.3, 6.34192399828317}}], 
   Polygon3DBox[{{13.2, 11.9, 4.66368952654441}, {10.3, 12.3, 
    6.34192399828317}, {11.5, 9.6, 7.01355829803959}}], 
   Polygon3DBox[{{13.2, 11.9, 4.66368952654441}, {11.5, 9.6, 
    7.01355829803959}, {13.8, 7.3, 5.46534536877588}}], 
   Polygon3DBox[{{10.3, 12.3, 6.34192399828317}, {6.8, 9.5, 
    7.76595132614157}, {11.5, 9.6, 7.01355829803959}}], 
   Polygon3DBox[{{6.8, 9.5, 7.76595132614157}, {3.3, 7.7, 6.4668384856899}, {
    8.45, 4.7, 7.27375418886286}}], 
   Polygon3DBox[{{6.8, 9.5, 7.76595132614157}, {8.45, 4.7, 
    7.27375418886286}, {11.5, 9.6, 7.01355829803959}}], 
   Polygon3DBox[{{3.3, 7.7, 6.4668384856899}, {0.6, 5.1, 0.911043357914425}, {
    5.3, 2.4, 5.03487835006964}}], 
   Polygon3DBox[{{3.3, 7.7, 6.4668384856899}, {5.3, 2.4, 5.03487835006964}, {
    8.45, 4.7, 7.27375418886286}}], 
   Polygon3DBox[{{5.3, 2.4, 5.03487835006964}, {8.45, 4.7, 
     7.27375418886286}, {11, 1.1, 2.71845544381364}}], 
   Polygon3DBox[{{8.45, 4.7, 7.27375418886286}, {11.5, 9.6, 
    7.01355829803959}, {13.8, 7.3, 5.46534536877588}}], 
   Polygon3DBox[{{8.45, 4.7, 7.27375418886286}, {13.8, 7.3, 
    5.46534536877588}, {12.9, 3.1, 3.99749921826134}}], 
   Polygon3DBox[{{8.45, 4.7, 7.27375418886286}, {12.9, 3.1, 
     3.99749921826134}, {11, 1.1, 2.71845544381364}}]},
  ImageMargins->0.,
  ImageSize->Medium,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{364, 315},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->7129,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "This plots the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z", "TI"], TraditionalForm]], "InlineFormula"],
 " coordinates according to the connectivity established by the triangulation \
",
 StyleBox["trival", "MR"],
 ". "
}], "MathCaption",
 CellID->13975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TriangularSurfacePlot", "[", 
  RowBox[{"data3D", ",", "trival"}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->26470],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[{{4.4, 14, 3.87814388593306}, {6.7, 15.25, 
     3.12209865314983}, {6.9, 12.8, 6.30476010645924}}], 
   Polygon3DBox[{{4.4, 14, 3.87814388593306}, {6.9, 12.8, 6.30476010645924}, {
     2.1, 11.1, 4.42492937796752}}], 
   Polygon3DBox[{{6.7, 15.25, 3.12209865314983}, {6.9, 12.8, 
    6.30476010645924}, {9.5, 14.9, 3.76031913539263}}], 
   Polygon3DBox[{{6.9, 12.8, 6.30476010645924}, {2.1, 11.1, 
    4.42492937796752}, {6.8, 9.5, 7.76595132614157}}], 
   Polygon3DBox[{{6.9, 12.8, 6.30476010645924}, {9.5, 14.9, 
    3.76031913539263}, {10.3, 12.3, 6.34192399828317}}], 
   Polygon3DBox[{{6.9, 12.8, 6.30476010645924}, {10.3, 12.3, 
    6.34192399828317}, {6.8, 9.5, 7.76595132614157}}], 
   Polygon3DBox[{{2.1, 11.1, 4.42492937796752}, {6.8, 9.5, 
    7.76595132614157}, {3.3, 7.7, 6.4668384856899}}], 
   Polygon3DBox[{{2.1, 11.1, 4.42492937796752}, {3.3, 7.7, 6.4668384856899}, {
    0.6, 5.1, 0.911043357914425}}], 
   Polygon3DBox[{{9.5, 14.9, 3.76031913539263}, {13.2, 11.9, 
    4.66368952654441}, {10.3, 12.3, 6.34192399828317}}], 
   Polygon3DBox[{{13.2, 11.9, 4.66368952654441}, {10.3, 12.3, 
    6.34192399828317}, {11.5, 9.6, 7.01355829803959}}], 
   Polygon3DBox[{{13.2, 11.9, 4.66368952654441}, {11.5, 9.6, 
    7.01355829803959}, {13.8, 7.3, 5.46534536877588}}], 
   Polygon3DBox[{{10.3, 12.3, 6.34192399828317}, {6.8, 9.5, 
    7.76595132614157}, {11.5, 9.6, 7.01355829803959}}], 
   Polygon3DBox[{{6.8, 9.5, 7.76595132614157}, {3.3, 7.7, 6.4668384856899}, {
    8.45, 4.7, 7.27375418886286}}], 
   Polygon3DBox[{{6.8, 9.5, 7.76595132614157}, {8.45, 4.7, 
    7.27375418886286}, {11.5, 9.6, 7.01355829803959}}], 
   Polygon3DBox[{{3.3, 7.7, 6.4668384856899}, {0.6, 5.1, 0.911043357914425}, {
    5.3, 2.4, 5.03487835006964}}], 
   Polygon3DBox[{{3.3, 7.7, 6.4668384856899}, {5.3, 2.4, 5.03487835006964}, {
    8.45, 4.7, 7.27375418886286}}], 
   Polygon3DBox[{{5.3, 2.4, 5.03487835006964}, {8.45, 4.7, 
    7.27375418886286}, {12.9, 3.1, 3.99749921826134}}], 
   Polygon3DBox[{{5.3, 2.4, 5.03487835006964}, {12.9, 3.1, 
     3.99749921826134}, {11, 1.1, 2.71845544381364}}], 
   Polygon3DBox[{{8.45, 4.7, 7.27375418886286}, {11.5, 9.6, 
    7.01355829803959}, {13.8, 7.3, 5.46534536877588}}], 
   Polygon3DBox[{{8.45, 4.7, 7.27375418886286}, {13.8, 7.3, 
    5.46534536877588}, {12.9, 3.1, 3.99749921826134}}]},
  ImageMargins->0.,
  ImageSize->Medium,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{364, 315},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->2161,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9nQ2MXNdVx8c7M7uz39/rXdv7Ya/XXtu79tpe2+u112vH9vrbTp3UadzY
iWNvbSd17CR2SkKSEhLSQD8ohUJBRVCptKqAoqqoVCqICAiFEgQIBIJKSBUI
FSEkRIWQkEbw7rn/N/P2N3f9ZgLCcl585553zu+e+9695573debK3RuLt67c
vXn1ysix567cuXHz6vMjC7efi37KrshkVtyI/tvXn4n+/d+ZjP/v34rFYia7
uLhYtD+Ze26T+ddom49+fMFK/xJt66JSVv/3v34/2rod8wkN0VYa/kmyBVfK
lfRH/7hr9f+gvZuWqf+e9m91pXypXjaeN5m/l452tKEO5Tsm/V1Jdwc1Pmcy
fyurfSkab5v0X0tjP2qzKD9j0n8l3aurkv4L6R5EbQ7lWyb9Z9I9gto8yh82
6Xele11V0t+R7jHU1qP8tEl/W7o3orYB5adM+h3p3lyV9O9J9wRqCyjfNOm3
pXsbahtRvmHSvyPd26uS/pZ0T6O2CeXrJv1N6d6N2maUP2TS35DuvVVJf126
96G2BeVFk/6adB9AbSvK10z6q9J9sCrpX5Puw6htQ/mqSX9Fuo+ilufykyb9
JUmfSNHtpb8oktMpuq+Y9Bek+yxqO1B+wqR/SbrfV5X056X7IdR2ovy4Sf+C
dF9AbRfKl03656T7A1VJf1a6P4jabpQvmfRnpPsSantQfsykPy3dT1Ql/Unp
fhK1vSgbaebj0r1YlfRb0n0dtRzPL5r0m9L9FGpXovyoSb8u3R+uSvo16b6N
Ws4V1nuZV6X7WdQOoPyISb8s3Xerkn5Rul9A7SqU7ajLvCDpF1HLWev9Jn1X
JK+k6PbSz0r3R1N0P2zSt6X7R1G7BmU7t2yucj++UZX0U9L9MdQOonzepK9L
tytlo6CJo/4QyjY22IjrbFhr8tFub3+56P9G/87srErHk7Js/suWdGSy0aYu
KnK2Gkb5QdPyhEgegZZ6aeEMySjinGm5VEyON2UtjQYUlSXN2Tms7YNiught
zWKilrUo22htZ0+2NKqVtbRJC+MKRjxnTMsFsVyClk5pGa9Ky0NiuQwtPfAP
46hRlG3Wsv4vj6llbX1iopb1KJ8yLWfFdAVaBqSFtsNaTovlKrSsQcvY02Q8
adpOiOkatA2JiVo2oGwxQGZBWuwscy3R3jyPwnsfUYuug2FMWjhqMJo9bloO
ieEGtIzDLxwNqe2YaZsvJmejsrbNYqpOy34xPQ0tk9LC+YfH9oJpmRXLLWiZ
khbOp5tQtqgus0csz0DLTviHMUhY2y4x3YG2XWKiFp77R0zLjmJypi1rmZEW
RmZbULboNjMlluehZR9axvg0rG1STHehbU5M1MKx8QHTsqWYWJ0ntByUFq4I
JlE+ZFrGxfIRaDksLVzhhLVsEMuL0LIA/3CdtxVlW3nYKOV+fAnajouJWjif
zZuWtWJ6GVpOSUu+Ki1DYnkFWs6iZcwYTKFsKzAbZ+pKEVFZ24NiohbO93Om
ZUBMPwIt56KNCzwsxeB3suO/UsPKYjLWWtoq4/jGmz+wGObf/64Y/Y3+EQlX
xEH7TVePaF6HrtPRxhWzTld9SVdJ3S5osxWtnY/uxx9bptfqnbZsmazObRJa
GGd5rZ+DthNia4C2bKzNd2xFi2dNW4e8R8b4+GyE1nyKVlv5+9XqkswYPbog
6ubl9Hvf3k9/vvSrN2HrlqSNo2pDK2zUwwZ7b6ZsI/Erj2eeRYfVojZYa3Cb
nLfmDdLenqA95tZ+GPYOyV5nyF6+ZG8ZP4ZtMkPHMTAej7ths5DwaPlILo8o
PHN3B61zFOM4fkAt7oH1RljPplg3/1fMTByJ78F6PKOtTLGeg3WOe2HrzAOG
ZmdX7If1phTrbPt00DozhYwwZuM4DtabYT2f0vawdc7Lt2F9Rm1fk2K9PsX6
zqB15iYZN+6Jo3NYb4H1hhTrO4LWGdkw9t2ltg/DeiusF2Cdc3bYOrOhN2F9
Wm1fV6N1tt3KFdZ4/nNFs0NtH4X1NlhvTLE+FbTOrOcirE/J+hist8N6U4rn
w9YZq3N9uk2eH0+x3pxifVvQOvOsXGNPqu2bYL0D1ltSrG8NWnernVB+YEJt
3gKrnbDaCquMdsNWmXV9DNY3q82TNVpnm21VUXFeM9PK3NEmtX0brHfXaH0i
aD2YuU1Y36i2T8F6V7Rxu3WkeDxslTndC7C6QW3eGTjG3W5ZtL0thWJLkIK5
h4dBsV5tnw6McW63elC0p1BsDlIwT3weFHEOaHdgjnO7cZ5P80WYgrmhB0Gx
Vr6YCcR3bjeOvGkUm4IUgyifBcWwKGYDcbvbratGCssTVczzzDefBkWc09sP
ipwoelOOC+YDwhTMGJ4ExRr54oCjyCVXnm6ngRoZNgYZmJ8+DobV8sRBrlej
XQZrJNgQJGBWegEEA/LCodgLi/GfkZRjoTr7zCUfgf1+eeCByL4TG62x1WNB
q8xYPwCrfYlWOzGffjD3Z9bXSGC2KiJtZpgPgqBX7Y4JsjgCxlIomGELUzAb
fAAU3fLDQVEwb7KhRorRIAWzyftB0ZU4C5xYARQba+yRdUEK5o9nQdEhX8yL
ogkUm2r0RZiC+ecZULSBghmWzTVSrA1SMOO8GxSt6pGYoh0UEzVSjAQpmLGe
BkVzYoR2YszHTIKCsVTwmmPFipxHzw5QNMkXMQVzJFtrpBgOUnBmnQJFQb6Y
E0UfKKZq7JGhIEV8BWMbrDckfODqmSvZkWKdPghbZ0bFpYPHQJKHH5g3IUla
bwwGSZL54WjfTP7M5F86miHQ5OSXmIZ5lOkaadYEaaZB0xTRNGTi621lmjr5
Zr9omFfZnULDUSFMsws0HfKNz0yXaBIxnhNeC5Y9NR4xFuVX5PL2xOVoxwgj
0yvPNCQ84xgdyb44wgDJTI19tCpIMgOS1dGmMWGVuY7ZGvsibHUvrI5EG9fW
vbLKHMe+Gq0OBK2WZs7ImrM67Dau5699zLztV3xuh82wP1ej/f6g/X0h+1lv
3yHEq323ywQIDvz/EEQbu9NEFMw9zNdIYTmOijz6HCiGQJFzG1eOrDuA9aLZ
DppDNdL0BWkOgGYQNHn5ZJ3mEOYmDqdQMHJ6bxQNohiUL3alUHSmUPQGKeZT
KAqi6BfFHlAcrZGiJ0hxEBRrQNEkim5R7AXFsRp75L1RtIiiTRTMChyvkaI7
SHEIFKtB0YZzpSCaA6A5ARqXp3WzH2cJywNX3A1/uAoKu+tA1pkXOAXr7sqI
G3hz//z94P1x742iQxRul8MgOA0Cl0l01Q0Rgc0Bxf/8j+hvgKUzyHIELKvA
0h5tnLjjIcvZmMVPOjbuNzmOfInDo1SwdARZjoJlIHCkOvF4JGPvnJYvTGfE
4VBa/g956JuCeOLzOHSsZnV0JJnMR9lyX2Vts/wZ1R6kW0jxVl507TizmHtc
0DFcAGVjCiVnJbsCV3Gl+zgo+wMztRPvlg85Bh4WXSvoCqDLpfjwPdK5tZbI
OEccVO92gqwBZPUpZK1BshMgWxltbIUjGub05+SnXtDUp9CwF1uCNCdB0y2a
TNaVfOA5JDJGN7MiWwWyPMgaUvxUHVmHyHLoyWGcBVsD6yFXHAZlFpQFULoM
n7sFJnx8nQJdi+gaQDci3/EK3bR8NwqqOlA1giq+N493vTQHKU+DsiDKZlCu
TUTVScrtotxo3VqidKWMu0aylG1YHmOE4NlIfAZsebG1gW1UbFxxbVW/Ttj8
WPagu4q6lGu1fMZcdpjLruzkSlyi6gTVmKi4+twij00l+tX5qg1MK8UUvLOj
gumcpHtAsTER+ScpxkWxK6bQ0UTPxPcO8sp+mOK0pJO91guicZyNvAdkTL22
F2T0T7uOJT7TFCaL73HP4ZiivzbJX8zfrJO/9sdnnweroGophp9ADVPF98wX
QNUNqi2iWg2qYVHNL40A3cwProIs8Yqt5+JdeUeWnA/Lc02KawBcq8V1uCIC
cwcH2bLqSV67bAqyuetJdYvxM8bLs20VG7O1Azq+jlXHFv3I62hhrnn5rAtc
XeCawvHfBb4++e5EMAYLnKkeoeLZjjBl/DRCbwrldnmPdF2iOxOMwcp0HPmr
o9srugHQcWzdKTpeG+lQ374PdPkUOl6zDNPtLiafAF8adyTpdomuJXDvhfPd
Q8G4bPkxuLrjb6foRlJ8t1t0vMbWKLpHgrHZ8r4L04Xuk3fF9Sm+mxEd7/tu
UM9eDEY/1dM1Bum2im4cdO2gm8W5yyvHOfnwEiibQNn8nii3iHJLCuW+OIdA
uuifV1LI6D/ewxAmi59R2ZZCtj/auIzNNVC0pFDwXo4wxZgodoKC8eJctLHb
LUDRmtJL1VGsKybfLbA8xf74WLr3JX+d5O3vFUM91JZCxXttPFXyCRNH5GZM
XjtoDRzd9myJI3K/R0TR30wu2mQDR3X7/5psWL6aSyGbSfjK4EBYL989CsKO
FEJGHJWEa4rJNy4sT7gHhDkQNsmHF0DYCcKmFB8WKgjjZ42YzWsJjPtJwjwI
W0V4HoTdIOR6M52wT4TMuHCNOa3jrwCyDvXu2RQyN1OFnqGtJOoWUWiNniTa
AZ81gqxbPjsFsh6QuejIVTPOqCTrENm5FF9tB1kTyPrkswWQ9RlOiUwey2S/
+4P/8l26LGP5l9Zi8h0aZcYmMG5Tf7aCbZW8dhhsK2OvZfyfOgd1nyitkqxJ
ZBdSyLbCeyQclPfmQ95TzO3gSMgot5KwQYQXUwgnQNgOwhH5cB8Ie9WjnkyY
mcon5ivJcsXkG0aWJ9scrwxANCqf7QmcpXZdJSaSPRI1eKLy83VFPCkvnsbA
ij3pKXJtlKd2BkePqBxxObRcoi/dMch71jyfw1sEUWG5DIeIekC0SURTgbnA
nqA0nNJRFRkMsyR/+VCKlzaAqRdME+q9icAcb/E4jnRGPbznMiYsj2zXi/f3
2nodV/0gm5K3xgNxkc0WIGOOheekJyM//ccs7Sj8R8qd8t/6QGRrT5yCkld0
OLZ5Sq7xeOSRch0oV4Fyt3y5NrAKsDUhKJmnDVM6j7v4Ms2Hw+rhQVDtle/W
BNZ2Tr4ZVLwrilTm2woPXwNdPeiG4DtSzsl3A4H1sa32QZl2N7anpIevplAO
gnIIlAdF2bfctR+NdvQpnyvius/T8l4c0uZBuzrOPoPyAfV4ZyBPYxED6JgD
D9M16jhkT5NqAD4k3YJ82BbIwNndEqDjM3dcJ3o6Hg+c10jZD8pRUJ6QD5uW
5n7F2A5GPhvHqN0z8pkWMvLK2kowrgfjGXmSVyIdYQcImcfn2swT8jglYRaE
vToCx0F2Tt5zV9Pcz52g4XN1YZo2HXFpFD3wE2kekp+6QMHn60hhV/Mqjr/H
U2i6QLMJNOeXoeGTb3yzj6cJvkkvQVMHmviOl4lAD7li3Vf/sZgcuXhk84rG
YJAq+A6++1C1w0eToDsdbSyqBR3HBtLwWTVPxzflGF2+RHfGLrSbp5JMW8F0
UkwNYOJoyn4LM/Xo2H48yNKqXtsOhmPqtUYwcHbk+MNe9Ax8q9FjQZYW+GUH
mI7ILy1g4hzIWYXPWHomnpPGVL4a7OIV8OwMzH42j4CH0RfjGp5/nodXGktP
AMs7jeqp3aCYV091gIKRKuNnesXibWNzR0ulNxrgDXLMyRvd4GBcz+ep6A3P
weMouc523qgHzQxoZkXTCxquf7giYy94Gp5ZjsZGDVDsBcUe9c1KUNSDIniv
cgXFIH59VBRZHRn7YX2XfLAK1vOwzjvpwtaHiuX3Cvpc0zW7Vd0ZnQusouxt
b7Ccg2U+N8RxwlvmGPMBERyE1W3y9hCsZmGVT6UzRvBWGf25dzy6E+IArE6q
rWthlTklPplDq7ZGrBi7LsrqLKxukdVRZzVfsqosEd/hE7Y1Wiy/ndEyPrAx
Ln+OORu5cssy5WdGpI8xn9fPEeey7EzDzpjaMp7woGsF39PM2dVbYcbCvbfB
OWQqkNeyO58iK/YsC/ZjZOG1c7S6qjYwjojzeK4Nzvr+qrSPF8tvS3RaGcEN
idn1QMEd8dDCGM1r5V131+WRDdC+WtrXiTn7s3/j87nYn3Gpt8Ix60ai7HrP
tYcrsv7EGequH+Zl8ViKRcvyVIxTfBdxVl4cDuTQ49HItbMxsurKJ6uyOllM
vtFyac7Esh2w1qU29quNzWrjGewffINXxTOM11BuUl8yb9WRmO+c1TZZ5du0
uQL3VjkiXg3sZXemwmqbrHbJs13y7PuxP1d73irfhMP3VnfJaiesNsfrerW1
R219pCqrO9SftNYna22wVkhEna6NK2WN7/vmmttb45vNHkd5lazyuk+9rBbU
xlXyLPdnNsJb5fh/GeVBWW2A1aw8m5PVQbWVvqLVFWaVb+G/hPJaWbWrvrmS
VbW0Tv4dkc3FqmzuKSbfMFyudXNPs5sf5bebqOdz1F4bZ5yLKLto0TGuEyPf
WM6Mptc6i18fRdlFQc7bA9J6B/XM1nmtnL/4tvppae2UB56vSivnLZ5Ts9Ja
ECvffc48qNc6V0y+J7tc6+YzN6+9FNCyIiq6vb2GeUg8jPLvo1xfoYFzJ78c
kK7hECTOo/wHKOcrNMT3PHLPd1DOVex5BBLnUP5DlLMVGo5Cgl9lSNewAAnO
aN9Gua5CwzG1n3v+0X32zGT4bQrO239szi6Vi/66n9+XstR1v31PQfY4yt+x
riqVS7zxW70p/yeJctkK+4H99K60eWn2O4+LP13iuQdRy8huqXT8ZnRKOR+5
Zvq5hecNz6t3JO0zqzxP+X0Ud9a5or/bkHHDHMq/K93+eZv47fKU+pak/NNy
HBc5Gv+WpP1TqBybOSN8XdL+qW7ODzMo/4akB006fjM/pX5VUv49I5dQy7n8
y5IeM2nO7Iw3vij/+nddMXrgO3x/Wbr9G9OeEC+lPi8p/+5AxgaMJT8naf92
TUaWjHd/RtL+LbeMfpkv+LSk/fuRGTHwfR2fkLQdsXal2LWOUm9Jyr/V/AZq
ubZ6Q9L+vfWMMphdek294b9EwK+j8E6KV6Tbf9fhafFS6kVJ+e9v3ELtGMr3
JO2/YPIMapmpfFbS/hsw/OIKr4TekrT/5s4d8VLqpqT814qeQy1zPYuS9t97
YgzD6yhXJO2/mMWvuDBfflm94b85dk+8lLoonf47Zh9BLfOUFyTtv+T2Q6hl
zvW8pC3+yfDLMMyMnpX0qyb9kngpdVJS9sbxzMuoZYZtQdJvmvQrqGVe57Ck
f8KkX0Ut8zPzkv6USX9UvJSKn2T4jEm9hlquyWek87MmzS/YcE09LemfN+nX
Ucu18JSkf9Gk3xBv6BsBTuoLJvUmarlKGZf0r5g0v4rDVch6SX/FpN9CLVcX
I5L+dZP+cfFSalD+/ZpJfRy1vLtiQDp/06Q/gdo8yr2S/qZJfxK1vIOnU9K/
bdKfQi3vkWmV9Nsm/ZPF8pcS6RMnZbF35qfMbKl20T+h6H6wCNO+vpWMwOIn
lt612p8u+m8z/rmVMiv+B/tGPh4=\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Compare to the default ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"], "MR"]], "InlineFormula"],
 " behavior."
}], "MathCaption",
 CellID->12263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data3D", ",", " ", 
   RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->4313],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxdWgc4lV8YR8gI9153D+vao+hfRqX7UqFhNjT8o71EQgMtSkOFaC9JQ0o0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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtk1dMVUEURefaFcEaRYkoCtiABIxYsDxsBLsoWKMBFbCBoiCCBTB8GAP2
xN419t5LbIm99/Jh1y9NLIlRP3SdnPOx3t4z9955c2b2CUnLTsqq4JybAxWh
HwyCarABij3n5qIvYDY+Hz0FA/D90SHoSTQRNsIqqAmXIYVnyWggugjtIOvj
z8p3sBx/B50Co/Fv0AXwHsYxLka3wjR8MPoMJuBnopPQ52gebINsxk3RPRCE
b4X6nO6xOhTBWKgNuTy/J+vCTShhPBEdIeuDH3yEoxAPn+EY9JC1ePew1XIJ
hjIeZmt1garwEPKZn46ehiT8QDk/2aedz1PItFr2Qii+LVoHmtj5d2buBjpe
1saXoiHQDb8DbQ4x+OtoKtyC3lbLS1iNL7T16+LboPXRI7I2ROJXyllDuad3
lwnf4aLUBovtXubbObe2u5Bzi/f0vCQnryHA7ivM0xq2Q4TdyzpIx8+y2u+D
P6QxdxfNgtuWITmfMcy/tXuTukoZp1v2Pkn+bM21UAXKeP7O8hNsmewLm6Ae
40D0FazBz5MsWPYm2x19cZr7J1Irz3KcZn6Zp70R5vR+pEcSmDuO9rS8BTBu
KXeH7kZbSG34Q2h72GfvRKJ/YIlkQvbH3Bl0MDyCSpaZWOhudfk8zZ7k8LHk
i/EM+/YE2gcewD/LVldPc+uDr0732Uv2bvfeCb7BBdvDFvgJQTCKd8qd9mYj
Wz/Bac6jrZf/wnnLxg+n9YY67fdY3kmxWgpsn9IvB9AYGIk/Z/VKL0+1PETL
/0FlWApR1lNF1uO5sBkaePpeR2hod7EfajEfZefeGDypk5+dTvtlIf6a1Oc0
kzmMm6EfIBVfYtlLxGeg4RAh9+G0jwqZL0DjnH4nPZ7B3HrbWxx+l9N+lLz9
sv3Jnn87zZ4f7xxE20kdTvPlb/VegRqwwmke5H+vQjLfDLc7Drf5PE97R/rl
PyVZoIg=
         "]], Polygon3DBox[CompressedData["
1:eJxNlklwkEUQRmcIBlwQhWhEAgoESaAU1KhhMVEgCASJ4A4oEJFdIqCAJqIW
JIGEoIJJ2PSmWOXJq+JyUE+WW+nJpUrKDde4xQVF30d/Bw+vpmf+npmenu6e
f0R9w/x1fVJKz0NfuCqndBksRa6Hd+B++vfB28jraRtgHdwLfeAfxv+GjLwc
DiIXQjU8Rn83rEReBfthLf01sC/F3FfhFa9xt9fQ3Cr374J6WAZ/MPYnTIDx
KdbQWquhG3kT7UY4B/lc6SBfDIuRl/gsG3KcQ2f6XjZCf6hLsYbWWgVdyKfR
7qDtB1PgDPoD4ArkCngBTpXPaE+B3+AXKIXRcBbfBkIZcjm8Bj9DjdaCzhT+
2ez+izCb/gzfx2GYJB/Qng5fwjGYC9en8I3uSHcjH22B95Hfg805dDXnC/ga
ttlG2VYAv3tMcrF98RecbZ/8a5tlW4PmsWabvw2D8+kPgeuQZ8II5OEwG7kW
SnLo6Nssr30CBnmPYr4VwSTkyXBtjjPrrMtS+F46k30Hbd6j1jbMRJ6Vw5/T
5RPFm+4E5sA38BVMhWkpvi1A5xbrvOuYUawMcAwqFl+G4yliQLGwifbMFHF/
Tw77B+vOnQOK/b5QCP0df0U6Z44Y0N2PTfG9wHM098MU+v3gA8eXYk6xdnWK
u0w57kF3WuA9irz/dPk+x9l0xhbNo3+NzzcGeRdtO1yUQ78aqjTHebgSVjiH
GuEBgf6D0Kp7oj8qzDgZ+7JRtik/tfYo+iNz7CEkj3CclNGOg4nIlfJBDptk
S7n8niOHlDtD4Dz5zjGhe+9grDTHHtprp3WKnZcavxAusA2lnqN4HmffFtrX
/VyzdIeDfT8jPXe4bd5oHX3THWrtYTniWHrPMjaRthKeQd6eoiapFqmOdvjM
lbbhduQ9tE/AbaobcClMgIocc7c7B5WL8lWZfTTWOtJVHbs8x/1e6XWaLbf4
rhXTt9K/GW5SjOewtcJzK41k1XjV+ueUdzlqzMm8y+Fj+VZxONU6h52b1faB
zq4YmgN1OfJbNaDOY7Uw1/fc7rwd7Vid7tib4bN2OI7GeGya963JkdvK8eV8
X5Fi7SO0L6XYQ765JEeNH2/9t1LUqxrbMy9H7ZGN82yvbLshR67If/LlFORe
34fuskT3xtiTOXJBOSFZY4/DXuv/mqLmq67ewdhR2s9gUY76rDesyvm8JIeO
vi2GhXAnrE7xPh5C3gfdcBA+ZuwA7X74CPmTFOMH/E1v50/Q47rVwXib7lD5
kuMsvbZNMXbUOvomG484RhWb8qli503aN1LE0Lcp3g3VUNXS+fab3h69Qap7
qpnHXaf0pq53DimXTrhmKd8GWdaY3n3VQPljKaylv8Zn+S7FvjqTvn1OOzCF
To+/yZYfU7ylP6So/TW2Wba/Djfm8EmPdVXT2xnbAa32U5vlFvtMex/zmbXP
o4w9laL26w3YZb1FumtoUmzkqJmNXrtZfve6rZa3eQ+990/D1hT/RJ2M7clx
dp1PtUY1R29FuftDc7yhJY47/VMpVhQzzd5TuaEcka7maG6ZY0Wx1OWY6XY8
7/3fmNpOx5hiTzHYxNxGx3avc2EofOoY1bqKxS6vtcdryF8P55irNXb63AtT
+Gy37d+S4p9na443UG/fQ9aVrxakmKPvh1K8zRvgkRx6Td7nP43nGqY=
         "]], Polygon3DBox[CompressedData["
1:eJwtlWdsSFEUx+8TQsxStbe2ovaeNUrNKG3tvWpTm9KliMSqUbFDrFiJvSNm
YgWxxwczYsQIX6wYv3/u+fDL+Z9z37n3vXPvPa/y8OSESbmcc30gD0wInHuE
nQZj0ONhImzDLw9FoRjMInYHmywNs6E2sRXY/JADtfCzsZ/gI3yFBFhPfA1M
QBeBNAjF34ItCU2hGRQmth9bEyKhGvQm1hMS4QJ+L/gJP+C783OUsthWKA31
oC6MI2c0zEA/hrFoB78xiXAe/sFZ+AKf4ZuN/YVf9v7n4A/kJjewOe5iJkNe
dJ7Aj93DnwJ7VDf8ECgG4fjh2H3YKKiErgr54AH+VCgBYXAQChFvhW0NjZ2f
Q7k1IML5+Q5AAeL5oSA0tDUXaV9UZ1s/LPC1Vn0PQ3H0QriBToIs9AJDuh+x
KzAfXRb22j6URpeBNLhv3zkHnWp51/FHQl/n5zikb7L1S0ET/OrYSIiw81UB
KqLLQWf0CcUCn7fV9jXU5tC718BGQU1o7ryVr3m3ay6L7VCNoYXzz9Wzs9PT
zmxdaAB1YCixq1Af3Rgu2hlTTiPVynnbUDWEyppX3wPD0de0BnqnzrHFNV4F
vw22peXs0n6ij2CjLa7xtvjttN+Wsxti0EctXzntIQY/NvBjba3e2r9j0BG/
A3TSs85b+bG2z6MgDt0V4tHLoRu6R+Dj0icV01nUfVEP0Nm2Ok61mqq+yegp
0B/6BP5+qma9bWy77at6yKTA36sP+kZ7V92xBOKnsN2hK3SxvY+3d9K4Ymd0
nmyd/vbup2E1rNI50/PYIdiBkIkOgXnO9yCtEQfvne9Hx+0c6zyrv3SAd/DG
+X1Qzd/CCxjAc2OxYyDd+d74UHcTNjnfV25hp2OnwUx9L/4G2Ki48711veqP
TYKRge+1GlM/ysTPgHnKd17rPs2Fp/hzba10u3d6Xr3sOWyGVI0Te4ZdZzlz
IAe9NvD3Uz1JfWo2OiXw9VzpfP/vZbVVXOPq8U+Ip8BtGIEfjW3p/Hm4CYOJ
DdK9gfHmq1YZ6FfOj6lXX0Zfcv7/oHs3zHK0V6/xs6zOS/AXwzKbYzV2BYyz
9VahX2KXal2t5/w+r7R31X8o23L+A8Twuzo=
         "]], 
        Polygon3DBox[{{174, 265, 55, 137, 267, 51}, {230, 184, 76, 64, 179, 
         229}, {356, 354, 110, 208, 214, 115}, {158, 204, 103, 392, 395, 
         126}, {182, 330, 80, 188, 332, 71}, {244, 161, 26, 35, 169, 243}, {
         271, 173, 45, 270, 170, 40}}]}]}, {}, {}}, {
     Line3DBox[{28, 2, 47, 48, 49, 5, 50, 174, 51, 175, 52, 53, 176, 54, 6, 
      154, 153, 152, 151, 150, 14, 223, 222, 221, 220, 219, 125, 15, 228, 130,
       227, 129, 16, 94, 93, 92, 91, 90, 199, 89, 88, 11, 99, 201, 98, 97, 
      200, 96, 95, 148, 10, 195, 196, 197, 198, 87, 145, 146, 147, 4, 44, 172,
       45, 173, 46, 135, 1, 26, 161, 27, 28}], {
      Line3DBox[{135, 273, 169, 243, 245, 131, 247, 159, 275, 277, 280, 137, 
       267, 175}], 
      Line3DBox[{147, 186, 330, 182, 281, 282, 284, 287, 290, 139, 294, 297, 
       163, 367, 369, 372, 206, 354, 356, 215, 364, 153}], 
      Line3DBox[{148, 301, 303, 307, 312, 165, 318, 323, 326, 328, 329, 204, 
       158, 149, 398, 399, 400, 403, 406, 410, 220}], 
      Line3DBox[{150, 361, 216, 384, 381, 212, 263, 261, 258, 253, 191, 241, 
       236, 233, 230, 184, 333, 142, 346, 343, 341, 198}], 
      Line3DBox[{161, 244, 246, 132, 248, 249, 160, 278, 177, 265, 174}], 
      Line3DBox[{172, 270, 170, 283, 285, 288, 291, 140, 295, 298, 300, 164, 
       370, 373, 207, 355, 357, 358, 155, 154}], 
      Line3DBox[{173, 271, 272, 274, 171, 292, 141, 296, 299, 178, 276, 279, 
       136, 266, 268, 269, 176}], 
      Line3DBox[{199, 387, 390, 393, 396, 225, 348, 351, 227}], 
      Line3DBox[{200, 306, 311, 315, 168, 322, 325, 203, 389, 392, 395, 224, 
       347, 350, 205, 402, 405, 409, 219}], 
      Line3DBox[{201, 314, 167, 321, 202, 386, 388, 391, 394, 397, 226, 349, 
       352, 353, 228}], 
      Line3DBox[{145, 344, 187, 331, 334, 336, 338, 185, 237, 143, 250, 254, 
       259, 262, 264, 213, 382, 156, 359, 362, 151}], 
      Line3DBox[{146, 345, 188, 332, 335, 337, 183, 286, 289, 138, 293, 162, 
       365, 366, 368, 371, 374, 208, 214, 360, 363, 152}], 
      Line3DBox[{195, 144, 302, 304, 308, 313, 166, 319, 324, 327, 181, 238, 
       242, 192, 255, 209, 375, 217, 401, 404, 407, 411, 221}], 
      Line3DBox[{196, 339, 193, 305, 309, 133, 316, 320, 180, 231, 234, 239, 
       189, 251, 256, 210, 376, 377, 379, 218, 408, 412, 222}], 
      Line3DBox[{197, 340, 342, 194, 310, 134, 317, 179, 229, 232, 235, 240, 
       190, 252, 257, 260, 211, 378, 380, 383, 385, 157, 223}]}, {
      Line3DBox[{28, 246, 245, 37, 43, 292, 291, 290, 289, 75, 79, 237, 236, 
       235, 234, 67, 327, 326, 325, 101, 386, 89}], 
      Line3DBox[{49, 25, 278, 277, 276, 58, 300, 31, 367, 366, 19, 259, 258, 
       257, 256, 255, 111, 119, 398, 104, 126, 395, 394, 393, 92}], 
      Line3DBox[{54, 63, 358, 116, 364, 363, 362, 361, 118, 385, 124, 412, 
       411, 410, 409, 125}], 
      Line3DBox[{88, 100, 321, 322, 323, 324, 66, 231, 232, 233, 78, 338, 74, 
       286, 287, 288, 42, 274, 36, 243, 244, 27}], 
      Line3DBox[{129, 351, 352, 107, 402, 403, 404, 122, 379, 380, 381, 382, 
       114, 22, 374, 110, 354, 355, 61, 268, 52}], 
      Line3DBox[{26, 35, 273, 272, 41, 285, 284, 73, 337, 336, 77, 230, 229, 
       65, 320, 319, 318, 34, 315, 314, 99}], 
      Line3DBox[{44, 38, 70, 330, 80, 345, 344, 343, 342, 85, 305, 304, 303, 
       96}], Line3DBox[{45, 270, 39, 281, 71, 332, 331, 81, 346, 86, 310, 309,
        308, 307, 306, 97}], 
      Line3DBox[{46, 271, 40, 283, 282, 72, 335, 334, 333, 76, 64, 317, 316, 
       33, 313, 312, 311, 98}], 
      Line3DBox[{47, 248, 247, 23, 56, 296, 295, 294, 293, 29, 17, 250, 82, 
       241, 240, 239, 238, 68, 328, 102, 389, 388, 387, 90}], 
      Line3DBox[{48, 249, 24, 275, 57, 299, 298, 297, 30, 365, 18, 254, 253, 
       252, 251, 83, 242, 69, 329, 103, 392, 391, 390, 91}], 
      Line3DBox[{50, 265, 55, 280, 279, 59, 32, 370, 369, 368, 20, 262, 261, 
       260, 112, 376, 375, 120, 399, 105, 347, 127, 397, 396, 93}], 
      Line3DBox[{51, 267, 266, 60, 109, 373, 372, 371, 21, 264, 263, 113, 378,
        377, 121, 401, 400, 106, 350, 349, 348, 128, 94}], 
      Line3DBox[{53, 269, 62, 357, 356, 115, 360, 359, 117, 384, 383, 123, 
       408, 407, 406, 405, 108, 353, 130}], 
      Line3DBox[{87, 341, 340, 339, 84, 302, 301, 95}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJwll3k4Ve/392k0RRIZMyTRhxClolYihIxlCokIkRQlKUpkChlCQpOkIvOc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    "]],
  BoxRatios->{1, 1, 0.4},
  ImageMargins->0.,
  ImageSize->Medium,
  Method->{
   "RotationControl" -> "Globe", "SpherePoints" -> Automatic, 
    "CylinderPoints" -> Automatic},
  PlotRange->{{0.6, 13.8}, {1.1, 15.25}, {0.911043357914425, 
   7.76595132614157}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{364, 292},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->5535,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ConvexHull",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/ConvexHull"], "[", "{", 
     "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     ButtonBox["AllPoints",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/AllPoints"], "\[Rule]", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], "]"}], Cell["\<\
give the minimum set of points needed to define the convex hull\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["DelaunayTriangulation",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"], 
     "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     ButtonBox["Hull",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/Hull"], "\[Rule]", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], Cell["\<\
give both the Delaunay triangulation vertex adjacency list and the convex \
hull\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlanarGraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/PlanarGraphPlot"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     ButtonBox["LabelPoints",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/LabelPoints"], "\[Rule]", 
     
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], "]"}], Cell[
    "plot the Delaunay triangulation without labels", "TableText"]},
   {
    RowBox[{
     ButtonBox["DiagramPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"], "[", "{", 
     "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     ButtonBox["LabelPoints",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/LabelPoints"], "\[Rule]", 
     
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], "]"}], Cell[
    "plot the Voronoi diagram without labels", "TableText"]},
   {
    RowBox[{
     ButtonBox["DiagramPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"], "[", "{", 
     "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     ButtonBox["TrimPoints",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/TrimPoints"], "\[Rule]", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "plot the Voronoi diagram with the outermost ray plus ",
     Cell[BoxData[
      RowBox[{"(", 
       StyleBox["n", "TI"], "-", "1", ")"}]], "InlineFormula"],
     " of the outermost diagram vertices trimmed"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->27178],

Cell["Options for computational geometry functions. ", "Caption",
 CellID->31417],

Cell["\<\
This gives the minimum set of points needed to define the convex hull. \
\>", "MathCaption",
 CellID->6580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvexHull", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"AllPoints", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->23296],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConvexHull", "::", "\<\"duplicated\"\>"}], ":", 
  " ", "\<\"\\!\\(1\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" duplicated point(s) \
ignored.\\\\\\\"\\\", \\\"MSG\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[25]:=",
 CellID->20450],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->11173]
}, Open  ]],

Cell["\<\
This returns both the Delaunay triangulation and the convex hull. \
\>", "MathCaption",
 CellID->14870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", 
  RowBox[{"DelaunayTriangulation", "[", 
   RowBox[{"data2D", ",", 
    RowBox[{"Hull", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->24716],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtuEzEQdbLZDQRy6UW0EgiVB8RDBTzQ/kJ56kdEFVL7gEClfwv/YuyN
Hblnx+u113uLNlKyHs/4zHjGHnsnt9un+x8/t08Pd9uL74/b3/cPd38ubn49
iq5kwtjkL2PswzkTbS5a+Vd+/onvrrlrHcvfRHM5+wj0DOhFw/KXnngvgV4D
vQH6TU36zKEPabQ/yb1+BL2fCKmpIHG2deU+Vxy/UP0b9TxSzzPH85wYV+aN
KemNF5SUQaeiiX1IIwZqRv6h6nxNjZ/tafGRzCTyzOR4aT3KZZb+hcUOLZ8o
fmrhu/S5xtv4c8VPLfbNS8ZR/dXWv9Y2NbWmZsyYYbOWmhO65B7EDDkk9EVU
NLR1SqLZpHU/taPioMe3uVwas35mmdm8FMXOda98PJ01ZmJiw74y+WjxcgB4
BX7Bd1mAVWV3npX4yQS5omJQ0O66wSC/GgrOgbIl07urgIYZEvMw2jjhVfIq
ZmdXHsE59Q1vw2NkS9/4r0gtYaukvbVWRFmSvbiG8GYU50ZLR8p1y8J5D1nL
icvPzP+WSu2vsnWx1or2Zje3iqUazNN6Z5LZ7pldS4Ww5nXumadAoz1od2z5
tw55177Gc9DEbzgHGbTrbCp7B97nnRIvhcV2Q84Vqz1ktaShUe+Axh0fFq12
Yo4xpXauT8zJzOMdc/SwPv+xn1obdeTeczpPUWdlorwt77En6rlSzxT4KX9e
PcoU35SfGfL6tr025Khzgq7BySZWQ/1brvccpLuur/ZN/pWn/Jfc664II91W
fbUrOfSiTe5rkPcOtTY66jwsnVj9akNn/o+K944aUg12RO+u9t0c+u4cdVUz
bFXpPtVTR7xwPHwPqYv3jcfIhl3XUUe8+nXomHhXPGRVDbkaOmrppxZc2c1o
CVvvXVdz+yaPtEs+zOv9q7P2fxQZKeeoXXx8621t1US7kqtaA77OvSebVaqa
bPIfDv9opw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{475, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]//Shallow=",
 CellID->383530681]
}, Open  ]],

Cell[TextData[{
 "Here is a set of random numbers uniformly distributed on \
[0,\[ThinSpace]1]",
 Cell[BoxData[
  FormBox["\[Cross]", TraditionalForm]], "InlineFormula"],
 "[0,\[ThinSpace]1]. "
}], "MathCaption",
 CellID->18197],

Cell[BoxData[
 RowBox[{
  RowBox[{"random", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Random", "[", "]"}], ",", 
       RowBox[{"Random", "[", "]"}]}], "}"}], ",", 
     RowBox[{"{", "40", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->1893],

Cell[TextData[{
 "This computes the Voronoi diagram of ",
 StyleBox["random", "MR"],
 ". "
}], "MathCaption",
 CellID->13342],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"randvert", ",", "randval"}], "}"}], "=", 
   RowBox[{"VoronoiDiagram", "[", "random", "]"}]}], ";"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->2661],

Cell["The diagram plot is dominated by outlier vertices. ", "MathCaption",
 CellID->16878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagramPlot", "[", 
  RowBox[{"random", ",", "randvert", ",", "randval", ",", 
   RowBox[{"LabelPoints", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->15654],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->419757749]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrimPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/TrimPoints"], "->", "2"}]], 
  "InlineFormula"],
 " means that the diagram is plotted so that both the outermost ray and the \
outermost vertex are eliminated. "
}], "MathCaption",
 CellID->2075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagramPlot", "[", 
  RowBox[{"random", ",", "randvert", ",", "randval", ",", 
   RowBox[{"LabelPoints", "\[Rule]", "False"}], ",", 
   RowBox[{"TrimPoints", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->27035],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->539212430]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["TrimPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/TrimPoints"]], 
  "InlineFormula"],
 " option can be used to magnify the diagram until the points in ",
 StyleBox["random", "MR"],
 " fill the plot. "
}], "MathCaption",
 CellID->4439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagramPlot", "[", 
  RowBox[{"random", ",", "randvert", ",", "randval", ",", 
   RowBox[{"LabelPoints", "\[Rule]", "False"}], ",", 
   RowBox[{"TrimPoints", "\[Rule]", "6"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->11494],

Cell[BoxData[
 GraphicsBox[{
   {PointSize[0.012], PointBox[{0.26677488743003, 0.221463312544598}], 
    PointBox[{0.303027245568594, 0.021967199999028}], 
    PointBox[{0.0941453010958449, 0.321130254151922}], 
    PointBox[{0.257694099601562, 0.903587597809996}], 
    PointBox[{0.932801416342398, 0.707326954009106}], 
    PointBox[{0.241619172846159, 0.327607012808426}], 
    PointBox[{0.490743790872417, 0.732327711739876}], 
    PointBox[{0.830271270634255, 0.175071847553539}], 
    PointBox[{0.186397016350372, 0.0658704175910981}], 
    PointBox[{0.627315875466556, 0.200216411255833}], 
    PointBox[{0.123517188870454, 0.286765396585615}], 
    PointBox[{0.018535763177323, 0.155347656543204}], 
    PointBox[{0.856742301440424, 0.0653020840410177}], 
    PointBox[{0.715508517608729, 0.133380456544176}], 
    PointBox[{0.762597000344579, 0.744171829889095}], 
    PointBox[{0.457814418007166, 0.22979285873418}], 
    PointBox[{0.829795584002181, 0.036844875879989}], 
    PointBox[{0.216195245161007, 0.902185845925754}], 
    PointBox[{0.339051793129765, 0.304517164140113}], 
    PointBox[{0.385923974526752, 0.727113998372214}], 
    PointBox[{0.152654776779393, 0.238646746549015}], 
    PointBox[{0.758608099060196, 0.526897587116381}], 
    PointBox[{0.0291375879089389, 0.9518813499634}], 
    PointBox[{0.740072335882873, 0.371549930573177}], 
    PointBox[{0.172395286468515, 0.886579265922382}], 
    PointBox[{0.0245638182741444, 0.238169474029002}], 
    PointBox[{0.409798286123936, 0.142407436033287}], 
    PointBox[{0.566749400266978, 0.0083766152948216}], 
    PointBox[{0.580002702121754, 0.105562560153298}], 
    PointBox[{0.35055415510597, 0.106190769369068}], 
    PointBox[{0.24095090899199, 0.801045396013185}], 
    PointBox[{0.964630180579218, 0.379076770996853}], 
    PointBox[{0.088296132212597, 0.562398649464169}], 
    PointBox[{0.206022081519022, 0.852179183880472}], 
    PointBox[{0.0591585443036581, 0.610517299500769}], 
    PointBox[{0.465949745636149, 0.480629253307295}], 
    PointBox[{0.886763257835143, 0.723938033578387}], 
    PointBox[{0.441385927362004, 0.242459779278293}], 
    PointBox[{0.476964971711208, 0.5815305975451}], 
    PointBox[{0.874636527095026, 0.234083163983472}]}, 
   {PointSize[0.012], PointBox[{-5.97921637904655, 0.63351484753897}], 
    PointBox[{-1.93020023222796, 0.607567027798793}], 
    PointBox[{-0.162619163773041, 0.443341594977531}], 
    PointBox[{-0.127606614005938, 0.436459330879774}], 
    PointBox[{0.0375837286143178, 0.780622029936866}], 
    PointBox[{0.0699780071931676, 0.270739687146586}], 
    PointBox[{0.0804309297721581, 0.763046709682187}], 
    PointBox[{0.088630346768441, 0.232758890129512}], 
    PointBox[{0.0887827187358214, 0.191865122873602}], 
    PointBox[{0.106890141460433, 0.746966832499882}], 
    PointBox[{0.119454987259804, 0.142480016756748}], 
    PointBox[{0.148292114002753, 1.02349067241437}], 
    PointBox[{0.16265039372939, 0.443496150831235}], 
    PointBox[{0.16661022663222, 0.35333193125232}], 
    PointBox[{0.187584860535023, 0.292679437394803}], 
    PointBox[{0.196925932138323, 0.661059191613695}], 
    PointBox[{0.198863473225348, 0.157988044815793}], 
    PointBox[{0.199588857360843, 0.879526060074033}], 
    PointBox[{0.215014091882188, 0.265248932698915}], 
    PointBox[{0.22333030017855, 1.30594011290814}], 
    PointBox[{0.237997684165531, 0.87171231557681}], 
    PointBox[{0.245164550699068, 0.63020247282317}], 
    PointBox[{0.258349231140521, 0.127258244575168}], 
    PointBox[{0.258840780168218, 0.850762343554265}], 
    PointBox[{0.265351772600651, 0.0987486428623083}], 
    PointBox[{0.276299530435944, 0.517711022593372}], 
    PointBox[{0.282059171933102, 0.281138400409401}], 
    PointBox[{0.283141691836449, 0.561580728408269}], 
    PointBox[{0.283633758714272, 0.551584304544361}], 
    PointBox[{0.322182345293324, 0.450446825541902}], 
    PointBox[{0.341447092358259, 0.187653181361267}], 
    PointBox[{0.350048051686121, 0.835869931403517}], 
    PointBox[{0.355893336088747, 0.216884849037865}], 
    PointBox[{0.356199137211716, 0.214341742487074}], 
    PointBox[{0.417806758426281, 0.194891528995411}], 
    PointBox[{0.430158686675971, 0.894080206128195}], 
    PointBox[{0.434282794622249, 0.00342177104092683}], 
    PointBox[{0.441763225618594, 0.660775159424505}], 
    PointBox[{0.442698728085813, 0.0220232179954529}], 
    PointBox[{0.444209307512674, 0.362520030002559}], 
    PointBox[{0.483059589130857, 0.0692860943539662}], 
    PointBox[{0.500422961992822, 0.149495965255667}], 
    PointBox[{0.537497277985641, 0.185960878466313}], 
    PointBox[{0.539478095627371, 0.352694399711406}], 
    PointBox[{0.566438172836695, 0.35182000881062}], 
    PointBox[{0.575542294808675, 0.357059058910376}], 
    PointBox[{0.609262591086691, 1.13780400266998}], 
    PointBox[{0.610357571297785, 0.51591642829456}], 
    PointBox[{0.618432042531163, 0.464843453294405}], 
    PointBox[{0.630798354756838, 0.643502409389334}], 
    PointBox[{0.634011892355385, 0.637858765092412}], 
    PointBox[{0.645153140765161, 0.132148588338213}], 
    PointBox[{0.66309840132681, 0.0447341004716921}], 
    PointBox[{0.700724073306698, -0.0000418175895244005}], 
    PointBox[{0.73571457916824, 0.251647929125966}], 
    PointBox[{0.737567618826861, 0.251456814250246}], 
    PointBox[{0.770182740919132, 0.266429727382828}], 
    PointBox[{0.788059086776553, 0.10335283145313}], 
    PointBox[{0.789947843348902, 0.10727120123257}], 
    PointBox[{0.808482298809815, 0.63465569224074}], 
    PointBox[{0.850277577378262, 0.437180120462278}], 
    PointBox[{0.85327456732286, 0.34776709126897}], 
    PointBox[{0.866864385916602, 0.596683967261799}], 
    PointBox[{0.924675632554544, 0.540870808896786}], 
    PointBox[{0.93526988136673, 0.142315679986014}], 
    PointBox[{1.19042149955362, 2.97845516600532}], 
    PointBox[{1.23558705917066, 0.110475953937283}]}, 
   {Thickness[0.003], 
    LineBox[{{0.265351772600651, 0.0987486428623083}, {
     0.200808913367413, -0.0727114204231592}}], 
    LineBox[{{0.434282794622249, 0.00342177104092683}, {
     0.420692209918043, -0.260300383657453}}], 
    LineBox[{{0.22333030017855, 1.30594011290814}, {0.271624052331954, 
     1.53449662460077}}], 
    LineBox[{{1.19042149955362, 2.97845516600532}, {1.37007106378524, 
     3.6075243242389}}], 
    LineBox[{{0.924675632554544, 0.540870808896786}, {1.27696598147306, 
     0.5750306267398}}], 
    LineBox[{{0.866864385916602, 0.596683967261799}, {0.926393416658049, 
     0.761670652300995}}], 
    LineBox[{{0.119454987259804, 0.142480016756748}, {
     0.0129891508117417, -0.0572522161058979}}], 
    LineBox[{{-5.97921637904655, 0.63351484753897}, {-6.77575007246675, 
     0.644116672270514}}], 
    LineBox[{{0.788059086776553, 0.10335283145313}, {0.871726150882332, 
     0.0241267625222594}}], 
    LineBox[{{1.23558705917066, 0.110475953937283}, {1.5493617461265, 
     0.00258807479848874}}], 
    LineBox[{{0.700724073306698, -0.0000418175895244005}, {
     0.729192333891866, -0.263088001324734}}], 
    LineBox[{{0.215014091882188, 0.265248932698915}, {0.198863473225348, 
     0.157988044815793}, {0.258349231140521, 0.127258244575168}, {
     0.341447092358259, 0.187653181361267}, {0.356199137211716, 
     0.214341742487074}, {0.355893336088747, 0.216884849037865}, {
     0.282059171933102, 0.281138400409401}, {0.215014091882188, 
     0.265248932698915}}], 
    LineBox[{{0.434282794622249, 0.00342177104092683}, {0.265351772600651, 
     0.0987486428623083}}], 
    LineBox[{{-0.127606614005938, 0.436459330879774}, {0.0699780071931676, 
     0.270739687146586}, {0.16661022663222, 0.35333193125232}, {
     0.16265039372939, 0.443496150831235}, {-0.127606614005938, 
     0.436459330879774}}], 
    LineBox[{{0.22333030017855, 1.30594011290814}, {0.237997684165531, 
     0.87171231557681}, {0.258840780168218, 0.850762343554265}, {
     0.350048051686121, 0.835869931403517}, {0.430158686675971, 
     0.894080206128195}, {0.609262591086691, 1.13780400266998}, {
     1.19042149955362, 2.97845516600532}}], 
    LineBox[{{0.866864385916602, 0.596683967261799}, {0.924675632554544, 
     0.540870808896786}}], 
    LineBox[{{0.16265039372939, 0.443496150831235}, {0.16661022663222, 
     0.35333193125232}, {0.187584860535023, 0.292679437394803}, {
     0.215014091882188, 0.265248932698915}, {0.282059171933102, 
     0.281138400409401}, {0.322182345293324, 0.450446825541902}, {
     0.276299530435944, 0.517711022593372}, {0.16265039372939, 
     0.443496150831235}}], 
    LineBox[{{0.430158686675971, 0.894080206128195}, {0.441763225618594, 
     0.660775159424505}, {0.630798354756838, 0.643502409389334}, {
     0.609262591086691, 1.13780400266998}, {0.430158686675971, 
     0.894080206128195}}], 
    LineBox[{{0.737567618826861, 0.251456814250246}, {0.789947843348902, 
     0.10727120123257}, {0.93526988136673, 0.142315679986014}, {
     0.770182740919132, 0.266429727382828}, {0.737567618826861, 
     0.251456814250246}}], 
    LineBox[{{0.265351772600651, 0.0987486428623083}, {0.258349231140521, 
     0.127258244575168}, {0.198863473225348, 0.157988044815793}, {
     0.119454987259804, 0.142480016756748}}], 
    LineBox[{{0.566438172836695, 0.35182000881062}, {0.537497277985641, 
     0.185960878466313}, {0.645153140765161, 0.132148588338213}, {
     0.73571457916824, 0.251647929125966}, {0.575542294808675, 
     0.357059058910376}, {0.566438172836695, 0.35182000881062}}], 
    LineBox[{{0.0699780071931676, 0.270739687146586}, {0.088630346768441, 
     0.232758890129512}, {0.187584860535023, 0.292679437394803}, {
     0.16661022663222, 0.35333193125232}, {0.0699780071931676, 
     0.270739687146586}}], 
    LineBox[{{0.119454987259804, 0.142480016756748}, {0.0887827187358214, 
     0.191865122873602}, {-5.97921637904655, 0.63351484753897}}], 
    LineBox[{{1.23558705917066, 0.110475953937283}, {0.93526988136673, 
     0.142315679986014}, {0.789947843348902, 0.10727120123257}, {
     0.788059086776553, 0.10335283145313}}], 
    LineBox[{{0.645153140765161, 0.132148588338213}, {0.66309840132681, 
     0.0447341004716921}, {0.700724073306698, -0.0000418175895244005}, {
     0.788059086776553, 0.10335283145313}, {0.789947843348902, 
     0.10727120123257}, {0.737567618826861, 0.251456814250246}, {
     0.73571457916824, 0.251647929125966}, {0.645153140765161, 
     0.132148588338213}}], 
    LineBox[{{0.609262591086691, 1.13780400266998}, {0.630798354756838, 
     0.643502409389334}, {0.634011892355385, 0.637858765092412}, {
     0.808482298809815, 0.63465569224074}, {1.19042149955362, 
     2.97845516600532}, {0.609262591086691, 1.13780400266998}}], 
    LineBox[{{0.539478095627371, 0.352694399711406}, {0.417806758426281, 
     0.194891528995411}, {0.500422961992822, 0.149495965255667}, {
     0.537497277985641, 0.185960878466313}, {0.566438172836695, 
     0.35182000881062}, {0.539478095627371, 0.352694399711406}}], 
    LineBox[{{0.788059086776553, 0.10335283145313}, {
     0.700724073306698, -0.0000418175895244005}}], 
    LineBox[{{0.148292114002753, 1.02349067241437}, {0.199588857360843, 
     0.879526060074033}, {0.237997684165531, 0.87171231557681}, {
     0.22333030017855, 1.30594011290814}, {0.148292114002753, 
     1.02349067241437}}], 
    LineBox[{{0.282059171933102, 0.281138400409401}, {0.355893336088747, 
     0.216884849037865}, {0.444209307512674, 0.362520030002559}, {
     0.322182345293324, 0.450446825541902}, {0.282059171933102, 
     0.281138400409401}}], 
    LineBox[{{0.350048051686121, 0.835869931403517}, {0.245164550699068, 
     0.63020247282317}, {0.283141691836449, 0.561580728408269}, {
     0.441763225618594, 0.660775159424505}, {0.430158686675971, 
     0.894080206128195}, {0.350048051686121, 0.835869931403517}}], 
    LineBox[{{0.088630346768441, 0.232758890129512}, {0.0887827187358214, 
     0.191865122873602}, {0.119454987259804, 0.142480016756748}, {
     0.198863473225348, 0.157988044815793}, {0.215014091882188, 
     0.265248932698915}, {0.187584860535023, 0.292679437394803}, {
     0.088630346768441, 0.232758890129512}}], 
    LineBox[{{0.634011892355385, 0.637858765092412}, {0.610357571297785, 
     0.51591642829456}, {0.618432042531163, 0.464843453294405}, {
     0.850277577378262, 0.437180120462278}, {0.924675632554544, 
     0.540870808896786}, {0.866864385916602, 0.596683967261799}, {
     0.808482298809815, 0.63465569224074}, {0.634011892355385, 
     0.637858765092412}}], 
    LineBox[{{-5.97921637904655, 0.63351484753897}, {-1.93020023222796, 
     0.607567027798793}, {0.0375837286143178, 0.780622029936866}, {
     0.148292114002753, 1.02349067241437}, {0.22333030017855, 
     1.30594011290814}}], 
    LineBox[{{0.575542294808675, 0.357059058910376}, {0.73571457916824, 
     0.251647929125966}, {0.737567618826861, 0.251456814250246}, {
     0.770182740919132, 0.266429727382828}, {0.85327456732286, 
     0.34776709126897}, {0.850277577378262, 0.437180120462278}, {
     0.618432042531163, 0.464843453294405}, {0.575542294808675, 
     0.357059058910376}}], 
    LineBox[{{0.0375837286143178, 0.780622029936866}, {0.0804309297721581, 
     0.763046709682187}, {0.199588857360843, 0.879526060074033}, {
     0.148292114002753, 1.02349067241437}, {0.0375837286143178, 
     0.780622029936866}}], 
    LineBox[{{-5.97921637904655, 0.63351484753897}, {0.0887827187358214, 
     0.191865122873602}, {0.088630346768441, 0.232758890129512}, {
     0.0699780071931676, 0.270739687146586}, {-0.127606614005938, 
     0.436459330879774}, {-0.162619163773041, 
     0.443341594977531}, {-1.93020023222796, 
     0.607567027798793}, {-5.97921637904655, 0.63351484753897}}], 
    LineBox[{{0.341447092358259, 0.187653181361267}, {0.442698728085813, 
     0.0220232179954529}, {0.483059589130857, 0.0692860943539662}, {
     0.500422961992822, 0.149495965255667}, {0.417806758426281, 
     0.194891528995411}, {0.356199137211716, 0.214341742487074}, {
     0.341447092358259, 0.187653181361267}}], 
    LineBox[{{0.700724073306698, -0.0000418175895244005}, {0.66309840132681, 
     0.0447341004716921}, {0.483059589130857, 0.0692860943539662}, {
     0.442698728085813, 0.0220232179954529}, {0.434282794622249, 
     0.00342177104092683}}], 
    LineBox[{{0.500422961992822, 0.149495965255667}, {0.483059589130857, 
     0.0692860943539662}, {0.66309840132681, 0.0447341004716921}, {
     0.645153140765161, 0.132148588338213}, {0.537497277985641, 
     0.185960878466313}, {0.500422961992822, 0.149495965255667}}], 
    LineBox[{{0.258349231140521, 0.127258244575168}, {0.265351772600651, 
     0.0987486428623083}, {0.434282794622249, 0.00342177104092683}, {
     0.442698728085813, 0.0220232179954529}, {0.341447092358259, 
     0.187653181361267}, {0.258349231140521, 0.127258244575168}}], 
    LineBox[{{0.106890141460433, 0.746966832499882}, {0.196925932138323, 
     0.661059191613695}, {0.245164550699068, 0.63020247282317}, {
     0.350048051686121, 0.835869931403517}, {0.258840780168218, 
     0.850762343554265}, {0.106890141460433, 0.746966832499882}}], 
    LineBox[{{0.924675632554544, 0.540870808896786}, {0.850277577378262, 
     0.437180120462278}, {0.85327456732286, 0.34776709126897}, {
     1.23558705917066, 0.110475953937283}}], 
    LineBox[{{-0.162619163773041, 0.443341594977531}, {-0.127606614005938, 
     0.436459330879774}, {0.16265039372939, 0.443496150831235}, {
     0.276299530435944, 0.517711022593372}, {0.283633758714272, 
     0.551584304544361}, {0.283141691836449, 0.561580728408269}, {
     0.245164550699068, 0.63020247282317}, {0.196925932138323, 
     0.661059191613695}, {-0.162619163773041, 0.443341594977531}}], 
    LineBox[{{0.0804309297721581, 0.763046709682187}, {0.106890141460433, 
     0.746966832499882}, {0.258840780168218, 0.850762343554265}, {
     0.237997684165531, 0.87171231557681}, {0.199588857360843, 
     0.879526060074033}, {0.0804309297721581, 0.763046709682187}}], 
    LineBox[{{-1.93020023222796, 0.607567027798793}, {-0.162619163773041, 
     0.443341594977531}, {0.196925932138323, 0.661059191613695}, {
     0.106890141460433, 0.746966832499882}, {0.0804309297721581, 
     0.763046709682187}, {0.0375837286143178, 
     0.780622029936866}, {-1.93020023222796, 0.607567027798793}}], 
    LineBox[{{0.276299530435944, 0.517711022593372}, {0.322182345293324, 
     0.450446825541902}, {0.444209307512674, 0.362520030002559}, {
     0.539478095627371, 0.352694399711406}, {0.566438172836695, 
     0.35182000881062}, {0.575542294808675, 0.357059058910376}, {
     0.618432042531163, 0.464843453294405}, {0.610357571297785, 
     0.51591642829456}, {0.283633758714272, 0.551584304544361}, {
     0.276299530435944, 0.517711022593372}}], 
    LineBox[{{1.19042149955362, 2.97845516600532}, {0.808482298809815, 
     0.63465569224074}, {0.866864385916602, 0.596683967261799}}], 
    LineBox[{{0.355893336088747, 0.216884849037865}, {0.356199137211716, 
     0.214341742487074}, {0.417806758426281, 0.194891528995411}, {
     0.539478095627371, 0.352694399711406}, {0.444209307512674, 
     0.362520030002559}, {0.355893336088747, 0.216884849037865}}], 
    LineBox[{{0.283141691836449, 0.561580728408269}, {0.283633758714272, 
     0.551584304544361}, {0.610357571297785, 0.51591642829456}, {
     0.634011892355385, 0.637858765092412}, {0.630798354756838, 
     0.643502409389334}, {0.441763225618594, 0.660775159424505}, {
     0.283141691836449, 0.561580728408269}}], 
    LineBox[{{0.770182740919132, 0.266429727382828}, {0.93526988136673, 
     0.142315679986014}, {1.23558705917066, 0.110475953937283}, {
     0.85327456732286, 0.34776709126897}, {0.770182740919132, 
     0.266429727382828}}]}},
  AspectRatio->1,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{-0.197860712786123, 0.999871729592301}, {-0.029985128648985, 
   1.16774731372944}}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->26292]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DelaunayTriangulationQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulationQ"], 
     "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["trival", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the vertex adjacency list ",
     Cell[BoxData[
      StyleBox["trival", "TI"]], "InlineFormula"],
     " represents a Delaunay triangulation of the points, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->10648],

Cell["Testing for a Delaunay triangulation. ", "Caption",
 CellID->29552],

Cell[TextData[{
 StyleBox["delval", "MR"],
 " is a Delaunay triangulation, so this returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DelaunayTriangulationQ", "[", 
  RowBox[{"data2D", ",", "delval"}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->10823],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->26439]
}, Open  ]],

Cell[TextData[{
 "This returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " because ",
 StyleBox["trival", "MR"],
 " is not a Delaunay triangulation. "
}], "MathCaption",
 CellID->12172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DelaunayTriangulationQ", "[", 
  RowBox[{"data2D", ",", "trival"}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->3674],

Cell[BoxData[
 RowBox[{
  RowBox[{"DelaunayTriangulationQ", "::", "\<\"inval\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Triangle \\\\\\\"\\\", \\\"MSG\\\"]\
\\)\\!\\({11, 15, 12}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is not a valid \
Delaunay triangle.\\\\\\\"\\\", \\\"MSG\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[33]:=",
 CellID->17253],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->20024]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BoundedDiagram",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/BoundedDiagram"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], "1"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], "1"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], "2"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], "2"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], "1"], Cell[", ", "TableText"], 
         SubscriptBox[
          StyleBox["y", "TI"], "1"], Cell["}, {", "TableText"], 
         SubscriptBox[
          StyleBox["x", "TI"], "2"], Cell[", ", "TableText"], 
         SubscriptBox[
          StyleBox["y", "TI"], "2"], Cell["}, \[Ellipsis] }]", "TableText"], 
         StyleBox[" ", "TR"]}]}]}]}]}], Cell[TextData[{
     "compute the bounded Voronoi diagram of a set of points ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"],
     ", where the bound is the convex polygon described by the points ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BoundedDiagram",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/BoundedDiagram"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], Cell[", ", "TableText"], 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], Cell["}, {", "TableText"], 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], Cell[", ", "TableText"], 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], Cell["}, \[Ellipsis] }, ", "TableText"], 
     StyleBox["delval", "TI"], "]"}], Cell[TextData[{
     "compute the bounded Voronoi diagram using the Delaunay triangulation \
vertex adjacency list ",
     StyleBox["delval", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BoundedDiagram",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/BoundedDiagram"], "[", 
     "{", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], Cell[", ", "TableText"], 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], Cell["}, {", "TableText"], 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], Cell[", ", "TableText"], 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], Cell["}, \[Ellipsis] }, ", "TableText"], 
     StyleBox["delval", "TI"], ",", 
     StyleBox["convexhull", "TI"], "]"}], Cell[TextData[{
     "compute the bounded Voronoi diagram using the Delaunay triangulation \
vertex adjacency list ",
     Cell[BoxData[
      StyleBox["delval", "TI"]], "InlineFormula"],
     " and the convex hull index list ",
     StyleBox["convexhull", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->3666],

Cell["Computing the bounded Voronoi diagram. ", "Caption",
 CellID->24553],

Cell["\<\
When spatial data is collected within a finite region of the plane, the \
unbounded Voronoi diagram of the points may not offer an accurate picture of \
the region of influence of each point. A tile on the periphery of the diagram \
will be open, indicating an infinite region of influence, when in fact an \
open tile is simply due to the limited extent of the spatial sampling. It is \
sometimes useful to intersect the unbounded Voronoi diagram of the data with \
the boundary of the convex region from which the data was collected. Then \
each point in the data can be associated with a closed tile or finite region \
of influence. \
\>", "Text",
 CellID->705],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundedDiagram",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/BoundedDiagram"]], 
  "InlineFormula"],
 " begins by finding the unbounded Voronoi diagram. It then works \
counterclockwise around the boundary, integrating bounding polygon vertices \
into the diagram, and deleting Voronoi diagram vertices falling outside of \
the boundary. Bounding an open tile of the Voronoi diagram allows one to \
approximate the true underlying closed tile one would have if the data \
collection had not been limited to a portion of the plane. "
}], "Text",
 CellID->27985],

Cell["\<\
The bounded diagram is represented as two lists: (1) a vertex coordinate \
list, and (2) a vertex adjacency list, one entry for each point in the \
original unbounded diagram indicating the associated bounded polygon vertices \
in counterclockwise order. \
\>", "Text",
 CellID->9867],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["BoundedDiagram",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/BoundedDiagram"]], 
  "InlineFormula"],
 " requires the unbounded Voronoi diagram, the computation of the bounded \
diagram can be made more efficient by providing additional arguments, such as \
the Delaunay triangulation vertex adjacency list and the convex hull. "
}], "Text",
 CellID->31115],

Cell[TextData[{
 "These are the coordinates of the rectangular region from which the ",
 StyleBox["data2D", "MR"],
 " sample was drawn. "
}], "MathCaption",
 CellID->2098],

Cell[BoxData[
 RowBox[{
  RowBox[{"b1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "16"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->31284],

Cell[TextData[{
 "This assigns the list of bounded diagram vertices to ",
 StyleBox["diagvert1", "MR"],
 " and the bounded diagram vertex adjacency list to ",
 StyleBox["diagval1", "MR"],
 ". "
}], "MathCaption",
 CellID->27516],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"diagvert1", ",", "diagval1"}], "}"}], "=", 
   RowBox[{"BoundedDiagram", "[", 
    RowBox[{"b1", ",", "data2D", ",", "delval", ",", "convexhull"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->7726],

Cell[TextData[{
 "Here is a plot of the bounded diagram of ",
 StyleBox["data2D", "MR"],
 " given by ",
 StyleBox["diagvert1", "MR"],
 " and ",
 StyleBox["diagval1", "MR"],
 ". "
}], "MathCaption",
 CellID->7464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagramPlot", "[", 
  RowBox[{"data2D", ",", "diagvert1", ",", "diagval1"}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->6907],

Cell[BoxData[
 GraphicsBox[{{InsetBox["1", {4.4, 14}], InsetBox["2", {6.7, 15.25}], 
    InsetBox["3", {6.9, 12.8}], InsetBox["4", {2.1, 11.1}], 
    InsetBox["5", {9.5, 14.9}], InsetBox["6", {13.2, 11.9}], 
    InsetBox["7", {10.3, 12.3}], InsetBox["8", {6.8, 9.5}], 
    InsetBox["9", {3.3, 7.7}], InsetBox["10", {0.6, 5.1}], 
    InsetBox["11", {5.3, 2.4}], InsetBox["12", {8.45, 4.7}], 
    InsetBox["13", {11.5, 9.6}], InsetBox["14", {13.8, 7.3}], 
    InsetBox["15", {12.9, 3.1}], InsetBox["16", {11, 1.1}]}, 
   {PointSize[0.012], PointBox[{3.52985648385443, 4.75937980522809}], 
    PointBox[{4.34075391180654, 9.97908961593172}], 
    PointBox[{4.69275724275724, 11.4057442557443}], 
    PointBox[{4.76091257179324, 11.2133056796426}], 
    PointBox[{5.46011387649683, 5.48777882131956}], 
    PointBox[{5.91533559898046, 13.952782497876}], 
    PointBox[{6.09237481031867, 6.57316009104704}], 
    PointBox[{7.98079896907217, 14.1213917525773}], 
    PointBox[{8.15935047951177, 1.79099825632084}], 
    PointBox[{8.38726708074534, 11.1034161490683}], 
    PointBox[{8.70011848341232, 13.2308056872038}], 
    PointBox[{9.13688524590164, 10.166393442623}], 
    PointBox[{9.19067656765677, 7.63820132013201}], 
    PointBox[{10.5172110552764, 3.46114949748744}], 
    PointBox[{10.8224842767296, 6.62248427672956}], 
    PointBox[{11.3003353204173, 5.63921385991058}], 
    PointBox[{11.6365306122449, 11.2773469387755}], 
    PointBox[{12.0480609418283, 14.2609418282548}], PointBox[{13.845, 9.645}],
     PointBox[{14, 1}], PointBox[{14, 16}], PointBox[{0, 16}], 
    PointBox[{0, 1}], PointBox[{14., 5.06071428571429}], 
    PointBox[{14., 9.66521739130435}], PointBox[{13.4581081081081, 16.}], 
    PointBox[{8.215625, 16.}], PointBox[{4.80271739130435, 16.}], 
    PointBox[{0., 15.1275862068966}], PointBox[{0., 8.44705882352941}], 
    PointBox[{0., 8.425}], PointBox[{1.37021276595745, 1.}], 
    PointBox[{7.97894736842105, 1.}], PointBox[{13.1078947368421, 1.}]}, 
   {Thickness[0.003], 
    LineBox[{{0, 16}, {0., 15.1275862068966}, {4.69275724275724, 
      11.4057442557443}, {5.91533559898046, 13.952782497876}, {
      4.80271739130435, 16.}, {0, 16}}], 
    LineBox[{{8.215625, 16.}, {4.80271739130435, 16.}, {5.91533559898046, 
     13.952782497876}, {7.98079896907217, 14.1213917525773}, {8.215625, 
     16.}}], LineBox[{{5.91533559898046, 13.952782497876}, {4.69275724275724, 
     11.4057442557443}, {4.76091257179324, 11.2133056796426}, {
     8.38726708074534, 11.1034161490683}, {8.70011848341232, 
     13.2308056872038}, {7.98079896907217, 14.1213917525773}, {
     5.91533559898046, 13.952782497876}}], 
    LineBox[{{0., 15.1275862068966}, {0., 8.44705882352941}, {
     4.34075391180654, 9.97908961593172}, {4.76091257179324, 
     11.2133056796426}, {4.69275724275724, 11.4057442557443}, {0., 
     15.1275862068966}}], 
    LineBox[{{13.4581081081081, 16.}, {8.215625, 16.}, {7.98079896907217, 
     14.1213917525773}, {8.70011848341232, 13.2308056872038}, {
     12.0480609418283, 14.2609418282548}, {13.4581081081081, 16.}}], 
    LineBox[{{14, 16}, {13.4581081081081, 16.}, {12.0480609418283, 
      14.2609418282548}, {11.6365306122449, 11.2773469387755}, {13.845, 
      9.645}, {14., 9.66521739130435}, {14, 16}}], 
    LineBox[{{8.70011848341232, 13.2308056872038}, {8.38726708074534, 
     11.1034161490683}, {9.13688524590164, 10.166393442623}, {
     11.6365306122449, 11.2773469387755}, {12.0480609418283, 
     14.2609418282548}, {8.70011848341232, 13.2308056872038}}], 
    LineBox[{{4.76091257179324, 11.2133056796426}, {4.34075391180654, 
     9.97908961593172}, {6.09237481031867, 6.57316009104704}, {
     9.19067656765677, 7.63820132013201}, {9.13688524590164, 
     10.166393442623}, {8.38726708074534, 11.1034161490683}, {
     4.76091257179324, 11.2133056796426}}], 
    LineBox[{{0., 8.44705882352941}, {0., 8.425}, {3.52985648385443, 
     4.75937980522809}, {5.46011387649683, 5.48777882131956}, {
     6.09237481031867, 6.57316009104704}, {4.34075391180654, 
     9.97908961593172}, {0., 8.44705882352941}}], 
    LineBox[{{0, 1}, {1.37021276595745, 1.}, {3.52985648385443, 
      4.75937980522809}, {0., 8.425}, {0, 1}}], 
    LineBox[{{1.37021276595745, 1.}, {7.97894736842105, 1.}, {
     8.15935047951177, 1.79099825632084}, {5.46011387649683, 
     5.48777882131956}, {3.52985648385443, 4.75937980522809}, {
     1.37021276595745, 1.}}], 
    LineBox[{{6.09237481031867, 6.57316009104704}, {5.46011387649683, 
     5.48777882131956}, {8.15935047951177, 1.79099825632084}, {
     10.5172110552764, 3.46114949748744}, {11.3003353204173, 
     5.63921385991058}, {10.8224842767296, 6.62248427672956}, {
     9.19067656765677, 7.63820132013201}, {6.09237481031867, 
     6.57316009104704}}], 
    LineBox[{{9.13688524590164, 10.166393442623}, {9.19067656765677, 
     7.63820132013201}, {10.8224842767296, 6.62248427672956}, {13.845, 
     9.645}, {11.6365306122449, 11.2773469387755}, {9.13688524590164, 
     10.166393442623}}], 
    LineBox[{{14., 5.06071428571429}, {14., 9.66521739130435}, {13.845, 
     9.645}, {10.8224842767296, 6.62248427672956}, {11.3003353204173, 
     5.63921385991058}, {14., 5.06071428571429}}], 
    LineBox[{{14., 5.06071428571429}, {11.3003353204173, 5.63921385991058}, {
      10.5172110552764, 3.46114949748744}, {13.1078947368421, 1.}, {14, 1}, {
      14., 5.06071428571429}}], 
    LineBox[{{7.97894736842105, 1.}, {13.1078947368421, 1.}, {
     10.5172110552764, 3.46114949748744}, {8.15935047951177, 
     1.79099825632084}, {7.97894736842105, 1.}}]}},
  AspectRatio->1,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{-0.894736842105263, 14.8947368421053}, {0.605263157894737, 
   16.3947368421053}}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->26154]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TileAreas",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputationalGeometry/ref/TileAreas"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], "1"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], "1"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], "2"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], "2"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["q", "TI"], "1"], ",", " ", 
          RowBox[{
           SubscriptBox[
            StyleBox["q", "TI"], "2"], 
           RowBox[{",", " ", "\[Ellipsis]"}]}]}], "}"}], ",", " ", 
        StyleBox["val", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "find the areas of the tiles centered on ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "}",
     " and having vertices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["q", "TI"], 
       StyleBox["j", "TI"]]], "InlineFormula"],
     ", as stipulated by the vertex adjacency list ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->27438],

Cell["Computing tile areas. ", "Caption",
 CellID->26195],

Cell["\<\
You can make use of Voronoi diagrams to build spatial interaction models, or \
simply calculate the area of influence of individual tiles. \
\>", "Text",
 CellID->14951],

Cell["\<\
In an unbounded Voronoi diagram, some of the tiles have infinite area. \
\>", "MathCaption",
 CellID->20],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TileAreas", "[", 
  RowBox[{"data2D", ",", "diagvert", ",", "diagval"}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->29184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Infinity]", ",", "\[Infinity]", ",", "9.290492419697507`", ",", 
   "\[Infinity]", ",", "\[Infinity]", ",", "\[Infinity]", ",", 
   "9.799010941636512`", ",", "16.8550645121325`", ",", "12.67132425790285`", 
   ",", "\[Infinity]", ",", "\[Infinity]", ",", "20.81450973639879`", ",", 
   "13.205476316006525`", ",", "\[Infinity]", ",", "\[Infinity]", ",", 
   "\[Infinity]"}], "}"}]], "Output",
 ImageSize->{560, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->29510]
}, Open  ]],

Cell["In a bounded diagram, each of the tiles has finite area. ", \
"MathCaption",
 CellID->6692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"areas", "=", 
  RowBox[{"TileAreas", "[", 
   RowBox[{"data2D", ",", "diagvert1", ",", "diagval1"}], "]"}]}]], "Input",
 CellLabel->"In[38]:=",
 CellID->26799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "15.747851520862884`", ",", "5.4137834346992815`", ",", 
   "9.290492419697507`", ",", "18.584271583220563`", ",", 
   "10.223816457637605`", ",", "10.660114888896093`", ",", 
   "9.799010941636512`", ",", "16.8550645121325`", ",", "17.516179844598184`",
    ",", "15.680167296912659`", ",", "19.072014823776673`", ",", 
   "20.81450973639879`", ",", "13.205476316006525`", ",", 
   "8.708163679664088`", ",", "11.335647862556174`", ",", 
   "7.0934346813039415`"}], "}"}]], "Output",
 ImageSize->{489, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->4745]
}, Open  ]],

Cell["\<\
This gives the tile areas scaled by the area of the rectangle from which the \
sample was drawn. \
\>", "MathCaption",
 CellID->24647],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["areas", 
  RowBox[{"14", " ", "15"}]]], "Input",
 CellLabel->"In[39]:=",
 CellID->3078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.07498976914696612`", ",", "0.02577992111761563`", ",", 
   "0.044240440093797656`", ",", "0.08849653134866936`", ",", 
   "0.04868484027446479`", ",", "0.05076245185188616`", ",", 
   "0.04666195686493577`", ",", "0.08026221196253572`", ",", 
   "0.08341038021237232`", ",", "0.07466746331863172`", ",", 
   "0.09081911820846035`", ",", "0.09911671303047044`", ",", 
   "0.06288322055241202`", ",", "0.04146744609363852`", ",", 
   "0.05397927553598179`", ",", "0.03377826038716163`"}], "}"}]], "Output",
 ImageSize->{445, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->20649]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Computational Geometry Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 43.4098046}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Tutorial", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "Computational geometry is the study of efficient algorithms for solving \
geometric problems. The nearest neighbor problem involves identifying one \
point, out of a set of points, that is nearest to the query point according \
to some measure of distance. The nearest neighborhood problem involves \
identifying the locus of points lying nearer to the query point than to any \
other point in the set. This package provides functions for solving these and \
related problems in the case of planar points and the Euclidean distance \
metric. Computational geometry functions. The convex hull of a set S is the \
boundary of the smallest set containing S. The Voronoi diagram of S is the \
collection of nearest neighborhoods for each of the points in S. For points \
in the plane, these neighborhoods are polygons. The Delaunay triangulation of \
S is a triangulation of the points in S such that no triangle contains a \
point of S in its circumcircle. This is equivalent to connecting the points \
in S according to whether their neighborhood polygons share a common side. ", 
    "synonyms" -> {}, "title" -> "Computational Geometry Package", "type" -> 
    "Tutorial", "uri" -> 
    "ComputationalGeometry/tutorial/ComputationalGeometry"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2629, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3254, 80, 63, 1, 70, "Title",
 CellID->17318],
Cell[3320, 83, 581, 10, 70, "Text",
 CellID->6043],
Cell[3904, 95, 1869, 56, 70, "DefinitionBox",
 CellID->15937],
Cell[5776, 153, 69, 1, 70, "Caption",
 CellID->22060],
Cell[5848, 156, 1264, 36, 70, "Text",
 CellID->20610],
Cell[7115, 194, 63, 1, 70, "MathCaption",
 CellID->10797],
Cell[7181, 197, 105, 3, 70, "Input",
 CellID->22106],
Cell[7289, 202, 78, 1, 70, "MathCaption",
 CellID->11447],
Cell[7370, 205, 1223, 38, 70, "Input",
 CellID->17829],
Cell[8596, 245, 138, 4, 70, "MathCaption",
 CellID->24763],
Cell[CellGroupData[{
Cell[8759, 253, 139, 4, 70, "Input",
 CellID->28683],
Cell[8901, 259, 290, 9, 36, "Output",
 CellID->912]
}, Open  ]],
Cell[9206, 271, 69, 1, 70, "MathCaption",
 CellID->26899],
Cell[CellGroupData[{
Cell[9300, 276, 434, 15, 70, "Input",
 CellID->14985],
Cell[9737, 293, 283, 6, 70, "Message",
 CellID->10808],
Cell[10023, 301, 218, 7, 36, "Output",
 CellID->1832]
}, Open  ]],
Cell[10256, 311, 446, 15, 70, "MathCaption",
 CellID->5206],
Cell[CellGroupData[{
Cell[10727, 330, 334, 11, 70, "Input",
 CellID->25927],
Cell[11064, 343, 1069, 34, 68, "Output",
 CellID->20945]
}, Open  ]],
Cell[12148, 380, 913, 21, 70, "Text",
 CellID->24458],
Cell[13064, 403, 821, 22, 70, "Text",
 CellID->627],
Cell[13888, 427, 223, 7, 70, "MathCaption",
 CellID->9017],
Cell[14114, 436, 213, 7, 70, "Input",
 CellID->21394],
Cell[14330, 445, 647, 24, 70, "MathCaption",
 CellID->15609],
Cell[CellGroupData[{
Cell[15002, 473, 188, 6, 70, "Input",
 CellID->14878],
Cell[15193, 481, 556, 19, 36, "Output",
 CellID->27756]
}, Open  ]],
Cell[15764, 503, 306, 8, 70, "MathCaption",
 CellID->5549],
Cell[CellGroupData[{
Cell[16095, 515, 108, 3, 70, "Input",
 CellID->32345],
Cell[16206, 520, 694, 23, 36, "Output",
 CellID->28321]
}, Open  ]],
Cell[16915, 546, 161, 5, 70, "MathCaption",
 CellID->24621],
Cell[CellGroupData[{
Cell[17101, 555, 160, 4, 70, "Input",
 CellID->13555],
Cell[17264, 561, 221, 7, 36, "Output",
 CellID->19558]
}, Open  ]],
Cell[17500, 571, 609, 17, 70, "MathCaption",
 CellID->15939],
Cell[CellGroupData[{
Cell[18134, 592, 141, 4, 70, "Input",
 CellID->5965],
Cell[18278, 598, 878, 27, 54, "Output",
 CellID->23646]
}, Open  ]],
Cell[19171, 628, 1679, 50, 70, "DefinitionBox",
 CellID->4399],
Cell[20853, 680, 129, 4, 70, "Caption",
 CellID->10719],
Cell[20985, 686, 210, 6, 70, "MathCaption",
 CellID->12519],
Cell[21198, 694, 159, 5, 70, "Input",
 CellID->29621],
Cell[21360, 701, 143, 4, 70, "MathCaption",
 CellID->524],
Cell[21506, 707, 181, 6, 70, "Input",
 CellID->30578],
Cell[21690, 715, 5014, 151, 70, "DefinitionBox",
 CellID->2029],
Cell[26707, 868, 78, 1, 70, "Caption",
 CellID->20133],
Cell[26788, 871, 288, 9, 70, "MathCaption",
 CellID->29554],
Cell[CellGroupData[{
Cell[27101, 884, 113, 3, 70, "Input",
 CellID->13793],
Cell[27217, 889, 2214, 39, 381, "Output",
 CellID->27982]
}, Open  ]],
Cell[29446, 931, 81, 1, 70, "MathCaption",
 CellID->32395],
Cell[CellGroupData[{
Cell[29552, 936, 145, 4, 70, "Input",
 CellID->28218],
Cell[29700, 942, 1004, 22, 381, "Output",
 CellID->481]
}, Open  ]],
Cell[30719, 967, 77, 1, 70, "MathCaption",
 CellID->28028],
Cell[30799, 970, 679, 21, 70, "Input",
 CellID->930],
Cell[31481, 993, 162, 7, 70, "MathCaption",
 CellID->20640],
Cell[CellGroupData[{
Cell[31668, 1004, 140, 4, 70, "Input",
 CellID->8839],
Cell[31811, 1010, 2214, 39, 381, "Output",
 CellID->4144]
}, Open  ]],
Cell[34040, 1052, 273, 9, 70, "MathCaption",
 CellID->24829],
Cell[CellGroupData[{
Cell[34338, 1065, 109, 3, 70, "Input",
 CellID->17479],
Cell[34450, 1070, 5602, 102, 381, "Output",
 CellID->23196]
}, Open  ]],
Cell[40067, 1175, 87, 1, 70, "MathCaption",
 CellID->13577],
Cell[40157, 1178, 326, 11, 70, "Input",
 CellID->19288],
Cell[40486, 1191, 93, 1, 70, "MathCaption",
 CellID->10377],
Cell[40582, 1194, 687, 22, 70, "Input",
 CellID->28488],
Cell[41272, 1218, 195, 9, 70, "MathCaption",
 CellID->1035],
Cell[CellGroupData[{
Cell[41492, 1231, 155, 4, 70, "Input",
 CellID->16116],
Cell[41650, 1237, 5598, 102, 381, "Output",
 CellID->20222]
}, Open  ]],
Cell[47263, 1342, 308, 11, 70, "MathCaption",
 CellID->18700],
Cell[47574, 1355, 723, 24, 70, "Input",
 CellID->28685],
Cell[48300, 1381, 598, 20, 70, "MathCaption",
 CellID->172],
Cell[CellGroupData[{
Cell[48923, 1405, 119, 3, 70, "Input",
 CellID->23200],
Cell[49045, 1410, 10481, 182, 336, 2539, 47, "CachedBoxData", "BoxData", \
"Output",
 CellID->7129]
}, Open  ]],
Cell[59541, 1595, 273, 10, 70, "MathCaption",
 CellID->13975],
Cell[CellGroupData[{
Cell[59839, 1609, 147, 4, 70, "Input",
 CellID->26470],
Cell[59989, 1615, 10318, 179, 336, 2539, 47, "CachedBoxData", "BoxData", \
"Output",
 CellID->2161]
}, Open  ]],
Cell[70322, 1797, 237, 9, 70, "MathCaption",
 CellID->12263],
Cell[CellGroupData[{
Cell[70584, 1810, 172, 5, 70, "Input",
 CellID->4313],
Cell[70759, 1817, 89856, 1486, 313, 29475, 492, "CachedBoxData", "BoxData", \
"Output",
 CellID->5535]
}, Open  ]],
Cell[160630, 3306, 4181, 124, 70, "DefinitionBox",
 CellID->27178],
Cell[164814, 3432, 81, 1, 70, "Caption",
 CellID->31417],
Cell[164898, 3435, 117, 3, 70, "MathCaption",
 CellID->6580],
Cell[CellGroupData[{
Cell[165040, 3442, 512, 17, 70, "Input",
 CellID->23296],
Cell[165555, 3461, 284, 6, 70, "Message",
 CellID->20450],
Cell[165842, 3469, 210, 7, 36, "Output",
 CellID->11173]
}, Open  ]],
Cell[166067, 3479, 113, 3, 70, "MathCaption",
 CellID->14870],
Cell[CellGroupData[{
Cell[166205, 3486, 214, 6, 28, "Input",
 CellID->24716],
Cell[166422, 3494, 1210, 24, 68, "Output",
 Evaluatable->False,
 CellID->383530681]
}, Open  ]],
Cell[167647, 3521, 228, 7, 70, "MathCaption",
 CellID->18197],
Cell[167878, 3530, 315, 11, 70, "Input",
 CellID->1893],
Cell[168196, 3543, 125, 5, 70, "MathCaption",
 CellID->13342],
Cell[168324, 3550, 215, 7, 70, "Input",
 CellID->2661],
Cell[168542, 3559, 90, 1, 70, "MathCaption",
 CellID->16878],
Cell[CellGroupData[{
Cell[168657, 3564, 209, 5, 28, "Input",
 CellID->15654],
Cell[168869, 3571, 5577, 95, 381, "Output",
 Evaluatable->False,
 CellID->419757749]
}, Open  ]],
Cell[174461, 3669, 337, 10, 70, "MathCaption",
 CellID->2075],
Cell[CellGroupData[{
Cell[174823, 3683, 258, 6, 28, "Input",
 CellID->27035],
Cell[175084, 3691, 12031, 201, 381, "Output",
 Evaluatable->False,
 CellID->539212430]
}, Open  ]],
Cell[187130, 3895, 321, 11, 70, "MathCaption",
 CellID->4439],
Cell[CellGroupData[{
Cell[187476, 3910, 258, 6, 70, "Input",
 CellID->11494],
Cell[187737, 3918, 17988, 310, 381, "Output",
 CellID->26292]
}, Open  ]],
Cell[205740, 4231, 1215, 37, 70, "DefinitionBox",
 CellID->10648],
Cell[206958, 4270, 73, 1, 70, "Caption",
 CellID->29552],
Cell[207034, 4273, 244, 9, 70, "MathCaption",
 CellID->6717],
Cell[CellGroupData[{
Cell[207303, 4286, 148, 4, 70, "Input",
 CellID->10823],
Cell[207454, 4292, 158, 5, 36, "Output",
 CellID->26439]
}, Open  ]],
Cell[207627, 4300, 260, 10, 70, "MathCaption",
 CellID->12172],
Cell[CellGroupData[{
Cell[207912, 4314, 147, 4, 70, "Input",
 CellID->3674],
Cell[208062, 4320, 377, 7, 70, "Message",
 CellID->17253],
Cell[208442, 4329, 159, 5, 36, "Output",
 CellID->20024]
}, Open  ]],
Cell[208616, 4337, 3889, 110, 70, "DefinitionBox",
 CellID->3666],
Cell[212508, 4449, 74, 1, 70, "Caption",
 CellID->24553],
Cell[212585, 4452, 674, 11, 70, "Text",
 CellID->705],
Cell[213262, 4465, 631, 13, 70, "Text",
 CellID->27985],
Cell[213896, 4480, 294, 6, 70, "Text",
 CellID->9867],
Cell[214193, 4488, 438, 11, 70, "Text",
 CellID->31115],
Cell[214634, 4501, 171, 5, 70, "MathCaption",
 CellID->2098],
Cell[214808, 4508, 393, 14, 70, "Input",
 CellID->31284],
Cell[215204, 4524, 228, 7, 70, "MathCaption",
 CellID->27516],
Cell[215435, 4533, 280, 9, 70, "Input",
 CellID->7726],
Cell[215718, 4544, 212, 9, 70, "MathCaption",
 CellID->7464],
Cell[CellGroupData[{
Cell[215955, 4557, 156, 4, 70, "Input",
 CellID->6907],
Cell[216114, 4563, 5858, 102, 381, "Output",
 CellID->26154]
}, Open  ]],
Cell[221987, 4668, 1813, 59, 70, "DefinitionBox",
 CellID->27438],
Cell[223803, 4729, 57, 1, 70, "Caption",
 CellID->26195],
Cell[223863, 4732, 179, 4, 70, "Text",
 CellID->14951],
Cell[224045, 4738, 115, 3, 70, "MathCaption",
 CellID->20],
Cell[CellGroupData[{
Cell[224185, 4745, 153, 4, 70, "Input",
 CellID->29184],
Cell[224341, 4751, 566, 13, 36, "Output",
 CellID->29510]
}, Open  ]],
Cell[224922, 4767, 97, 2, 70, "MathCaption",
 CellID->6692],
Cell[CellGroupData[{
Cell[225044, 4773, 183, 5, 70, "Input",
 CellID->26799],
Cell[225230, 4780, 653, 15, 54, "Output",
 CellID->4745]
}, Open  ]],
Cell[225898, 4798, 144, 4, 70, "MathCaption",
 CellID->24647],
Cell[CellGroupData[{
Cell[226067, 4806, 115, 4, 70, "Input",
 CellID->3078],
Cell[226185, 4812, 677, 15, 71, "Output",
 CellID->20649]
}, Open  ]]
}, Open  ]],
Cell[226889, 4831, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

