(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6316,        218]
NotebookOptionsPosition[      3985,        151]
NotebookOutlinePosition[      5375,        185]
CellTagsIndexPosition[      5332,        182]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Computer Arithmetic Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Ulp",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/Ulp"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "size of the effect of changing the last bit in a number"
}], "GuideText",
 CellID->10195700],

Cell[TextData[{
 Cell[TextData[ButtonBox["MicroscopePlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/MicroscopePlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot values of a function when the last bits in its argument change "
}], "GuideText",
 CellID->27926755],

Cell[TextData[{
 Cell[TextData[ButtonBox["MicroscopicErrorPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/MicroscopicErrorPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot the error from the exact values of the function"
}], "GuideText",
 CellID->795268087],

Cell[CellGroupData[{

Cell["Symbolic Modeling of Computer Arithmetic", "GuideFunctionsSubsection",
 CellID->522165213],

Cell[TextData[{
 Cell[TextData[ButtonBox["ComputerNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/ComputerNumber"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbolic representation of a floating-point number"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetArithmetic",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "define the type of computer arithmetic"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["RoundingRule",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExponentRange",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/ExponentRange"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MixedMode",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/MixedMode"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IdealDivide",
  BaseStyle->"Link",
  ButtonData->"paclet:ComputerArithmetic/ref/IdealDivide"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->429405130]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "GuideTutorial",
 CellID->81000476]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Numbers and Precision",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Computer Arithmetic Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 44.2067000}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Guide", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "Ulp -- size of the effect of changing the last bit in a number, \
MicroscopePlot -- plot values of a function when the last bits in its \
argument change , MicroscopicErrorPlot -- plot the error from the exact \
values of the function, ComputerNumber -- symbolic representation of a \
floating-point number, SetArithmetic -- define the type of computer \
arithmetic", "synonyms" -> {}, "title" -> "Computer Arithmetic Package", 
    "type" -> "Guide", "uri" -> 
    "ComputerArithmetic/guide/ComputerArithmeticPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[691, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[750, 31, 292, 9, 70, "GuideText",
 CellID->10195700],
Cell[1045, 42, 330, 10, 70, "GuideText",
 CellID->27926755],
Cell[1378, 54, 327, 10, 70, "GuideText",
 CellID->795268087],
Cell[CellGroupData[{
Cell[1730, 68, 96, 1, 70, "GuideFunctionsSubsection",
 CellID->522165213],
Cell[1829, 71, 308, 9, 70, "GuideText",
 CellID->203374175],
Cell[2140, 82, 300, 10, 70, "GuideText",
 CellID->1463276848],
Cell[2443, 94, 926, 27, 70, "InlineGuideFunctionListing",
 CellID->429405130]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3418, 127, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3483, 130, 185, 4, 70, "GuideTutorial",
 CellID->81000476]
}, Open  ]],
Cell[CellGroupData[{
Cell[3705, 139, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3770, 142, 173, 4, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[3958, 149, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

